<style>
  
  .w-200px {
    width: 230px;
  }

  .info-title {
    background: none;
    margin-right: auto;
    border: none;
  }

  .info-card-detail {
    padding-right: 10px;
  }

  .btn-arrest {
    background-color: #02077D !important;
    color: #fff;
  }
  .ft7{
    display: -webkit-box;
  -webkit-line-clamp: 2; /* Limit to 2 lines */
  -webkit-box-orient: vertical;
  overflow: hidden;
  text-overflow: ellipsis;
  }

  @media(max-width:768px) {
    .w-200px {
      width: 200px;
    }

    .w100p {
      width: 100%;
    }

  }
</style>
<main class="">
  <div class="container my-2">
    <div class="">
      <div class="d-flex justify-content-center">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs n-tabs gap-3 mt-4" id="contentTabs" role="tablist">
          <li class="nav-item" role="presentation">
            <button class="nav-link active w-200px" id="articles-tab" data-bs-toggle="tab" data-bs-target="#articles"
              type="button" role="tab" aria-controls="articles" aria-selected="true"
              data-i18n="client_activity"></button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link w-200px" id="videos-tab" data-bs-toggle="tab" data-bs-target="#videos" type="button"
              role="tab" aria-controls="videos" aria-selected="false" data-i18n="prospective_client_activity"></button>
          </li>
        </ul>
      </div>

      <!-- Tab panes -->
      <div class="tab-content mt-2" id="contentTabsContent">
        <div class="tab-pane fade show active mb-5 mt-2" id="articles" role="tabpanel" aria-labelledby="articles-tab">
          <div class="row g-2 my-3">

          </div>
        </div>
        <div class="tab-pane fade my-3" id="videos" role="tabpanel" aria-labelledby="videos-tab">
          <div class="row g-2 my-3">

          </div>
        </div>
      </div>

       <div class="modal fade" id="acceptInviteModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered invite-modal">
          <div class="modal-content">
            <div class="modal-header justify-content-center">
              <h5 class="modal-title ">Firm Invitation to Join</h5>
            </div>
            <div class="modal-body ">
              <div class="text-center">
                <p id="inviteText"></p>
              </div>
              
              <div class="card-wrapper">
                <div class="d-flex align-items-center gap-3 mt-3">
                <img id="inviteFirmImage" src="../assets/images/th.jpeg" alt="Firm Image" width="80" height="80" class="rounded">
                <div class="text-start">
                  <p id="inviteFirmName"></p>
                  <p id="inviteFirmAdmin">Firm Admin</p>
                </div>
              </div>
              <div class="">
                <p id="inviteFirmLocation"><i class="fa-solid fa-location-dot"></i> Location</p>
                <p id="inviteFirmPhone"><i class="fa-solid fa-phone"></i> Phone</p>
                <p id="inviteFirmWebsite"><i class="fa-solid fa-globe"></i> Website</p>
              </div>
              </div>

              <div class="d-flex gap-3 justify-content-between mt-4">
                <button class="btn btn-danger" id="rejectInviteBtn">Decline</button>
                <button class="btn btn-success" id="acceptInviteBtn">Accept</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>


<!-- Swiper CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
<!-- Swiper JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<scrip src="https://vjs.zencdn.net/7.20.3/video.min.js"></script>


<script>
  // ===== CONFIGURATION =====
  let currentUser = null;
  let currentUserData = null;
  let unsubscribeAlerts = null;
  
    // ===== MAIN HANDLER =====
  let isProcessing = false;
  let pendingDocs = null;

  firebase.initializeApp(firebaseConfig);
  const db = firebase.firestore();
  const auth = firebase.auth();

  // ===== AUTH STATE MANAGEMENT =====

  firebase.auth().onAuthStateChanged(async (user) => {
    if (user) {
      try {
        currentUser = user;
        
        // Fetch user data once
        const userDoc = await db.collection("Users").doc(user.uid).get();
        currentUserData = userDoc.exists ? userDoc.data() : null;

        if (!currentUserData) {
          console.warn("⚠️ No user data found for:", user.uid);
          return;
        }

        console.log("✅ Auth ready, loading alerts...");
        await loadAlerts();
        
      } catch (err) {
        console.error("❌ Error during auth initialization:", err);
      }
    } else {
      console.log("🚪 User signed out");
      currentUser = null;
      currentUserData = null;
      
      // Clean up listeners
      if (unsubscribeAlerts) {
        unsubscribeAlerts();
        unsubscribeAlerts = null;
      }
    }
  });

  // ===== ALERT LOADING =====
  async function loadAlerts() {
    if (!currentUser || !currentUserData) return;

    // Unsubscribe from previous listener
    if (unsubscribeAlerts) unsubscribeAlerts();

    try {
      // Get Law Firm and Practice Areas
      const lawFirmId = currentUserData.LawFirmId;
      if (!lawFirmId) {
        console.warn("⚠️ No LawFirmId found.");
        return;
      }

      const lawFirmDoc = await db.collection("LawFirm").doc(lawFirmId).get();
      const lawFirmData = lawFirmDoc.data();
      if (!lawFirmData) {
        console.warn("⚠️ No LawFirm data found.");
        return;
      }

      const practiceAreas = lawFirmData.practiceAreas || [];
      
      // Build query for relevant practice areas
      const lawFields = [];
      if (practiceAreas.includes("Criminal Defense")) lawFields.push("LawId");
      if (practiceAreas.includes("Immigration Law")) lawFields.push("imigrationLawId");

      if (lawFields.length === 0) {
        console.warn("⚠️ No valid practice area (Criminal/Immigration).");
        return;
      }

      // ✅ FIX: Single combined query for all alerts
      const queries = lawFields.map(lawField =>
        db.collection("QuoteAlert")
          .where(lawField, "==", currentUser.uid)
          .where("status", "==", "request")
          .where("isLawArchived", "in", [false, null])
      );

      // Subscribe to all queries
      unsubscribeAlerts = onMultipleSnapshots(queries, handleAlertsSnapshot);

    } catch (error) {
      console.error("❌ Error loading alerts:", error);
    }
  }

  // ===== SNAPSHOT LISTENER =====
  function onMultipleSnapshots(queries, callback) {
    const docsMap = new Map();
    let debounceTimer = null;
    
    const triggerCallback = () => {
      clearTimeout(debounceTimer);
      debounceTimer = setTimeout(() => {
        callback([...docsMap.values()]);
      }, 100); // Debounce 100ms to batch rapid changes
    };
    
    const unsubscribers = queries.map(query =>
      query.onSnapshot(snapshot => {
        let hasChanges = false;
        
        snapshot.docChanges().forEach(change => {
          hasChanges = true;
          if (change.type === "removed") {
            docsMap.delete(change.doc.id);
          } else {
            docsMap.set(change.doc.id, change.doc);
          }
        });
        
        if (hasChanges) {
          triggerCallback();
        }
      })
    );

    return () => {
      clearTimeout(debounceTimer);
      unsubscribers.forEach(unsub => unsub());
    };
  }

  async function handleAlertsSnapshot(docs) {
    // Store the latest docs
    pendingDocs = docs;
    
    // If already processing, the next call will pick up the latest data
    if (isProcessing) {
      console.log("⏳ Already processing, will use latest data...");
      return;
    }
    
    isProcessing = true;
    
    try {
      await processAlerts(pendingDocs);
    } finally {
      isProcessing = false;
      
      // If new data arrived while processing, process it now
      if (pendingDocs !== docs) {
        console.log("🔄 Processing queued updates...");
        handleAlertsSnapshot(pendingDocs);
      }
    }
  }

  async function processAlerts(docs) {
    const clientContainer = document.querySelector("#articles .row.g-2.my-3");
    const prospectiveContainer = document.querySelector("#videos .row.g-2.my-3");

    if (!clientContainer || !prospectiveContainer) {
      console.error("❌ Containers not found");
      return;
    }

    // Clear both containers
    clientContainer.innerHTML = "";
    prospectiveContainer.innerHTML = "";

    if (docs.length === 0) {
      showEmptyState(clientContainer);
      showEmptyState(prospectiveContainer);
      return;
    }

    
    // ✅ FIX: Batch fetch all user data first
    const userIds = new Set();
    docs.forEach(doc => {
      const alert = doc.data();
      // console.log("📋 Processing alerts:", alert);
      
      userIds.add(alert.userId);
      if (alert.LawId) userIds.add(alert.LawId);
      if (alert.imigrationLawId) userIds.add(alert.imigrationLawId);
    });

    const usersCache = await fetchUsersInBatch([...userIds]);

    // Sort by date
    const sortedDocs = docs.slice().sort((a, b) => {
      const aDate = a.data().createdDate || 0;
      const bDate = b.data().createdDate || 0;
      return bDate - aDate;
    });

    // Separate into client vs prospective
    const clientAlerts = [];
    const prospectiveAlerts = [];

    for (const doc of sortedDocs) {
      const alert = doc.data();
      
      // Skip hidden alerts
      if (alert.isAttorenyHide === true) continue;

      const userData = usersCache.get(alert.userId);
      if (!userData) continue;

      // ✅ FIX: Determine if this is a designated client
      const designatedLawyer = userData.designatedLawyerId || "";
      const designatedImmLawyer = userData.designatedImmigrationLawyerId || "";
      const isDesignated = 
        designatedLawyer === currentUser.uid || 
        designatedImmLawyer === currentUser.uid;

      if (isDesignated) {
        clientAlerts.push({ doc, alert, userData, usersCache });
      } else {
        prospectiveAlerts.push({ doc, alert, userData, usersCache });
      }
    }

    // 🔹 Collect LawFirm IDs for attorneys
    const lawFirmIds = new Set();

    docs.forEach(doc => {
      const alert = doc.data();
      if (alert.LawId) lawFirmIds.add(alert.LawId);
      if (alert.imigrationLawId) lawFirmIds.add(alert.imigrationLawId);
    });

    // 🔹 Fetch LawFirm data
    const lawFirmCache = await fetchLawFirmsInBatch([...lawFirmIds]);

    // Render both sections
    renderAlertSection(clientAlerts, clientContainer, true, lawFirmCache);
    renderAlertSection(prospectiveAlerts, prospectiveContainer, false, lawFirmCache);


    console.log(`✅ Rendered ${clientAlerts.length} client alerts, ${prospectiveAlerts.length} prospective alerts`);

    // Setup video playback
    setupSequentialPlayback();
  }

  // ===== BATCH FETCH USERS =====
  async function fetchUsersInBatch(userIds) {
    const usersCache = new Map();
    
    // Firestore `in` query has a limit of 10 values, so batch them
    const chunks = [];
    for (let i = 0; i < userIds.length; i += 10) {
      chunks.push(userIds.slice(i, i + 10));
    }

    for (const chunk of chunks) {
      try {
        const snapshot = await db.collection("Users")
          .where(firebase.firestore.FieldPath.documentId(), 'in', chunk)
          .get();
        
        snapshot.forEach(doc => {
          usersCache.set(doc.id, doc.data());
        });
      } catch (error) {
        console.error("❌ Error fetching users batch:", error);
        // Fallback: fetch individually if batch fails
        for (const userId of chunk) {
          try {
            const userDoc = await db.collection("Users").doc(userId).get();
            if (userDoc.exists) {
              usersCache.set(userDoc.id, userDoc.data());
            }
          } catch (err) {
            console.error(`❌ Error fetching user ${userId}:`, err);
          }
        }
      }
    }

    return usersCache;
  }

  async function fetchLawFirmsInBatch(lawFirmIds) {
    const cache = new Map();

    const chunks = [];
    for (let i = 0; i < lawFirmIds.length; i += 10) {
      chunks.push(lawFirmIds.slice(i, i + 10));
    }

    for (const chunk of chunks) {
      const snapshot = await db
        .collection("LawFirm")
        .where(firebase.firestore.FieldPath.documentId(), "in", chunk)
        .get();

      snapshot.forEach(doc => {
        cache.set(doc.id, doc.data());
      });
    }

    return cache;
  }



  // ===== RENDER SECTION =====
  function renderAlertSection(alerts, container, isClientActivity, lawFirmCache) {
    if (alerts.length === 0) {
      showEmptyState(container);
      return;
    }

    alerts.forEach(({ doc, alert, userData, usersCache }) => {
      const alertHtml = buildAlertCard(doc, alert, userData, usersCache,lawFirmCache, isClientActivity);
      container.insertAdjacentHTML('beforeend', alertHtml);
    });
  }

  // ===== BUILD ALERT CARD =====
  function buildAlertCard(doc, alert, userData, usersCache, lawFirmCache, isClientActivity) {
    const isManualIncident = alert.quoteType === "Manual Incident";
    const isImmigrationIncident = isManualIncident &&
      alert.incidentType?.includes("Immigration Law");

    // Escape user data to prevent XSS
    const escape = (str) => {
      const div = document.createElement('div');
      div.textContent = str || '';
      return div.innerHTML;
    };

    // Format dates
    const formattedDate = alert.createdDate 
      ? new Date(alert.createdDate).toLocaleDateString('en-US', {
          weekday: 'long', year: 'numeric', month: 'long', day: 'numeric',
          hour: '2-digit', minute: '2-digit'
        })
      : 'N/A';

    const formattedIncidentDate = alert.incidentDateTime
      ? formatCustomDate(alert.incidentDateTime)
      : 'N/A';

    // Get attorney names
    let attorneyName = "Opted Out";
    let immigrationAttorneyName = "Opted Out";

    if (alert.LawId) {
      const firm = lawFirmCache.get(alert.LawId);
      attorneyName = firm?.professionalName || "N/A";
    }

    if (alert.imigrationLawId) {
      const firm = lawFirmCache.get(alert.imigrationLawId);
      immigrationAttorneyName = firm?.professionalName || "N/A";
    }


    // Build title section
    const titleHtml = isManualIncident
      ? `<p class="mb-0 fp2">${escape(alert.incidentType || 'N/A')} Incident for ${escape(userData.Name)}</p>
        <p class="ft7 mb-2">${formattedIncidentDate}</p>`
      : `<p class="mb-0 fp2">Legal Emergency Alert for ${escape(alert.title)}</p>
        <p class="ft7 mb-2">${formattedDate}</p>`;

    // Build media section
    const mediaHtml = isManualIncident
      ? (alert.docUrl 
          ? `<div class="document-preview border rounded p-2">
              <iframe src="${escape(alert.docUrl)}" width="100%" height="180px" style="border:none;"></iframe>
              <a href="${escape(alert.docUrl)}" target="_blank" class="btn btn-outline-primary mt-2 w-100">
                View Full Document
              </a>
            </div>`
          : `<div class="alert alert-info">No document available</div>`)
      : (alert.videoUrls?.length
          ? `<video class="video-cl w-100 mb-2 autoplay-video" data-index="0" 
              data-urls='${JSON.stringify(alert.videoUrls)}' muted autoplay playsinline controls>
              <source src="${alert.videoUrls[0]}" type="video/mp4">
            </video>`
          : `<div class="alert alert-info">No video available</div>`);

    // Build details section
    const dateOfBirth = userData.userDOB 
      ? new Date(userData.userDOB).toLocaleDateString('en-US')
      : 'N/A';
    const visaExpiryDate = userData.visaExpiryDate
      ? new Date(userData.visaExpiryDate).toLocaleDateString('en-US')
      : 'N/A';

    let detailsHtml = "";
    let callOutActions = "";

    if (isManualIncident) {
      detailsHtml = `
        <p class="fw-bold text-danger mb-1 mt-2 w-100 border-bottom pb-1">Incident Details</p>
        <p class="mb-0 info-card-detail"><strong>Legal Name:</strong> ${escape(userData.Name)}</p>
        <p class="mb-0 info-card-detail"><strong>Date of Birth:</strong> ${dateOfBirth}</p>
        <p class="mb-0 info-card-detail"><strong>Incident Location:</strong> ${escape(alert.incidentLocation || 'N/A')}</p>
        ${alert.incidentDescription 
          ? `<p class="mb-0 info-card-detail"><strong>Description:</strong> ${escape(alert.incidentDescription)}</p>` 
          : ''}
      `;

      if (isImmigrationIncident) {
        detailsHtml += `
          <p class="fw-bold text-success mb-1 mt-3 w-100 border-bottom pb-1">Immigration Info</p>
          <p class="mb-0 info-card-detail"><strong>Citizenship:</strong> ${escape(userData.countryOfCitizenship || 'N/A')}</p>
          <p class="mb-0 info-card-detail"><strong>Visa Type:</strong> ${escape(userData.visaType || 'N/A')}</p>
          <p class="mb-0 info-card-detail"><strong>Visa Expiry:</strong> ${visaExpiryDate}</p>
          <p class="mb-0 info-card-detail"><strong>A-Number:</strong> ${escape(userData.ANumber || 'N/A')}</p>
        `;

        callOutActions = `
          <button onclick="fetchImmigrationInfo('${escape(alert.title)}', '${doc.id}')" type="button"
            class="btn btn-save py-2 px-3 rounded flex-grow-1 flex-md-grow-0">
            Immigration Info
          </button>
        `;
      }

      callOutActions += `
        ${isClientActivity 
          ? `<button type="button" class="btn btn-danger py-2 px-3 rounded flex-grow-1 flex-md-grow-0"
              onclick="handleOptOut('${doc.id}')">Opt Out</button>` 
          : ''}
        <!-- <button type="submit" class="btn btn-save py-2 px-3 rounded flex-grow-1 flex-md-grow-0">
          Submit
        </button> -->

        <button type="button" 
          class="btn btn-save py-2 px-3 rounded flex-grow-1 flex-md-grow-0"
          onclick="handleSubmitWithMembership('${doc.id}')">
          Submit
        </button>
      `;
    } else {
      detailsHtml = `
        <p class="fw-bold text-primary mb-1 mt-2 w-100 border-bottom pb-1">Personal Info</p>
        <p class="mb-0 info-card-detail"><strong>Legal Name:</strong> ${escape(userData.Name)}</p>
        <p class="mb-0 info-card-detail"><strong>Date of Birth:</strong> ${dateOfBirth}</p>
        <p class="mb-0 info-card-detail"><strong>Location:</strong> ${escape(alert.city)}, ${escape(alert.county)}</p>

        <p class="fw-bold text-success mb-1 mt-2 w-100 border-bottom pb-1">Immigration Info</p>
        <p class="mb-0 info-card-detail"><strong>Citizenship:</strong> ${escape(userData.countryOfCitizenship || 'N/A')}</p>
        <p class="mb-0 info-card-detail"><strong>Visa Type:</strong> ${escape(userData.visaType || 'N/A')}</p>
        <p class="mb-0 info-card-detail"><strong>Visa Expiry:</strong> ${visaExpiryDate}</p>
        <p class="mb-0 info-card-detail"><strong>A-Number:</strong> ${escape(userData.ANumber || 'N/A')}</p>

        <p class="fw-bold text-danger mb-1 mt-2 w-100 border-bottom pb-1">Case Details</p>
        <p class="mb-0 info-card-detail"><strong>Detained At:</strong> ${escape(alert.detainedPlace || 'N/A')}</p>
        <p class="mb-0 info-card-detail"><strong>Designated Attorney:</strong> ${escape(attorneyName)}, ${escape(immigrationAttorneyName)}</p>
      `;

      callOutActions = `
        <button onclick="fetchImmigrationInfo('${escape(alert.title)}', '${doc.id}')" type="button"
          class="btn btn-save py-2 px-3 rounded flex-grow-1 flex-md-grow-0">
          Immigration Info
        </button>
        <button onclick="fetchArrestDetails('${escape(alert.title)}', '${doc.id}')" type="button"
          class="btn btn-save py-2 px-3 rounded flex-grow-1 flex-md-grow-0 btn-arrest">
          Arrest Details
        </button>
        ${isClientActivity 
          ? `<button type="button" class="btn btn-danger py-2 px-3 rounded flex-grow-1 flex-md-grow-0"
              onclick="handleOptOut('${doc.id}')">Opt Out</button>` 
          : ''}
        <!-- <button type="submit" class="btn btn-save py-2 px-3 rounded flex-grow-1 flex-md-grow-0">
          Submit
        </button> -->
        <button type="button" 
          class="btn btn-save py-2 px-3 rounded flex-grow-1 flex-md-grow-0"
          onclick="handleSubmitWithMembership('${doc.id}')">
          Submit
        </button>
      `;
    }

    // Build full card
    return `
      <div class="col-md-12">
        <div class="card stCard">
          <div class="card-body">
            <div class="d-flex justify-content-between align-items-center">
              <div class="info-title">${titleHtml}</div>
              <div class="d-flex gap-2 align-items-center">
                    
                      ${alert.isFalse ? `<img src="<?= base_url('assets/images/icons/warning.png'); ?>" alt="Warning" style="width: 20px; height: 20px; margin-left: 5px;" title="False Alert" />` : ""}
                        <button onclick="archiveByLawyer('${doc.id}')" class="btn btn-sm  py-1 px-2 btn-ar" title="Archive">
                          <img src="<?= base_url(); ?>/assets/images/icons/ari.png"/> <small>Archive</small>
                          </button>
                        <button onclick="openDocusignDocument('${doc.id}')" class="btn btn-sm py-1 px-2 btn-ar" title="document">
                          <i class="fa-solid fa-file" style="color:#0412CA; font-size:22px"></i>
                        </button>

              </div>
            </div>

            <div class="row g-2">
              <div class="col-md-6">${detailsHtml}</div>
              <div class="col-md-6">${mediaHtml}</div>
            </div>

            <form id="form-${doc.id}" class="row" method="post" onsubmit="return handleSubmit(event, '${doc.id}')">
              <div class="col-md-3">
                <label for="quote-${doc.id}" class="s-label">Quote</label>
                <div class="input-group inp-gr mb-3">
                  <span class="input-group-text">$</span>
                  <input type="number" class="form-control" id="quote-${doc.id}" name="quote"
                    placeholder="Enter Quote" value="${alert.qoutesPrice || ''}" required />
                </div>
              </div>
              <div class="col-md-3">
                <label for="deposit-${doc.id}" class="s-label">Deposit</label>
                <div class="input-group inp-gr mb-3">
                  <span class="input-group-text">$</span>
                  <input type="number" class="form-control" id="deposit-${doc.id}" name="deposit"
                    placeholder="Enter deposit" value="${alert.qoutesDeposite || ''}" />
                </div>
              </div>
              <div class="col-md-6 p-0 m-auto">
                <div class="d-flex flex-wrap justify-content-start gap-2">
                  ${callOutActions}
                  <button onclick="hideAlertFromAttorney('${doc.id}')" type="button"
                    class="btn btn-danger py-2 px-3 rounded flex-grow-1 flex-md-grow-0"
                    title="Permanently Delete?">
                    Delete Activity
                  </button>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    `;
  }

  // ===== HELPER FUNCTIONS =====
  function showEmptyState(container) {
    container.innerHTML = `
      <div class="col-md-12">
        <div class="alert alert-warning">
          <div class="card-body text-center">
            <p>No activity found</p>
          </div>
        </div>
      </div>
    `;
  }

  async function handleSubmitWithMembership(docId) {
    const allowed = await checkAttorneyMembershipAccess({
      redirectTo: "<?= base_url('site/subscriptionAttorney'); ?>"
    });

    if (!allowed) return; // 🚫 stop non-members

    // ✅ User is allowed, call your existing submit handler
    if (typeof handleSubmit === 'function') {
      // You can simulate the event or create a dummy event
      const form = document.getElementById(`form-${docId}`);
      if (form) handleSubmit({ preventDefault: () => {} }, docId);
    } else {
      console.warn("handleSubmit function not defined");
    }
  }


  function formatCustomDate(value) {
    if (!value) return "-";
    let date;
    if (value.seconds) {
      date = new Date(value.seconds * 1000);
    }
    // Milliseconds timestamp (number)
    else if (typeof value === "number") {
      date = new Date(value);
    }
    // JS Date object
    else if (value instanceof Date) {
      date = value;
    }
    else {
      return "-";
    }

    return (
      date.toLocaleDateString("en-US", {
        day: "2-digit",
        month: "long",
        year: "numeric"
      }) +
      " , " +
      date.toLocaleTimeString("en-US", {
        hour: "2-digit",
        minute: "2-digit",
        hour12: true
      })
    );
  }

  async function handleOptOut(alertId) {
    try {
      const alertRef = db.collection("QuoteAlert").doc(alertId);
      const alertDoc = await alertRef.get();

      if (!alertDoc.exists) {
        Swal.fire("Error", "Alert not found.", "error");
        return;
      }

      const alertData = alertDoc.data();
      const lawyerId = currentUser.uid;

      // Update basic opt-out fields in QuoteAlert
      const updateFields = {
        updatedAt: firebase.firestore.FieldValue.serverTimestamp(),
      };

      if (alertData.LawId === lawyerId) {
        updateFields.LawId = "";
        updateFields.isOptOut = true;
      }
      if (alertData.imigrationLawId === lawyerId) {
          updateFields.imigrationLawId = "",
          updateFields.isImmigrationOptOut = true; // Immigration attorney opted out
        }


      await alertRef.update(updateFields);

      console.log("alertData",alertData);
      
      // 🔁 MANUAL OPT-OUT HANDLING
      if (alertData.quoteType === "Manual Incident") {
        if (alertData.baseDocId?.trim()) {
          // Case 1️⃣: baseDocId exists → main document is ManualIncident
          const baseDocRef = db
            .collection("QuoteAlert")
            .doc(alertData.baseDocId.trim());

          // ✅ Create or update the manualOptoutAttorney array in baseDoc
          await baseDocRef.set(
            {
              manualOptoutAttorney:
                firebase.firestore.FieldValue.arrayUnion(lawyerId),
              updatedAt: firebase.firestore.FieldValue.serverTimestamp(),
            },
            { merge: true }
          );

        } else {
          // Case 2️⃣: No baseDocId → main document is QuoteAlert itself
          await alertRef.set(
            {
              manualOptoutAttorney:
                firebase.firestore.FieldValue.arrayUnion(lawyerId),
              updatedAt: firebase.firestore.FieldValue.serverTimestamp(),
            },
            { merge: true }
          );
        }
      }

      // 🔔 Notify client + emergency contacts
      await sendOptOutMessagesToUserAndEmergency(alertData.userId);

      Swal.fire({
        icon: "success",
        title: "Opted Out",
        text: "You have successfully opted out of this case.",
      });

      loadAlerts();
    } catch (error) {
      console.error("Error opting out:", error);
      Swal.fire({
        icon: "error",
        title: "Error",
        text: error.message || "Failed to opt out. Please try again.",
      });
    }
  }

  async function handleSubmit(event, alertId) {
    event.preventDefault();

    const quote = parseFloat(document.getElementById(`quote-${alertId}`).value);
    let deposit = parseFloat(document.getElementById(`deposit-${alertId}`).value);
    if (isNaN(deposit)) deposit = 0;

    if (isNaN(quote) || isNaN(deposit) || quote <= 0) {
      Swal.fire({
        icon: "error",
        title: "Invalid Input",
        text: "Please enter valid positive numbers for quote and deposit",
      });
      return;
    }

    try {
      const alertRef = db.collection("QuoteAlert").doc(alertId);
      const alertDoc = await alertRef.get();
      if (!alertDoc.exists) {
        Swal.fire("Error", "QuoteAlert not found.", "error");
        return;
      }
      const alertData = alertDoc.data();
  
    // ✅ Step 1: Get LawFirmId and TemplateId
      if (!currentUserData || !currentUserData.LawFirmId) {
        Swal.fire("Error", "LawFirm ID not found in user data.", "error");
        return;
      }

      const lawFirmId = currentUserData.LawFirmId;
      const lawFirmDoc = await db.collection("LawFirm").doc(lawFirmId).get();
      if (!lawFirmDoc.exists) {
        Swal.fire("Error", "LawFirm document not found.", "error");
        return;
      }

      const lawFirmData = lawFirmDoc.data();
      const templateId = lawFirmData.templateId;

    // ✅ Step 2: If template_id is missing in QuoteAlert → duplicate-template API
  
      if (!alertData.template_id) {
        if (!templateId) {
          Swal.fire("Missing Template", "Template not found in LawFirm.", "error");
          return;
        }

        Swal.fire({
          title: "Preparing document...",
          text: "Please wait while we duplicate template.",
          allowOutsideClick: false,
          didOpen: () => Swal.showLoading(),
        });
      

          // const apiUrl = "https://duepro.com/duepro_docusign_apis/index.php/docusign/duplicate-template";
          // console.log(apiUrl,"apiUrl");
        
        const apiUrl = "https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/duplicate-template";
        const formData = new URLSearchParams();
        formData.append("template_id", templateId);
        formData.append("doc_id", alertId);

        const response = await fetch(apiUrl, {
          method: "POST",
          body: formData,
        });
        const result = await response.json();
        Swal.close();

        if (!result.success) {
          Swal.fire("Error", result.message || "Failed to duplicate template.", "error");
          return;
        }
      }

    
      
      // Step 3: Create copy for NON-accepted attorney
      // let needCopy = false;
      // const newData = JSON.parse(JSON.stringify(alertData)); // Deep copy

      // if (lawFirmData.practiceAreas === "Criminal Defense" && alertData.imigrationLawId) {
      //   // Immigration attorney is NON-accepted → keep only immigration in COPY
      //   needCopy = true;

      //   newData.LawId = "";  // ❗ remove Criminal from copy
      //   newData.acceptedAttorneyType = "";
      //   // newData.LawFirmId = alertData.imigrationLawId;
      // }

      // if (lawFirmData.practiceAreas === "Immigration" && alertData.LawId) {
      //   // Criminal attorney is NON-accepted → keep only criminal in COPY
      //   needCopy = true;

      //   newData.imigrationLawId = "";  // ❗ remove Immigration attorney from copy
      //   // newData.LawFirmId = "";        
      //   newData.acceptedAttorneyType = "";
      // }

      // if (needCopy) {
      //   newData.qoutesPrice = 0;
      //   newData.qoutesDeposite = 0;
      //   newData.isCopy = true;
      //   newData.status = "request";

      //   const newId = `${alertId}_copy`;
      //   await db.collection("QuoteAlert").doc(newId).set(newData);
      //           console.log("✅ New QuoteAlert copy created:", newId);
      // }
      const isCriminalAttorney = alertData.LawId === currentUser.uid;
      const isImmigrationAttorney = alertData.imigrationLawId === currentUser.uid;

      let needCopy = false;
      const newData = JSON.parse(JSON.stringify(alertData));

      if (isCriminalAttorney && alertData.imigrationLawId) {
        // Immigration attorney should get copy
        needCopy = true;

        newData.LawId = "";
        newData.acceptedAttorneyType = "";
      }

      if (isImmigrationAttorney && alertData.LawId) {
        // Criminal attorney should get copy
        needCopy = true;

        newData.imigrationLawId = "";
        newData.acceptedAttorneyType = "";
      }

      if (needCopy) {

        newData.qoutesPrice = 0;
        newData.qoutesDeposite = 0;
        newData.isCopy = true;
        newData.status = "request";
        newData.findAttorney = [];
        newData.acceptedAttorneyLawFrimID = "";
        newData.isInActive= true;


        const newId = `${alertId}_copy`;
        await db.collection("QuoteAlert").doc(newId).set(newData);
                console.log("✅ New QuoteAlert copy created:", newId);
      }

      // Step 4: Update ORIGINAL (accepted attorney)
      const updateOriginal = {
        qoutesPrice: quote,
        qoutesDeposite: deposit,
        isAttorneyAlerted: true,
        status: "accept",
        updatedAt: Date.now(),
        
      };

      // Criminal Defense accepted → keep ONLY LawId
      if (isCriminalAttorney) {
        updateOriginal.acceptedAttorneyType = "Criminal Defense";
        updateOriginal.acceptedAttorneyLawFrimID = currentUser.uid;
        updateOriginal.imigrationLawId = "";  // remove immigration
      }
      
      // Immigration accepted → keep Immigration (LawFirmId + imigrationLawId)
      else if (isImmigrationAttorney) {
        updateOriginal.acceptedAttorneyType = "Immigration Law";
        updateOriginal.acceptedAttorneyLawFrimID = currentUser.uid;
        updateOriginal.LawId = "";            // remove criminal attorney
      }

      await alertRef.update(updateOriginal);

      try {
        const targetDocRef = alertData.baseDocId
          ? db.collection("ManualIncident").doc(alertData.baseDocId)
          : alertRef;

        await targetDocRef.update({
          isInActive: true,
          quotedAttorney: firebase.firestore.FieldValue.arrayUnion(currentUser.uid),
          updatedAt: firebase.firestore.FieldValue.serverTimestamp(),
        });
      } catch (err) {
        console.warn("quotedAttorney update skipped:", err);
      }

      Swal.fire({
        icon: "success",
        title: "Submitted",
        text: "Quote has been successfully submitted.",
      });

    // ✅ Refresh alerts
      loadAlerts();

    } catch (error) {
      console.error("Error submitting quote:", error);
      Swal.fire({
        icon: "error",
        title: "Error",
        text: "Failed to submit quote. Please try again.",
      });
    }
  }

  async function fetchArrestDetails(name, alertId) {
    try {
      const user = firebase.auth().currentUser;
      if (!user) return;

      // 🔒 HARD MEMBERSHIP GATE (nothing runs before this)
      const allowed = await checkAttorneyMembershipAccess({
        redirectTo: "<?php echo base_url('site/subscriptionAttorney'); ?>"
      });

      // ⛔ ABSOLUTE STOP — NO DATA, NO UI, NO LOGS
      if (!allowed) return;
      
      const upperName = name.toUpperCase();
      let arrest = null;

      // 1️⃣ Try fetching from API
      try {
        const res = await fetch(`https://us-central1-duepro-2cf60.cloudfunctions.net/widgets/searchnew?name=${encodeURIComponent(upperName)}`);
        const result = await res.json();

        if (result.success !== 0 && result.result) {
          arrest = result.result; // API data found
        }
      } catch (apiError) {
        console.warn("API fetch failed:", apiError);
      }

      // 2️⃣ If API fails, try Firestore
      if (!arrest) {
        const alertDoc = await db.collection("QuoteAlert").doc(alertId).get();
        if (alertDoc.exists) {
          const alertData = alertDoc.data();
          if (alertData.offense && Array.isArray(alertData.offense) && alertData.offense.length > 0) {
            arrest = {
              fullName: name,
              offense: alertData.offense
            };
          }
        }
      }

      // 3️⃣ If still no record, show message
      if (!arrest) {
        return Swal.fire("No Record", "No arrest record found.", "info");
      }

      // Format API arrest date if present
      const arrestDate = arrest.arrestDate ? new Date(arrest.arrestDate).toLocaleString() : "N/A";

      Swal.fire({
        title: `Arrest Details`,
        html: `
          <p><strong>Name:</strong> ${arrest.fullName || name}</p>
          <p><strong>Gender:</strong> ${arrest.gender || 'N/A'}</p>
          <p><strong>Age:</strong> ${arrest.age || 'N/A'}</p>
          <p><strong>Address:</strong> ${arrest.address || 'N/A'}</p>
          <p><strong>City/State/Zip:</strong> ${arrest.cityStateZip || 'N/A'}</p>
          <p><strong>Offense:</strong><br />
            ${
              Array.isArray(arrest.offense) && arrest.offense.length
                ? arrest.offense.map(o =>
                    `${o.chargedesc || 'Unknown'} (${o.severity || '-'}) - ${o.warrantissuedagency || 'Unknown Agency'}`
                  ).join('<br>')
                : 'N/A'
            }
          </p>
          <p><strong>Detention:</strong> ${arrest.detention || 'N/A'}</p>
          <p><strong>Arrest Date:</strong> ${arrestDate}</p>
        `,
        confirmButtonText: 'Close'
      });

    } catch (err) {
      console.error(err);
      Swal.fire("Error", "Failed to fetch arrest details.", "error");
    }
  }

  async function fetchImmigrationInfo(name, alertId) {
    try {
      // Fetch alert
      const alertDoc = await db.collection("QuoteAlert").doc(alertId).get();
      if (!alertDoc.exists) {
        return Swal.fire("Error", "Alert not found.", "error");
      }
      const alertData = alertDoc.data();

      // Fetch user data
      const userDoc = await db.collection("Users").doc(alertData.userId).get();
      if (!userDoc.exists) {
        return Swal.fire("Error", "User not found.", "error");
      }
      const userData = userDoc.data();

      // DOCUMENT FIELDS
      const immigrationDoc = userData.imigrationID || null;
      const supportingDoc = userData.supportingDocument || null;
      

      // Immigration ID document button
      let immigrationHtml = `<p>No immigration document uploaded</p>`;
      if (immigrationDoc) {
        immigrationHtml = `
          <button class="btn btn-outline-primary w-100 text-start" onclick="openDocument('${immigrationDoc}')">
            View Immigration ID
          </button>
        `;
      }

      // Supporting document button
      let supportingHtml = `<p>No supporting document uploaded</p>`;
      if (supportingDoc)
      {
        supportingHtml = `
          <button class="btn btn-outline-primary w-100 text-start" onclick="openDocument('${supportingDoc}')">
            View Supporting Document
          </button>
        `;
      }

          // SweetAlert
          Swal.fire({
        title: `Immigration Info`,
        html: `
          <div class="container text-start">

            <div class="row g-3 mt-2">

              <!-- Immigration ID Card -->
              <div class="col-12 col-md-6">
                <div class="card border shadow-sm">
                  <div class="card-body">
                    <h6 class="card-title fw-bold">
                      <i class="fa-solid fa-passport me-1"></i> Immigration ID
                    </h6>
                    <div class="mt-2">
                      ${immigrationHtml}
                    </div>
                  </div>
                </div>
              </div>

              <!-- Supporting Document Card -->
              <div class="col-12 col-md-6">
                <div class="card border shadow-sm">
                  <div class="card-body">
                    <h6 class="card-title fw-bold">
                      <i class="fa-solid fa-file me-1"></i> Supporting Document
                    </h6>
                    <div class="mt-2">
                      ${supportingHtml}
                    </div>
                  </div>
                </div>
              </div>

            </div>

          </div>
        `,
        width: "650px",
        confirmButtonText: "Close",
      });


    } catch (err) {
      console.error(err);
      Swal.fire("Error", "Failed to fetch immigration info.", "error");
    }
  }

  // Opens the document
  function openDocument(url) {
    if (!url) {
      Swal.fire("Error", "Document URL not found.", "error");
      return;
    }
    window.open(url, "_blank");
  }

  function setupSequentialPlayback() {
    document.querySelectorAll('.autoplay-video').forEach(video => {
      video.addEventListener('ended', () => {
        const urls = JSON.parse(video.getAttribute('data-urls') || '[]');
        let currentIndex = parseInt(video.getAttribute('data-index') || '0', 10);

        if (currentIndex + 1 < urls.length) {
          currentIndex += 1;
          const nextUrl = urls[currentIndex];

          video.setAttribute('data-index', currentIndex);
          video.querySelector('source').src = nextUrl;
          video.load();
          video.play();
        }
      });
    });
  }

  async function sendOptOutMessagesToUserAndEmergency(userId) {
    if (!currentUser || !userId) return;

    try {
      const userDoc = await db.collection("Users").doc(userId).get();
      if (!userDoc.exists) return;

      const userData = userDoc.data();
      const emergencyContactId = userData.designatedEmgContact;
      const userName = userData?.Name || "The client";

      const messageText = `${userName}'s designated attorney has opted out from being able to help in this situation. Please request a quote from a different attorney.`;
      const messageText2 = `Your's designated attorney has opted out from being able to help in this situation. Please request a quote from a different attorney.`;
      // Send to user
      await sendOptOutMessageDirect(userId, messageText2);

      // Send to emergency contact
      if (emergencyContactId) {
        await sendOptOutMessageDirect(emergencyContactId, messageText);
      }

    } catch (error) {
      console.error("Error sending opt-out messages to user and emergency:", error);
    }
  }
  
  async function sendOptOutMessageDirect(receiverId, messageText) {
    if (!currentUser || !receiverId) return;

    try {
      const chatQuery = await db.collection("Chats")
        .where(`participants.${currentUser.uid}`, "==", true)
        .where(`participants.${receiverId}`, "==", true)
        .limit(1)
        .get();

      let chatId;
      if (!chatQuery.empty) {
        chatId = chatQuery.docs[0].id;
      } else {
        const newChat = {
          participants: {
            [currentUser.uid]: true,
            [receiverId]: true
          },
          lastMessage: {},
          createdAt: Date.now()
        };
        const chatRef = await db.collection("Chats").add(newChat);
        chatId = chatRef.id;
      }

      const message = {
        content: messageText,
        fromID: currentUser.uid,
        fromName: currentUserData?.Name || "Attorney",
        toID: receiverId,
        isRead: false,
        messageId: generateId(),
        timestamp: Date.now(),
        type: "system"
      };

      await db.collection("Chats").doc(chatId).collection("Conversations").add(message);
      await db.collection("Chats").doc(chatId).update({ lastMessage: message });

    } catch (error) {
      console.error("Error sending opt-out message:", error);
    }
  }

  async function sendMessageToUser(receiverId, message) {
    try {
      // 🔍 Check if chat already exists
      const chatQuery = await db.collection("Chats")
        .where(`participants.${currentUser.uid}`, "==", true)
        .where(`participants.${receiverId}`, "==", true)
        .limit(1)
        .get();

      let chatId;
      if (!chatQuery.empty) {
        chatId = chatQuery.docs[0].id;
      } else {
        const newChat = {
          participants: {
            [currentUser.uid]: true,
            [receiverId]: true
          },
          lastMessage: {},
          createdAt: Date.now()
        };
        const chatRef = await db.collection("Chats").add(newChat);
        chatId = chatRef.id;
      }

      // 💬 Add message to chat
      await db.collection("Chats").doc(chatId).collection("Conversations").add(message);

      // 🕒 Update last message
      await db.collection("Chats").doc(chatId).update({ lastMessage: message });

    } catch (error) {
      console.error("❌ Error sending message to user:", error);
    }
  }

  function generateId() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, c => {
      const r = Math.random() * 16 | 0;
      const v = c === 'x' ? r : (r & 0x3 | 0x8);
      return v.toString(16);
    });
  }

  async function hideAlertFromAttorney(alertId) {
    try {
      const confirm = await Swal.fire({
        title: "Permanently Delete?",
        text: "This action cannot be undone.",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Yes, Delete it"
      });

      if (!confirm.isConfirmed) return;

      await db.collection("QuoteAlert").doc(alertId).update({
        isAttorenyHide: true,
        updatedAt: firebase.firestore.FieldValue.serverTimestamp()
      });

      Swal.fire("Deleted", "The alert is now Deleted.", "success");
      loadAlerts();
    } catch (error) {
      console.error("Error hiding alert:", error);
      Swal.fire("Error", "Could not hide alert. Try again later.", "error");
    }
  }

  async function openDocusignDocument(alertId) {

    const allowed = await checkAttorneyMembershipAccess({
      redirectTo: "<?php echo base_url('site/subscriptionAttorney'); ?>",
      showAlert: true
    });

    if (!allowed) return; // 🚫 Stop non-members

    if (!currentUserData || !currentUserData.LawFirmId) {
      Swal.fire("Error", "LawFirm ID not found.", "error");
      return;
    }

    const lawFirmId = currentUserData.LawFirmId;

    try {
      // 1️⃣ Fetch QuoteAlert document
      const alertDoc = await db.collection("QuoteAlert").doc(alertId).get();

      if (!alertDoc.exists) {
        Swal.fire("Error", "QuoteAlert document not found.", "error");
        return;
      }
      console.log("alertId",alertId);
      

      const alertData = alertDoc.data();

      // Check if QuoteAlert has its own template ID
      let selectedTemplateId = null;

      if (alertData.template_id) {
        selectedTemplateId = alertData.template_id;
      } else if (alertData.Immegrationtemplate_id) {
        selectedTemplateId = alertData.Immegrationtemplate_id;
      }



      if (!selectedTemplateId) {
        // Fetch current law firm once
        const lawFirmDoc = await db.collection("LawFirm").doc(lawFirmId).get();

        if (!lawFirmDoc.exists) {
          Swal.fire("Error", "LawFirm document not found.", "error");
          return;
        }

        const lawFirmData = lawFirmDoc.data();

        // 🔁 CASE 1: Attached attorney → fetch admin firm template
        if (lawFirmData.attachedWithLawfirmId && lawFirmData.attachedWithLawfirmId.trim() !== "") {
          const adminFirmDoc = await db
            .collection("LawFirm")
            .doc(lawFirmData.attachedWithLawfirmId)
            .get();

          if (!adminFirmDoc.exists) {
            Swal.fire("Error", "Admin LawFirm document not found.", "error");
            return;
          }

          selectedTemplateId = adminFirmDoc.data()?.templateId;
        } 
        // 🔁 CASE 2: Admin / standalone firm → use own template
        else {
          selectedTemplateId = lawFirmData.templateId;
        }

        console.log("selectedTemplateId", selectedTemplateId);

        // Final validation
        if (!selectedTemplateId) {
          Swal.fire(
            "Error",
            "No template ID found for this law firm.",
            "error"
          );
          return;
        }
      }



      // 3️⃣ Open Docusign Document
      // const url = `https://buzzwaretechserver.site/duepro_docusign_apis/index.php/docusign/view?template_id=${selectedTemplateId}&doc_id=${alertId}`;
      const url = `https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/view?template_id=${selectedTemplateId}&doc_id=${alertId}`;
      // const url = `https://duepro.com/test_docusign_apis/index.php/docusign/view?template_id=${selectedTemplateId}&doc_id=${alertId}`;

      window.open(url, "_blank");

    } catch (error) {
      console.error("Error opening document:", error);
      Swal.fire("Error", "Cannot open document.", "error");
    }
  }

  async function archiveByLawyer(alertId) {
      const result = await Swal.fire({
        title: 'Move to Archive?',
        text: 'You can restore this alert within 30 days of when the alert occurred.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, archive it',
        cancelButtonText: 'Cancel',
        reverseButtons: true
      });

      if (result.isConfirmed) {
        try {
          await db.collection("QuoteAlert").doc(alertId).update({
            isLawArchived: true,
            updatedAt: firebase.firestore.FieldValue.serverTimestamp()
          });

          Swal.fire({
            icon: "success",
            title: "Archived",
            text: "This alert has been archived successfully.",
          });

          loadAlerts(); // reload alert list
        } catch (error) {
          console.error("Error archiving:", error);
          Swal.fire({
            icon: "error",
            title: "Error",
            text: "Failed to archive this alert.",
          });
        }
      }
  }

</script> 

<script src="<?= base_url('/assets/js/model.js'); ?>"></script>


<style>
  .css-arrow {
    position: relative;
    padding-right: 16px;
  }

  .css-arrow::after {
    content: "";
    position: absolute;
    right: 0;
    top: 50%;
    width: 6px;
    height: 6px;
    border-top: 2px solid currentColor;
    border-right: 2px solid currentColor;
    transform: translateY(-50%) rotate(45deg);
  }

</style>