<link
  rel="stylesheet"
  href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"
/>


<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<style>
  .swiper-container {
    overflow: hidden;
  }
  .swiper-button-prev {
    left:unset !important;
    right:unset !important
  }
  .activity-user-card-title{
    margin-right: auto;
  }
  .info-card-detail{
    padding-right: 10px;
  }
  .modal.fade.show{
    display: flex !important;
    align-items: center;
    justify-content: center;
  }

  /* Ensure autocomplete dropdown appears above other fields */
  .autocomplete-wrapper gmp-place-autocomplete {
    position: relative;
    z-index: 1056; /* higher than Bootstrap modal body */
  }

  /* Fix internal input height */
  gmp-place-autocomplete::part(input) {
    height: 38px;
    border-radius: 0.375rem;
    /* border: 1px solid #ced4da; */
    background: #ffffff;
  }

  /* Dropdown layer fix */
  gmp-place-autocomplete::part(dropdown) {
    z-index: 1060;
  }
  .location-input {
    color-scheme: light only !important;
  }

  .btn-view-document:hover{
    background-color: #0412ca;
  }

   p{
    margin: 0;
  }

  .document-icon{
    max-width: 280px;
    width: 100%;
    
  }

  .btn-count {
  display: flex;
  align-items: center;
  gap: 6px;
  padding: 6px 10px;
  font-size: 13px;
  border-radius: 6px;
  background: #f4f6fb;
  color: #333;
  border: 1px solid #dcdfe8;
  transition: all 0.2s ease;
  white-space: nowrap;
  }
  .btn-count:hover {
    border-color: #dcdfe8;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);}

  .btn-count img {
    width: 16px;
    height: 16px;
  }

  .btn-count{
      background: #F5F6FB;
      border-radius: 8px;
      color: #0412ca;
    }

  .modal-dialog.modal-dialog-centered{
    max-width: 400px;
    width: 100%;
  }

</style>

<main class="">
  <div class="container">
    <div class="my-5">
      <div class="row">
        <div class="col-md-12 my-2 d-flex w-100">
          <form class="d-flex position-relative mt-2 mt-md-0 w-100" role="search">
            <input class="form-control me-4 search w-100 bg-white pe-4" type="search" placeholder="Search"
              aria-label="Search" style="width: 350px" />
            <img src="../assets/images/icons/searchicon.png" alt="" width="15px" height="15px" class="searchIcon" />
          </form>
          <button onclick="openIncidentModal()" type="button" class="btn btn-save py-1 btn-same btn-width">
            Add Incident
          </button>
        </div>
        <div class="col-md-12 my-2 d-flex">
          <h2 class="d-flex position-relative mt-2 mt-md-0 m-auto">
            Alert History
          </h2>

        </div>
      </div>
      <div class="row my-2">

        <!-- Loader Overlay -->
        <div id="loaderOverlay2" class="d-flex justify-content-center align-items-center" style=" width:100%; height:100%; 
            background: rgba(255,255,255,0.8); z-index: 9999; display: none;">
          <div class="spinner-border text-primary" role="status" style="width:3rem; height:3rem;">
            <span class="visually-hidden">Loading...</span>
          </div>
        </div>

      </div>


      <!-- Incident Modal -->
      <div class="modal fade" id="incidentModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
          <form id="incidentForm" class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Add Incident</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body row g-3">
              <div class="col-md-6">
                <label class="custom-label">Incident Type</label>
                <select id="incidentType" class="form-control custom-input" required>
                  <option value="">Select incident type</option>
                  <option value="Criminal Defense">Criminal Defense</option>
                  <option value="Traffic / Criminal Defense">Traffic / Criminal Defense</option>
                  <option value="Immigration Law">Immigration Law</option>
                  <option value="Personal Injury">Personal Injury</option>
                  <option value="Family Law">Family Law</option>
                  <option value="Employment Law">Employment Law</option>
                  <option value="Business / Corporate Law">Business / Corporate Law</option>
                  <option value="Real Estate">Real Estate</option>
                  <option value="Bankruptcy Law">Bankruptcy Law</option>
                  <option value="Tax Law">Tax Law</option>
                  <option value="Civil Litigation / Consumer Protection">Civil Litigation / Consumer Protection</option>
                  <option value="General Practice">General Practice</option>
                </select>
              </div>

              <div class="col-md-6">
                <label class="custom-label">Who is this for?</label>
                <select class="form-control custom-input" id="forSelect">
                  <option value="Someone else">Someone else</option>
                  <option value="Me">Me</option>
                </select>
              </div>

              <div class="col-md-6" id="nameDiv">
                <label class="custom-label">Name</label>
                <input class="form-control custom-input" placeholder="Person name" required>
              </div>


              <div class="col-md-6">
                <label class="custom-label" >Incident Date & Time</label>
                <input id="incidentDateTime" type="datetime-local" class="form-control custom-input" required>
              </div>

              <div class="col-md-12">
                <label for="incidentAddress" class="custom-label mb-2" data-i18n="address">Address</label>
                <gmp-place-autocomplete
                  class="pac-target-input form-control location-input p-0"
                  id="incidentAddress"
                  placeholder="Enter incident address"
                  required
                  >
                </gmp-place-autocomplete>

                <input type="hidden" id="incidentLat" required>
                <input type="hidden" id="incidentLng" required>
              </div>

              


              <div class="col-md-12">
                <label class="custom-label">Description (optional)</label>
                <textarea id="incidentDescription" class="form-control custom-input" rows="3"></textarea>
              </div>

              <div class="col-md-12">
                <label class="custom-label">Upload Documents (optional)</label>
                <input type="file" id="incidentFile" class="form-control custom-input">
              </div>

            </div>

            <div class="modal-footer">
              <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Cancel</button>
              <button class="btn btn-save" type="submit">Submit Incident</button>
            </div>
          </form>
        </div>
      </div>


      <!-- <div class="col-md-12 my-2">
                <button class="btn btnLoad d-block mx-auto  btn-same">                Load More
                </button>
              </div> -->


      <div class="modal fade" id="optOutListModal" tabindex="-1">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Opted-Out Attorneys</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>

          <div class="modal-body">
            <ul id="optOutAttorneyList" class="list-group">
              <!-- Names injected here -->
            </ul>
          </div>
        </div>
      </div>
    </div>

    </div>
  </div>
  </div>
</main>
 
<script>(g=>{var h,a,k,p="The Google Maps JavaScript API",c="google",l="importLibrary",q="__ib__",m=document,b=window;b=b[c]||(b[c]={});var d=b.maps||(b.maps={}),r=new Set,e=new URLSearchParams,u=()=>h||(h=new Promise(async(f,n)=>{await (a=m.createElement("script"));e.set("libraries",[...r]+"");for(k in g)e.set(k.replace(/[A-Z]/g,t=>"_"+t[0].toLowerCase()),g[k]);e.set("callback",c+".maps."+q);a.src=`https://maps.${c}apis.com/maps/api/js?`+e;d[q]=f;a.onerror=()=>h=n(Error(p+" could not load."));a.nonce=m.querySelector("script[nonce]")?.nonce||"";m.head.append(a)}));d[l]?console.warn(p+" only loads once. Ignoring:",g):d[l]=(f,...n)=>r.add(f)&&u().then(()=>d[l](f,...n))})
({key: "AIzaSyB0jx5yCf4vk4I5ridEorfPMqohEhpH1H4", v: "weekly"});</script>

<script src="<?= base_url('assets/js/subscription.js'); ?>"></script>

<script>
  const db = firebase.firestore();


  let currentUserName = "";
  let selectedIncidentAddress = null;
  let city = "";
  let county = "";
  let country = "";

  const container = document.querySelector(".row.my-2");
  const loadBtn = document.createElement('button');
  loadBtn.className = 'btn btn-save btn-same mt-3 d-block mx-auto';
  loadBtn.textContent = 'Load More';
  const searchInput = document.querySelector('.search');

  let alertsByDate = [];
  let allAlertsByDate = [];
  let shownGroups = 3;
  let consultCount = 0;
  let quoteCount = 0;
  let optOutCount = 0;

  firebase.auth().onAuthStateChanged(async (user) => {
    if (!user) return;

    showLoader();

    const quoteRef = db.collection("QuoteAlert");

    // Fetch current user info
    const userDoc = await db.collection("Users").doc(user.uid).get();
    if (!userDoc.exists) return;

    currentUserName = userDoc.data().Name || "";
    const fullAddress = userDoc.data().address || "";
    if (fullAddress) {
      const locationData = parseAddress(fullAddress);
      city = locationData.city;
      county = locationData.county;
      country = locationData.country;
    }

    const friendsIds = Object.keys(userDoc.data().userFriends || {});
    const allUserIds = [user.uid, ...friendsIds];

    // Real-time listener for quotes
    quoteRef.where("userId", "in", allUserIds).onSnapshot(async (snapshot) => {
      const allQuotes = [];

      for (const doc of snapshot.docs) {
        const q = { id: doc.id, ...doc.data(), date: new Date(doc.data().createdDate) };

        // Skip archived, copied, or new hire quotes
        if (q.isCopy || q.isNewHire || q.isUserArchived) continue;

        // Fetch user data for each quote
        const uDoc = await db.collection("Users").doc(q.userId).get();
        const userData = uDoc.exists ? uDoc.data() : {};
        q.userName = userData.Name || 'N/A';
        q.userDOB = userData.userDOB || null;

        // Reverse geocode if lat/lng available
        if (q.userLat && q.userLng) {
          q.address = await getAddressFromCoords(q.userLat, q.userLng);
        } else {
          q.address = "Unknown location";
        }

        allQuotes.push(q);
      }

      // Group quotes by date
      // const grouped = {};
      // allQuotes.forEach(a => {
      //   const key = a.date.toDateString();
      //   (grouped[key] ||= []).push(a);
      // });

      // allAlertsByDate = Object.entries(grouped).map(([day, items]) => ({ day, items }));
      // alertsByDate = [...allAlertsByDate];
      // ✅ SORT FIRST (LATEST FIRST)
      allQuotes.sort((a, b) => (b.createdDate || 0) - (a.createdDate || 0));

      const grouped = {};

      allQuotes.forEach(q => {
        const key = q.date.toDateString();
        if (!grouped[key]) grouped[key] = [];
        grouped[key].push(q); // already sorted
      });

      // ✅ PRESERVE ORDER of days
      allAlertsByDate = Object.keys(grouped).map(day => ({
        day,
        items: grouped[day]
      }));

      alertsByDate = [...allAlertsByDate];
      shownGroups = 3;

        // 🔥 THIS updates UI automatically after delete/add/update
      renderGroups();

    });
  
    const userData = userDoc.data();
    const userFriendsMap = userData.userFriends || {};
    const friendIds = Object.keys(userFriendsMap);

    // Own quotes
    const ownSnap = await quoteRef.where("userId", "==", user.uid).get();

    const ownQuotes = ownSnap.docs.map(d => ({ id: d.id, ...d.data(), date: new Date(d.data().createdDate) }))
      .filter(d => d.isUserArchived === false || d.isUserArchived === undefined);

    let friendQuotes = [];
    for (let i = 0; i < friendIds.length; i += 10) {
      const chunk = friendIds.slice(i, i + 10);
      const friendSnap = await quoteRef
        .where("userId", "in", chunk)
        .get();

      friendQuotes.push(
        ...friendSnap.docs
          .map(d => ({ id: d.id, ...d.data(), date: new Date(d.data().createdDate) }))
          .filter(d => d.isUserArchived === false || d.isUserArchived === undefined)
      );
    }

    // let allQuotes = [...ownQuotes, ...friendQuotes].sort((a, b) => b.date - a.date);
    let allQuotes = [...ownQuotes, ...friendQuotes]
    .filter(q =>
      q.isCopy !== true &&
      q.isNewHire !== true
    ).sort((a, b) => b.date - a.date);
    
    allQuotes = allQuotes.filter(
      (item, index, self) => index === self.findIndex(q => q.id === item.id)
    );

    // const userIds = [
    //   ...new Set(allQuotes.flatMap(q => [q.userId, q.LawId, q.imigrationLawId].filter(Boolean)))
    // ];
    const userIds = [
      ...new Set(allQuotes.map(q => q.userId).filter(Boolean))
    ];

    const lawFirmIds = [
      ...new Set(
        allQuotes.flatMap(q => [q.LawId, q.imigrationLawId].filter(Boolean))
      )
    ];

    const lawFirmMap = {};

    for (const id of lawFirmIds) {
      const lfDoc = await db.collection("LawFirm").doc(id).get();
      if (lfDoc.exists) lawFirmMap[id] = lfDoc.data();
    }



    const userMap = {};

    for (const uid of userIds) {
      const uDoc = await db.collection("Users").doc(uid).get();
      if (uDoc.exists) userMap[uid] = uDoc.data();
    }

    for (const q of allQuotes) {
      const userData = userMap[q.userId] || {};

      // const criminalAttorney = q.LawId ? userMap[q.LawId] : null;
      // console.log("criminalAttorney",criminalAttorney);
      
      const immigrationLawId = q.imigrationLawId || q.immigrationLawId;
      // const immigrationAttorney = immigrationLawId ? userMap[immigrationLawId] : null;

      q.userName = userData.Name || 'N/A';
      q.userDOB = userData.userDOB || null;

      if (q.userLat && q.userLng) {
        q.address = await getAddressFromCoords(q.userLat, q.userLng);
      } else {
        q.address = "Unknown location";
      }

      // q.criminalAttorneyName = q.LawId
      //   ? (criminalAttorney ? criminalAttorney.professionalName : 'N/A')
      //   : 'N/A';

      // q.immigrationAttorneyName = immigrationLawId
      //   ? (immigrationAttorney ? immigrationAttorney.professionalName : 'N/A')
      //   : 'N/A';

      const criminalFirm = q.LawId ? lawFirmMap[q.LawId] : null;
      const immigrationFirm = immigrationLawId ? lawFirmMap[immigrationLawId] : null;

      q.criminalAttorneyName = criminalFirm?.professionalName || 'N/A';
      q.immigrationAttorneyName = immigrationFirm?.professionalName || 'N/A';


      q.attorneyName = `${q.criminalAttorneyName}, ${q.immigrationAttorneyName}`;
      q.ANumber = userData.ANumber || 'N/A';
      q.countryOfCitizenship = userData.countryOfCitizenship || 'N/A';
      q.visaType = userData.visaType || 'N/A';
      q.visaExpiryDate = userData.visaExpryDate || userData.visaExpiryDate || 'N/A';
    }

    const grouped = {};
    allQuotes.forEach(a => {
      const key = a.date.toDateString();
      (grouped[key] ||= []).push(a);
    });

    allAlertsByDate = Object.entries(grouped).map(([day, items]) => ({ day, items }));
    alertsByDate = [...allAlertsByDate];    

    document.addEventListener("click", async (e) => {
      // 🔹 QUOTES
      const quoteBtn = e.target.closest(".btn-quote");
      if (quoteBtn) {
        window.location.href = "quotesUser";
        return;
      }

      // 🔹 CONSULTS
      const consultBtn = e.target.closest(".btn-consult");
      if (consultBtn) {
        const docId = consultBtn.dataset.docid;
        window.location.href = `quotesUser?openConsults=1&docId=${docId}`;
        return;
      }

      // 🔹 OPT-OUT
      const optOutBtn = e.target.closest(".btn-optout");
      if (optOutBtn) {
        const docId = optOutBtn.dataset.docid;
        console.log("docId",docId);
        
        await openOptOutModal(docId);
        return;
      }

      
    });

    renderGroups();
    hideLoader(); // ✅ Hide spinner after all operations
  });

  function showLoader() {
    document.getElementById("loaderOverlay2").style.display = "flex";
  }

  function hideLoader() {
    const hideLoad = document.getElementById("loaderOverlay2");
    if (!hideLoad) return; // ✅ prevent crash
    hideLoad.style.display = "none";
  }

  function parseAddress(address) {
    let city = "", county = "", country = "";

    if (!address) return { city, county, country };

    // Split by commas and trim each part
    const parts = address.split(",").map(p => p.trim());

    // If only 1 part, assume it's country
    if (parts.length === 1) {
      country = parts[0];
    }
    // If 2 parts, assume city + country
    else if (parts.length === 2) {
      city = parts[0];
      country = parts[1];
    }
    // If 3 parts, assume city, county, country
    else if (parts.length === 3) {
      city = parts[0];
      county = parts[1];
      country = parts[2];
    }
    // 4 or more parts, take last as country, second last as county, rest joined as city
    else if (parts.length >= 4) {
      country = parts[parts.length - 1];
      county = parts[parts.length - 2];
      city = parts.slice(0, parts.length - 2).join(", ");
    }

    return { city, county, country };
  }

  async function initIncidentAddress() {
    await google.maps.importLibrary("places");

    const el = document.getElementById("incidentAddress");
    el.addEventListener("gmp-select", async (e) => {
    const place = e.placePrediction.toPlace();

    await place.fetchFields({
      fields: ["id", "displayName", "formattedAddress", "location"]
    });

    selectedIncidentAddress = {
      id: place.id,
      displayName: place.displayName,
      formattedAddress: place.formattedAddress,
      location: {
        lat: place.location.lat(),
        lng: place.location.lng()
      }
    };
    });
  }

  document.addEventListener("DOMContentLoaded", initIncidentAddress);



  async function openIncidentModal() {
    const user = firebase.auth().currentUser;
    if (!user) return;

    // 🔒 HARD membership gate
    const allowed = await checkMembershipAccess({
      redirectTo: "<?php echo base_url('site/membership'); ?>"
    });

    // ⛔ STOP everything if not allowed
    if (!allowed) return;

    const modalEl = document.getElementById("incidentModal");
    if (!modalEl) {
      console.error("❌ Modal element not found");
      return;
    }

    const modal = new bootstrap.Modal(modalEl);
    modal.show();

  }

  document.addEventListener("DOMContentLoaded", () => {
    console.log("🚀 Document ready, initializing form...");

    const forSelect = document.getElementById("forSelect");
    const nameDiv = document.getElementById("nameDiv");
    const nameInput = nameDiv?.querySelector("input");
    const incidentForm = document.getElementById("incidentForm");

    if (!forSelect || !nameDiv || !nameInput || !incidentForm) {
      console.error("❌ Required form elements not found");
      return;
    }

    /* ---- Toggle Name Field ---- */
   function toggleNameField() {
    if (forSelect.value === "Someone else") {
      nameDiv.style.display = "block";
      nameInput.value = "";
      nameInput.removeAttribute("readonly");
    } else {
      nameDiv.style.display = "block";
      nameInput.value = currentUserName;
      nameInput.setAttribute("readonly", true);
    }
    }

    toggleNameField();
    forSelect.addEventListener("change", toggleNameField);

    // ✅ Fix: Reapply toggle when modal opens
    document.getElementById("incidentModal").addEventListener("shown.bs.modal", () => {
      toggleNameField();
    });

    /* ---- Form Submission ---- */
    incidentForm.addEventListener("submit", async (e) => {
      e.preventDefault();

      try {
        // Check authentication
        const user = firebase.auth().currentUser;

        if (!user) {
          throw new Error("You must be logged in to submit an incident");
        }

        // Get form values
        const incidentType = document.getElementById("incidentType")?.value;
        const incidentDateTimeValue = document.getElementById("incidentDateTime")?.value;

        // Validate required fields
        if (!incidentType) {
          Swal.fire("Error", "Please select an incident type.", "error");
          document.getElementById("incidentType")?.focus();
          return;
        }

        if (!incidentDateTimeValue) {
          Swal.fire("Error", "Please select incident date and time.", "error");
          document.getElementById("incidentDateTime")?.focus();
          return;
        }

        // ✅ Validate incident location (REQUIRED)
        if (
          !selectedIncidentAddress ||
          !selectedIncidentAddress.location ||
          typeof selectedIncidentAddress.location.lat !== "number" ||
          typeof selectedIncidentAddress.location.lng !== "number"
        ) {
          Swal.fire(
            "Address Required",
            "Please select a valid address from the suggestions.",
            "warning"
          );

          document.getElementById("incidentAddress")?.focus();
          return; // ⛔ STOP submission
        }


        // Prepare incident data
        const newQuote = {
          quoteType: "Manual Incident",
          city: city || "",
          county: county || "",
          country: country || "",
          personAffected: forSelect.value || "Me",
          personName: forSelect.value === "Me"
              ? currentUserName
              : nameInput.value.trim(),
          incidentDateTime: new Date(incidentDateTimeValue).getTime(),
          incidentDescription: document.getElementById("incidentDescription")?.value || "",
          incidentType: incidentType,
          incidentLocation: selectedIncidentAddress
            ? selectedIncidentAddress.formattedAddress
            : "",
          userLat: selectedIncidentAddress?.location?.lat || null,
          userLng: selectedIncidentAddress?.location?.lng || null,
          qoutesPrice: 0,
          qoutesDeposite: 0,
          paidStatus: "0",
          status: "request",
          // createdDate: incidentDateTimeValue,
          createdDate: Date.now(),
          updatedAt: Date.now(),
          userId: user.uid,
          findAttorney: [],
          scheduledConsult: [],
          isActive: true,
          isInActive: true,
          isAttorneyAlerted: false,
          isFalse: false,
          isNewHire: false,
          isOptOut: false,
          isLawArchived: false,
        };

        // Optional file upload (Documents only)
        const fileInput = document.getElementById("incidentFile");
        if (fileInput?.files?.length > 0) {
          const file = fileInput.files[0];

          // ✅ Allowed document MIME types
          const allowedTypes = [
            "application/pdf",
            "application/msword",
            "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
            "text/plain"
          ];

          if (!allowedTypes.includes(file.type)) {
            Swal.fire("Error", "Only documents (PDF, DOC, DOCX, TXT) are allowed.", "error");
            return; // ❌ Stop form submission
          } else {
            console.log("📎 Uploading document...");
            const fileName = `${Date.now()}_${file.name}`;
            const storageRef = firebase.storage().ref(`user_uploads/${fileName}`);
            
            await storageRef.put(file);
            newQuote.docUrl = await storageRef.getDownloadURL();
            console.log("✅ Document uploaded successfully");
          }
        }

        // Save to Firestore
        await firebase.firestore().collection("QuoteAlert").add(newQuote);
        console.log("✅ Document saved successfully!");

        // await reloadAlerts();  // <--- ADD THIS

        // Show success message
        await Swal.fire({
          title: "Success!",
          text: "Your incident has been submitted successfully.",
          icon: "success",
          confirmButtonText: "OK"
        });
        renderGroups();

        // Close modal and reset
        const modalInstance = bootstrap.Modal.getInstance(document.getElementById("incidentModal"));
        if (modalInstance) {
          modalInstance.hide();
          incidentForm.reset();
          selectedIncidentAddress = null;
          forSelect.value = "Me";
          toggleNameField();
        }
        
        // Reset everything when modal closes
        // document.getElementById("incidentModal").addEventListener("hidden.bs.modal", () => {
          
        //   });
       
        const placeEl = document.getElementById("incidentAddress");
        if (placeEl) {
          placeEl.value = "";              // clears visible text
          placeEl.dispatchEvent(new Event("input")); // clears internal state
        }


      } catch (error) {
        console.error("❌ Submission error:", error);
        Swal.fire({
          title: "Error",
          text: error.message || "Failed to submit incident. Please try again.",
          icon: "error",
          confirmButtonText: "OK"
        });
      }
    });

    document.getElementById("incidentModal").addEventListener("hidden.bs.modal", () => {
      incidentForm.reset();
      selectedIncidentAddress = null;
      nameInput.value = "";
      nameInput.removeAttribute("readonly");
      nameDiv.style.display = "none";
    });
  });

  function getAddressFromCoords(lat, lng) {
    return new Promise((resolve, reject) => {
      const geocoder = new google.maps.Geocoder();
      const latlng = { lat: parseFloat(lat), lng: parseFloat(lng) };

      geocoder.geocode({ location: latlng }, (results, status) => {
        if (status === "OK") {
          if (results[0]) {
            resolve(results[0].formatted_address);
          } else {
            resolve("Unknown location");
          }
        } else {
          console.error("Geocoder failed: " + status);
          reject("Geocoder failed: " + status);
        }
      });
    });
  }

  function formatCustomDate(value) {
    if (!value) return "-";
    let date;
    if (value.seconds) {
      date = new Date(value.seconds * 1000);
    }
    // Milliseconds timestamp (number)
    else if (typeof value === "number") {
      date = new Date(value);
    }
    // JS Date object
    else if (value instanceof Date) {
      date = value;
    }
    else {
      return "-";
    }

    return (
      date.toLocaleDateString("en-US", {
        day: "2-digit",
        month: "long",
        year: "numeric"
      }) +
      " , " +
      date.toLocaleTimeString("en-US", {
        hour: "2-digit",
        minute: "2-digit",
        hour12: true
      })
    );
  }


  function setupSequentialVideoPlayback() {
    document.querySelectorAll('.autoplay-video').forEach(video => {
      video.addEventListener('ended', () => {
        const urls = JSON.parse(video.getAttribute('data-urls'));
        let currentIndex = parseInt(video.getAttribute('data-index'), 10);

        if (currentIndex + 1 < urls.length) {
          currentIndex += 1;
          const nextUrl = urls[currentIndex];

          video.setAttribute('data-index', currentIndex);
          video.querySelector('source').src = nextUrl;
          video.load();
          video.play();
        }
      });
    });
  }

  function renderGroups() {
    container.innerHTML = '';
    alertsByDate.slice(0, shownGroups).forEach(({ day, items }, index) => {
      const sortedItems = [...items].sort(
        (a, b) => (b.createdDate || 0) - (a.createdDate || 0)
      );
      const colapseId = `grp-${index}`;
      const html = `
        <p><a class="btn border-0 fp2" data-bs-toggle="collapse" href="#${colapseId}">
          <i class="fa fa-chevron-right"></i> ${day}
        </a></p>
        <div class="collapse show mb-3" id="${colapseId}">
          ${items.map(item => renderCard(item)).join('')}
        </div>`;
      container.insertAdjacentHTML('beforeend', html);
    });

    if (shownGroups < alertsByDate.length) {
      loadBtn.onclick = () => {
        shownGroups += 3;
        renderGroups();
      };
      container.appendChild(loadBtn);
    }

    setupSequentialVideoPlayback();
  };

  function renderCard(item) {
    console.log("item",item);
    
    // 🔹 Compute counts per doc
    const consultCount = Array.isArray(item.scheduledConsult) ? item.scheduledConsult.length : 0;
    const quoteCount = Array.isArray(item.quotedAttorney) ? item.quotedAttorney.length : 0;
    const optOutCount = Array.isArray(item.manualOptoutAttorney)? item.manualOptoutAttorney.length: 0;

    const formattedDate = formatCustomDate(item.date);
    const formattedIncidentDate = formatCustomDate(item.incidentDateTime);
    const userDOB = item.userDOB ? formatDOB(new Date(item.userDOB)) : 'N/A';
    const userAddress = item.address || 'N/A';
    const userName = item.userName || 'N/A';
    const visaExpiryDate = item.visaExpiryDate ? new Date(item.visaExpiryDate).toLocaleDateString() : "N/A";
    

    const acceptedTypesCount = Array.isArray(item.hireAttorneyAcceptedType)
      ? item.hireAttorneyAcceptedType.length
      : 0;

    const disableFindAttorney = acceptedTypesCount > 1;

    // Title
    let titleDetail = '';
    if(item.quoteType === "Manual Incident"){
      titleDetail = `<div class="mr-auto activity-user-card-title">
                  <p class="fp2 mb-2">${item.incidentType || 'N/A'} Incident For ${item.personName || 'N/A'}</p>
                  <p class="ft7 mb-0" style="line-height:normal">${formattedIncidentDate}</p>
                </div>`;
    } else {
      titleDetail = `<div class="mr-auto activity-user-card-title">
                  <p class="fp2 mb-2">Legal Emergency Alert for ${item.title}</p>
                  <p class="ft7 mb-0" style="line-height:normal">${formattedDate}</p>
                </div>`;
    }

    // Media
    let mediaHtml = '';
    if(item.quoteType === "Manual Incident") {
      mediaHtml = item.docUrl 
        ? `<div class="document-preview border rounded p-2">
            <iframe src="${item.docUrl}" width="100%" height="180px" style="border:none;"></iframe>
            <a href="${item.docUrl}" target="_blank" class="btn btn-outline-primary mt-2 w-100 btn-view-document">View Full Document</a>
          </div>`
        : `<img class="document-icon" src="<?= base_url('assets/images/document.png'); ?>" alt="Document Icon" ><p class="text-muted"> No document available.</p>`;
    } else {
      mediaHtml = (item.videoUrls || []).length
        ? `<video class="video-cl w-100 mb-2 autoplay-video" data-index="0" data-urls='${JSON.stringify(item.videoUrls)}' muted autoplay playsinline controls>
            <source src="${item.videoUrls[0]}" type="video/mp4">
          </video>`
        : '<p class="text-muted">No videos available.</p>';
    }

    // Details
    let detailsHtml = '';
    if(item.quoteType === "Manual Incident") {
      detailsHtml = `
      <div class="d-flex flex-column justify-content-evenly h-100">
        <p class="fw-bold text-danger mb-0 mt-2 w-100">Incident Details</p>
        <p class="mb-0 info-card-detail"><strong>Incident Location:</strong> ${item.incidentLocation || 'N/A'}</p>
        ${item.incidentDescription ? `<p class="mb-0 info-card-detail"><strong>Description:</strong> ${item.incidentDescription}</p>` : ''}
      
      </div>
      `;
    } else {
      // Normal quote / existing case
      detailsHtml = `
        <p class="mb-0 info-card-detail"><strong>Address:</strong> ${userAddress}</p>
        <p class="mb-0 info-card-detail"><strong>Date of Birth:</strong> ${userDOB}</p>
        
        <p class="fw-bold text-success mb-0 mt-2 w-100">Immigration Info</p>
        <p class="mb-0 info-card-detail"><strong>A-Number:</strong> ${item.ANumber}</p>
        <p class="mb-0 info-card-detail"><strong>Visa Type:</strong> ${item.visaType}</p>
        <p class="mb-0 info-card-detail"><strong>Visa Expiry Date:</strong> ${visaExpiryDate}</p>
        <p class="mb-0 info-card-detail"><strong>Citizenship:</strong> ${item.countryOfCitizenship}</p>

        <p class="fw-bold text-danger mb-0 mt-2 w-100">Case Details</p>
        <div class="d-flex flex-wrap gap-1">
          <p class="mb-0 info-card-detail"><strong>Detained At:</strong> ${item.detainedPlace || 'N/A'}</p>
          <p class="mb-0 info-card-detail"><strong>Charges:</strong>
            ${Array.isArray(item.offense) && item.offense.length 
              ? item.offense.map(off => `${off.chargedesc || 'Unknown'} (${off.severity || '-'}) - ${off.warrantissuedagency || 'Agency Unknown'}`).join('<br>')
              : 'N/A'}
          </p>
          <p class="mb-0 info-card-detail"><strong>Attorney Alerted:</strong> ${item.isAttorneyAlerted ? 'Yes' : 'No'}</p>
          <div>
            <p class="mb-0 info-card-detail"><strong>Designated Attorneys:</strong></p>
            <div class="d-flex gap-2 flex-wrap">
              <p class="mb-0 info-card-detail"><strong>Criminal Attorney:</strong> ${item.criminalAttorneyName}</p>
              <p class="mb-0 info-card-detail"><strong>Immigration Attorney:</strong> ${item.immigrationAttorneyName}</p>
            </div>
          </div>
        </div>
      `;
    }

    // Buttons
    let alertButtonsHtml = '';
    if (item.quoteType === "Manual Incident") {
      alertButtonsHtml = `
        <div class="d-flex gap-2 flex-wrap action-icons me-auto">
          <button class="btn btn-count btn-consult py-1 btn-same d-flex align-items-center gap-1 btn-width" data-docid="${item.id}">
            <img src="<?= base_url('assets/images/calender.png'); ?>" />
            <span>Consults</span>
            <p class="count">${consultCount}</p>
          </button>

          <button class="btn btn-count btn-quote py-1 btn-same d-flex align-items-center gap-1 btn-width">
            <img src="<?= base_url('assets/images/money.png'); ?>" />
            <span>Quotes</span>
            <p class="count">${quoteCount}</p>
          </button>

          <button class="btn btn-count btn-optout py-1 btn-same d-flex align-items-center gap-1 btn-width"
            data-docid="${item.id}">
            <img src="<?= base_url('assets/images/optout.png'); ?>" />
            <span>Opt-Out</span>
            <p class="count">${optOutCount}</p>
          </button>               
        </div>
        <!-- <a href="<?= base_url('site/findattornyIncident'); ?>?id=${item.id}" 
          class="btn btn-save btn-same btn-width ${disableFindAttorney ? 'disabled' : ''}"
          ${disableFindAttorney ? 'aria-disabled="true"' : ''}
          onclick='${disableFindAttorney ? 'return false;' : 'storeAlert(this)'}'
          data-item='${JSON.stringify(item).replace(/"/g, "&quot;")}' >
          Find Attorney
        </a> -->
        <a href="javascript:void(0);" 
          class="btn btn-save btn-same btn-width" 
          data-item='${JSON.stringify(item).replace(/"/g, "&quot;")}'
          onclick="handleFindAttorneyIncident(this)">
          Find Attorney
        </a>


        <button onclick="deleteQuote('${item.id}')" class="btn btn-danger py-1 btn-same d-flex align-items-center gap-1 btn-width">
          <i class="fa fa-trash"></i> Delete
        </button>
      `;
    } else {
      alertButtonsHtml = `
        <button onclick="fetchArrestDetails('${item.title}', '${item.id}')" class="btn btn-save py-1 btn-same btn-width">
            Arrest Details
        </button>
        <!--
        <a href="<?= base_url('site/findattorny'); ?>?id=${item.id}" 
          class="btn btn-save btn-same btn-width ${disableFindAttorney ? 'disabled' : ''}"
          ${disableFindAttorney ? 'aria-disabled="true"' : ''}
          onclick='${disableFindAttorney ? 'return false;' : 'storeAlert(this)'}'
          data-item='${JSON.stringify(item).replace(/"/g, "&quot;")}' >
          Find Attorney
        </a> -->

        <a href="javascript:void(0);" 
          class="btn btn-save btn-same btn-width" 
          data-item='${JSON.stringify(item).replace(/"/g, "&quot;")}'
          onclick="handleFindAttorney(this)">
          Find Attorney
        </a>

        <button onclick="deleteQuote('${item.id}')" class="btn btn-danger py-1 btn-same d-flex align-items-center gap-1 btn-width">
          <i class="fa fa-trash"></i> Delete
        </button>
      `;
    }

    // Final Card HTML
    return `
      <div class="col-md-12 my-2">
        <div class="card stCard">
          <div class="card-body">
            <div class="col-md-12 d-flex justify-content-end">
              ${titleDetail}
              <div class="d-flex gap-2 align-items-center">
                ${item.isFalse ? `<img src="<?= base_url('assets/images/icons/warning.png'); ?>" alt="Warning" style="width: 20px; height: 20px;" title="False Alert" />` : ""}
                <button onclick="archiveQuote('${item.id}')" class="btn btn-sm py-1 px-2 btn-ar" title="Archive">
                  <img src="<?= base_url(); ?>/assets/images/icons/ari.png"/> <small>Archive</small>
                </button>
              </div>
            </div>

            <div class="row g-2">
              <div class="col-md-6">
                <div class="d-flex flex-wrap flex-column h-100">
                  ${detailsHtml}
                </div>
              </div>
              <div class="col-md-6 text-center mb-2">${mediaHtml}</div>
            </div>

            <div class="d-flex justify-content-end gap-2 mt-2 flex-wrap">
              ${alertButtonsHtml}
            </div>
          </div>
        </div>
      </div>
    `;
  }

  // async function handleFindAttorneyIncident(el) {
  //   const item = JSON.parse(el.dataset.item.replace(/&quot;/g, '"'));

  //   const allowed = await checkMembershipAccess({
  //     redirectTo: "<?php echo base_url('site/membership'); ?>"
  //   });

  //   if (!allowed) return; // 🚫 stop non-members

  //   // ✅ User is allowed → continue normal action
  //   storeAlert(el);

  //   // Navigate to page
  //   window.location.href = `<?= base_url('site/findattornyIncident'); ?>?id=${item.id}`;
  // }
  async function handleFindAttorneyIncident(el) {
    const item = JSON.parse(el.dataset.item.replace(/&quot;/g, '"'));

    // ✅ Membership check first
    const allowed = await checkMembershipAccess({
      redirectTo: "<?php echo base_url('site/membership'); ?>"
    });
    if (!allowed) return; // stop non-members

    // ✅ Call your actual alert/store function here
    // Make sure this function exists in your JS
    if (typeof storeAlert === 'function') {
        storeAlert(el); 
    } else {
        console.warn("storeAlert function not found, skipping this step.");
    }

    // Navigate to the attorney incident page
    window.location.href = `<?= base_url('site/findattornyIncident'); ?>?id=${item.id}`;
}


  async function handleFindAttorney(el) {
    const item = JSON.parse(el.dataset.item.replace(/&quot;/g, '"'));

    const allowed = await checkMembershipAccess({
      redirectTo: "<?php echo base_url('site/membership'); ?>"
    });

    if (!allowed) return; // 🚫 stop non-members

     // ✅ Call your actual alert/store function here
    // Make sure this function exists in your JS
    if (typeof storeAlert === 'function') {
        storeAlert(el); 
    } else {
        console.warn("storeAlert function not found, skipping this step.");
    }

    // Navigate to page
    window.location.href = `<?= base_url('site/findattorny'); ?>?id=${item.id}`;
  }


  document.addEventListener("click", function(e) {
    const btn = e.target.closest(".btn-find-attorney");
    if (!btn) return;

    const id = btn.dataset.id;
    storeAlert(id);
    window.location.href = `<?= base_url('site/findattornyIncident'); ?>?id=${id}`;
  });
  
  async function openOptOutModal(docId) {
    try {
      const listEl = document.getElementById("optOutAttorneyList");
      listEl.innerHTML = `<li class="list-group-item">Loading...</li>`;

      // 🔎 Get QuoteAlert doc
      const docSnap = await db
        .collection("QuoteAlert")
        .doc(docId)
        .get();

      if (!docSnap.exists) {
        listEl.innerHTML = `
          <li class="list-group-item text-muted">
            No opt-out data found
          </li>`;
        return;
      }

      const attorneyIds = Array.isArray(docSnap.data().manualOptoutAttorney)
        ? docSnap.data().manualOptoutAttorney
        : [];

      if (!attorneyIds.length) {
        listEl.innerHTML = `
          <li class="list-group-item text-muted">
            No attorneys opted out
          </li>`;
      } else {
        listEl.innerHTML = "";

        // 🚀 Fetch users in parallel
        const userDocs = await Promise.all(
          attorneyIds.map(id =>
            db.collection("Users").doc(id).get()
          )
        );

        userDocs.forEach(doc => {
          const data = doc.data() || {};

          const name =
            data.Name ||
            "Unnamed Attorney";

          const image =
            data.imageUrl ||
            "https://ui-avatars.com/api/?name=" + encodeURIComponent(name);

          const li = document.createElement("li");
          li.className = "list-group-item d-flex align-items-center gap-3";

          li.innerHTML = `
            <img
              src="${image}"
              alt="${name}"
              class="rounded-circle"
              style="width:40px;height:40px;object-fit:cover;"
            />
            <span class="fw-semibold">${name}</span>
          `;

          listEl.appendChild(li);
        });
      }

      // ✅ Show modal
      new bootstrap.Modal(
        document.getElementById("optOutListModal")
      ).show();

    } catch (error) {
      console.error("Error loading opt-out list:", error);
      Swal.fire("Error", "Failed to load opt-out attorneys.", "error");
    }
  }



  async function archiveQuote(id) {
    const result = await Swal.fire({
      title: 'Move to Archive?',
      text: 'You can restore this alert within 30 days of when the alert occurred.',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Yes, archive it',
      cancelButtonText: 'Cancel',
      reverseButtons: true
    });

    if (result.isConfirmed) {
      try {
        await db.collection("QuoteAlert").doc(id).update({ isUserArchived: true });
        Swal.fire("Archived", "This alert has been archived.", "success");
        location.reload();
      } catch (error) {
        console.error(error);
        Swal.fire("Error", "Failed to archive the alert.", "error");
      }
    }
  }

  function formatDOB(date) {
    return date.toLocaleDateString('en-US', {
      day: '2-digit',
      month: 'long',
      year: 'numeric'
    });
  }

  async function deleteQuote(id) {
    const confirm = await Swal.fire({
      title: "Permanently Delete?",
      text: "This action cannot be undone.",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Yes, delete it!",
      cancelButtonText: "Cancel"
    });

    if (!confirm.isConfirmed) return;

    try {
      await db.collection("QuoteAlert").doc(id).delete();

      Swal.fire("Deleted!", "The activity has been deleted.", "success");

      // ❌ DO NOT call renderGroups here
      // onSnapshot will auto-refresh the UI
    } catch (error) {
      console.error(error);
      Swal.fire("Error", "Failed to delete the activity.", "error");
    }
  }

  // async function deleteQuote(id) {
  //   const confirm = await Swal.fire({
  //     title: "Permanently Delete?",
  //     text: "This action cannot be undone.",
  //     icon: "warning",
  //     showCancelButton: true,
  //     confirmButtonText: "Yes, delete it!",
  //     cancelButtonText: "Cancel"
  //   });

  //   if (confirm.isConfirmed) {
  //     try {
  //       await db.collection("QuoteAlert").doc(id).delete();
  //       Swal.fire("Deleted!", "The activity has been deleted.", "success");
  //     } catch (error) {
  //       console.error(error);
  //       Swal.fire("Error", "Failed to delete the activity.", "error");
  //     }
  //   }
  //   await renderGroups();
  // }

  async function reloadAlerts() {

    const user = firebase.auth().currentUser;
    if (!user) return;
    //  showLoader(); // ✅ Start spinner
    const userDoc = await db.collection("Users").doc(user.uid).get();
    const userData = userDoc.data();
    const userFriendsMap = userData.userFriends || {};
    const friendIds = Object.keys(userFriendsMap);

    const quoteRef = db.collection("QuoteAlert");
    const ownSnap = await quoteRef.where("userId", "==", user.uid).where("isUserArchived", "==", false).get();
    const ownQuotes = ownSnap.docs.map(d => ({ id: d.id, ...d.data(), date: new Date(d.data().createdDate) }));

    let friendQuotes = [];
    for (let i = 0; i < friendIds.length; i += 10) {
      const chunk = friendIds.slice(i, i + 10);
      const friendSnap = await quoteRef.where("userId", "in", chunk).where("isUserArchived", "==", false).get();
      friendQuotes.push(...friendSnap.docs.map(d => ({ id: d.id, ...d.data(), date: new Date(d.data().createdDate) })));
    }

    const allQuotes = [...ownQuotes, ...friendQuotes].sort((a, b) => b.date - a.date);



    const userIds = [...new Set(allQuotes.flatMap(q => [q.userId, q.LawId].filter(Boolean)))];
    const userMap = {};

    for (const uid of userIds) {
      const uDoc = await db.collection("Users").doc(uid).get();
      if (uDoc.exists) {
        userMap[uid] = uDoc.data();
      }
    }

    for (const q of allQuotes) {
      const userData = userMap[q.userId] || {};
      const attorneyData = q.LawId ? userMap[q.LawId] : null;

      q.userName = userData.Name || 'N/A';
      q.userDOB = userData.userDOB || null;

      if (q.userLat && q.userLng) {
        q.address = await getAddressFromCoords(q.userLat, q.userLng); // ✅ works now
      } else {
        q.address = "Unknown location";
      }

      q.attorneyName = attorneyData ? attorneyData.Name : 'N/A';
    }


    const grouped = {};
    allQuotes.forEach(a => {
      const key = a.date.toDateString();
      (grouped[key] ||= []).push(a);
    });

    allAlertsByDate = Object.entries(grouped).map(([day, items]) => ({ day, items }));
    alertsByDate = [...allAlertsByDate];
    shownGroups = 3;
    renderGroups();
     hideLoader(); // ✅ Always hide loader
  }

  async function fetchArrestDetails(name, alertId) {
    
    try {
        const user = firebase.auth().currentUser;
    if (!user) return;

    // 🔒 HARD MEMBERSHIP GATE (nothing runs before this)
    const allowed = await checkMembershipAccess({
      redirectTo: "<?php echo base_url('site/membership'); ?>"
    });

    // ⛔ ABSOLUTE STOP — NO DATA, NO UI, NO LOGS
    if (!allowed) return;
      const upperName = name.toUpperCase();
      let arrest = null;

      // 1️⃣ Try API
      try {
        const res = await fetch(`https://us-central1-duepro-2cf60.cloudfunctions.net/widgets/searchnew?name=${encodeURIComponent(upperName)}`);
        const result = await res.json();

        if (result.success !== 0 && result.result) {
          arrest = result.result;
        }
      } catch (apiError) {
        console.warn("API fetch failed:", apiError);
      }

      // 2️⃣ If API fails, use Firestore
      if (!arrest) {
        const alertDoc = await db.collection("QuoteAlert").doc(alertId).get();
        if (alertDoc.exists) {
          const alertData = alertDoc.data();
          if (alertData.offense && Array.isArray(alertData.offense) && alertData.offense.length > 0) {
            arrest = { fullName: name, offense: alertData.offense };
          }
        }
      }

      // 3️⃣ Show result or not found
      if (!arrest) {
        return Swal.fire("No Record", "No arrest record found.", "info");
      }

      const arrestDate = arrest.arrestDate ? new Date(arrest.arrestDate).toLocaleString() : "N/A";

      Swal.fire({
        title: `Arrest Details`,
        html: `
          <p><strong>Name:</strong> ${arrest.fullName || name}</p>
          <p><strong>Gender:</strong> ${arrest.gender || 'N/A'}</p>
          <p><strong>Age:</strong> ${arrest.age || 'N/A'}</p>
          <p><strong>Address:</strong> ${arrest.address || 'N/A'}</p>
          <p><strong>City/State/Zip:</strong> ${arrest.cityStateZip || 'N/A'}</p>
          <p><strong>Offense:</strong><br />
            ${
              Array.isArray(arrest.offense) && arrest.offense.length
                ? arrest.offense.map(o =>
                    `${o.chargedesc || 'Unknown'} (${o.severity || '-'}) - ${o.warrantissuedagency || 'Unknown Agency'}`
                  ).join('<br>')
                : 'N/A'
            }
          </p>
          <p><strong>Detention:</strong> ${arrest.detention || 'N/A'}</p>
          <p><strong>Arrest Date:</strong> ${arrestDate}</p>
        `,
        confirmButtonText: 'Close'
      });
    } catch (err) {
      console.error(err);
      Swal.fire("Error", "Failed to fetch arrest details.", "error");
    }
  }

</script>