<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<!-- Bootstrap Icons -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
  .select2-container--default .select2-selection--multiple {
    border-radius: 15px;
    filter: drop-shadow(0px 5px 7.5px rgba(0, 0, 0, 0.05));
    background-color: #ffffff;
    padding-block: 0.6rem;
    outline: none;
  }
  .select2-container--default.select2-container--focus .select2-selection--multiple {
    border-color: #86b7fe;
    outline: 0;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
  }

  /* Remove default arrow icon */
  .select2-selection__arrow {
    display: none;
  }

  /* Add Bootstrap-like chevron icon (optional using ::after) */
  .select2-container--default .select2-selection--multiple::after {
    content: '';
    position: absolute;
    top: 50%;
    right: 1rem;
    width: 1rem;
    height: 1rem;
    transform: translateY(-50%);
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='none' viewBox='0 0 16 16' stroke='currentColor' stroke-width='2'%3e%3cpath stroke-linecap='round' stroke-linejoin='round' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-size: 100% 100%;
    pointer-events: none;
    color: #6c757d;
  }
  .social-icon {
    transition: transform 0.2s ease;
  }
  .social-icon:hover {
    transform: scale(1.2);
  }

  .share-container {
    position: relative;
    display: inline-block;
    /* z-index:999; */
  }

  .share-btn {
    background: #0412CA;
    border: none;
    color: #fff;
    border-radius: 50%;
    width: 50px;
    height: 50px;
    font-size: 20px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: background 0.3s, transform 0.2s;
  }

  .share-btn:hover {
    /*background: #0056b3;*/
    transform: scale(1.05);
  }

  .share-options {
    position: absolute;
    top: 90px;
    left: 14px;
    display: flex;
    flex-direction: column;
    gap: 8px;
    opacity: 0;
    transform: translateY(-10px);
    pointer-events: none;
    transition: all 0.25s ease;
    z-index:999;
        background: #0412ca45;
      padding: 10px;
      border-radius: 50px;
  }

  .share-options.active {
    opacity: 1;
    transform: translateY(0);
    pointer-events: auto;
  }

  .share-icon {
    width: 40px;
    height: 40px;
    border: none;
    border-radius: 50%;
    color: #fff;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: transform 0.2s, opacity 0.3s;
  }

  .share-icon:hover {
    transform: scale(1.1);
  }

  .whatsapp { background: #25d366; }
  .facebook { background: #1877f2; }
  .twitter { background: #000000; }
  .linkedin { background: #0a66c2; }
  .instagram { background: #e4405f; }
  .copy { background: #6c757d; }

  .btn-invite{
    color: #ffffff;
    background-color: #0412CA;
    border-radius: 15px;
    padding: 10px 20px;
    border: none;
  }

  .btn-attorney{
    background-color: #02077D;
    color: #ffffff;
    border-radius: 15px;
    padding: 10px 20px;
    border: none;
  }
  .professional_title_wrapper{

  }

  .professional_badge{
    background: #F5F5FC;
    padding:5px;
  }

  #attorneyListModal .modal-content {
    background-color: #F5F6FB;
    border-radius: 15px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    border: none;
  }
  #attorneyListModal .list-group, 
  #attorneyListModal .list-group-item {
    border: none;
  }

  .delete-attorney-btn {
    transition: transform 0.2s ease, background-color 0.2s ease;
  }

  .delete-attorney-btn:hover {
    transform: scale(1.1);
    background-color: #c82333 !important;
  }

  .profile-card {
    background: linear-gradient(
    180deg,
    #0412CA 0%,
    #F5F6FB 30%,
    #F5F6FB 80%
  );
  border-radius: 16px;
  box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
}

.viewer-image {
  width: 120px;
  height: 120px;
  object-fit: cover;
  border: 4px solid #ffffff;
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
}

.modal-content {
  border-radius: 18px;
  overflow: hidden;
}

.modal-header {
  border-bottom: none;
}




   

</style>

<main class="">
  <div class="container">
    <div class="mt-5 mb-2">
      <div class="firm-title__wrapper d-flex align-item-center">
        <p class="fs-1p me-auto" data-i18n="add_law_firm"></p>
        <button type="button" class="btn-attorney" id="invitedAttorneyList">Attoreny(s)</button>
        <button type="button" class="btn btn-outline-primary ms-2 btn-invite" id="inviteBtn">Invite</button>
      </div>

      <div class="">
        <div class="mt-3 text-end d-none">
          <button type="button" id="shrBtn" class="btn btn-save btn-width">
            🔗 Share
          </button>
        </div>

        <!-- Floating Share Button -->
        <div class="d-flex justify-content-end my-2">
          <div class="share-container d-flex align-items-center gap-2 flex-column">
            <p class="fs1 mb-0">Share Invite</p>
            <button id="shareBtn" class="share-btn">
              <i class="bi bi-share-fill"></i>
            </button>
            <div class="share-options" id="shareOptions">
              <button class="share-icon whatsapp" data-platform="whatsapp">
                <i class="bi bi-whatsapp"></i>
              </button>
              <button class="share-icon facebook" data-platform="facebook">
                <i class="bi bi-facebook"></i>
              </button>
              <button class="share-icon twitter" data-platform="twitter">
                <i class="bi bi-twitter-x"></i>
              </button>
              <button class="share-icon linkedin" data-platform="linkedin">
                <i class="bi bi-linkedin"></i>
              </button>
              <button class="share-icon instagram" data-platform="instagram">
                <i class="bi bi-instagram"></i>
              </button>
              <button class="share-icon copy" data-platform="copy">
                <i class="bi bi-clipboard"></i>
              </button>
            </div>
          </div>


        </div>
      </div>
    </div>
    <!-- Invite Attorney Modal -->
    <div class="modal fade" id="inviteModal" tabindex="-1" aria-labelledby="inviteModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="inviteModalLabel">Invite Attorney to Your Firm</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <p>Copy and share the link below to invite another attorney from your firm.</p>
            <p class="mb-1 fw-semibold">Your Firm Invite Link:</p>
            <div class="input-group mb-3">
              <input type="text" class="form-control" id="firmInviteLink" readonly value="" />
              <button class="btn btn-outline-secondary" type="button" id="copyInviteLinkBtn" title="Copy link">
                <i class="bi bi-clipboard"></i>
              </button>
            </div>
            <p class="mb-2">You can send this link by text, email, or any preferred channel.</p>
            <div class="d-flex gap-3 justify-content-center">
              <button type="button" class="btn btn-light" id="inviteMailBtn" title="Send by Email">
                <i class="bi bi-envelope-fill"></i>
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="modal fade" id="acceptInviteModal" tabindex="-1">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header justify-content-center">
            <h5 class="modal-title ">Firm Invitation to Join</h5>
          </div>
          <div class="modal-body ">
            <div class="text-center">
              <p id="inviteText"></p>
            </div>
            
            <div class="card-wrapper">
              <div class="d-flex align-items-center gap-3 mt-3">
              <img id="inviteFirmImage" src="../assets/images/th.jpeg" alt="Firm Image" width="80" height="80" class="rounded">
              <div class="text-start">
                <p id="inviteFirmName"></p>
                <p id="inviteFirmAdmin">Firm Admin</p>
              </div>
            </div>
            <div class="">
              <p id="inviteFirmLocation"><i class="fa-solid fa-location-dot"></i> Location</p>
              <p id="inviteFirmPhone"><i class="fa-solid fa-phone"></i> Phone</p>
              <p id="inviteFirmWebsite"><i class="fa-solid fa-globe"></i> Website</p>
            </div>
            </div>

            <div class="d-flex gap-3 justify-content-between mt-4">
              <button class="btn btn-danger" id="rejectInviteBtn">Decline</button>
              <button class="btn btn-success" id="acceptInviteBtn">Accept</button>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Attorney List Modal -->
    <div class="modal fade" id="attorneyListModal" tabindex="-1" aria-labelledby="attorneyListModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title " id="attorneyListModalLabel">Attorneys in Your Firm Network</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <div id="attorneyListContainer">
              <!-- Attorney list will be populated here -->
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Professional Profile Viewer Modal -->
    <div class="modal fade" id="profileViewerModal" tabindex="-1">
      <div class="modal-dialog modal-dialog-centered modal-lg modal-dialog-scrollable">
        <div class="modal-content">
          <div class="modal-header justify-content-center">
            <h5 class="modal-title ">Professioanl Information</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>

          <div class="modal-body" id="profileViewerContent">
            <!-- Content injected dynamically -->
          </div>
        </div>
      </div>
    </div>


    <form id="profileForm" class="mb-4">
      <div class="row g-3">
        <div class="col-md-6">
          <label for="lawfirmName" class="custom-label mb-2">lawfirm Name</label>
          <input class="form-control custom-input" type="lawfirmName" id="lawfirmName" name="lawfirmName" />
        </div>

        <div class="col-md-6">
          <label for="practice" class="custom-label mb-2" data-i18n="practice_label"></label>
          <input class="form-control custom-input" type="text" id="practice" name="practice" />
        </div>

        <!-- <div class="col-md-6">
          <label for="mobile" class="custom-label mb-2" data-i18n="mobile_label"></label>
          <input class="form-control custom-input" type="tel" id="mobile" name="mobile" />
        </div> -->

        <div class="col-md-6">
          <label for="address" class="custom-label mb-2" data-i18n="address_label"></label>
          <input class="form-control custom-input" type="text" id="address" name="address" required />
          <input type="hidden" id="userlat" name="userlat" />
          <input type="hidden" id="userlon" name="userlon" />

        </div>

        <div class="col-md-6">
          <label for="counties" class="custom-label mb-2" data-i18n="counties_served_label"></label>
          <select class="form-control custom-input" id="counties" name="counties[]" multiple>
            <option value="Bexar" data-i18n="Bexar">Bexar</option>
            <option value="Cameron" data-i18n="Cameron">Cameron</option>
            <option value="Collin" data-i18n="Collin">Collin</option>
            <option value="Dallas" data-i18n="Dallas">Dallas</option>
            <option value="Denton" data-i18n="Denton">Denton</option>
            <option value="Ellis" data-i18n="Ellis">Ellis</option>
            <option value="El Paso" data-i18n="El Paso">El Paso</option>
            <option value="Fort Bend" data-i18n="Fort Bend">Fort Bend</option>
            <option value="Harris" data-i18n="Harris">Harris</option>
            <option value="Hidalgo" data-i18n="Hidalgo">Hidalgo</option>
            <option value="Hood" data-i18n="Hood">Hood</option>
            <option value="Hunt" data-i18n="Hunt">Hunt</option>
            <option value="Johnson" data-i18n="Johnson">Johnson</option>
            <option value="Kaufman" data-i18n="Kaufman">Kaufman</option>
            <option value="Navarro" data-i18n="Navarro">Navarro</option>
            <option value="Palo Pinto" data-i18n="Palo Pinto">Palo Pinto</option>
            <option value="Parker" data-i18n="Parker">Parker</option>
            <option value="Rockwall" data-i18n="Rockwall">Rockwall</option>
            <option value="Somervell" data-i18n="Somervell">Somervell</option>
            <option value="Tarrant" data-i18n="Tarrant">Tarrant</option>
            <option value="Travis" data-i18n="Travis">Travis</option>
            <option value="Wise" data-i18n="Wise">Wise</option>
          </select>

        </div>

        <!-- <div class="col-md-6">
          <label for="email" class="custom-label mb-2" data-i18n="email_label"></label>
          <input class="form-control custom-input" type="email" id="email" name="email" />
        </div> -->
        

        <div class="col-md-6">
          <label for="website" class="custom-label mb-2" data-i18n="website_label"></label>
          <input class="form-control custom-input" type="url" id="website" name="website" />
        </div>

        <div class="col-md-6 align-self-end">
          <label class="custom-label mb-2" data-i18n="intro_video_label"></label>
          <label for="videoUpload" class="upload-btn btn w-100" data-i18n="upload_prompt"></label>
          <input type="file" id="videoUpload" name="video" accept="video/*" class="d-none" />
          <div id="videoPreview" class="mt-2 text-muted"></div>
        </div>

        <div class="col-md-6">
          <label class="custom-label mb-2" data-i18n="photo_label"></label>
          <label for="photoUpload" class="upload-btn btn w-100" data-i18n="upload_prompt"></label>
          <input type="file" id="photoUpload" name="photo" accept="image/*" class="d-none" />
          <div id="photoPreview" class="mt-2"></div>
        </div>

        <div class="col-md-6">
          <label class="custom-label mb-2" data-i18n="supporting_document_label"></label>
          <label for="documentUpload" class="upload-btn btn w-100" data-i18n="upload_prompt"></label>
          <input type="file" id="documentUpload" name="documentUpload" class="d-none" />
          <input id="documentUpload" type="file" hidden>

          <label for="documentUpload" class="btn btn-sm btn-outline-primary">
            📄 View Uploaded Document
          </label>
        </div>

        <div class="col-md-6 d-flex align-items-center justify-content-start">
          <button id="syncBtn" type="button" class="btn btn-save" data-i18n="sync_my_case_label"></button>
        </div>

        <div class="col-md-12 d-flex mt-4 mb-5 justify-content-center">
          <div class="col-md-6">
            <button id="firmSaveBtn" type="submit" class="btn btn-save w-100" data-i18n="save"></button>
          </div>
        </div>
      </div>
    </form>
  </div>
</main>


<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<!-- Google Places API -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB0jx5yCf4vk4I5ridEorfPMqohEhpH1H4&libraries=places"></script>

<script>
  const db = firebase.firestore();
  const storage = firebase.storage();
  let existingLawFirmId = null;
  let autocomplete;
  let userlat = null;
  let userlon = null;
  let documentTemplateId = null;
  let isAttachedAttorney = false;


  const formInputs = document.querySelectorAll(
    "#profileForm input, #profileForm textarea"
  );

  $(document).ready(function () {

    $('#counties').select2({
      placeholder: "Select Counties",
      width: '100%',
      closeOnSelect: false});
    // loadLawFirmData();
  });

  async function loadLawFirmData() {
    const user = firebase.auth().currentUser;
    if (!user) {
      console.log("No user logged in");
      return;
    }

    try {
      const userDoc = await db.collection("Users").doc(user.uid).get();
      const userData = userDoc.data();

      if (userData?.LawFirmId) {
        existingLawFirmId = userData.LawFirmId;
        console.log("Law Firm ID loaded:", existingLawFirmId);

        // Initialize sync button AFTER we have the law firm ID
        initializeSyncButton();

        const lawFirmDoc = await db
          .collection("LawFirm")
          .doc(existingLawFirmId)
          .get();

        if (existingLawFirmId) {
          listenToMyCaseToken(existingLawFirmId);
        }

        if (lawFirmDoc.exists) {
          const law = lawFirmDoc.data();

          let parentLawFirmId = null;

          // ✅ CHECK: Only if this attorney is attached to a parent firm
          if (law.attachedWithLawfirmId) {
            isAttachedAttorney = true;
            parentLawFirmId = law.attachedWithLawfirmId;

            // ✅ Fetch parent firm data
            const parentSnap = await db
              .collection("LawFirm")
              .doc(parentLawFirmId)
              .get();

            if (parentSnap.exists) {
              const parentLaw = parentSnap.data();

              // ✅ Populate form from parent firm
              document.getElementById("practice").value = parentLaw.bioPractice || "";
              document.getElementById("address").value = parentLaw.address || "";
              document.getElementById("lawfirmName").value = parentLaw.lawfirmName || "";
              document.getElementById("website").value = parentLaw.website || "";

              $("#counties").val(parentLaw.county || []).trigger("change");

              if (parentLaw.userlat && parentLaw.userlon) {
                document.getElementById("userlat").value = parentLaw.userlat;
                document.getElementById("userlon").value = parentLaw.userlon;
                userlat = parentLaw.userlat;
                userlon = parentLaw.userlon;
              }

              if (parentLaw.imageUrl) {
                document.getElementById("photoPreview").innerHTML =
                  `<img src="${parentLaw.imageUrl}" class="img-fluid rounded border" style="max-height: 200px;" />`;
              }

              if (parentLaw.videoUrl) {
                document.getElementById("videoPreview").innerHTML =
                  `<p style="margin-top: 10px;">
                    <a href="${parentLaw.videoUrl}" target="_blank" class="btn btn-sm btn-outline-primary">
                      View Video
                    </a>
                  </p>`;
              }

              documentTemplateId = parentLaw.templateId || null;
            }

            // ✅ Lock the UI after loading parent data
            lockLawFirmUI();
          } else {
            // ✅ NOT attached - load own data
            documentTemplateId = law.templateId || null;

            document.getElementById("practice").value = law.bioPractice || "";
            document.getElementById("address").value = law.address || "";
            document.getElementById("lawfirmName").value = law.lawfirmName || "";
            document.getElementById("website").value = law.website || "";

            $("#counties").val(law.county || []).trigger("change");

            if (law.userlat && law.userlon) {
              document.getElementById("userlat").value = law.userlat;
              document.getElementById("userlon").value = law.userlon;
              userlat = law.userlat;
              userlon = law.userlon;
            }

            if (law.imageUrl) {
              document.getElementById("photoPreview").innerHTML =
                `<img src="${law.imageUrl}" alt="Uploaded Photo" class="img-fluid rounded border" style="max-height: 200px;" />`;
            }

            if (law.videoUrl) {
              document.getElementById("videoPreview").innerHTML =
                `<p style="margin-top: 10px;">
                  <a href="${law.videoUrl}" target="_blank" class="btn btn-sm btn-outline-primary">
                    View Video
                  </a>
                </p>`;
            }
          }
        }
      }
    } catch (error) {
      console.error("❌ loadLawFirmData failed:", error);
    }
  }

  function lockLawFirmUI() {
    // inputs & textarea
    document
      .querySelectorAll("#profileForm input, #profileForm textarea")
      .forEach(el => {
        el.setAttribute("readonly", true);
        el.setAttribute("disabled", true);
      });

    // select2
    $("#counties").prop("disabled", true);

    // file inputs
    ["photoUpload", "videoUpload", "documentUpload"].forEach(id => {
      const el = document.getElementById(id);
      if (el) el.disabled = true;
    });

    // disable buttons (EXCEPT attorney list)
    [
      "inviteBtn",
      "shrBtn",
      "shareBtn",
      "syncBtn",
    ].forEach(id => {
      const btn = document.getElementById(id);
      if (btn) {
        btn.disabled = true;
        btn.classList.add("disabled");
        btn.style.pointerEvents = "none";
        btn.style.opacity = "0.5";
      }
    });

    const submitBtn = document.getElementById("firmSaveBtn");
      submitBtn.disabled = true;
      submitBtn.classList.add("disabled");
  }

  firebase.auth().onAuthStateChanged(async (user) => {
    // if (!user) {
    //   Swal.fire("Error", "You must be logged in.", "error");
    //   return;
    // }

    //  const pendingInvite = sessionStorage.getItem("pendingLawFirmInvite");

    //   if (!user) {
    //     if (pendingInvite) {
    //       console.log("🔐 Redirecting to login, invite preserved");
    //       window.location.href =
    //         `/dueproupdated/login?redirect=${encodeURIComponent(window.location.href)}`;
    //     }
    //     return;
    //   }

    const userDoc = await db.collection("Users").doc(user.uid).get();
    const userData = userDoc.data();


    if (userData?.LawFirmId) {
      existingLawFirmId = userData.LawFirmId;
      
      const lawFirmDoc = await db.collection("LawFirm").doc(existingLawFirmId).get();

      if (existingLawFirmId) {
        listenToMyCaseToken(existingLawFirmId);
      }
      
      if (lawFirmDoc.exists) {
        const law = lawFirmDoc.data();
        documentTemplateId = law.templateId || null;

        // Populate form fields
        document.getElementById("practice").value = law.bioPractice || "";
        // document.getElementById("mobile").value = law.phone || "";
        document.getElementById("address").value = law.address || "";
        // document.getElementById("email").value = law.email || "";
        document.getElementById("lawfirmName").value = law.lawfirmName || "";
        document.getElementById("website").value = law.website || "";
        
        $('#counties').val(law.county || []).trigger('change');

        if (law.userlat && law.userlon) {
          document.getElementById("userlat").value = law.userlat;
          document.getElementById("userlon").value = law.userlon;
          userlat = law.userlat;
          userlon = law.userlon;
        }

        // ✅ Show existing uploaded files if available
        if (law.imageUrl) {
          document.getElementById("photoPreview").innerHTML =
            `<img src="${law.imageUrl}" alt="Uploaded Photo" class="img-fluid rounded border" style="max-height: 200px;" />`;
        }

        if (law.videoUrl) {
          document.getElementById("videoPreview").innerHTML =
            ` <p style="margin-top: 10px;">
        <a href="${law.videoUrl}" target="_blank" class="btn btn-sm btn-outline-primary" >
        View Video
        </a>`;
        }
      }
    }
      // 4️⃣ 🔒 LOCK UI (HERE)
    if (isAttachedAttorney) {
      lockLawFirmUI();
    }
    // Load data after user is authenticated
    await loadLawFirmData();
  });

  function initAutocomplete() {
    const input = document.getElementById('address');
    autocomplete = new google.maps.places.Autocomplete(input);
    autocomplete.setFields(['geometry', 'address_components', 'formatted_address']);

    autocomplete.addListener('place_changed', function () {
      const place = autocomplete.getPlace();
      if (!place.geometry) {
        Swal.fire("Invalid Address", "No details found for selected address.", "warning");
        return;
      }
      userlat = place.geometry.location.lat();
      userlon = place.geometry.location.lng();
      document.getElementById('userlat').value = userlat;
      document.getElementById('userlon').value = userlon;
    });
  }

  async function fetchDocumentBase64(templateId) {
    
    try {
      // const url = `https://duepro.com/duepro_docusign_apis/index.php/docusign/downloadTemplatePdf?template_id=${templateId}`;
      const url = `https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/downloadTemplatePdf?template_id=${templateId}`;
      
      const response = await fetch(url);
      const result = await response.json();

      if (!result.success || !result.pdfBase64) {
        throw new Error(result.message || "Base64 not found!");
      }

      return result.pdfBase64;

    } catch (err) {
      Swal.fire("Error", err.message, "error");
      return null;
    }
  }

  function openBase64PDF(base64Data) {
    // Remove base64 header if exists
    if (base64Data.includes(",")) {
      base64Data = base64Data.split(",")[1];
    }

    // Fix URL-safe base64
    base64Data = base64Data.replace(/-/g, "+").replace(/_/g, "/");

    // Decode
    const byteCharacters = atob(base64Data);

    const byteArray = new Uint8Array(byteCharacters.length);
    for (let i = 0; i < byteCharacters.length; i++) {
      byteArray[i] = byteCharacters.charCodeAt(i);
    }

    // Convert to PDF
    const blob = new Blob([byteArray], { type: "application/pdf" });
    const blobUrl = URL.createObjectURL(blob);

    // Open in new tab
    window.open(blobUrl, "_blank");
  }

  async function fetchCalendlyUserURI(accessToken) {
    const response = await fetch("https://api.calendly.com/users/me", {
      headers: {
        Authorization: `Bearer ${accessToken}`,
        "Content-Type": "application/json"
      }
    });

    if (!response.ok) {
      throw new Error("Failed to fetch Calendly user URI");
    }

    const data = await response.json();
    return data.resource.uri;
  }

  async function fetchCalendlyEventTypes(accessToken, userURI) {
    const encodedUserURI = encodeURIComponent(userURI);

    const response = await fetch(
      `https://api.calendly.com/event_types?user=${encodedUserURI}`,
      {
        headers: {
          Authorization: `Bearer ${accessToken}`,
          "Content-Type": "application/json"
        }
      }
    );

    if (!response.ok) {
      throw new Error("Failed to fetch Calendly event types");
    }

    const data = await response.json();
    return data.collection.filter(event => event.active);
  }

  document.querySelector("form").addEventListener("submit", async (e) => {
    e.preventDefault();
      Swal.fire({
    title: "Please wait...",
    text: "Submiting",
    allowOutsideClick: false,
    allowEscapeKey: false,
    didOpen: () => {
      Swal.showLoading();
    }
    });

    try {
      const user = firebase.auth().currentUser;
      if (!user) {
        Swal.close();
        Swal.fire("Error", "You must be logged in.", "error");
        return;
      }

      const form = e.target;
      const address = form.address.value.trim();

      if (!userlat || !userlon) {
        try {
          const location = await new Promise((resolve, reject) => {
            const geocoder = new google.maps.Geocoder();
            geocoder.geocode({ address }, (results, status) => {
              if (status === "OK" && results[0]) {
                const loc = results[0].geometry.location;
                resolve({ lat: loc.lat(), lng: loc.lng() });
              } else reject("Geocoding failed: " + status);
            });
          });
          userlat = location.lat;
          userlon = location.lng;
        } catch (geoError) {
          Swal.close();
          Swal.fire("Location Error", "Failed to retrieve lat/lon from address.", "error");
          return;
        }
      }

      const storageRef = storage.ref();
      const uploadFile = async (inputId, folder) => {
        const fileInput = document.getElementById(inputId);

        // ✅ SAFETY CHECK
        if (!fileInput || !fileInput.files || fileInput.files.length === 0) {
          return null;
        }

        const file = fileInput.files[0];
        const fileRef = storageRef.child(
          `lawfirm_uploads/${folder}/${Date.now()}_${file.name}`
        );

        await fileRef.put(file);
        return await fileRef.getDownloadURL();
      };


      const lawFirmData = {
        bioPractice: form.practice.value.trim(),
        // practiceAreas: selectedPracticeAreas,
        // phone: form.mobile.value.trim(),
        // clandlyToken: clandlyAccessToken,
        address: address,
        // email: form.email.value.trim(),
        lawfirmName: form.lawfirmName.value.trim(),
        website: form.website.value.trim(),
        county: $('#counties').val(),
        userlat,
        userlon,
        userId: user.uid,
        updatedAt: Date.now()
      };

      const photoUrl = await uploadFile("photoUpload", "photos");
      const videoUrl = await uploadFile("videoUpload", "videos");
      const docUrl = await uploadFile("document", "documents");

      if (photoUrl) lawFirmData.imageUrl = photoUrl;
      if (videoUrl) lawFirmData.videoUrl = videoUrl;
      if (docUrl) lawFirmData.docUrl = docUrl;

      let lawFirmRef;

      if (existingLawFirmId) {
      // ✅ Update existing law firm
      await db.collection("LawFirm").doc(existingLawFirmId).update(lawFirmData);
      lawFirmRef = { id: existingLawFirmId };
      } else {
        // ✅ Create a new law firm document using the current user's UID as the document ID
        lawFirmData.createdDate = Date.now();
        await db.collection("LawFirm").doc(user.uid).set(lawFirmData);
        await db.collection("Users").doc(user.uid).update({ LawFirmId: user.uid });
        lawFirmRef = { id: user.uid }; // âœ… so later code uses the UID as the law firm id
      }


      if (docUrl) {
        try {
          
          const response = await fetch(
            // "https://duepro.com/duepro_docusign_apis/index.php/docusign/token",
            "https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/token",
            { headers: { Accept: "application/json" } }
          );

          if (!response.ok) throw new Error("Failed to get token");
          const data = await response.json();

          if (!data.success) {
            console.warn("Token API responded without success:", data);
            return;
          }

          // ✅ Save only templateId in Firestore
          
          
          // ✅ Keep access token only in memory
          const accessToken = data.access_token;

          // 2️⃣ Convert the just-uploaded document to base64
          const file = document.getElementById("document").files[0];
          if (!file) throw new Error("No document selected");
          const fileBase64 = await new Promise((resolve, reject) => {
            const reader = new FileReader();
            reader.onload = () => {
              // strip the "data:application/pdf;base64," prefix
              const base64String = reader.result.split(",")[1];
              resolve(base64String);
            };
            reader.onerror = reject;
            reader.readAsDataURL(file);
          });


          // 3️⃣ Call create-draft-template API
          const formData = new FormData();
          formData.append("attorneyId", user.uid);   // ✅ Firebase user ID
          formData.append("document", fileBase64);   // ✅ Base64 encoded PDF
          // formData.append("returnUrl", "https://sugarfest.online/docusign_apis/index.php");
          formData.append("returnUrl", window.location.href);

          formData.append("otherData", `${lawFirmData}`);

          const draftResponse = await fetch(
            // "https://duepro.com/duepro_docusign_apis/index.php/docusign/create-draft-template",
            "https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/create-draft-template",
            {
              method: "POST",
              headers: {
                Authorization: `Bearer ${accessToken}`, // ✅ token used only in header
                // ❗ Do NOT manually set Content-Type with FormData
              },
              body: formData,
            }
          );
          if (!draftResponse.ok) throw new Error("Failed to create draft template");

          const draftData = await draftResponse.json();
          console.log("✅ DocuSign draft template created:", draftData);
          await db.collection("LawFirm").doc(lawFirmRef.id).update({
            templateId: draftData.data.templateId, // 👈 store only templateId, not the token

          });
          // 5️⃣ 👉 Open the sender view so the attorney can prepare fields
          const senderViewUrl = draftData.data.senderViewUrl;
        
          if (senderViewUrl) {
            // open in a new tab
        //   window.location.href=senderViewUrl
          } else {
            console.warn("senderViewUrl not returned by API");
          }


        } catch (apiErr) {
          console.error("❌ DocuSign API error:", apiErr);
          
        }
      }

      Swal.fire("Success", "Law firm information saved successfully.", "success");


    } catch (error) {
      console.error("Error saving law firm:", error);
      Swal.fire("Error", error.message, "error");
    }
  });
    
  document.getElementById("shrBtn").addEventListener("click", async () => {
    try {
      const user = firebase.auth().currentUser;
      if (!user) {
        Swal.fire("Error", "You must be logged in to share your link.", "error");
        return;
      }

      // ✅ Use LawFirm ID or fallback to user UID
      const lawFirmId = existingLawFirmId || user.uid;
      const shareUrl = `https://duepro.com/userlogins?attorneyId=${lawFirmId}`;
      const message = `Check out my attorney profile on DuePro: ${shareUrl}`;

      // ✅ Copy link to clipboard initially
      await navigator.clipboard.writeText(shareUrl);

      // ✅ SweetAlert with copy + brand icons
      Swal.fire({
        title: "Share Your Attorney Link",
        html: `
          <p class="mb-3">Your link has been copied to clipboard!</p>
          <div class="d-flex justify-content-center mb-3">
            <button id="copyLinkBtn" class="btn btn-dark btn-sm">
              <i class="bi bi-clipboard"></i>
            </button>
          </div>
          <div class="d-flex flex-wrap justify-content-center gap-3">
            <a href="https://wa.me/?text=${encodeURIComponent(message)}" target="_blank" class="social-icon" style="color: #25D366;">
              <i class="bi bi-whatsapp" style="font-size: 28px;"></i>
            </a>
            <a href="https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(shareUrl)}" target="_blank" class="social-icon" style="color: #1877F2;">
              <i class="bi bi-facebook" style="font-size: 28px;"></i>
            </a>
            <a href="https://twitter.com/intent/tweet?text=${encodeURIComponent(message)}" target="_blank" class="social-icon" style="color: #000000;">
              <i class="bi bi-twitter-x" style="font-size: 28px;"></i>
            </a>
            <a href="https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(shareUrl)}" target="_blank" class="social-icon" style="color: #0A66C2;">
              <i class="bi bi-linkedin" style="font-size: 28px;"></i>
            </a>
            <a href="https://www.instagram.com/" target="_blank" class="social-icon" style="color: #E4405F;">
              <i class="bi bi-instagram" style="font-size: 28px;"></i>
            </a>
          </div>
        `,
        showConfirmButton: true,
        confirmButtonText: "Close",
        icon: "success",
        didOpen: () => {
          // Add copy functionality to the button inside SweetAlert
          document.getElementById("copyLinkBtn").addEventListener("click", async () => {
            try {
              await navigator.clipboard.writeText(shareUrl);
              const btn = document.getElementById("copyLinkBtn");
              btn.innerHTML = '<i class="bi bi-check2"></i>'; // show checkmark
              btn.classList.replace("btn-dark", "btn-success");
              setTimeout(() => {
                btn.innerHTML = '<i class="bi bi-clipboard"></i>';
                btn.classList.replace("btn-success", "btn-dark");
              }, 1500);
            } catch {
              Swal.fire("Error", "Failed to copy the link.", "error");
            }
          });
        },
      });

    } catch (err) {
      console.error("Error sharing link:", err);
      Swal.fire("Error", "Failed to copy or share the link.", "error");
    }
  });
    
  document.addEventListener("DOMContentLoaded", () => {
    const shareBtn = document.getElementById("shareBtn");
    const shareOptions = document.getElementById("shareOptions");
    const shareIcons = document.querySelectorAll(".share-icon");

    // ✅ Toggle open/close on click
    shareBtn.addEventListener("click", (e) => {
      e.stopPropagation();
      shareOptions.classList.toggle("active");
    });

    // ✅ Close when clicking outside
    document.addEventListener("click", (e) => {
      if (!shareBtn.contains(e.target) && !shareOptions.contains(e.target)) {
        shareOptions.classList.remove("active");
      }
    });

    // ✅ Dynamic share actions
    shareIcons.forEach(icon => {
      icon.addEventListener("click", async (e) => {
        e.stopPropagation();
        const platform = icon.getAttribute("data-platform");
        const user = firebase.auth().currentUser;

        if (!user) {
          Swal.fire("Error", "You must be logged in to share your link.", "error");
          return;
        }

        const lawFirmId = window.existingLawFirmId || user.uid;
        const shareUrl = `https://duepro.com/userlogins?attorneyId=${lawFirmId}`;
        const message = `Check out my attorney profile on DuePro: ${shareUrl}`;

        switch (platform) {
          case "whatsapp":
            window.open(`https://wa.me/?text=${encodeURIComponent(message)}`, "_blank");
            break;
          case "facebook":
            window.open(`https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(shareUrl)}`, "_blank");
            break;
          case "twitter":
            window.open(`https://twitter.com/intent/tweet?text=${encodeURIComponent(message)}`, "_blank");
            break;
          case "linkedin":
            window.open(`https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(shareUrl)}`, "_blank");
            break;
          case "instagram":
            window.open(`https://www.instagram.com/`, "_blank");
            break;
          case "copy":
            await navigator.clipboard.writeText(shareUrl);
            Swal.fire("Copied!", "Link copied to clipboard.", "success");
            break;
        }

        // auto-close after selection
        shareOptions.classList.remove("active");
      });
    });
  });

  window.onload = initAutocomplete;

  document.addEventListener("DOMContentLoaded", function () {
    const popoverTriggerList = [].slice.call(
      document.querySelectorAll('[data-bs-toggle="popover"]')
    );

    popoverTriggerList.forEach(function (popoverTriggerEl) {
      new bootstrap.Popover(popoverTriggerEl);
    });
  });

  document.addEventListener("DOMContentLoaded", () => {
    const inviteBtn = document.getElementById("inviteBtn");
    const invitedAttorneyList = document.getElementById("invitedAttorneyList");
    const inviteModalEl = document.getElementById("inviteModal");
    const inviteLinkInput = document.getElementById("firmInviteLink");
    const copyInviteLinkBtn = document.getElementById("copyInviteLinkBtn");
    const inviteMailBtn = document.getElementById("inviteMailBtn");
    const inviteMessageBtn = document.getElementById("inviteMessageBtn");

    // ✅ Define modal instance once at the top
    const inviteModal = inviteModalEl ? new bootstrap.Modal(inviteModalEl) : null;

    // Main invite button click handler
    if (inviteBtn) {
      inviteBtn.addEventListener("click", async () => {
        const user = firebase.auth().currentUser;
        if (!user) return;

        // ✅ Membership check first
        const allowed = await checkAttorneyMembershipAccess({
          redirectTo: "<?php echo base_url('site/subscriptionAttorney'); ?>"
        });
        
        if (!allowed) return; // Stop flow if not subscribed

        const db = firebase.firestore();

        try {
          // 🔎 Fetch current user's LawFirm profile
          const lawFirmSnap = await db.collection("LawFirm").doc(user.uid).get();

          if (!lawFirmSnap.exists) {
            Swal.fire({
              title: "Law Firm Not Found",
              text: "Please create and save your Law Firm profile first.",
              icon: "warning",
              confirmButtonText: "OK",
            });
            return;
          }

          const lawFirm = lawFirmSnap.data();

          // 🚫 CHECK: Professional Name is required
          if (!lawFirm?.professionalName || lawFirm.professionalName === "" || !lawFirm?.email) {
            Swal.fire({
              title: "Add Law Firm Info to Invite Attorneys",
              text: "Invites are tied to your firm profile. Please add and save your Law Firm Information first.",
              icon: "warning",
              confirmButtonText: "OK",
            }).then(() => {
              window.location.href = "/dueproupdated/site/professionalInformation";
            });
            return;
          }

          // 🚫 REQUIRED DATA CHECK (templateId, email, lawfirmName)
          if (!lawFirm?.templateId  || !lawFirm?.lawfirmName) {
            Swal.fire({
              title: "Add Law Firm Info to Invite Attorneys",
              text: "Invites are tied to your firm profile. Please add and save your Law Firm Information first.",
              icon: "warning",
              confirmButtonText: "OK",
            });
            return; // ⛔ STOP here — modal will NOT open
          }

          // ✅ Everything valid → build invite link
          const lawFirmId = window.existingLawFirmId || existingLawFirmId || user.uid;
          const inviteUrl = `http://localhost/dueproupdated/site/professionalInformation?attorneyId=${lawFirmId}`;

          if (inviteLinkInput) inviteLinkInput.value = inviteUrl;

          // ✅ Now show the modal
          if (inviteModal) {
            inviteModal.show();
          }
        } catch (err) {
          console.error("Invite check failed:", err);
          Swal.fire("Error", "Unable to verify firm profile.", "error");
        }
      });
    }

    // ✅ NEW: Function to load attorney list (reusable)
    async function loadAttorneyList(
      db,
      adminUserId,
      attorneyListContainer,
      currentUserId,
      isAdmin
    ) {
      try {
        // Show loading state
        attorneyListContainer.innerHTML = `
          <div class="text-center py-4">
            <div class="spinner-border text-primary" role="status">
              <span class="visually-hidden">Loading...</span>
            </div>
            <p class="mt-2">Loading attorneys...</p>
          </div>
        `;

        // 🔎 Fetch current user's document
        const userDoc = await db.collection("LawFirm").doc(adminUserId).get();

        if (!userDoc.exists) {
          attorneyListContainer.innerHTML = `
            <div class="text-center py-4">
              <p class="text-danger">User document not found.</p>
            </div>
          `;
          return;
        }

        const userData = userDoc.data();
        console.log("userData",userData);
        
        const attachedLawFirmAttorney = userData.attachedLawfirmAttorneys || [];
        console.log("attachedLawFirmAttorney", attachedLawFirmAttorney);

        // Current admin card
        const currentAdminData = `
          <div class="list-group">
            <div class="list-group-item d-flex align-items-center gap-3 p-3 attorney-card"
            data-attorney-id="${adminUserId}">
            <img src="${userData.professionalPic || '../assets/images/attorneyplaceholder.png'}"
                  alt="${userData.professionalName}"
                  class="rounded-circle"
                  style="width: 60px; height: 60px; object-fit: cover;">
              <div class="flex-grow-1">
                <div class="professional_title_wrapper d-flex justify-content-between">
                  <h6 class="m-0">${userData.professionalName}</h6>
                  <p class="professional_badge m-0">Firm Admin</p>
                </div>
                <p class="mb-1 text-muted small">${userData.lawfirmName || 'Attorney'}</p>
                <p class="mb-0 text-muted small">
                  <i class="bi bi-envelope"></i> ${userData.email || 'N/A'}
                </p>
              </div>
            </div>
          </div>
        `;

        // ✅ CORRECT EMPTY CHECK
        if (!Array.isArray(attachedLawFirmAttorney) || attachedLawFirmAttorney.length === 0) {
          attorneyListContainer.innerHTML = `
              ${currentAdminData}

          <div class="text-center py-3">
              <i class="bi bi-person-x" style="font-size: 3rem; color: #6c757d;"></i>
              <p class="mt-3 text-muted">No attorney is attached with your firm network</p>
            </div>
          `;
          return;
        }

        // ✅ FETCH ATTORNEYS (FIXED COLLECTION NAME)
        const attorneyPromises = attachedLawFirmAttorney.map(async (attorneyId) => {
          const attorneyDoc = await db.collection("LawFirm").doc(attorneyId).get();

          if (attorneyDoc.exists) {
            const attorneyData = attorneyDoc.data();
            return {
              id: attorneyId,
              name: attorneyData.professionalName || "Unknown Attorney",
              email: attorneyData.email || "N/A",
              phone: attorneyData.phone || "N/A",
              title: attorneyData.lawfirmName || "Attorney",
              imageUrl: attorneyData.professionalPic || "../assets/images/placeholder.png",
            };
          }
          return null;
        });

        const attorneys = (await Promise.all(attorneyPromises)).filter(attorney => attorney !== null);

        // Display attorneys
        if (attorneys.length === 0) {
          attorneyListContainer.innerHTML = `
            <div class="text-center py-5">
              ${currentAdminData}
              <i class="bi bi-person-x" style="font-size: 3rem; color: #6c757d;"></i>
              <p class="mt-3 text-muted">No attorney is attached with your firm network</p>
            </div>
          `;
          return;
        }

        // Render attorney list
        attorneyListContainer.innerHTML = `
          <div class="list-group">
            ${currentAdminData}
            ${attorneys.map(attorney => `
              <div class="list-group-item d-flex align-items-center gap-3 p-3 attorney-card" data-attorney-id="${attorney.id}">
                <img src="${attorney.imageUrl}" alt="${attorney.name}" 
                    class="rounded-circle" style="width: 60px; height: 60px; object-fit: cover;">
                <div class="flex-grow-1">
                  <h6 class="mb-1">${attorney.name}</h6>
                  <p class="mb-1 text-muted small">${attorney.title}</p>
                  <p class="mb-0 text-muted small"><i class="bi bi-envelope"></i> ${attorney.email}
                  </p>
                </div>
                ${
                  isAdmin || attorney.id === currentUserId
                    ? `<button class="btn btn-sm btn-danger delete-attorney-btn"
                        data-attorney-id="${attorney.id}">
                        <i class="bi bi-trash"></i>
                      </button>`
                    : ""
                }
              </div>
            `).join('')}
          </div>
        `;

        // ✅ Add event listeners to delete buttons
        document.querySelectorAll('.delete-attorney-btn').forEach(btn => {
          btn.addEventListener('click', async (e) => {
            e.stopPropagation();
            const attorneyId = btn.getAttribute('data-attorney-id');
            await deleteAttorney(
              attorneyId,
              adminUserId,
              db,
              attorneyListContainer,
              currentUserId,
              isAdmin
            );

          });
        });

        document.querySelectorAll(".attorney-card").forEach(card => {
          card.addEventListener("click", async (e) => {
            e.stopPropagation();
            const attorneyId = card.getAttribute('data-attorney-id');
            console.log("clicked");
            
            await openProfileViewer(attorneyId);
          });
        });
      } catch (err) {
        console.error("Error fetching attorney list:", err);      
        attorneyListContainer.innerHTML = `
          <div class="text-center py-4">
            <p class="text-danger">Error loading attorneys: ${err.message}</p>
          </div>
        `;
      }
    }

    async function openProfileViewer(attorneyId) {
      const db = firebase.firestore();
      const modal = new bootstrap.Modal(
        document.getElementById("profileViewerModal")
      );

      const professionalViewContainer = document.getElementById("profileViewerContent");

      // Loading state
      professionalViewContainer.innerHTML = `
        <div class="text-center py-4">
          <div class="spinner-border text-primary"></div>
          <p class="mt-2">Loading profile...</p>
        </div>
      `;

      modal.show();

      try {
        const snap = await db.collection("LawFirm").doc(attorneyId).get();

        if (!snap.exists) {
          professionalViewContainer.innerHTML = `<p class="text-danger">Profile not found.</p>`;
          return;
        }

        const data = snap.data();        

        // Format arrays for display
        const formatArray = (arr) => {
          if (!arr) return "N/A";
          if (Array.isArray(arr) && arr.length > 0) {
            return arr.join(", ");
          }
          return "N/A";
        };

        professionalViewContainer.innerHTML = `
          <div class="row justify-content-center">
            <div class="col-md-11">

              <div class="profile-card p-4 p-md-5">

                <!-- Profile Image -->
                <div class="text-center mb-4">
                  <img
                    src="${data.professionalPic || '../assets/images/attorneyplaceholder.png'}"
                    class="rounded-circle viewer-image"
                  />
                  <h5 class="mt-3 ">
                    ${data.professionalName || data.lawfirmName || "Attorney"}
                  </h5>
                </div>

                <div class="row g-3">

                  <div class="col-md-12">
                    <label class="custom-label mb-1">Email</label>
                    <input class="form-control custom-input" value="${data.email || 'N/A'}" readonly />
                  </div>

                  <div class="col-md-12">
                    <label class="custom-label mb-1">Language</label>
                    <div class="form-control custom-input bg-light">
                      ${formatArray(data.professionalLanguage)}
                    </div>
                  </div>

                  <div class="col-md-6">
                    <label class="custom-label mb-1">Bar Number</label>
                    <input class="form-control custom-input" value="${data.professionalBarNumber || 'N/A'}" readonly />
                  </div>

                  <div class="col-md-6">
                    <label class="custom-label mb-1">Calendly Token</label>
                    <input
                      class="form-control custom-input"
                      value="${data.clandlyToken ? 'Configured' : 'N/A'}"
                      readonly
                    />
                  </div>

                  <div class="col-md-12">
                    <label class="custom-label mb-1">Practice Areas</label>
                    <div class="form-control custom-input bg-light">
                      ${formatArray(data.practiceAreas)}
                    </div>
                  </div>

                  <div class="col-md-12">
                    <label class="custom-label mb-1">Address</label>
                    <textarea class="form-control custom-input" rows="2" readonly>${data.address || 'N/A'}</textarea>
                  </div>

                  <div class="col-md-12">
                    <label class="custom-label mb-1">Bio</label>
                    <textarea class="form-control custom-input" rows="4" readonly>${data.bioPractice || 'N/A'}</textarea>
                  </div>

                  <div class="col-md-12">
                    <label class="custom-label mb-1">Website</label>
                    ${
                      data.website
                        ? `<a href="${data.website}" target="_blank" class="form-control custom-input text-primary">${data.website}</a>`
                        : `<input class="form-control custom-input" value="N/A" readonly />`
                    }
                  </div>

                </div>
              </div>

            </div>
          </div>
        `;


       
      } catch (err) {
        console.error(err);
        professionalViewContainer.innerHTML = `<p class="text-danger">Failed to load profile.</p>`;
      }
    }


    // ✅ IMPROVED: Function to delete an attorney with smooth reload
    // async function deleteAttorney(attorneyId, adminUserId, db, attorneyListContainer, currentUserId, isAdmin){
    //   try {
    //     const confirmDelete = await Swal.fire({
    //       title: "Remove Attorney",
    //       text: "Are you sure you want to remove this attorney from your firm network?",
    //       icon: "warning",
    //       showCancelButton: true,
    //       confirmButtonText: "Yes, remove",
    //       cancelButtonText: "Cancel",
    //       confirmButtonColor: "#dc3545"
    //     });

    //     if (!confirmDelete.isConfirmed) {
    //       return;
    //     }

    //     // Show loading without closing modal
    //     Swal.fire({
    //       title: "Removing...",
    //       text: "Please wait",
    //       allowOutsideClick: false,
    //       showConfirmButton: false,
    //       didOpen: () => Swal.showLoading()
    //     });

    //     // 1. Remove attorney ID from admin's attachedLawfirmAttorneys array
    //     const adminUserRef = db.collection("LawFirm").doc(adminUserId);
    //     await adminUserRef.update({
    //       attachedLawfirmAttorneys: firebase.firestore.FieldValue.arrayRemove(attorneyId)
    //     });

    //     // 2. Remove attachedWithLawfirmId and attachedWithLawfirmName from the removed attorney's document
    //     const attorneyUserRef = db.collection("LawFirm").doc(attorneyId);
    //     await attorneyUserRef.update({
    //       attachedWithLawfirmId: firebase.firestore.FieldValue.delete(),
    //       attachedWithLawfirmName: firebase.firestore.FieldValue.delete(),
    //       attachedLawFirmWebsite: firebase.firestore.FieldValue.delete(),
    //       attachedLawFirmAddress: firebase.firestore.FieldValue.delete()
    //     });

    //     // ✅ Close loading alert
    //     Swal.close();

    //     // ✅ RELOAD the attorney list without closing the modal
    //     await loadAttorneyList(
    //       db,
    //       adminUserId,
    //       attorneyListContainer,
    //       currentUserId,
    //       isAdmin
    //     );

    //   } catch (err) {
    //   console.error("Error deleting attorney:", err);
    //   Swal.fire({
    //     title: "Error",
    //     text: err.message || "Failed to remove attorney",
    //     icon: "error"
    //   });
    //   }
    // }
    async function deleteAttorney(attorneyId, adminUserId, db, attorneyListContainer, currentUserId, isAdmin) {
  try {
    let confirmDelete;

    // Check if the user is deleting themselves
    const isSelfDelete = attorneyId === currentUserId;

    if (isSelfDelete) {
      // Self-delete confirmation modal
      confirmDelete = await Swal.fire({
        title: "Are you sure you want to continue?",
        html: `
          You're about to leave this law firm.<br><br>
          <ul style="text-align:left;">This will:
            <li>Unlink your profile from the firm</li>
            <li>Unlink shared bank account information</li>
            <li>Disconnect the case management integration</li>
            <li>Remove you from contract templates</li>
          </ul>
          <br>Your DuePro account won't be deleted, but you'll no longer be associated with this law firm.
        `,
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Leave",
        cancelButtonText: "Cancel",
        confirmButtonColor: "#dc3545"
      });
    } else {
      // Admin deleting another attorney
      confirmDelete = await Swal.fire({
        title: "Remove Attorney",
        text: "Are you sure you want to remove this attorney from your firm network?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Yes, remove",
        cancelButtonText: "Cancel",
        confirmButtonColor: "#dc3545"
      });
    }

    if (!confirmDelete.isConfirmed) return;

    // Show loading alert
    Swal.fire({
      title: isSelfDelete ? "Leaving Firm..." : "Removing...",
      text: "Please wait",
      allowOutsideClick: false,
      showConfirmButton: false,
      didOpen: () => Swal.showLoading()
    });

    const adminUserRef = db.collection("LawFirm").doc(adminUserId);
    const attorneyUserRef = db.collection("LawFirm").doc(attorneyId);

    if (isSelfDelete) {
      // Self-delete: remove from admin's attachedLawfirmAttorneys
      await adminUserRef.update({
        attachedLawfirmAttorneys: firebase.firestore.FieldValue.arrayRemove(attorneyId)
      });

      // Remove self's attachedWithLawfirmId info
      await attorneyUserRef.update({
        attachedWithLawfirmId: firebase.firestore.FieldValue.delete(),
        attachedWithLawfirmName: firebase.firestore.FieldValue.delete(),
        attachedLawFirmWebsite: firebase.firestore.FieldValue.delete(),
        attachedLawFirmAddress: firebase.firestore.FieldValue.delete()
      });

      // Reload page or redirect to dashboard after leaving
      Swal.close();
      window.location.href = "/site/addlawLawer"; // Or wherever appropriate
      return;

    } else {
      // Admin deleting another attorney
      await adminUserRef.update({
        attachedLawfirmAttorneys: firebase.firestore.FieldValue.arrayRemove(attorneyId)
      });

      await attorneyUserRef.update({
        attachedWithLawfirmId: firebase.firestore.FieldValue.delete(),
        attachedWithLawfirmName: firebase.firestore.FieldValue.delete(),
        attachedLawFirmWebsite: firebase.firestore.FieldValue.delete(),
        attachedLawFirmAddress: firebase.firestore.FieldValue.delete()
      });

      Swal.close();

      // Reload attorney list
      await loadAttorneyList(db, adminUserId, attorneyListContainer, currentUserId, isAdmin);
    }

  } catch (err) {
    console.error("Error deleting attorney:", err);
    Swal.fire({
      title: "Error",
      text: err.message || "Failed to remove attorney",
      icon: "error"
    });
  }
}


    // Attorney list modal handler
    if (invitedAttorneyList) {
      invitedAttorneyList.addEventListener("click", async () => {
        const user = firebase.auth().currentUser;

        if (!user) {
          Swal.fire("Error", "You must be logged in.", "error");
          return;
        }

        const db = firebase.firestore();
        const attorneyListContainer = document.getElementById("attorneyListContainer");
        const attorneyListModal = new bootstrap.Modal(document.getElementById("attorneyListModal"));

        // Show modal first
        attorneyListModal.show();

        const currentLawSnap = await db.collection("LawFirm").doc(user.uid).get();

        if (!currentLawSnap.exists) {
          Swal.fire("Error", "Law firm record not found", "error");
          return;
        }

        const currentLaw = currentLawSnap.data();

        let adminUserId = null;
        let isAdmin = false;
        let isAttachedUser = false;

        // ADMIN
        if (Array.isArray(currentLaw.attachedLawfirmAttorneys)) {
          adminUserId = user.uid;
          isAdmin = true;
        }

        // ATTACHED ATTORNEY
        else if (currentLaw.attachedWithLawfirmId) {
          adminUserId = currentLaw.attachedWithLawfirmId;
          isAttachedUser = true;
        }
        if (!adminUserId) {
          Swal.fire(
            "Firm Link Error",
            "This account is not associated with any firm.",
            "error"
          )
          return;
        }


        // Load attorney list
        // await loadAttorneyList(db, adminUserId, attorneyListContainer);
        await loadAttorneyList(
          db,
          adminUserId,
          attorneyListContainer,
          user.uid,
          isAdmin
          );
      });
    }

    // Copy invite link button
    if (copyInviteLinkBtn && inviteLinkInput) {
      copyInviteLinkBtn.addEventListener("click", async () => {
        try {
          await navigator.clipboard.writeText(inviteLinkInput.value);
          copyInviteLinkBtn.innerHTML = '<i class="bi bi-check2"></i>';
          setTimeout(() => {
            copyInviteLinkBtn.innerHTML = '<i class="bi bi-clipboard"></i>';
          }, 1500);
        } catch (e) {
          console.error("Failed to copy invite link:", e);
        }
      });
    }

    // Email invite button
    if (inviteMailBtn && inviteLinkInput) {
      inviteMailBtn.addEventListener("click", () => {
        const subject = encodeURIComponent("Invite to join our firm on DuePro");
        const body = encodeURIComponent(
          `Here is our firm invite link on DuePro:\n\n${inviteLinkInput.value}`
        );
        window.location.href = `mailto:?subject=${subject}&body=${body}`;
      });
    }

    // SMS invite button
    if (inviteMessageBtn && inviteLinkInput) {
      inviteMessageBtn.addEventListener("click", () => {
        const text = encodeURIComponent(
          `Here is our firm invite link on DuePro: ${inviteLinkInput.value}`
        );
        window.location.href = `sms:?&body=${text}`;
      });
    }
  });

</script> 

<script>
  const videoUpload = document.getElementById("videoUpload");
  const photoUpload = document.getElementById("photoUpload");
  const documentUpload = document.getElementById("documentUpload");
  const addressInput = document.getElementById("address");

  videoUpload.addEventListener("change", function () {
    const file = this.files[0];
    const preview = document.getElementById("videoPreview");

    if (file) {
      const url = URL.createObjectURL(file);

      preview.innerHTML = `
      
        <p style="margin-top: 10px;">
          <a href="${url}" target="_blank" style="color: #007bff; text-decoration: none;">
            ${file.name}
          </a>
        </p>
      `;
    } else {
      preview.innerHTML = "";
    }
  });

  photoUpload.addEventListener("change", function () {
    const file = this.files[0];
    const preview = document.getElementById("photoPreview");
    if (file) {
      const url = URL.createObjectURL(file);
      preview.innerHTML = `<img src="${url}" alt="Image Preview" class="img-fluid rounded border" style="max-height: 200px;" />`;
    } else {
      preview.innerHTML = "";
    }
  });

  documentUpload.addEventListener("click", async function (e) {
    e.preventDefault();
    const allowed = await checkAttorneyMembershipAccess({
      redirectTo: "<?php echo base_url('site/subscriptionAttorney'); ?>",
      showAlert: true
    });

    if (!allowed) return; // 🚫 Stop non-members
    
    const address = addressInput.value.trim();
    if (!address) {
      Swal.fire({
        title: "Error",
        text: "Address field is required before uploading supporting document.",
        icon: "warning",
        confirmButtonText: "OK"
      });
      return;
    }

    try {
      const user = firebase.auth().currentUser;
      if (!user) throw new Error("User not logged in.");

      const address = addressInput.value.trim();
      if (!address) {
        Swal.fire({
          title: "Error",
          text: "Address field is required before uploading supporting document.",
          icon: "warning",
          confirmButtonText: "OK"
        });
        return;
      }

      const uid = user.uid;
      const lawRef = db.collection("LawFirm").doc(uid);
      let lawDoc = await lawRef.get();
      let lawData = {};

      if (!lawDoc.exists) {
        // Create law firm document if it doesn't exist
        lawData = {
          address: address,
          userId: uid,
          createdDate: Date.now(),
          templateId: null,
          myCaseLawId: null
        };
        await lawRef.set(lawData);
      } else {
        lawData = lawDoc.data();
        // Update address if changed
        if (lawData.address !== address) {
          await lawRef.update({ address });
        }
      }

      // // Fetch templateId and myCaseLawId
      //  let templateId = lawData.templateId || "";
      // console.log(documentTemplateId,"documentTemplateId in fresh doc");
      
      
      const myCaseLawId = lawData.myCaseLawId || null;

      // Open fresh-document API
      // const apiUrl = `https://duepro.com/duepro_docusign_apis/index.php/docusign/fresh-document?doc_id=${uid}&template_id=${documentTemplateId}&myCaseLawId=${myCaseLawId}`;
      const apiUrl = `https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/fresh-document?doc_id=${uid}&template_id=${documentTemplateId}&myCaseLawId=${myCaseLawId}`;
    window.open(apiUrl, "_blank");

    // Preview the file if already selected
    const file = documentUpload.files[0];
    if (file) {
      documentPreview.innerHTML = `<p>📄 ${file.name}</p>`;
      }

    } catch (err) {
      console.error("Error preparing fresh document:", err);
    Swal.fire("Error", err.message, "error");
    }
  });

  function initializeSyncButton() {
    const syncBtn = document.getElementById("syncBtn");
    
    if (!syncBtn) {
      console.error("syncBtn element not found");
      return;
    }

    // Remove any existing listeners by cloning the button
    const newSyncBtn = syncBtn.cloneNode(true);
    syncBtn.parentNode.replaceChild(newSyncBtn, syncBtn);
    
    newSyncBtn.addEventListener("click", async () => {

    // ✅ Check membership first
    const allowed = await checkAttorneyMembershipAccess({
      redirectTo: "<?php echo base_url('site/subscriptionAttorney'); ?>",
      showAlert: true
    });

    if (!allowed) return; // 🚫 Stop non-members

      const state = newSyncBtn.dataset.state;

      console.log("Sync button clicked, state:", state);
      console.log("existingLawFirmId:", existingLawFirmId);

      return;

      // Validate that we have a law firm ID
      if (!existingLawFirmId) {
        Swal.fire("Error", "Law firm information not found. Please save your profile first.", "error");
        return;
      }

      // SYNC WITH MYCASE
      if (state === "sync") {
        const url = `https://buzzwaretechserver.site/mycase_apis/mycase/connect?id=${existingLawFirmId}`;
        window.open(url, "_blank");
        return;
      }

      // UNSYNC MYCASE
      if (state === "unsync") {
        Swal.fire({
          title: "Unsync MyCase",
          text: "Before you continue, please note that new cases will no longer be created or updated in MyCase once unsynced. You can reconnect anytime in Law Firm Info —> Sync with MyCase.",
          icon: "warning",
          showCancelButton: true,
          confirmButtonText: "Unsync",
          cancelButtonText: "Cancel"
        }).then(async (result) => {

          if (!result.isConfirmed) return;

          Swal.fire({
            title: "Unsyncing...",
            didOpen: () => Swal.showLoading(),
            allowOutsideClick: false
          });

          try {
            // Remove link from LawFirm document
            await db.collection("LawFirm")
              .doc(existingLawFirmId)
              .update({ myCaseLawId: null });

            // Remove token document
            await db.collection("mycase_tokens")
              .doc(existingLawFirmId)
              .delete();

            Swal.fire("Success", "Disconnected from MyCase.", "success");

          } catch (err) {
            console.error("Unsync error:", err);
            Swal.fire("Error", err.message, "error");
          }
        });
      }
    });
  }

  function listenToMyCaseToken(lawFirmId) {
    // console.log("Setting up MyCase token listener for:", lawFirmId);
    
    return db.collection("mycase_tokens")
      .doc(lawFirmId)
      .onSnapshot((snap) => {
        const syncBtn = document.getElementById("syncBtn");
        
        if (!syncBtn) {
          console.error("syncBtn not found in DOM");
          return;
        }

        if (!snap.exists || !snap.data()?.access_token) {
          // NOT CONNECTED
          syncBtn.textContent = "Sync with MyCase";
          syncBtn.dataset.state = "sync";
          syncBtn.classList.remove("btn-secondary");
          syncBtn.classList.add("btn-save");
        } else {
          // CONNECTED
          syncBtn.textContent = "Unsync MyCase";
          syncBtn.dataset.state = "unsync";
          syncBtn.classList.remove("btn-save");
          syncBtn.classList.add("btn-secondary");
        }
      }, (error) => {
        console.error("MyCase token listener error:", error);
      });
  }

</script>
<script src="<?= base_url('/assets/js/model.js'); ?>"></script>






