<style>
  .w-200px {
    width: 200px;
  }
  .ft7 {
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
    text-overflow: ellipsis;
  }
 
</style>
<main class="mb-5">
  <div class="container my-2">
    <div class="">
      <div class="d-flex justify-content-center">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs n-tabs gap-3 mt-4 align-items-center" id="contentTabs" role="tablist">
         
          
          <li class="nav-item" role="presentation">
            <button class="nav-link w-200px active" id="archived-tab" data-bs-toggle="tab" data-bs-target="#archived" type="button" role="tab" aria-controls="archived" aria-selected="false">Archived Alerts</button>
          </li>
        </ul>
      </div>

      <!-- Tab panes -->
      <div class="tab-content mt-2" id="contentTabsContent">
       
        <div class="tab-pane fade show active my-3" id="archived" role="tabpanel" aria-labelledby="archived-tab">
          <div class="row g-2 my-3" id="archivedContainer"></div>
        </div>
      </div>
    </div>
  </div>
</main>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<!-- <script>
let currentUser = null;
let currentUserData = null;

firebase.initializeApp(firebaseConfig);
const db = firebase.firestore();
const auth = firebase.auth();

firebase.auth().onAuthStateChanged(async (user) => {
  if (user) {
    currentUser = user;
    currentUserData = await db.collection("Users").doc(user.uid).get().then(doc => doc.data());
    loadArchivedAlerts(); // Load only archived alerts
  }
});

// 🔹 Load only archived alerts
function loadArchivedAlerts() {
  db.collection("QuoteAlert")
    .where("LawId", "==", currentUser.uid)
    .where("isLawArchived", "==", true)
    .onSnapshot(snapshot => renderArchivedAlerts(snapshot));
}

// 🔹 Render only archived alerts
async function renderArchivedAlerts(snapshot) {
  const container = document.querySelector("#archivedContainer");
  container.innerHTML = "";

  if (snapshot.empty) {
    container.innerHTML = `<div class="col-md-12"><div class="alert alert-warning text-center">No archived alerts found.</div></div>`;
    return;
  }

  for (const doc of snapshot.docs) {
    const alert = doc.data();

    // Get client data
    const userDoc = await db.collection("Users").doc(alert.userId).get();
    const userData = userDoc.data();

    // Format date
    const formattedDate = new Date(alert.createdDate).toLocaleDateString('en-US', {
      weekday: 'long', year: 'numeric', month: 'long', day: 'numeric', hour: '2-digit', minute: '2-digit'
    });

    // Attorney Name
    let attorneyName = "Opted Out";
    if (alert.LawId) {
      const attorneyDoc = await db.collection("Users").doc(alert.LawId).get();
      if (attorneyDoc.exists) {
        attorneyName = attorneyDoc.data().Name || "N/A";
      }
    }

    // Swiper video section
    const swiperClass = `swiper-${doc.id}`;
    const videoHtml = alert.videoUrls?.length ? `
      <div class="swiper ${swiperClass}">
        <div class="swiper-wrapper">
          ${alert.videoUrls.map(url => `
            <div class="swiper-slide">
              <video class="video-cl w-100 rounded" controls>
                <source src="${url}" type="video/mp4" />
              </video>
            </div>`).join('')}
        </div>
        <div class="swiper-button-prev"></div>
        <div class="swiper-button-next"></div>
        <div class="swiper-pagination"></div>
      </div>` : '<div class="alert alert-info">No video available</div>';

    if (alert.videoUrls?.length) {
      setTimeout(() => {
        new Swiper(`.${swiperClass}`, {
          loop: true,
          slidesPerView: 1,
          spaceBetween: 10,
          navigation: {
            nextEl: `.${swiperClass} .swiper-button-next`,
            prevEl: `.${swiperClass} .swiper-button-prev`
          },
          pagination: {
            el: `.${swiperClass} .swiper-pagination`,
            clickable: true
          }
        });
      }, 0);
    }

    // Alert card
    const alertHtml = `
      <div class="col-md-12">
        <div class="card stCard">
          <div class="card-body">
            <div class="d-flex justify-content-end mb-1">
              <button onclick="undoArchive('${doc.id}')" class="btn btn-sm btn-secondary py-1 px-2"><i class="fa fa-undo"></i> Move to Alerts</button>
            </div>
            <div class="row g-2">
              <div class="col-md-6">
                <p class="mb-0 fp2">Legal Emergency Alert for ${alert.title}</p>
                <p class="ft7 mb-2">${formattedDate}</p>
                <div class="row g-2">
                  <div class="col-6"><p class="ft7 mb-0">Location:<br /><span class="fw-bold">${alert.city}, ${alert.county}</span></p></div>
                  <div class="col-6"><p class="ft7 mb-0">Client Name:<br /><span class="fw-bold">${userData.Name}</span></p></div>
                  <div class="col-6"><p class="ft7 mb-0">DOB:<br /><span class="fw-bold">${new Date(userData.userDOB).toLocaleDateString('en-US')}</span></p></div>
                  <div class="col-6"><p class="ft7 mb-0">Charges:<br />  <span class="fw-bold">
      ${
        Array.isArray(alert.offense) && alert.offense.length
          ? alert.offense.map(o => `${o.chargedesc} (${o.severity})`).join('<br>')
          : 'N/A'
      }
    </span></p></div>
                  <div class="col-4"><p class="ft7 mb-0">Detained At:<br /><span class="fw-bold">${alert.detainedPlace || 'N/A'}</span></p></div>
                  <div class="col-4"><p class="ft7 mb-0">Designated Attorney:<br /><span class="fw-bold">${attorneyName}</span></p></div>
                  <div class="col-4"><p class="ft7 mb-0">Attorney Alerted:<br /><span class="fw-bold">${alert.isAttorneyAlerted ? 'Yes' : 'No'}</span></p></div>
                </div>
              </div>
              <div class="col-md-6">${videoHtml}</div>
            </div>
          </div>
        </div>
      </div>`;
    
    container.insertAdjacentHTML('beforeend', alertHtml);
  }
}

// 🔹 Undo archive button handler
async function undoArchive(alertId) {
  try {
    await db.collection("QuoteAlert").doc(alertId).update({
      isLawArchived: false,
      updatedAt: firebase.firestore.FieldValue.serverTimestamp()
    });

    Swal.fire({
      icon: "success",
      title: "Moved to Alerts",
      text: "This alert is now active again."
    });

    loadArchivedAlerts();
  } catch (error) {
    console.error("Error undoing archive:", error);
    Swal.fire({
      icon: "error",
      title: "Error",
      text: "Failed to move this alert back."
    });
  }
}
</script> -->
<script>
let currentUser = null;
let currentUserData = null;
let unsubscribeArchivedAlerts = null; // To track the listener

firebase.initializeApp(firebaseConfig);
const db = firebase.firestore();
const auth = firebase.auth();

firebase.auth().onAuthStateChanged(async (user) => {
  // Clean up previous listener
  if (unsubscribeArchivedAlerts) unsubscribeArchivedAlerts();
  
  if (user) {
    currentUser = user;
    currentUserData = await db.collection("Users").doc(user.uid).get().then(doc => doc.data());
    loadArchivedAlerts();
  }
});

function loadArchivedAlerts() {
  // Unsubscribe previous listener if exists
  if (unsubscribeArchivedAlerts) unsubscribeArchivedAlerts();
  
  unsubscribeArchivedAlerts = db.collection("QuoteAlert")
    .where("LawId", "==", currentUser.uid)
    .where("isLawArchived", "==", true)
    .onSnapshot(
      snapshot => renderArchivedAlerts(snapshot),
      error => console.error("Archived alerts listener error:", error)
    );
}

async function renderArchivedAlerts(snapshot) {
  const container = document.querySelector("#archivedContainer");
  container.innerHTML = "";

  if (snapshot.empty) {
    container.innerHTML = `<div class="col-md-12"><div class="alert alert-warning text-center">No archived alerts found.</div></div>`;
    return;
  }

  for (const doc of snapshot.docs) {
    const alert = doc.data();
    if (alert.isAttorenyHide === true) continue; // Skip hidden alerts

    // Get client data
    const userDoc = await db.collection("Users").doc(alert.userId).get();
    const userData = userDoc.data();

    // Format date
    const formattedDate = new Date(alert.createdDate).toLocaleDateString('en-US', {
      weekday: 'long', year: 'numeric', month: 'long', day: 'numeric', hour: '2-digit', minute: '2-digit'
    });

    // Attorney Name
    let attorneyName = "Opted Out";
    if (alert.LawId) {
      const attorneyDoc = await db.collection("Users").doc(alert.LawId).get();
      if (attorneyDoc.exists) {
        attorneyName = attorneyDoc.data().Name || "N/A";
      }
    }

    // Swiper video section
    const swiperClass = `swiper-${doc.id}`;
    const videoHtml = alert.videoUrls?.length ? `
      <div class="swiper ${swiperClass}">
        <div class="swiper-wrapper">
          ${alert.videoUrls.map(url => `
            <div class="swiper-slide">
              <video class="video-cl w-100 rounded" controls>
                <source src="${url}" type="video/mp4" />
              </video>
            </div>`).join('')}
        </div>
        <div class="swiper-button-prev"></div>
        <div class="swiper-button-next"></div>
        <div class="swiper-pagination"></div>
      </div>` : '<div class="alert alert-info">No video available</div>';

    if (alert.videoUrls?.length) {
      setTimeout(() => {
        new Swiper(`.${swiperClass}`, {
          loop: true,
          slidesPerView: 1,
          spaceBetween: 10,
          navigation: {
            nextEl: `.${swiperClass} .swiper-button-next`,
            prevEl: `.${swiperClass} .swiper-button-next`
          },
          pagination: {
            el: `.${swiperClass} .swiper-pagination`,
            clickable: true
          }
        });
      }, 0);
    }

    // Alert card with both undo archive and delete buttons
    const alertHtml = `
      <div class="col-md-12">
        <div class="card stCard">
          <div class="card-body">
            <div class="d-flex justify-content-end mb-1 gap-2">
              <button onclick="undoArchive('${doc.id}')" class="btn btn-sm btn-secondary py-1 px-2">
                <i class="fa fa-undo"></i> Move to Alerts
              </button>
              <button onclick="permanentlyDeleteAlert('${doc.id}')" class="btn btn-sm btn-danger py-1 px-2">
                <i class="fa fa-trash"></i> Delete Permanently
              </button>
            </div>
            <div class="row g-2">
              <div class="col-md-6">
                <p class="mb-0 fp2">Legal Emergency Alert for ${alert.title}</p>
                <p class="ft7 mb-2">${formattedDate}</p>
                <div class="row g-2">
                  <div class="col-6"><p class="ft7 mb-0">Location:<br /><span class="fw-bold">${alert.city}, ${alert.county}</span></p></div>
                  <div class="col-6"><p class="ft7 mb-0">Client Name:<br /><span class="fw-bold">${userData.Name}</span></p></div>
                  <div class="col-6"><p class="ft7 mb-0">DOB:<br /><span class="fw-bold">${new Date(userData.userDOB).toLocaleDateString('en-US')}</span></p></div>
                  <div class="col-6"><p class="ft7 mb-0">Charges:<br /><span class="fw-bold">
                    ${
                      Array.isArray(alert.offense) && alert.offense.length
                        ? alert.offense.map(o => `${o.chargedesc} (${o.severity})`).join('<br>')
                        : 'N/A'
                    }
                  </span></p></div>
                  <div class="col-4"><p class="ft7 mb-0">Detained At:<br /><span class="fw-bold">${alert.detainedPlace || 'N/A'}</span></p></div>
                  <div class="col-4"><p class="ft7 mb-0">Designated Attorney:<br /><span class="fw-bold">${attorneyName}</span></p></div>
                  <div class="col-4"><p class="ft7 mb-0">Attorney Alerted:<br /><span class="fw-bold">${alert.isAttorneyAlerted ? 'Yes' : 'No'}</span></p></div>
                </div>
              </div>
              <div class="col-md-6">${videoHtml}</div>
            </div>
          </div>
        </div>
      </div>`;
    
    container.insertAdjacentHTML('beforeend', alertHtml);
  }
}

async function undoArchive(alertId) {
  try {
    await db.collection("QuoteAlert").doc(alertId).update({
      isLawArchived: false,
      updatedAt: firebase.firestore.FieldValue.serverTimestamp()
    });

    Swal.fire({
      icon: "success",
      title: "Moved to Alerts",
      text: "This alert is now active again."
    });
  } catch (error) {
    console.error("Error undoing archive:", error);
    Swal.fire({
      icon: "error",
      title: "Error",
      text: "Failed to move this alert back."
    });
  }
}

async function permanentlyDeleteAlert(alertId) {
  try {
    const result = await Swal.fire({
      title: 'Permanently Delete?',
      text: "This action cannot be undone",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!'
    });

    if (result.isConfirmed) {
      await db.collection("QuoteAlert").doc(alertId).update({
        isAttorenyHide: true, // Using same flag as your previous script
        updatedAt: firebase.firestore.FieldValue.serverTimestamp()
      });

      Swal.fire(
        'Deleted!',
        'The alert has been Deleted.',
        'success'
      );
    }
  } catch (error) {
    console.error("Error deleting alert:", error);
    Swal.fire({
      icon: "error",
      title: "Error",
      text: "Failed to delete this alert."
    });
  }
}

// Clean up listener when page unloads
window.addEventListener('beforeunload', () => {
  if (unsubscribeArchivedAlerts) unsubscribeArchivedAlerts();
});
</script>