<style>
  .contract-details-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 1rem;
    margin: 1rem 0;
  }
  .detail-item {
    display: flex;
    justify-content: space-between;
    padding: 0.5rem;
    border-bottom: 1px solid #eee;
  }
  .detail-label {
    font-weight: bold;
  }
  .detail-value {
    color: #555;
  }
  #signature-pad {
    border: 1px solid #ddd;
    background-color: #f9f9f9;
  }
</style>
<!-- main -->
<main class="">
  <div class="container">
    <div class="my-5" id="contractDetails">
      <!-- Loading state -->
      <div class="text-center py-5">
        <div class="spinner-border text-primary" role="status">
          <span class="visually-hidden">Loading...</span>
        </div>
        <p class="mt-3">Loading contract details...</p>
        <!-- HTML -->


      </div>
      
    </div>
  </div>
  
  <!-- Modal -->
  <!-- <div class="modal fade" id="exampleModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h1 class="modal-title fp-1">Payment Method</h1>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <p class="fp-3">Law Pay</p>
          <p class="fp-2">
            As a Part of your Application, Lawpay will verify your info
            and Request Payment Details
            <a href="#">LawPay Privacy Policy</a>
          </p>
        </div>
      </div>
    </div>
  </div> -->
  <!-- Modal -->
  <div class="modal fade" id="exampleModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h1 class="modal-title fp-1">Payment Method</h1>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div id="card-element" class="my-3 border border-1 form-control"></div>
          <div id="payment-options" style="display:none;">
            <button id="full-payment-btn" class="btn btn-primary w-100 mb-2">
              Pay Full Amount ($<span id="full-amount">0</span>)
            </button>
            <button id="downpayment-btn" class="btn btn-secondary w-100">
              Pay Downpayment ($<span id="downpayment-amount">0</span>)
            </button>
          </div>
          <div id="stripe-element" style="display:none;">
            <div id="card-element" class="mb-3"></div>
            <button id="submit-payment" class="btn btn-success w-100">
              Confirm Payment
            </button>
          </div>


        </div>
      </div>
    </div>
  </div>
  <!-- <button
    id="testMyCaseBtn"
    class="btn btn-warning">
    Test MyCase Flow
  </button> -->
</main>




<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" ></script>
<script src="https://js.stripe.com/v3/"></script>

<script>
  // live
  // const stripe = Stripe('pk_live_51QFoufDBtwv2fMPqH893SayfEPn0JOASLUsVysih4wtZFpJ4K7n8lefX2oVnA5SVrmLUvMLGcu5arMhbddIPHroW00Z7JiRlo6');
  // test
  const stripe = Stripe('pk_test_51Plp8hHy6FyzXGcJpCU4v3gvt8rg46T6if8qspqMXX6McpcMflENFMp2HgyEp9C9G9aLfX1LpX0eNoMMUbKzJqKZ00hasa4ncI');
  let elements;
  let cardElement;
  let quoteData;
  let userData;
  let hasSigned = false;
  let quoteId;
  let lawId;

  // Define globally
let currentUserData = null;

  // Listen for Firebase auth state
  firebase.auth().onAuthStateChanged(async (user) => {
    if (!user) {
      console.log("No user logged in");
      return;
    }

    try {
      const doc = await firebase.firestore().collection("Users").doc(user.uid).get();
      if (!doc.exists) {
        console.log("User data not found in Firestore");
        return;
      }

      currentUserData = doc.data(); // Populate global variable
      // console.log("Current User Data:", currentUserData);

    } catch (err) {
      console.error("Error fetching user data:", err);
    }
  });

//   document.getElementById("testMyCaseBtn").addEventListener("click", async () => {
//   Swal.fire({
//     title: "Testing MyCase Flow",
//     text: "Running MyCase integration without payment...",
//     allowOutsideClick: false,
//     didOpen: () => Swal.showLoading()
//   });

//   await runMyCaseFlow();
// });



  document.addEventListener('DOMContentLoaded', async () => {
    const db = firebase.firestore();
    const urlParams = new URLSearchParams(window.location.search);
    lawId = urlParams.get('lawId');
      quoteId = urlParams.get('quoteId');
    if (quoteId && quoteId.includes('?')) {
    quoteId = quoteId.split('?')[0];  // take only the real ID
    }

    const container = document.getElementById('contractDetails');

    if (!lawId || !quoteId) {
      container.innerHTML = `
        <div class="alert alert-danger">
          Missing required parameters. Please ensure both lawId and quoteId are provided.
        </div>
      `;
      return;
    }

    try {
      // Fetch quote details
      const quoteDoc = await db.collection("QuoteAlert").doc(quoteId).get();
      if (!quoteDoc.exists) throw new Error("Quote not found");
      quoteData = quoteDoc.data();

      // Fetch user details
      const userDoc = await db.collection("Users").doc(quoteData.userId).get();
      if (!userDoc.exists) throw new Error("User not found");
      userData = userDoc.data();

      // Fetch emergency contact
      let guarantorName = "N/A";
      try {
        const emergencyContacts = await db.collection("Users")
          .doc(quoteData.userId)
          .collection("EmergencyContacts")
          .limit(1)
          .get();

        if (!emergencyContacts.empty) {
          guarantorName = emergencyContacts.docs[0].data().name || "N/A";
        }
      } catch (e) {
        console.error("Error fetching emergency contacts:", e);
      }
    // JavaScript



      // Format date
      const createdDate = new Date(quoteData.createdDate);
      const today = new Date();
      const dateStr = `${today.getMonth() + 1}/${today.getDate()}/${today.getFullYear()}`;

      container.innerHTML = `
        <div class="d-flex justify-content-between align-items-center">
        <p class="fp-1">Contract Details</p>
        <button id="viewDocBtn" class="btn btn-save btn-width d-flex justify-content-center align-items-center">View Document</button>
        </div>
        <div class="contract-details-grid">
          <div class="detail-item"><span class="detail-label">Date:</span><span class="detail-value">${dateStr}</span></div>
          <div class="detail-item"><span class="detail-label">Client Name:</span><span class="detail-value">${userData.Name || 'N/A'}</span></div>
          <div class="detail-item"><span class="detail-label">County:</span><span class="detail-value">${quoteData.county || 'N/A'}</span></div>
          <div class="detail-item">
        <span class="detail-label">Charges:</span>
        <span class="detail-value">
          ${
            Array.isArray(quoteData.offense) && quoteData.offense.length
              ? quoteData.offense.map(off =>
                  `${off.chargedesc || 'Unknown'} (${off.severity || '-'}) - ${off.warrantissuedagency || 'Unknown Agency'}`
                ).join('<br>')
              : 'N/A'
          }
        </span>
      </div>

          <div class="detail-item"><span class="detail-label">Retainer Fee:</span><span class="detail-value">$${quoteData.qoutesPrice || '0'}</span></div>
          <div class="detail-item"><span class="detail-label">Down Payment Amount:</span><span class="detail-value">$${quoteData.qoutesDeposite || '0'}</span></div>
          <div class="detail-item"><span class="detail-label">Paid on Date:</span><span class="detail-value">${quoteData.paidDate
    ? quoteData.paidDate.toDate().toLocaleDateString()  
    : 'Not paid yet'}</span></div>
          <div class="detail-item"><span class="detail-label">Paid on Day of Month:</span><span class="detail-value">${
      quoteData.paidDate ? quoteData.paidDate.toDate().getDate() : 'N/A'
    }</span></div>
          <div class="detail-item"><span class="detail-label">Guarantor Name:</span><span class="detail-value">${
      quoteData.userId === firebase.auth().currentUser.uid
        ? (userData.Name || 'N/A')
        : guarantorName
    }</span></div>
          <div class="detail-item"><span class="detail-label">Signature Date:</span><span class="detail-value">${dateStr}</span></div>
        </div>

      
        <div class="d-flex justify-content-end">
        
          <button class="btn btn-save btn-width d-flex justify-content-center align-items-center" data-bs-toggle="modal" data-bs-target="#exampleModal" id="pay">Finish & Pay</button>
        </div>
      `;
      // 🔹 Check if envelope has been signed
      const payBtn = document.getElementById('pay');
      
      // Signature Pad & Payment Handlers
      // initSignaturePad();
      setupPaymentHandlers();
      const urlParams = new URLSearchParams(window.location.search);
      const userId = urlParams.get('lawId'); // this is the userId
      let qid=  urlParams.get('quoteId');
      const viewDocBtn = document.getElementById('viewDocBtn');
      
      if (quoteData.isEnvelopSign === true) {
          // Enable Finish & Pay button
          payBtn.disabled = false;
          viewDocBtn.disabled = true;
        } else {
          viewDocBtn.disabled = false;
          payBtn.disabled = true;
          payBtn.addEventListener('click', function (e) {
              e.preventDefault();
              Swal.fire(
                'Please view and sign document first',
                '',
                'warning'
              );
          });
      }
      
      viewDocBtn.addEventListener("click", async () => {

          try {
            const db = firebase.firestore();
            const currentUser = firebase.auth().currentUser;
            if (!currentUser || !currentUser.email) {
              Swal.fire("Error", "No logged-in user email found", "error");
              return;
            }

            // 1️⃣ Get DocuSign Bearer token
            const tokenResp = await fetch(
              // "https://duepro.com/duepro_docusign_apis/index.php/docusign/token",
              "https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/token",
              
              { headers: { Accept: "application/json" } }
            );
            if (!tokenResp.ok) throw new Error("Failed to get token");
            const tokenData = await tokenResp.json();
            if (!tokenData.success || !tokenData.access_token) {
              throw new Error("Token API did not return a valid token");
            }
            const accessToken = tokenData.access_token;

            // 2️⃣ Find templateId for this lawId
            const lawUserDoc = await db.collection("Users").doc(lawId).get();
            if (!lawUserDoc.exists) throw new Error("Lawyer user not found");
            const lawUserData = lawUserDoc.data();
            if (!lawUserData.LawFirmId)
              throw new Error("LawFirmId not found in user document");

            const lawFirmDoc = await db.collection("LawFirm")
              .doc(lawUserData.LawFirmId)
              .get();
            if (!lawFirmDoc.exists) throw new Error("LawFirm document not found");
            // const templateId = lawFirmDoc.data().templateId;
            // if (!templateId) throw new Error("templateId not found in LawFirm document");
            let templateId;
            if (qid) {
              const quoteDoc = await db.collection("QuoteAlert").doc(qid).get();
              if (quoteDoc.exists) {
                const quoteData = quoteDoc.data();
                if (quoteData.template_id) {
                  templateId = quoteData.template_id; // Use template_id from QuoteAlert
                }
              }
            }

            // ✅ If no template_id in QuoteAlert, fallback to LawFirm's templateId
            if (!templateId) {
              templateId = lawFirmDoc.data().templateId;
            }
            if (!templateId) throw new Error("No templateId found in QuoteAlert or LawFirm");
                // 3️⃣ Prepare payload for DocuSign
                const today = new Date();
                const otherData = {
                  date: today.toISOString().slice(0, 10),
                  clientName: userData.Name || "N/A",
                  county: quoteData.county || "N/A",
                  charges: Array.isArray(quoteData.offense) && quoteData.offense.length
                    ? quoteData.offense.map(off =>
                        `${off.chargedesc || "Unknown"} (${off.severity || "-"})`
                      ).join(", ")
                    : "N/A",
                  retainerFee: quoteData.qoutesPrice || 0,
                  downPaymentAmount: quoteData.qoutesDeposite || 0,
                  paidOnDate: quoteData.paidDate
                    ? quoteData.paidDate.toDate().toISOString().slice(0, 10)
                    : "Not paid yet",
                  monthlyPayment: quoteData.monthlyPayment || 0,
                  paidOnDayOfMonth: quoteData.paidDate
                    ? quoteData.paidDate.toDate().getDate()
                    : "N/A",
                  guarantorName:
                    quoteData.userId === currentUser.uid
                      ? (userData.Name || "N/A")
                      : guarantorName,
                  signatureDate: today.toISOString().slice(0, 10)
                };

                console.log("template_id", templateId);
                console.log("name", userData.Name);
                console.log("email", userData.email);
                console.log("doc_id", quoteId);

                // ⚠️ Build URL-encoded form body (not FormData)
                const params = new URLSearchParams();
                params.append("templateId", templateId);
                // match iOS returnUrl (signingCallback)
                // params.append("returnUrl",  'https://duepro.com/duepro_docusign_apis/index.php/docusign/signingCallback');
                params.append("returnUrl",  'https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/signingCallback');
                params.append("webUrl",  window.location.href);
                params.append("name", userData.Name || "N/A");
                params.append("email", userData.email || "N/A");
                params.append("doc_id", quoteId);
                params.append("attorney_email", lawUserDoc.email || "N/A");
                
                
                // if backend needs attorney_email you can add:
                params.append("attorney_email", currentUser.email);
                // params.append("otherdata", JSON.stringify(otherData));
                // ✅ send each field in otherdata like iOS
            // Object.entries(otherData).forEach(([k, v]) => {
            //   params.append(`otherdata[${k}]`, v);
            // });
            params.append("otherdata", JSON.stringify(otherData));
                Swal.fire({
                  title: "Preparing Document...",
                  allowOutsideClick: false,
                  didOpen: () => Swal.showLoading(),
                });

            // 4️⃣ Call DocuSign envelope-from-template API
            const apiUrl =
            // "https://duepro.com/duepro_docusign_apis/index.php/docusign/envelope-from-template";
            "https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/envelope-from-template";
            const docusignResp = await fetch(apiUrl, {
              method: "POST",
              headers: {
                "Authorization": `Bearer ${accessToken}`,
                "Accept": "application/json",
                "Content-Type": "application/x-www-form-urlencoded"
              },
              body: params.toString(),
            });

            if (!docusignResp.ok) {
              const errText = await docusignResp.text();
              throw new Error(errText || "DocuSign API call failed");
            }

            const result = await docusignResp.json();
            console.log("DocuSign result:", result);

            // ✅ Extract envelopeId
            const envelopeId = result?.data?.envelope?.envelopeId;
            console.log("envelopeId",envelopeId);
            

            if (!envelopeId) {
              throw new Error("Envelope created but envelopeId missing");
            }

            // ✅ Save to QuoteAlert
            await db.collection("QuoteAlert").doc(quoteId).update({
              envelopeId: envelopeId,
              envelopeCreatedAt: firebase.firestore.FieldValue.serverTimestamp(),
            });
            Swal.close();

            // ✅ The API should return the signing URL inside result.data.recipientView.url
            if (result.data && result.data.recipientView && result.data.recipientView.url) {
              // window.open(result.data.recipientView.url, "_blank");
              window.location.href=result.data.recipientView.url
            } else {
              Swal.fire("Info", "Envelope created but no URL returned.", "info");
              console.log(result);
            }

          } catch (err) {
            console.error("DocuSign API error:", err);
            
            // Better error message for CORS
            if (err.message.includes('Failed to fetch')) {
                Swal.fire(
                    "Connection Error", 
                    "Unable to connect to DocuSign service. Please contact support.", 
                    "error"
                );
            } else {
                Swal.fire("Error", err.message || "Failed to load document", "error");
            }
        }
        //   catch (err) {
        //   console.error("DocuSign API error:", err);
        //   Swal.fire("Error", err.message || "Failed to load document", "error");
        // }
      });   


    } catch (error) {
      console.error("Error loading contract:", error);
      container.innerHTML = `
        <div class="alert alert-danger">
          Error loading contract details: ${error.message}
        </div>
      `;
    }
  });


  function setupPaymentHandlers() {
    const payBtn = document.getElementById('pay');
    if (!payBtn) return console.warn('Pay button not found');

    payBtn.addEventListener('click', async function (e) {
      e.preventDefault();

      // const canvas = document.getElementById("signature-pad");
      // const ctx = canvas.getContext("2d");
      // const signatureData = ctx.getImageData(0, 0, canvas.width, canvas.height).data;
      // hasSigned = signatureData.some(channel => channel !== 0);

      // if (!hasSigned) {
      //   Swal.fire('Signature Required', 'Please sign the contract before proceeding to payment', 'warning');
      //   return;
      // }

      document.getElementById('full-amount').textContent = quoteData.qoutesPrice;
      document.getElementById('downpayment-amount').textContent = quoteData.qoutesDeposite;
      if(quoteData.qoutesDeposite==0){
        document.getElementById('downpayment-btn').style.display="none"
      }
      document.getElementById('payment-options').style.display = 'block';

      $('#exampleModal').on('shown.bs.modal', function () {
        if (!elements) {
          elements = stripe.elements();
          cardElement = elements.create('card');
          cardElement.mount('#card-element');
        }
      });
    });

    document.getElementById('full-payment-btn').addEventListener('click', async function () {
      await processPayment(quoteData.qoutesPrice, 'full');
    });

    document.getElementById('downpayment-btn').addEventListener('click', async function () {
      await processPayment(quoteData.qoutesDeposite, 'partial');
    });
  }

  async function processPayment(amount, paymentType) {
    try {
      // // First upload the signature image to Firebase Storage
      // const canvas = document.getElementById("signature-pad");
      // const signatureDataURL = canvas.toDataURL();
      
      // // Convert data URL to blob
      // const blob = await (await fetch(signatureDataURL)).blob();
      const storageRef = firebase.storage().ref();
      // const signatureRef = storageRef.child(`SignDocs/${quoteId}_${new Date().getTime()}.png`);
      
      // Show loading indicator
      Swal.fire({
        title: 'Processing Payment',
        html: 'Please wait while we process your payment and signature...',
        allowOutsideClick: false,
        didOpen: () => {
          Swal.showLoading();
        }
      });

      // Upload signature image
      // const uploadTask = await signatureRef.put(blob);
      // const signatureUrl = await uploadTask.ref.getDownloadURL();

      // Create payment intent via CodeIgniter endpoint
      const response = await fetch('<?php echo site_url("site/create_payment_intent"); ?>', {
              method: 'POST',
              headers: {
                  'Content-Type': 'application/json',
                  'X-Requested-With': 'XMLHttpRequest'
              },
              body: JSON.stringify({
                  amount: Math.round(amount * 100), // Convert to cents
                  currency: 'usd',
                  quoteId: quoteId,
                  paymentType: paymentType,
                  lawId: lawId
              })
          });

          if (!response.ok) {
              const errorData = await response.json();
              throw new Error(errorData.error || 'Failed to create payment intent');
          }

      const { clientSecret } = await response.json();

      // Confirm the payment with Stripe
      const { paymentIntent, error } = await stripe.confirmCardPayment(clientSecret, {
        payment_method: {
          card: cardElement,
          billing_details: {
            name: userData.Name || 'Client',
          },
        }
      });

      if (error) {
        throw error;
      }

      if (paymentIntent.status === 'succeeded') {
        // Update QuoteAlert document with payment details
        const db = firebase.firestore();
        await db.collection("QuoteAlert").doc(quoteId).update({
          // signatureImage: signatureUrl,
          // paidStatus: paymentType === 'full' ? '1' : '0',
          paidStatus: "1",
          paidDate: new Date(),
          isFullPaid: paymentType === 'full',
          paymentId: paymentIntent.id,
          clientSecret: clientSecret,
          paymentMethod: 'stripe'
        });

        
          const quoteSnap = await db.collection("QuoteAlert").doc(quoteId).get();
          const quoteData = quoteSnap.data();
          const mainDocId = quoteData.baseDocId || quoteId;

          if (quoteData.acceptedAttorneyType) {
            await db.collection("QuoteAlert").doc(mainDocId).update({
              hireAttorneyAcceptedType: firebase.firestore.FieldValue.arrayUnion(
                quoteData.acceptedAttorneyType
              ),
              updatedAt: firebase.firestore.FieldValue.serverTimestamp()
            });
          }

        // Hide loading and show success
        // Swal.fire({
        //   icon: 'success',
        //   title: 'Payment Successful!',
        //   text: `Your ${paymentType} payment of $${amount} has been processed.`,
        //   confirmButtonText: 'OK'
        // }).then(() => {
        //   $('#exampleModal').modal('hide');
        //   window.location.href = "<?= base_url('site/quotesUser') ?>";
        // });
      Swal.fire({
    icon: 'success',
    title: 'Payment Successful!',
    text: `Your ${paymentType} payment of $${amount} has been processed.`,
    confirmButtonText: 'OK'
    }).then(async () => {
        $('#exampleModal').modal('hide');
        console.log("currentUserData",currentUserData);
            
        try {
          // ============================
          // 1️⃣ Lawyer → LawFirm
          // ============================
          const lawyerDoc = await db.collection("Users").doc(lawId).get();
          if (!lawyerDoc.exists) throw new Error("Lawyer not found");

          const lawFirmId = lawyerDoc.data().LawFirmId;
          if (!lawFirmId) throw new Error("LawFirmId missing on lawyer");

          // ============================
          // 2️⃣ QuoteAlert
          // ============================
          const quoteDoc = await db.collection("QuoteAlert").doc(quoteId).get();
          if (!quoteDoc.exists) throw new Error("Quote data not found");

          const quoteData = quoteDoc.data();

          if (!quoteData.envelopeId) {
            throw new Error("Envelope not created yet");
          }

          if (quoteData.myCaseCreated) {
            console.log("MyCase already created — skipping");
          } else {

            // ============================
            // 3️⃣ Client logic
            // ============================
            const existingClientId = currentUserData.myClientId || null;

            if (existingClientId) {
              await createMyCase(
                lawFirmId,
                existingClientId,
                quoteData
              );
            } else {
              const createdClient = await createMyCaseUser(
                currentUserData,
                lawFirmId,
                quoteData
              );

              if (!createdClient?.id) {
                throw new Error("Failed to create MyCase client");
              }

              await createMyCase(
                lawFirmId,
                createdClient.id,
                quoteData
              );
            }

            // ============================
            // 4️⃣ Mark completed
            // ============================
            await db.collection("QuoteAlert").doc(quoteId).update({
              myCaseCreated: true,
              myCaseCreatedAt: firebase.firestore.FieldValue.serverTimestamp(),
            });
          }

          // // ============================
          // // ✅ FINAL SUCCESS
          // // ============================
          // await Swal.fire(
          //   "Success",
          //   "Payment completed and case created successfully.",
          //   "success"
          // );

        } catch (err) {
          console.error("MyCase error:", err);

          await Swal.fire(
            "Warning",
            err.message || "Payment succeeded but case creation failed",
            "warning"
          );
        }

        // ✅ SINGLE REDIRECT — ALWAYS LAST
        window.location.href = "<?= base_url('site/quotesUser') ?>";
      });

        } else {
          throw new Error('Payment not completed');
        }

    } catch (error) {
      console.error('Payment processing error:', error);
      Swal.fire({
        icon: 'error',
        title: 'Payment Failed',
        text: error.message || 'There was an error processing your payment. Please try again.',
        confirmButtonText: 'OK'
      });
    }
  }

  async function runMyCaseFlow() {
    try {
      const db = firebase.firestore();

      // 1️⃣ Lawyer → LawFirm (still needed for firm context)
      const lawyerDoc = await db.collection("Users").doc(lawId).get();
      if (!lawyerDoc.exists) throw new Error("Lawyer not found");

      const lawFirmId = lawyerDoc.data().LawFirmId;
      if (!lawFirmId) throw new Error("LawFirmId missing on lawyer");

      console.log("lawFirmId", lawFirmId);

      // 2️⃣ QuoteAlert (source of envelopeId)
      const quoteDoc = await db.collection("QuoteAlert").doc(quoteId).get();
      if (!quoteDoc.exists) throw new Error("Quote data not found");

      const quoteData = quoteDoc.data();

      // ✅ REQUIRED: envelopeId
      const envelopeId = quoteData.envelopeId;
      if (!envelopeId) {
        Swal.fire("Notice", "Document not signed or envelope not created yet.", "info");
        return;
      }

      console.log("envelopeId", envelopeId);

      // 3️⃣ Current User (Client)
      const userDbData = currentUserData;
      const existingClientId = userDbData.myClientId || null;

      // 4️⃣ Create case in MyCase
      if (existingClientId) {
        console.log("Client exists → creating case...");
        await createMyCase(
          lawFirmId,
          existingClientId,
          {
            ...quoteData,
            envelopeId, // ✅ pass envelopeId to MyCase
          }
        );
      } else {
        console.log("Client not found → creating MyCase user...");
        const createdClient = await createMyCaseUser(
          userDbData,
          lawFirmId,
          {
            ...quoteData,
            envelopeId, // ✅ pass envelopeId
          }
        );

        if (!createdClient?.id) {
          throw new Error("Failed to create MyCase user");
        }

        await createMyCase(
          lawFirmId,
          createdClient.id,
          {
            ...quoteData,
            envelopeId,
          }
        );
      }


      console.log("✅ MyCase flow completed successfully.");
      Swal.fire("Success", "MyCase case created successfully", "success");

    } catch (err) {
      console.error("MyCase error:", err);
      Swal.fire("Error", err.message || "Failed to interact with MyCase", "error");
    }
  }


  function splitName(fullName) {
    if (!fullName || typeof fullName !== "string") {
      return { first_name: "", last_name: "" };
    }

    const parts = fullName.trim().split(" ");

    if (parts.length === 1) {
      return { first_name: parts[0], last_name: "" };
    }

    return {
      first_name: parts[0],
      last_name: parts.slice(1).join(" ") // handles middle & last names
    };
  }

  async function createMyCaseUser(userData, lawFirmId, quoteData) {
    const db = firebase.firestore();
    try {
      // const nameParts = splitName(currentUserData.Name);
      const nameParts = splitName(userData.Name);
      const payload = {
        lawId: lawFirmId,
        userData: {
          email: userData.email || "",
          first_name: nameParts.first_name,
          last_name:  nameParts.last_name,
        }
      };

      const response = await fetch("https://buzzwaretechserver.site/mycase_apis/mycase/create-client", {
        method: "POST",
        headers: {
          "Content-Type": "application/json"
        },
        body: JSON.stringify(payload)
      });
      

      if (!response.ok) {
        const errorData = await response.json();
        console.error("Failed to create MyCase client:", errorData);
        return;
      }

      const result = await response.json();
      
      // ✅ Extract MyCase user ID
      const myClientId = result.id;

      await db.collection("Users").doc(userData.uid).update({
        myClientId: Number(myClientId) || null
      });
      // ✅ Create Case Immediately

    } catch (err) {
      console.error("Error in createMyCaseUser:", err);
    }
  }

  function getPracticeAreaFromQuote(quoteAlert) {
    if (!quoteAlert) return "General";

    const category = quoteAlert?.category?.toLowerCase() || "";

    if (category.includes("immigration")) return "Immigration";
    if (category.includes("criminal")) return "Criminal Defense";

    return "General"; // fallback
  }

  function buildCasePayload(lawFirmId, myCaseId, quoteData) {
    // Unique Case Name (Date + Time)
    const now = new Date();
    const uniqueCaseName =
      "Case_" +
      now.getFullYear() +
      (now.getMonth() + 1) +
      now.getDate() +
      "_" +
      now.getHours() +
      now.getMinutes() +
      now.getSeconds();

    // Generate case_number (random 6 digits)
    const caseNumber = Math.floor(100000 + Math.random() * 900000).toString();

    const payload = {
      lawId: lawFirmId,
      caseData: {
        name: uniqueCaseName,
        case_number: caseNumber,
        opened_date: "2025-12-03",
        case_stage: "open",

        // 🟦 Dynamic practice area
        practice_area: quoteData?.practiceArea || "Immigration",

        description: "Case descriptionaa",
        status: "open",
        outstanding_balance: 0,
        billing_contact: { id: Number(myCaseId) },
        clients: [{ id: Number(myCaseId) }],
        billing_type: "flat",
        custom_field_values: [
          { custom_field: { id: 1294159 }, value: quoteData.qoutesDeposite },
          { custom_field: { id: 1295235 }, value: quoteData.qoutesPrice }
        ]
      }
    };
    return payload;
  }

  async function createMyCase(lawFirmId, myCaseId, quoteData) {
    const db = firebase.firestore();
    const payload = buildCasePayload(lawFirmId, myCaseId, quoteData);

    try {
      const response = await fetch(
        "https://buzzwaretechserver.site/mycase_apis/mycase/create-case",
        {
          method: "POST",
          headers: {
            "Content-Type": "application/json"
          },
          body: JSON.stringify(payload)
        }
      );

      const result = await response.json();

      // ✅ Extract MyCase user ID
      const myCaseId = result.id;

      const lawUserDoc = await db.collection("Users").doc(lawId).get();
      const lawFirmDoc = await db.collection("LawFirm").doc(lawUserDoc.data().LawFirmId).get();
      const myCaseLawId = lawFirmDoc.data().myCaseLawId;
      
      const uploadDoc = await uploadDocumentToMyCase(lawFirmId, myCaseLawId , myCaseId);

      if (!response.ok) {
        console.error("Failed to create case:", result);
        return;
      }

    } catch (err) {
      console.error("Error creating MyCase case:", err);
    }
  }

  async function uploadDocumentToMyCase(lawFirmId, myCaseLawId, myCaseId) {
    try {
      const payload = {
        lawId: lawFirmId,
        case_id: myCaseId,
        mycase_doc_id: "363142597",
      };
      
      const response = await fetch(
        "https://buzzwaretechserver.site/mycase_apis/mycase/upload-doc-to-case",
        {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify(payload)
        }
      );
      // console.log("MyCase document upload response:", response);

      if (!response.ok) {
        const error = await response.json();
        console.error("Upload Error:", error);
        return;
      }

      const result = await response.json();

      return result;

    } catch (err) {
      console.error("Upload Document Failed:", err);
    }
  }





</script>
