 <!-- main -->
   
<main class="mb-5">
  <div class="container">
    <div class="my-5">
      <div class="row g-2" id="attorneyDetails">
        <!-- Content will be dynamically inserted here -->
        <div class="col-12 text-center py-5">
          <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Loading...</span>
          </div>
          <p class="mt-3">Loading attorney details...</p>
        </div>
      </div>
    </div>
  </div>
</main>


<script src="<?= base_url('assets/js/subscription.js'); ?>"></script>

<script>
  document.addEventListener('DOMContentLoaded', () => {
    firebase.auth().onAuthStateChanged(async (user) => {
      const container = document.getElementById('attorneyDetails');
      if (!user) {
        container.innerHTML = `
          <div class="col-12 text-center py-5">
            <p class="text-danger">Please log in to view this page</p>
            <a href="/login" class="btn btn-primary">Login</a>
          </div>
        `;
        return;
      }

      const db = firebase.firestore();
      const currentUserId = user.uid;
      const urlParams = new URLSearchParams(window.location.search);
      const lawId = urlParams.get('lawId');
      const quoteId = urlParams.get('quoteId');

      if (!lawId) {
        container.innerHTML = `
          <div class="col-12 text-center py-5">
            <p class="text-danger">No attorney ID provided</p>
            <a href="<?= base_url('site/quotesUser') ?>" class="btn btn-primary">Go Back</a>
          </div>
        `;
        return;
      }

      try {
        // Get QuoteAlert
        const quoteSnap = await db.collection("QuoteAlert").doc(quoteId).get();
        const quote = quoteSnap.exists ? quoteSnap.data() : null;

        const lawFirmSnap = await db.collection("LawFirm")
          .where("userId", "==", lawId)
          .limit(1)
          .get();

        let firmData = {};
        let firmImageUrl = "../assets/images/placeholder.png";
        let firmVideo=""
        if (!lawFirmSnap.empty) {
          firmData = lawFirmSnap.docs[0].data();
          firmImageUrl = firmData.imageUrl || firmImageUrl;
        firmVideo = firmData.videoUrl
        }

        const isBestFirm = (await db.collection("LawFirm")
          .where("userId", "==", currentUserId)
          .limit(1)
          .get()).docs[0]?.data()?.isBest || false;

        const attorneyDoc = await db.collection("Users").doc(lawId).get();
        if (!attorneyDoc.exists) throw new Error("Attorney not found");

        const attorney = attorneyDoc.data();

        const isHired = quote?.paidStatus == 1;
        const quotePrice = quote?.qoutesPrice || 0;
        const depositPrice = quote?.qoutesDeposite || 0;

        let hireButtonHTML = '';
        let offenseWarning = '';

        const hasOffense = Array.isArray(quote?.offense) && quote.offense.length > 0;
        const allHaveSeverity = hasOffense && quote.offense.every(o => o.severity && o.severity.trim() !== '');

      hireButtonHTML = isHired
            ? `<a href="#" class="btn btn-secondary px-5 py-3 btn-same mt-3 disabled" id="disabledHireBtn">Hired</a>`
            : `<a href="<?= base_url('site/attorneyContract?lawId=${lawId}&quoteId=${quoteId}') ?>" class="btn btn-save px-5 py-3 btn-same mt-3" id="hireBtn">Hire</a>`;

        const statusLabel = isHired
          ? '<span class="badge bg-success">Hired</span>'
          : '<span class="badge bg-danger">Pending</span>';

        container.innerHTML = `
          <div class="col-md-3">
            <img class="img-fluid img-atr" src="${firmImageUrl}" alt="${attorney.Name || 'Attorney'}" />
          ${firmVideo ? `
        <video width="100%" controls class="mt-3">
          <source src="${firmVideo}" type="video/mp4">
          Your browser does not support video preview.
        </video>

      ` : ""}
            
          </div>
          <div class="col-md-9">
            <div>
              <div class="d-flex justify-content-between align-items-center">
                <div>
                  <p class="fp-1">${firmData.professionalName || 'Attorney Name'}</p>
                  <p class="fp-2">${attorney.title || 'Attorney'}</p>
                </div>
                <div>
                  <a href="<?= base_url('site/chatUser') ?>?receiverId=${lawId}" class="btn btn-save start-chat-btn" data-id="${lawId}">
                    <i class="fa-regular fa-message"></i>
                  </a>
                </div>
              </div>

              ${isBestFirm ? `
                <img class="logo-image" src="../assets/images/best.png" alt="Best Firm Logo" />
              ` : attorney.logoImage ? `
                <img class="logo-image" src="${attorney.logoImage}" alt="Firm Logo" />
              ` : ''}

              <div class="d-flex gap-3 align-items-center flex-wrap">
                <div class="d-flex gap-2 align-items-center">
                  <img class="icon-image" src="../assets/images/ph.png" alt="Phone" />
                  <p class="fp-5">${firmData.phone || 'Phone not available'}</p>
                </div>
                <div class="d-flex gap-2 align-items-center">
                  <img class="icon-image" src="../assets/images/ml.png" alt="Email" />
                  <p class="fp-5">${firmData.email || 'Email not available'}</p>
                </div>
                <div class="d-flex gap-2 align-items-center">
                  <img class="icon-image" src="../assets/images/locn.png" alt="Location" />
                  <p class="fp-5">${firmData.address || 'Address not available'}</p>
                </div>
              </div>

              ${firmData.bioPractice ? `
                <div class="mt-3">
                  <p class="fp-6 mb-1"><strong>About:</strong></p>
                  <p class="fp-5">${firmData.bioPractice}</p>
                </div>
              ` : ''}

              ${firmData.userlat && firmData.userlon ? `
                <div class="my-3">
                  <iframe width="100%" height="300" frameborder="0" style="border:0"
                    src="https://www.google.com/maps?q=${firmData.userlat},${firmData.userlon}&hl=es;z=14&output=embed"
                    allowfullscreen>
                  </iframe>
                </div>
              ` : ''}

              <div class="d-flex justify-content-start gap-4 mt-3 align-items-center">
                <p class="mb-0"><strong>Quote:</strong> $${quotePrice}</p>
                <p class="mb-0"><strong>Deposit:</strong> $${depositPrice}</p>
                ${statusLabel}
              </div>

              ${offenseWarning}
          <div class="d-flex justify-content-end">
              ${hireButtonHTML}
          </div>
            </div>
          </div>
        `;

        // Show alert if hire is disabled
        document.getElementById('disabledHireBtn')?.addEventListener('click', (e) => {
          e.preventDefault();
          Swal.fire({
            icon: 'info',
            title: 'Already Hired',
            text: 'You have already hired this attorney for this case.'
          });
        });
         // New: membership check for hire button
        const hireBtn = document.getElementById('hireBtn');
        if (hireBtn) {
          hireBtn.addEventListener('click', async (e) => {
            e.preventDefault();

            // ✅ Check membership
            const allowed = await checkMembershipAccess({
              redirectTo: "<?php echo base_url('site/membership'); ?>"
            });

            if (!allowed) return; // blocked user

            // Proceed to hire if allowed
            window.location.href = `<?= base_url('site/attorneyContract?lawId=${lawId}&quoteId=${quoteId}') ?>`;
          });
        }

      } catch (error) {
        console.error("Error loading attorney:", error);
        container.innerHTML = `
          <div class="col-12 text-center py-5">
            <p class="text-danger">Error loading attorney details</p>
            <p class="text-muted">${error.message}</p>
            <a href="<?= base_url('site/quotesUser') ?>" class="btn btn-primary">Go Back</a>
          </div>
        `;
      }
    });
  });
</script>
