<style>
  #loader {
    display: none;
  }
</style>

 <main class="mb-5">
   <div class="container-fluid mb-5">
     <div class="mt-5">
       <p class="f6" data-i18n="attorney_contact"></p>

       <div id="loader" class="text-center my-4">
         <div class="spinner-border text-primary" role="status">
           <span class="visually-hidden" data-i18n="loading">Loading...</span>
         </div>
       </div>
     </div>
     <div class="d-flex justify-content-center">
       <ul class="nav nav-tabs  n-tabs gap-2" id="lawTabs" role="tablist">
         <li class="nav-item" role="presentation">
           <button class="nav-link active" id="criminal-tab" data-bs-toggle="tab" data-bs-target="#criminal"
             type="button" role="tab">Criminal Defense</button>
         </li>
         <li class="nav-item" role="presentation">
           <button class="nav-link" id="immigration-tab" data-bs-toggle="tab" data-bs-target="#immigration"
             type="button" role="tab">Immigration</button>
         </li>
       </ul>
     </div>
     <div class="tab-content mt-3" id="lawTabsContent">
       <div class="tab-pane fade show active" id="criminal" role="tabpanel" aria-labelledby="criminal-tab">
         <div class="row justify-content-center">
           <div class="col-md-6 my-2">
             <div class="row g-2" id="criminalCards"></div>
           </div>
         </div>
       </div>
       <div class="tab-pane fade" id="immigration" role="tabpanel" aria-labelledby="immigration-tab">
         <div class="row justify-content-center">
           <div class="col-md-6 my-2">
             <div class="row g-2" id="immigrationCards"></div>
           </div>
         </div>
       </div>
     </div>
   </div>
 </main>

<script>
  const auth = firebase.auth();
  const db = firebase.firestore();

  const criminalContainer = document.getElementById("criminalCards");
  const immigrationContainer = document.getElementById("immigrationCards");

  let designatedCriminalId = null;
  let designatedImmigrationId = null;

  auth.onAuthStateChanged(async (user) => {
    if (!user) {
      Swal.fire("Error", "User not authenticated.", "error");
      return;
    }

    const userRef = db.collection("Users").doc(user.uid);
    const userDoc = await userRef.get();
    const userData = userDoc.data();

    designatedCriminalId = userData?.designatedLawyerId || null;
    designatedImmigrationId = userData?.designatedImmigrationLawyerId || null;

    // Fetch all law firms
    const lawFirmsSnapshot = await db.collection("LawFirm").get();
    const lawFirms = await Promise.all(
      lawFirmsSnapshot.docs.map(async (doc) => {
        const lawFirm = doc.data();
        // console.log("lawFirm",lawFirm);
        
        const userId = lawFirm.userId;
        // const userDoc = await db.collection("Users").doc(userId).get();
        // const userData = userDoc.data() || {};
        
        return {
          id: doc.id,
          userId,
          // Name: userData.Name || "",
          Name: lawFirm.professionalName || "",
          lawfirmName: lawFirm.attachedWithLawfirmName?.trim()
            || lawFirm.lawfirmName?.trim()
            || "NA",
          email: lawFirm.email || "",
          phone: lawFirm.phone || "",
          address: lawFirm.address || "",
          imageUrl: lawFirm.professionalPic || "",
          // practiceAreas: lawFirm.practiceAreas || ""
          practiceAreas: Array.isArray(lawFirm.practiceAreas)
            ? lawFirm.practiceAreas
          : [],
                // 🔑 REQUIRED FOR FILTERING
          attachedWithLawfirmId: lawFirm.attachedWithLawfirmId || "",
          templateId: (lawFirm.templateId || "").trim(),
        };
      })
    );
    
    function canShowAttorney(firm) {
      // Attached to a firm → show
      console.log("Checking firm:", firm);
      
      if (firm.attachedWithLawfirmId && firm.attachedWithLawfirmId !== "" || firm.templateId && firm.templateId !== "") {
        return true;
      }
      return false;
    }

    // Filter and reorder (designated attorney comes first)
    function sortFirms(firms, designatedId) {
      return firms.sort((a, b) => {
        if (a.userId === designatedId) return -1; // move designated first
        if (b.userId === designatedId) return 1;
        return 0;
      });
    }
    
    const visibleFirms = lawFirms.filter(canShowAttorney);

    const criminalFirms = sortFirms(
    visibleFirms.filter(f => f.practiceAreas.includes("Criminal Defense")),
    designatedCriminalId
    );

    const immigrationFirms = sortFirms(
    visibleFirms.filter(f => f.practiceAreas.includes("Immigration Law")),
    designatedImmigrationId
    );

    renderCards(criminalFirms, criminalContainer, designatedCriminalId, "criminal");
    renderCards(immigrationFirms, immigrationContainer, designatedImmigrationId, "immigration");


  });

  function renderCards(firms, container, designatedId, type) {
    container.innerHTML = "";

    firms.forEach((firm) => {
      
      const isSelected = firm.userId === designatedId;

      const card = document.createElement("div");
      card.className = "col-md-12";
      card.innerHTML = `
        <div class="card quote-card ${isSelected ? 'border-primary' : ''}" data-userid="${firm.userId}">
          <div class="card-body">

            <!-- Header -->
            <div class="d-flex justify-content-between align-items-start mb-3">
              <div class="d-flex gap-3 align-items-center">
                <img 
                  class="img-q rounded-circle" 
                  src="${firm.imageUrl || '<?php echo base_url(); ?>/assets/images/th.jpeg'}" 
                  alt="Profile"
                  width="60"
                  height="60"
                >

                <div>
                  <p class="fo-1 mb-1 fw-semibold">${firm.Name}</p>
                  <p class="fo-2 mb-0 text-muted">${firm.lawfirmName}</p>
                  <p class="fo-2 mb-0 text-muted">${firm.email}</p>
                  <p class="fo-3 mb-0">
                    <img src="../assets/images/ph.png" width="18">
                    ${firm.phone || "N/A"}
                  </p>
                </div>
              </div>

              ${isSelected 
                ? '<img src="<?php echo base_url(); ?>/assets/images/Fav.png" width="24" title="Your attorney" />' 
                : ''
              }
            </div>

            <hr class="my-2">

            <!-- Details -->
            <div class="row g-3">
              <div class="col-md-6">
                <p class="fo-2 mb-1 fw-semibold">Practice Areas</p>
                <p class="fo-3 mb-0 text-muted">${firm.practiceAreas}</p>
                <!--  <p class="fo-3 mb-0 text-muted">${firm.MultipracticeAreas}</p> -->
              </div>

              <div class="col-md-6">
                <p class="fo-2 mb-1 fw-semibold">Location</p>
                <div class="d-flex gap-2 align-items-start">
                  <img src="../assets/images/locn.png" width="18">
                  <p class="fo-3 mb-0 text-muted">${firm.address || "Not Provided"}</p>
                </div>
              </div>
            </div>

            </div>
          </div>
        `;
      card.querySelector('.quote-card').addEventListener('click', () => handleCardClick(firm.userId, type));
      container.appendChild(card);
    });
  }

  async function handleCardClick(clickedId, type) {
    const user = firebase.auth().currentUser;
    const userRef = db.collection("Users").doc(user.uid);

    const isCriminal = type === "criminal";
    const currentDesignatedId = isCriminal ? designatedCriminalId : designatedImmigrationId;
    const fieldName = isCriminal ? "designatedLawyerId" : "designatedImmigrationLawyerId";

    if (clickedId === currentDesignatedId) {
      const confirmRemove = await Swal.fire({
        title: "Remove Attorney",
        text: "Are you sure you want to remove this attorney contact?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Yes, remove it"
      });

      if (confirmRemove.isConfirmed) {
        await userRef.update({ [fieldName]: firebase.firestore.FieldValue.delete() });
        if (isCriminal) designatedCriminalId = null;
        else designatedImmigrationId = null;
        Swal.fire("Removed", "Attorney designation removed.", "success");
        location.reload();
      }
    } else {
      const confirmAssign = await Swal.fire({
        title: "Designate Attorney",
        text: "Are you sure you want to designate this attorney contact?",
        icon: "question",
        showCancelButton: true,
        confirmButtonText: "Yes, assign"
      });

      if (confirmAssign.isConfirmed) {
        await userRef.update({ [fieldName]: clickedId });
        if (isCriminal) designatedCriminalId = clickedId;
        else designatedImmigrationId = clickedId;
        Swal.fire("Assigned", "Attorney designated successfully.", "success");
        location.reload();
      }
    }
  }
</script>