<!-- Select2 CSS -->
<link
  href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css"
  rel="stylesheet"
/>
<!-- intlTelInput CSS -->
<link
  rel="stylesheet"
  href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.min.css"
/>

<style>
  /* ---------- Step indicator ---------- */
  .stepper {
    display: flex;
    justify-content: space-between;
    margin-bottom: 30px;
    position: relative;
  }

  .step {
    position: relative;
    z-index: 1;
    width: 100%;
    height: 10px;
    background: #e0e0e0;
    color: #333;
    border-radius: 10px;
    display: flex;
    justify-content: center;
    align-items: center;
    font-weight: bold;
    transition: 0.3s;
  }

  .step.active,
  .step.completed {
    background: #0412ca;
    /* selected/active color */
    color: #fff;
  }

  .step.completed::after {
    /* content: "✓";
    position: absolute;
    font-size: 14px;
    line-height: 1;
    top: 2px;
    left: 4px; */
  }

  /* ---------- Form steps ---------- */
  .form-step {
    display: none;
  }

  .form-step.active {
    display: block;
  }

  .btns {
    display: flex;
    justify-content: space-between;
    margin-top: 20px;
  }

  button {
    background: #0412ca;
    color: #fff;
    border: none;
    padding: 10px 20px;
    border-radius: 6px;
    cursor: pointer;
  }

  button[disabled] {
    opacity: 0.5;
    cursor: not-allowed;
  }

  /* ---------- Option cards (radios as cards) ---------- */
  .option-card {
    background: #ffffff;
    border-radius: 15px;
    filter: drop-shadow(0px 5px 7.5px rgba(0, 0, 0, 0.05));
    padding: 18px;
    cursor: pointer;
    border: 1px solid #ddd;
    transition: all 0.2s ease;
    text-align: left;
    height: 100%;
    display: flex;
    flex-direction: column;
    gap: 6px;
  }

  .option-card h5 {
    margin: 0;
    font-size: 1.05rem;
  }

  .option-card p {
    margin: 0;
    color: #555;
    font-size: 0.95rem;
  }

  .option-card input[type="radio"] {
    display: none;
    /* hide native radio */
  }

  .option-card.selected {
    border-color: #02077d;
    color: #02077d;
    border-width: 1px;
    border-style: solid;
  }

  .select2-container--default .select2-selection--multiple {
    border-radius: 15px;
    filter: drop-shadow(0px 5px 7.5px rgba(0, 0, 0, 0.05));
    background-color: #ffffff;
    padding-block: 0.6rem;
  }

  .select2-container--default.select2-container--focus .select2-selection--multiple {
    border-color: #86b7fe;
    outline: 0;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
  }

  /* Remove default arrow icon */
  .select2-selection__arrow {
    display: none;
  }

  /* Add Bootstrap-like chevron icon (optional using ::after) */
  .select2-container--default .select2-selection--multiple::after {
    content: "";
    position: absolute;
    top: 50%;
    right: 1rem;
    width: 1rem;
    height: 1rem;
    transform: translateY(-50%);
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='none' viewBox='0 0 16 16' stroke='currentColor' stroke-width='2'%3e%3cpath stroke-linecap='round' stroke-linejoin='round' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-size: 100% 100%;
    pointer-events: none;
    color: #6c757d;
  }

  .select2-container {
    width: 100% !important;
  }

  /* small responsive tweaks */
  @media (max-width: 575px) {
    .stepper::before {
      top: 12px;
    }

    .step {
      width: 26px;
      height: 26px;
    }
  }

  .pro-image {
    width: 200px;
    height: 200px;
    border-radius: 50%;
    display: none
  }

  #attorneyCards {
    max-height: 300px;
    overflow: auto;
  }

  .success-container {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;

    display: none;
    justify-content: center;
    align-items: center;
    z-index: 1000;
  }

  .success-content {
    background: white;
    padding: 3rem;
    border-radius: 15px;
    text-align: center;
    max-width: 500px;
  }

  .color-blue {
    color: #0412CA !important
  }

  .iti--allow-dropdown {
    width: 100%;
  }
</style>

<main>
  <!-- Add this before closing body tag -->
  <div id="successContainer" class="success-container ">
    <div class="success-content">


      <img class="d-block mx-auto" src="<?= base_url('assets/images/anlogo.png'); ?>" alt="Logo" width="100px" />

      <h2 class="color-blue">You Are Al Set!</h2>
      <p class="color-blue">Protection is Just A Tap Away</p>
      <button id="successClose" class="btn btn-success mt-3 d-none">Get Started</button>
    </div>
  </div>
  <div class="container p-3">
    <!-- Top step indicator (5 steps to match the 5 form panels) -->
    <div id="stepper" class="stepper"></div>

    <!-- SINGLE form wrapping all steps -->
    <div id="multiForm" novalidate>
      <!-- Step 1 -->
      <div class="form-step active" data-step="1">
        <h2 class="text-center">Tell us about you</h2>
        <h5 class="text-start mb-4">How will you use DuePro? Select One:</h5>
        <div class="row g-4 justify-content-center">
          <div class="col-md-4 col-sm-6">
            <label class="option-card d-block" for="opt_send">
              <input id="opt_send" type="radio" name="duepro_option" value="send" />
              <h5>Send Alerts (Personal Use)</h5>
              <p class="mb-0">
                I am a DuePro user who wants to send alerts to my emergency contact and my attorney.
              </p>
            </label>
          </div>

          <div class="col-md-4 col-sm-6">
            <label class="option-card d-block" for="opt_receive">
              <input id="opt_receive" type="radio" name="duepro_option" value="receive" />
              <h5>Receive Alerts (Attorney Use)</h5>
              <p class="mb-0">
                I am an attorney who wants to use DuePro within my law firm to receive alerts from users.
              </p>
            </label>
          </div>

          <div class="col-md-4 col-sm-6">
            <label class="option-card d-block" for="opt_both">
              <input id="opt_both" type="radio" name="duepro_option" value="both" />
              <h5>Send & Receive Alerts (Personal & Attorney Use) </h5>
              <p class="mb-0"> I am a DuePro user who wants to send alerts to my emergency contact and my attorney, and
                I am an attorney who wants to use DuePro within my law firm to receive alerts from users.</p>
            </label>
          </div>
        </div>
      </div>

      <!-- Step 2 -->
      <div class="form-step" data-step="2">
        <h2 class="text-center">Add your profile</h2>
        <div class="row my-2 g-2 justify-content-center">
          <label for="u-Image" class="col-md-6">
            <img class="pro-image d-none mx-auto" src="../assets/images/th.jpeg" alt="" id="userImage" />
          </label>
        </div>
        <form class="my-2" id="profileForm">
          <div class="row g-2 mb-5">
            <input type="file" id="u-Image" class="d-none" />
            <div class="col-md-6">
              <label for="name" class="custom-label mb-2">Full legal name (first,mddle,last)</label>
              <input class="form-control custom-input" type="text" name="name" id="name"
                placeholder="Full legal name (first,mddle,last)" required />
            </div>

            <div class="col-md-6">
              <label for="dob" class="custom-label mb-2" data-i18n="dob"></label>
              <input class="form-control custom-input" type="date" name="dob" id="dob" required />
            </div>

            <div class="col-md-6">
              <label for="address" class="custom-label mb-2" data-i18n="address"></label>
              <input class="form-control custom-input" type="text" name="address" id="address" placeholder="Address"
                required />
              <input type="hidden" id="userlat" />
              <input type="hidden" id="userlon" />
            </div>

            <div class="col-md-6">
              <label for="number" class="custom-label mb-2" data-i18n="mobile"></label>
              <input class="form-control custom-input" type="tel" name="number" id="number" required />
            </div>

            <div class="col-md-6">
              <label for="pincode" class="custom-label mb-2">
                Pin
              </label>
              <input class="form-control custom-input" type="text" name="pincode" id="pincode" maxlength="4"
                pattern="\d{4}" placeholder="Pin Code" required />
            </div>

            <div class="col-md-12 mt-4">
              <div class="row justify-content-center">
                <div class="col-md-6">

                </div>
              </div>
            </div>
          </div>
        </form>
      </div>

      <!-- Step 3 -->
      <div class="form-step" data-step="3">
        <h2 class="text-center">Add your emergency contact</h2>
        <form id="emerform">
          <div class="mb-3">
            <label for="fullName" class="form-label custom-label" data-i18n="full_name_label"></label>
            <input type="text" class="form-control custom-input" id="fullName" placeholder="Full Name"
              data-i18n-placeholder="full_name_placeholder" required />
          </div>

          <div class="mb-3">
            <label for="email" class="form-label custom-label" data-i18n="email_label"></label>
            <input type="email" class="form-control custom-input" id="em_email"
              data-i18n-placeholder="email_placeholder" placeholder="Email" required />
          </div>

          <div class="mb-3">
            <label for="mobile" class="form-label custom-label" data-i18n="mobile_label"></label>
            <input type="tel" class="form-control custom-input" id="em_mobile" placeholder=""
              data-i18n-placeholder="mobile_placeholder" required />
          </div>
          <div class="row justify-content-center">
            <div class="col-md-6">

            </div>
          </div>
        </form>
      </div>

      <!-- Step 4 -->
      <div class="form-step" data-step="4">
        <h2 class="text-center">Designate your attorney</h2>

        <div class="row justify-content-center">
          <div class="col-md-8 my-2">
            <!-- 🔍 Search -->
            <input type="text" id="searchInput" class="form-control mb-3"
              placeholder="Search attorney by name or email…" />

            <div class="row g-2" id="attorneyCards">
              <!-- Attorney cards will be injected here -->
            </div>

            <p class="fw-bold text-muted">
              (you can skip this step if you do not have an attorney in mind)
            </p>
          </div>
        </div>
      </div>

      <!-- Step 5 -->
      <div class="form-step" data-step="5">
        <h2 class="text-center">Add your law firm</h2>

        <form id="firmform">
          <div class="row g-3">
            <div class="col-md-6">
              <label for="practice" class="custom-label mb-2" data-i18n="practice_label"></label>
              <input class="form-control custom-input" type="text" id="practice" name="practice" required />
            </div>

            <div class="col-md-6">
               <label for="areas" class="custom-label mb-2" data-i18n="practice_areas_label">
            Practice Areas
          </label>

            <select class="form-select custom-input" id="areas" name="areas" multiple required>
                <option value="Criminal Defense">Criminal Defense</option>
                <option value="Traffic / Criminal Defense">Traffic / Criminal Defense</option>
                <option value="Immigration Law">Immigration Law</option>
                <option value="Personal Injury">Personal Injury</option>
                <option value="Family Law">Family Law</option>
                <option value="Employment Law">Employment Law</option>
                <option value="Business / Corporate Law">Business / Corporate Law</option>
                <option value="Real Estate">Real Estate</option>
                <option value="Bankruptcy Law">Bankruptcy Law</option>
                <option value="Tax Law">Tax Law</option>
                <option value="Civil Litigation / Consumer Protection">Civil Litigation / Consumer Protection</option>
                <option value="General Practice">General Practice</option>
              </select>
            </div>

            <div class="col-md-6">
              <label for="mobile" class="custom-label mb-2" data-i18n="mobile_label"></label>
              <input class="form-control custom-input" type="tel" id="firm_mobile" name="mobile" placeholder="Mobile"
                required />
            </div>

            <div class="col-md-6">
              <label for="address" class="custom-label mb-2" data-i18n="address_label"></label>
              <input class="form-control custom-input" type="text" id="addressfirm" name="addressfirm" required />
              <input type="hidden" id="firm_userlat" name="userlat" />
              <input type="hidden" id="firm_userlon" name="userlon" />
            </div>

            <div class="col-md-6">
              <label for="counties" class="custom-label mb-2" data-i18n="counties_served_label"></label>
              <select class="form-control custom-input" id="counties" name="counties[]" multiple placeholder="Counties"
                required>

                <option value="Bexar" data-i18n="Bexar">Bexar</option>
                <option value="Cameron" data-i18n="Cameron">Cameron</option>
                <option value="Collin" data-i18n="Collin">Collin</option>
                <option value="Dallas" data-i18n="Dallas">Dallas</option>
                <option value="Denton" data-i18n="Denton">Denton</option>
                <option value="Ellis" data-i18n="Ellis">Ellis</option>
                <option value="El Paso" data-i18n="El Paso">El Paso</option>
                <option value="Fort Bend" data-i18n="Fort Bend">Fort Bend</option>
                <option value="Harris" data-i18n="Harris">Harris</option>
                <option value="Hidalgo" data-i18n="Hidalgo">Hidalgo</option>
                <option value="Hood" data-i18n="Hood">Hood</option>
                <option value="Hunt" data-i18n="Hunt">Hunt</option>
                <option value="Johnson" data-i18n="Johnson">Johnson</option>
                <option value="Kaufman" data-i18n="Kaufman">Kaufman</option>
                <option value="Navarro" data-i18n="Navarro">Navarro</option>
                <option value="Palo Pinto" data-i18n="Palo Pinto">
                  Palo Pinto
                </option>
                <option value="Parker" data-i18n="Parker">Parker</option>
                <option value="Rockwall" data-i18n="Rockwall">Rockwall</option>
                <option value="Somervell" data-i18n="Somervell">Somervell</option>
                <option value="Tarrant" data-i18n="Tarrant">Tarrant</option>
                <option value="Travis" data-i18n="Travis">Travis</option>
                <option value="Wise" data-i18n="Wise">Wise</option>
              </select>
            </div>

            <div class="col-md-6">
              <label for="email" class="custom-label mb-2" data-i18n="email_label"></label>
              <input class="form-control custom-input" type="email" id="firm_email" name="email" placeholder="Email"
                required />
            </div>

            <div class="col-md-6">
              <label for="website" class="custom-label mb-2" data-i18n="website_label"></label>
              <input class="form-control custom-input" type="url" id="website" placeholder="Website" name="website" />
            </div>

            <div class="col-md-6 align-self-end">
              <label class="custom-label mb-2" data-i18n="intro_video_label"></label>
              <label for="videoUpload" class="upload-btn btn w-100" data-i18n="upload_prompt"></label>
              <input type="file" id="videoUpload" name="video" accept="video/*" class="d-none" />
              <div id="videoPreview" class="mt-2 text-muted"></div>
            </div>

            <div class="col-md-6">
              <label class="custom-label mb-2" data-i18n="photo_label"></label>
              <label for="photoUpload" class="upload-btn btn w-100" data-i18n="upload_prompt"></label>
              <input type="file" id="photoUpload" name="photo" accept="image/*" class="d-none" />
              <div id="photoPreview" class="mt-2"></div>
            </div>

            <div class="col-md-6">
              <label class="custom-label mb-2" data-i18n="supporting_document_label"></label>
              <label for="documentUpload" class="upload-btn btn w-100" data-i18n="upload_prompt"></label>
              <input type="file" id="documentUpload" name="document" class="d-none" />
              <div id="documentUpload" class="mt-2 text-muted"></div>

              <label for="documentUpload" class="btn btn-sm btn-outline-primary">
                📄 View Uploaded Document
              </label>
            </div>

            <!-- <div class="col-md-6 d-flex align-items-end">
              <button id="syncBtn" type="button" class="btn btn-save" data-i18n="sync_my_case_label"></button>
            </div> -->

            <!-- <div class="col-md-6">
              <label for="clandlyToken" class="custom-label mb-2" data-i18n="clandlyToken"></label>
              <input class="form-control custom-input" id="clandlyToken" name="clandlyToken" />
            </div> -->

            <div class="col-md-6">
              <label for="clandlyToken" class="custom-label mb-2 d-flex align-items-center gap-1">
                <span data-i18n="clandlyToken"></span>

                <!-- Info icon -->
                <i
                  class="bi bi-info-circle-fill text-primary"
                  tabindex="0"
                  data-bs-toggle="popover"
                  data-bs-trigger="focus"
                  data-bs-html="true"
                  data-bs-placement="right"
                  data-bs-content="
                  <strong>How to generate Calendly Token</strong><br><br>
                  <ol style='padding-left:16px; margin-top:8px;'>
                    <li>Log in to Calendly and complete MFA if prompted</li>
                    <li>Open <b>Menu —> Integrations & apps</b></li>
                    <li>Tap <b>API & Webhooks</b></li>
                    <li>
                      Under <b>Personal access tokens</b>,
                      tap <b>Get a token now</b> —> Continue
                    </li>
                    <li>
                      Name your token (e.g. <i>DuePro Integration</i>) and tap
                      <b>Create token</b>. Complete MFA if prompted
                    </li>
                    <li>Copy the generated token and store it securely</li>
                    <li>
                      Open <b>DuePro</b> —> Law Firm Info —> Calendly Token field —>
                      Paste token —> Tap Update
                    </li>
                  </ol>
                  "
                  style="cursor: pointer;margin-left: auto;margin-right: 15px;"
                ></i>
              </label>

              <input class="form-control custom-input d-none" id="clandlyToken" name="clandlyToken" />
            </div>

            <div class="col-md-12 mt-4">
              <div class="row justify-content-center">
                <div class="col-md-6">

                </div>
              </div>
            </div>
          </div>
        </form>

      </div>
      <!-- step 6 -->
      <div class="form-step" data-step="6">
        <form id="payoutForm" class="my-4">
          <h3 class="text-center mb-4">Payout Method</h3>

          <div class="mb-3">
            <label class="form-label">Phone Number</label>
            <input type="tel" class="form-control custom-input" id="phone" placeholder="+92331 5644313" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Account Number</label>
            <input type="text" class="form-control custom-input" id="accountNo" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Route Number</label>
            <input type="text" class="form-control custom-input" id="routeNo" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Taxpayer SSN/EIN</label>
            <input type="text" class="form-control custom-input" id="ssn" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Date of Birth</label>
            <input type="date" class="form-control custom-input" id="dobBank" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Street Address</label>
            <input type="text" class="form-control custom-input" id="streetAddress" required>
          </div>

          <div class="mb-3">
            <label class="form-label">City</label>
            <input type="text" class="form-control custom-input" id="city" required>
          </div>

          <div class="mb-3">
            <label class="form-label">State</label>
            <input type="text" class="form-control custom-input" id="state" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Zip Code</label>
            <input type="text" class="form-control custom-input" id="zipcode" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Country</label>
            <input type="text" class="form-control custom-input" id="country" value="US" required>
          </div>

          <!--<button type="submit" class="btn btn-primary w-100">Save Payout</button>-->
        </form>
      </div>
    </div>
    <!-- Navigation Buttons (kept outside the form to avoid accidental submit) -->
    <div class="btns mt-2 mb-5">
      <button type="button" id="prevBtn" disabled>Previous</button>
      <button type="button" id="nextBtn">Next</button>
    </div>
  </div>

</main>

<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB0jx5yCf4vk4I5ridEorfPMqohEhpH1H4&libraries=places"></script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<!-- intlTelInput JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js"></script>

<script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.9.3/dist/confetti.browser.min.js"></script>

<script>
  const stepperEl = document.getElementById("stepper");
  const allSteps   = Array.from(document.querySelectorAll(".form-step"));
  const nextBtn    = document.getElementById("nextBtn");
  const prevBtn    = document.getElementById("prevBtn");

  let visibleSteps = [allSteps[0]];
  let current      = 0;
  let selectedFlow = "";

  // ------------------- Stepper Circles -------------------
  function buildStepper() {
    stepperEl.innerHTML = "";
    visibleSteps.forEach((_, i) => {
      const div = document.createElement("div");
      div.className = "step";
      // div.textContent = i + 1;
      stepperEl.appendChild(div);
    });
  }

  function updateForm() {
    allSteps.forEach(s => s.classList.remove("active"));
    visibleSteps[current].classList.add("active");

    const circles = stepperEl.querySelectorAll(".step");
    circles.forEach((c, i) => {
      c.classList.toggle("active", i === current);
      c.classList.toggle("completed", i < current);
    });

    prevBtn.disabled = current === 0;
    nextBtn.textContent = current === visibleSteps.length - 1 ? "Submit" : "Next";

    toggleNextBtnIfNeeded();
  }
  let v1=""
  // ------------------- Flow selection -------------------
  document.querySelectorAll('input[name="duepro_option"]').forEach((radio) => {
    radio.addEventListener("change", (e) => {
      const val = e.target.value;
    v1= e.target.value;
      nextBtn.disabled=false
      document.querySelectorAll(".option-card").forEach((card) =>
        card.classList.remove("selected")
      );
      const card = radio.closest(".option-card");
      if (card) card.classList.add("selected");

      selectedFlow = val;
      if (val === "send") {
        visibleSteps = [allSteps[0], allSteps[1], allSteps[2], allSteps[3]];
      } else if (val === "receive") {
        visibleSteps = [allSteps[0], allSteps[1], allSteps[2], allSteps[4],allSteps[5]];
      } else {
        visibleSteps = [allSteps[0], allSteps[1], allSteps[2], allSteps[3], allSteps[4],allSteps[5]];
      }
      current = 0;
      buildStepper();
      updateForm();
    });
  });

  // ------------------- Required Fields Configuration -------------------
  const requiredFields = {
    1: [], // Step 1 (flow selection) - no validation needed
    2: ["name", "dob", "address", "number", "pincode"], // Profile step
    3: ["fullName", "em_email", "em_mobile"], // Emergency contact step
    4: [], // Attorney selection (optional)
    5: ["practice", "areas", "firm_mobile", "addressfirm", "counties", "firm_email"] ,// Law firm step
    6: ["phone", "accountNo", "routeNo", "ssn", "dob", "streetAddress","city","state","zipcode","country"] // Law firm step
  };

  // Attach input listeners to all required fields
  Object.values(requiredFields).flat().forEach(id => {
    const inp = document.getElementById(id);
    if (inp) inp.addEventListener("input", toggleNextBtnIfNeeded);
  });

  // Validation function
  function validateCurrentStep() {
    const currentStepNumber = parseInt(visibleSteps[current].getAttribute('data-step'));
    const fields = requiredFields[currentStepNumber];

    if(currentStepNumber==1 && v1==''){
        nextBtn.disabled=true
        return false
    }
    if (!fields || fields.length === 0) {
      return true; // No validation needed for this step
    }
    
    return fields.every(id => {
      const el = document.getElementById(id);
      return el && el.value.trim() !== "";
    });
  }

  function toggleNextBtnIfNeeded() {
    nextBtn.disabled = !validateCurrentStep();
  }


  async function showSuccessAnimation() {
      console.log("in success animation")
      const successContainer = document.getElementById('successContainer');
      successContainer.style.display = 'flex';

      // 🎉 Confetti animation
      confetti({
          particleCount: 350,
          spread: 100,
          origin: { y: 0.6 },
          colors: ['#0412CA', '#0412CA', '#0412CA', '#0412CA', '#0412CA', '#0412CA'],
            scalar: 3     // 🔹 2 = twice the default size
      });

    setTimeout(() => {
      confetti({
          particleCount: 100,
          angle: 60,
          spread: 55,
          origin: { x: 0 },
          colors: ['#2d3279ff'] ,
            scalar: 2     // 🔹 2 = twice the default size  // <-- add this
      });
    }, 250);

    setTimeout(() => {
        confetti({
            particleCount: 100,
            angle: 120,
            spread: 55,
            origin: { x: 1 },
            colors: ['#04084bff'] ,
              scalar: 2    // 🔹 2 = twice the default size  // <-- and here too
        });
    }, 500);


    // 🔹 After the confetti runs for a few seconds,
    //    update Firestore and then redirect.
    setTimeout(async () => {
        const user = firebase.auth().currentUser;
        if (!user) return;

        const userRef = db.collection("Users").doc(user.uid);

        // ✅ Update the fields
        await userRef.update({
            isNewUser: false,
            userInitalSetup: "complete"
        });

        // 🔀 Finally redirect to emergency page
        window.location.href = "<?= base_url('site/emergency'); ?>";
    }, 3000); // Adjust this timeout to match your animation duration
  }


  // Close success modal function
  function setupSuccessClose() {
      document.getElementById('successClose').addEventListener('click', function() {
          document.getElementById('successContainer').style.display = 'none';
          // Add redirect or next action here
          // window.location.href = '/dashboard';
      });
  }

  let autocomplete2;

  function initAutocomplete2() {
    console.log("in auto")
    const input = document.getElementById('address');
    autocomplete2 = new google.maps.places.Autocomplete(input);
    autocomplete2.setFields(['geometry', 'address_components']);

    autocomplete2.addListener('place_changed', function () {
      const place = autocomplete2.getPlace();
      if (!place.geometry) {
        Swal.fire("Invalid Address", "No details found for selected address.", "warning");
        return;
      }

      const lat = place.geometry.location.lat();
      const lng = place.geometry.location.lng();

      document.getElementById('userlat').value = lat;
      document.getElementById('userlon').value = lng;
    });
  }

    // window.onload = initAutocomplete2;
  
  window.addEventListener('load', initAutocomplete2);
  window.addEventListener('load',  initAutocomplete9);
  // ------------------- Step-specific Save Functions -------------------
  async function saveProfileStep() {
      try {
          const db = firebase.firestore();
          const storage = firebase.storage();
          let selectedImageFile = null;

          Swal.fire({
              title: "Please wait...",
              text: "Saving profile...",
              allowOutsideClick: false,
              allowEscapeKey: false,
              didOpen: () => {
                  Swal.showLoading();
              },
          });

          const user = firebase.auth().currentUser;
          if (!user) {
              Swal.fire("Error", "User not logged in.", "error");
              return false;
          }

          const pinCode = document.getElementById("pincode").value.trim();

          const iti2 = window.intlTelInputGlobals.getInstance(
              document.getElementById("number")
          );
          const phone = iti2.getNumber();

          if (!phone || !iti2.isValidNumber()) {
              Swal.fire(
                  "Invalid Phone Number",
                  "Please enter a valid phone number.",
                  "warning"
              );
              return false;
          }

          if (!/^\d{4}$/.test(pinCode)) {
              Swal.fire(
                  "Invalid Pin Code",
                  "Please enter a valid 4-digit number.",
                  "warning"
              );
              return false;
          }

          const userlat = parseFloat(document.getElementById("userlat").value) || null;
          const userlon = parseFloat(document.getElementById("userlon").value) || null;
        if(!userlat || !userlon){
          Swal.fire("Invalid Address",  "error");
          return false
        }
          const updatedData = {
              Name: document.getElementById("name").value,
              address: document.getElementById("address").value,
              userPhone: phone,
              userDOB: new Date(document.getElementById("dob").value).getTime(),
              pinCode: pinCode,
              userlat: userlat,
              userlon: userlon,
              userInitalSetup:"process"
            
          };

          if (selectedImageFile) {
              const storageRef = storage.ref(
                  `profileImages/${user.uid}/${Date.now()}_${selectedImageFile.name}`
              );
              const snapshot = await storageRef.put(selectedImageFile);
              const downloadURL = await snapshot.ref.getDownloadURL();
              updatedData.imageUrl = downloadURL;
          }

          await db.collection("Users").doc(user.uid).update(updatedData);
          Swal.fire("Success", "Your profile has been saved successfully.", "success");
          return true;
      } catch (error) {
          console.error("Error saving profile:", error);
          Swal.fire("Save Failed", error.message, "error");
          return false;
      }
  }

  // Initialize intlTelInput for emergency contact
  const input2 = document.querySelector("#em_mobile");
  const iti = window.intlTelInput(input2, {
      initialCountry: "auto",
      geoIpLookup: function (callback) {
          fetch("https://ipapi.co/json")
              .then((res) => res.json())
              .then((data) => callback(data.country_code))
              .catch(() => callback("us"));
      },
      utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js",
  });

  // bank




  // bank

  async function saveEmergencyContactStep() {
      try {
          const user = firebase.auth().currentUser;
          if (!user) {
              Swal.fire("Error", "User not logged in.", "error");
              return false;
          }

          const currentUserId = user.uid;
          const db = firebase.firestore();

          const fullName = document.getElementById("fullName").value.trim();
          const email = document.getElementById("em_email").value.trim();
          const mobile = iti.getNumber();

          // Validate phone number
          if (!mobile || !iti.isValidNumber()) {
              Swal.fire("Invalid Phone Number", "Please enter a valid phone number.", "error");
              return false;
          }

          Swal.fire({
              title: "Please wait...",
              text: "Saving emergency contact...",
              allowOutsideClick: false,
              allowEscapeKey: false,
              didOpen: () => {
                  Swal.showLoading();
              },
          });

          // Check for existing contact
          const contactSnap = await db
              .collection("Users")
              .doc(currentUserId)
              .collection("EmergencyContacts")
              .limit(1)
              .get();

          let existingContactId = null;
          if (!contactSnap.empty) {
              existingContactId = contactSnap.docs[0].id;
          }

          // Check if number belongs to another user
          const matchedUsers = await db.collection("Users").where("userPhone", "==", mobile).get();
          let matchedUserId = null;
          
          if (!matchedUsers.empty) {
              matchedUserId = matchedUsers.docs[0].id;
              await db.collection("Users").doc(currentUserId).update({
                  designatedEmgContact: matchedUserId,
              });
              await db.collection("Users").doc(matchedUserId).set({
                  userFriends: { [currentUserId]: "added" },
              }, { merge: true });
          }

          const emergencyData = {
              name: fullName,
              email: email,
              phone: mobile,
              referralcode: "Q8UL9D",
              userId: currentUserId,
          };

          if (existingContactId) {
              await db.collection("Users").doc(currentUserId)
                  .collection("EmergencyContacts").doc(existingContactId)
                  .update(emergencyData);
          } else {
              await db.collection("Users").doc(currentUserId)
                  .collection("EmergencyContacts").add(emergencyData);
          }

          Swal.fire("Success", "Emergency contact saved successfully.", "success");
          return true;
      } catch (error) {
          console.error("Emergency contact error:", error);
          Swal.fire("Error", error.message, "error");
          return false;
      }
  }

  function saveAttorneyStep() {
      // Attorney step is optional, so always return true
      console.log("Saving attorney selection (optional step)");
      return true;
  }

  $(document).ready(function () {
    $('#areas').select2({
      placeholder: "Select practice areas",
      width: '100%',
      closeOnSelect: false
    });
  });

  async function saveLawFirmStep() {
    const db = firebase.firestore();
    const storage = firebase.storage();

    try {
      // Show initial loading
      Swal.fire({
        title: "Please wait...",
        text: "Submitting...",
        allowOutsideClick: false,
        allowEscapeKey: false,
        didOpen: () => {
          Swal.showLoading();
        },
      });

      // Check if user is logged in
      const user = firebase.auth().currentUser;
      if (!user) {
        Swal.fire("Error", "You must be logged in.", "error");
        return false;
      }

      // Get Calendly token (optional)
      const calendlyToken = document.getElementById('clandlyToken').value.trim();
      
      // Calendly sync only if token exists
      if (calendlyToken) {
        try {
          Swal.fire({
            title: "Syncing...",
            text: "Connecting to Calendly...",
            allowOutsideClick: false,
            allowEscapeKey: false,
            didOpen: () => {
              Swal.showLoading();
            },
          });

          // Validate token by fetching user URI
          const calendlyUserUri = await fetchCalendlyUserURI(calendlyToken);
          
          // Fetch event types
          const eventTypes = await fetchCalendlyEventTypes(calendlyToken, calendlyUserUri);
          
          if (!eventTypes || eventTypes.length === 0) {
            throw new Error("No event types found in your Calendly account");
          }

          // Prepare modal options
          const eventOptions = {};
          eventTypes.forEach(event => {
            eventOptions[event.uri] = `${event.name} (${event.duration} mins)`;
          });

          Swal.close();

          // Show event selection modal
          const { value: selectedEventUri, isDismissed } = await Swal.fire({
            title: "Select Consultation Type",
            input: "select",
            inputOptions: eventOptions,
            inputPlaceholder: "Select an event",
            showCancelButton: true,
            confirmButtonText: "Save Selection",
            cancelButtonText: "Cancel",
            inputValidator: value => !value ? "Please select an event" : null
          });

          if (isDismissed || !selectedEventUri) {
            return false;
          }

          // Store Calendly data in hidden fields
          document.getElementById('clandlyToken').setAttribute('data-uri', calendlyUserUri);
          document.getElementById('clandlyToken').setAttribute('data-event', selectedEventUri);

          Swal.fire({
            icon: "success",
            title: "Calendly Synced",
            text: "Event type selected successfully!",
            timer: 1500,
            showConfirmButton: false
          });

        } catch (error) {
          console.error("Calendly sync error:", error);
          Swal.fire({
            icon: "error",
            title: "Calendly Sync Failed",
            text: error.message || "Invalid Calendly token. Continue without Calendly?",
            showCancelButton: true,
            confirmButtonText: "Continue Anyway",
            cancelButtonText: "Cancel"
          }).then((result) => {
            if (!result.isConfirmed) {
              throw new Error("User cancelled after Calendly sync failure");
            }
          });
        }
      }

      // Show processing
      Swal.fire({
        title: "Processing...",
        text: "Saving law firm information...",
        allowOutsideClick: false,
        allowEscapeKey: false,
        didOpen: () => {
          Swal.showLoading();
        },
      });

      // Get address and validate coordinates
      const addressfi = document.getElementById("addressfirm").value.trim();

      if (!userlat || !userlon) {
        Swal.fire("Invalid Address", "Please provide a valid address with coordinates.", "error");
        return false;
      }

      console.log("User latitude:", userlat, "User longitude:", userlon);

      // File upload helper function
      const storageRef = storage.ref();
      const uploadFile = async (inputId, folder) => {
        const fileInput = document.getElementById(inputId);
        if (fileInput && fileInput.files.length > 0) {
          const file = fileInput.files[0];
          const fileRef = storageRef.child(`lawfirm_uploads/${folder}/${Date.now()}_${file.name}`);
          await fileRef.put(file);
          return await fileRef.getDownloadURL();
        }
        return null;
      };

      // Get selected practice areas
      const selectedPracticeAreas = Array.from(
        document.getElementById("areas").selectedOptions
      ).map(option => option.value);

      // Prepare law firm data
      const lawFirmData = {
        bioPractice: document.getElementById("practice").value.trim(),
        practiceAreas: selectedPracticeAreas,
        phone: document.getElementById("firm_mobile").value.trim(),
        address: addressfi,
        email: document.getElementById("firm_email").value.trim(),
        website: document.getElementById("website").value.trim(),
        county: $("#counties").val(),
        userlat,
        userlon,
        userId: user.uid,
        updatedAt: Date.now(),
      };

      // Add Calendly info if it was synced
      if (calendlyToken) {
        const calendlyUserUri = document.getElementById('clandlyToken').getAttribute('data-uri');
        const calendlyEventUri = document.getElementById('clandlyToken').getAttribute('data-event');
        
        if (calendlyUserUri && calendlyEventUri) {
          lawFirmData.clandlyToken = calendlyToken;
          lawFirmData.uri = calendlyUserUri;
          lawFirmData.scheduleEvent = calendlyEventUri;
        }
      }

      // Upload files
      const photoUrl = await uploadFile("photoUpload", "photos");
      const videoUrl = await uploadFile("videoUpload", "videos");
      const docUrl = await uploadFile("document", "documents");

      if (photoUrl) lawFirmData.imageUrl = photoUrl;
      if (videoUrl) lawFirmData.videoUrl = videoUrl;
      if (docUrl) lawFirmData.docUrl = docUrl;

      let lawFirmRef;

      // Update or create law firm record
      if (existingLawFirmId) {
        await db.collection("LawFirm").doc(existingLawFirmId).set(lawFirmData, { merge: true });
        lawFirmRef = { id: existingLawFirmId };
      } else {
        lawFirmData.createdDate = Date.now();
        await db.collection("LawFirm").doc(user.uid).set(lawFirmData);
        await db.collection("Users").doc(user.uid).update({ LawFirmId: user.uid });
        lawFirmRef = { id: user.uid };
      }

      // DocuSign integration if document uploaded
      if (docUrl) {
        try {
          // Get DocuSign access token
          const tokenResponse = await fetch(
            // "https://duepro.com/duepro_docusign_apis/index.php/docusign/token",
            "https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/token",
            { headers: { Accept: "application/json" } }
          );

          if (!tokenResponse.ok) {
            throw new Error("Failed to get DocuSign token");
          }

          const tokenData = await tokenResponse.json();

          if (!tokenData.success) {
            console.warn("Token API responded without success:", tokenData);
            throw new Error("DocuSign token generation failed");
          }

          const accessToken = tokenData.access_token;
          const file = document.getElementById("documentUpload").files[0];
          
          if (!file) {
            throw new Error("No document selected");
          }

          // Convert file to base64
          const fileBase64 = await new Promise((resolve, reject) => {
            const reader = new FileReader();
            reader.onload = () => {
              const base64String = reader.result.split(",")[1];
              resolve(base64String);
            };
            reader.onerror = reject;
            reader.readAsDataURL(file);
          });

          // Prepare form data for DocuSign
          const formData = new FormData();
          formData.append("attorneyId", user.uid);
          formData.append("document", fileBase64);
          formData.append("returnUrl", window.location.href);
          formData.append("otherData", JSON.stringify(lawFirmData));

          // Create draft template in DocuSign
          const draftResponse = await fetch(
            // "https://duepro.com/duepro_docusign_apis/index.php/docusign/create-draft-template",
            "https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/create-draft-template",
            {
              method: "POST",
              headers: {
                Authorization: `Bearer ${accessToken}`,
              },
              body: formData,
            }
          );

          if (!draftResponse.ok) {
            throw new Error("Failed to create DocuSign draft template");
          }

          const draftData = await draftResponse.json();

          // Save template ID to Firestore
          await db.collection("LawFirm").doc(lawFirmRef.id).update({
            templateId: draftData.data.templateId,
          });

          const senderViewUrl = draftData.data.senderViewUrl;
          if (senderViewUrl) {
            // Optionally redirect to DocuSign
            // window.location.href = senderViewUrl;
          } else {
            console.warn("senderViewUrl not returned by DocuSign API");
          }

        } catch (docusignError) {
          console.error("DocuSign API error:", docusignError);
          // Don't fail the entire process if DocuSign fails
          Swal.fire({
            icon: "warning",
            title: "DocuSign Integration Issue",
            text: "Law firm saved, but document signing setup encountered an error.",
            timer: 2000,
            showConfirmButton: false
          });
        }
      }

      const successMessage = calendlyToken 
        ? "Law firm information saved successfully with Calendly integration!" 
        : "Law firm information saved successfully.";

      Swal.fire("Success", successMessage, "success");
      return true;

    } catch (error) {
      console.error("Error saving law firm:", error);
      Swal.fire("Error", error.message || "An unexpected error occurred.", "error");
      return false;
    }
  }
 
 

  // intlTelInput for phone with flags
  const phoneInput = document.getElementById("phone");
  const iti9 = window.intlTelInput(phoneInput, {
    separateDialCode: true,
    preferredCountries: ["us", "pk"],
    initialCountry: "auto",
    geoIpLookup: callback => {
      fetch("https://ipinfo.io/json?token=<your_token>")
        .then(res => res.json())
        .then(data => callback(data.country || "us"))
        .catch(() => callback("us"));
    }
  });

  // Autocomplete for address
  function initAutocomplete9() {
    const input = document.getElementById("streetAddress");
    const autocomplete = new google.maps.places.Autocomplete(input);
    autocomplete.setFields(["geometry"]);

    autocomplete.addListener("place_changed", function () {
      const place = autocomplete.getPlace();
      if (place.geometry) {
        document.getElementById("userlat").value = place.geometry.location.lat();
        document.getElementById("userlon").value = place.geometry.location.lng();
      }
    });
  };
  

  async function saveBankStep() {
    const db = firebase.firestore();
    const storage = firebase.storage();

    try {
      const user = firebase.auth().currentUser;

      // If user not found directly, wait for auth state
      const currentUser = user || await new Promise((resolve, reject) => {
        const unsub = firebase.auth().onAuthStateChanged(u => {
          unsub();
          u ? resolve(u) : reject(new Error("Not logged in"));
        });
      });

      Swal.fire({
        title: "Please wait...",
        text: "Saving payout...",
        allowOutsideClick: false,
        allowEscapeKey: false,
        didOpen: () => Swal.showLoading(),
      });

      const userDoc = await db.collection("Users").doc(currentUser.uid).get();
      if (!userDoc.exists) throw new Error("User data not found in Firestore");

      const userData = userDoc.data();
      const [firstName, ...lastNameParts] = (userData.Name || "").split(" ");
      const lastName = lastNameParts.join(" ") || "";

      const accountNo = document.querySelector("#accountNo").value.trim();
      const routeNo = document.querySelector("#routeNo").value.trim();
      const ssn = document.querySelector("#ssn").value.trim();
      const dob = new Date(document.querySelector("#dobBank").value);
      const streetAddress = document.querySelector("#streetAddress").value.trim();
      const city = document.querySelector("#city").value.trim();
      const state = document.querySelector("#state").value.trim();
      const zipcode = document.querySelector("#zipcode").value.trim();
      const country = document.querySelector("#country").value.trim();

      const phone =
        (window.iti && window.iti.getNumber()) ||
        document.querySelector("#phone")?.value.trim() ||
        userData.userPhone ||
        "";

      const lat = parseFloat(document.getElementById("userlat")?.value || userData.userlat || 0);
      const lng = parseFloat(document.getElementById("userlon")?.value || userData.userlon || 0);
      const fullAddress = `${streetAddress}, ${city}, ${state}, ${zipcode}, ${country}`;
      const dobInput = document.querySelector("#dobBank").value;
      const [year, month, day] = dobInput.split("-").map(Number);
      const payload = {
        firstName: firstName || "N/A",
        lastName: lastName || "N/A",
        accountId: userData.stripeaccount_id || "",
        email: userData.email || currentUser.email,
        phone,
      //   dob: {
      //     day: dob.getUTCDate(),
      //     month: dob.getUTCMonth() + 1,
      //     year: dob.getUTCFullYear(),
      //   },
      dob: { day, month, year },
        ssnLast4: ssn.slice(-4),
        fullSSN: ssn,
        address: { line1: streetAddress, city, state, postalCode: zipcode, country },
        bankAccount: { accountNumber: accountNo, routingNumber: routeNo, country, currency: "usd" },
        tosAcceptanceIP: "203.0.113.42",
        industry: "5732",
      };

      const bankData = {
        id: currentUser.uid,
        accountNo,
        address: fullAddress,
        city,
        country,
        dob: dob.getTime(),
        lat,
        lng,
        routeNo,
        ssn,
        state,
        streetAddress,
        zipcode,
      };
      console.log("DOB payload to Stripe:", payload.dob);
      // --- Call API ---
      // production link
      // https://us-central1-duepro-2cf60.cloudfunctions.net/widgetsforusa/updatestripeaccount2
      const response = await fetch(
        "https://us-central1-freeme-6e63a.cloudfunctions.net/widgetsforusa/updatestripeaccount2",
        {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify(payload),
        }
      );

      if (!response.ok) {
        const errorText = await response.text();
        throw new Error(`API Error: ${errorText || response.statusText}`);
      }

      const apiResult = await response.json();
      if (apiResult.error || apiResult.success === false) {
        throw new Error(apiResult.error || "Stripe account update failed.");
      }

      // --- Save to Firestore only after success ---
      await db.collection("BankAccounts").add(bankData);

      Swal.fire("Success", "Payout method saved successfully.", "success");

      return true; // ✅ Returns true only after success
    } catch (err) {
      console.error("Error saving payout:", err);
      Swal.fire("Error", err.message || "Something went wrong. Please try again.", "error");
      return false; // ❌ Return false if failed
    }
  }

  // Function to handle step-specific saving - FIXED: Made it async
  async function saveCurrentStep() {
      const currentStepNumber = parseInt(visibleSteps[current].getAttribute('data-step'));
        console.log("current step number",currentStepNumber)
      switch(currentStepNumber) {
    
          case 2: // Profile step
              return await saveProfileStep();
          case 3: // Emergency contact step
              return await saveEmergencyContactStep();
          case 4: // Attorney step (optional)
              return saveAttorneyStep();
          case 5: // Law firm step
              return await saveLawFirmStep();
        case 6: // Law firm step
              return await saveBankStep();
          default:
              return true; // No save needed for other steps
      }
  }

  // ------------------- Navigation -------------------
  nextBtn.addEventListener("click", async () => {
      // Validate current step
      if (!validateCurrentStep()) {
          Swal.fire("Validation Error", "Please fill in all required fields before proceeding.", "warning");
          return;
      }

      // Save current step data - FIXED: Added await
      const saveSuccess = await saveCurrentStep();
      console.log("saveSuccess",saveSuccess)
      if (!saveSuccess) {
          // Error message is already shown in the save functions
            console.log("if not save saveSuccess",saveSuccess)
          return;
      }

      // Navigate to next step or submit
      if (current < visibleSteps.length - 1) {
          current++;
          
          updateForm();
            console.log("in update fo,r",saveSuccess)
      } else {
          // Final submit
          console.log("in else animatio",saveSuccess)
          showSuccessAnimation();
      }
  });

  prevBtn.addEventListener("click", () => {
      if (current > 0) {
          current--;
          updateForm();
      }
  });

  // Initialize
  buildStepper();
  updateForm();
  setupSuccessClose();

  // Initialize form validation on page load
  document.addEventListener('DOMContentLoaded', function() {
    // Add form submit handlers to prevent default submission
    document.getElementById('profileForm')?.addEventListener('submit', function(e) {
      e.preventDefault();
      if (saveProfileStep()) {
      
      }
    });
    
    document.getElementById('emerform')?.addEventListener('submit', function(e) {
      e.preventDefault();
      if (saveEmergencyContactStep()) {
    
      }
    });
    
    document.getElementById('firmform')?.addEventListener('submit', function(e) {
      e.preventDefault();
      if (saveLawFirmStep()) {
        alert('Law firm details saved successfully!');
      }
    });
  });

  // Initialize
  buildStepper();
  updateForm();




  const auth3 = firebase.auth();
  const db3 = firebase.firestore();

  const cardsContainer = document.getElementById("attorneyCards");
  const searchInput = document.getElementById("searchInput");

  let designatedId = null;
  let allFirms = []; // 🔹 full list fetched from Firestore
  let filteredFirms = []; // 🔹 list after search filter
  let renderIndex = 0; // 🔹 how many have been rendered so far
  const PAGE_SIZE = 5; // 🔹 show 5 cards at a time

  auth3.onAuthStateChanged(async (user) => {
    if (!user) {
      Swal.fire("Error", "User not authenticated.", "error");
      return;
    }

    // current user doc
    const currentUserRef = db3.collection("Users").doc(user.uid);
    const currentUserDoc = await currentUserRef.get();
    designatedId = currentUserDoc.data()?.designatedLawyerId || null;

    // fetch law firms
    const lawFirmsSnapshot = await db3.collection("LawFirm").get();

    allFirms = await Promise.all(
      lawFirmsSnapshot.docs.map(async (doc) => {
        const lawFirm = doc.data();
        const userId = lawFirm.userId;

        // get user doc to access Name
        const userDoc = await db3.collection("Users").doc(userId).get();
        const userData = userDoc.data() || {};

        return {
          id: doc.id,
          userId,
          Name: userData.Name || "",
          email: lawFirm.email || "",
          phone: lawFirm.phone || "",
          address: lawFirm.address || "",
          imageUrl: lawFirm.imageUrl || "",
        };
      })
    );

    // start with everything
    filteredFirms = allFirms;
    renderIndex = 0;
    cardsContainer.innerHTML = "";
    renderNextBatch();
  });


  // 🔎 Live search
  searchInput.addEventListener("input", () => {
    const q = searchInput.value.toLowerCase().trim();

    // 🔑 if query empty → show all again
    if (!q || q == "") {
      filteredFirms = allFirms;
    } else {
      filteredFirms = allFirms.filter(
        (firm) =>
          firm.Name.toLowerCase().includes(q) ||
          firm.email.toLowerCase().includes(q)
      );
    }

    // reset list and render from start
    renderIndex = 0;
    cardsContainer.innerHTML = "";
    renderNextBatch();
  });

  // 👇 Load next 5 when near bottom
  // 👇 Load next 5 when the cards container is scrolled near its bottom
  cardsContainer.addEventListener("scroll", () => {
    const nearBottom =
      cardsContainer.scrollTop + cardsContainer.clientHeight >=
      cardsContainer.scrollHeight - 20; // 20px threshold

    if (nearBottom) renderNextBatch();
  });

  function renderNextBatch() {
    const slice = filteredFirms.slice(renderIndex, renderIndex + PAGE_SIZE);
    slice.forEach((firm) => appendCard(firm));
    renderIndex += slice.length;
  }

  function appendCard(firm) {
    const isSelected = firm.userId === designatedId;
    const card = document.createElement("div");
    card.className = "col-md-12";
    card.innerHTML = `
    <div class="card quote-card ${
      isSelected ? "border-primary" : ""
    }" data-userid="${firm.userId}">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-start">
          <div class="d-flex gap-2 align-items-center">
            <img class="img-q" src="${
              firm.imageUrl || "<?php echo base_url(); ?>/assets/images/th.jpeg"
            }" alt="">
            <div>
              <p class="fo-1 mb-0">${firm.Name}</p>
              <p class="fo-2 mb-0">${firm.email}</p>
            </div>
          </div>
          ${
            isSelected
              ? '<img src="<?php echo base_url(); ?>/assets/images/Fav.png" width="25px" title="Your attorney" />'
              : ""
          }
        </div>
        <div class="row g-2 mt-2">
          <div class="col-md-6">
            <div class="d-flex gap-2 align-items-center">
              <img src="../assets/images/ph.png" width="30px">
              <p class="fo-3 mb-0">${firm.phone || "N/A"}</p>
            </div>
          </div>
          <div class="col-md-6 d-flex justify-content-end">
            <div class="d-flex gap-2 align-items-center">
              <img src="../assets/images/locn.png" width="30px">
              <p class="fo-3 mb-0">${firm.address || "N/A"}</p>
            </div>
          </div>
        </div>
      </div>
    </div>`;

    card
      .querySelector(".quote-card")
      .addEventListener("click", () => handleCardClick(firm.userId));

    cardsContainer.appendChild(card);
  }

  async function handleCardClick(clickedId) {
    const user = firebase.auth().currentUser;
    const userRef = db3.collection("Users").doc(user.uid);

    if (clickedId === designatedId) {
      const confirmRemove = await Swal.fire({
        title: "Remove Attorney",
        text: "Are you sure you want to remove this attorney contact?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Yes, remove it",
      });

      if (confirmRemove.isConfirmed) {
        await userRef.update({
          designatedLawyerId: firebase.firestore.FieldValue.delete(),
        });
        designatedId = null;
        Swal.fire("Removed", "Attorney designation removed.", "success");
        //   location.reload();
        // fetch law firms
        const lawFirmsSnapshot = await db3.collection("LawFirm").get();

        allFirms = await Promise.all(
          lawFirmsSnapshot.docs.map(async (doc) => {
            const lawFirm = doc.data();
            const userId = lawFirm.userId;

            // get user doc to access Name
            const userDoc = await db3.collection("Users").doc(userId).get();
            const userData = userDoc.data() || {};

            return {
              id: doc.id,
              userId,
              Name: userData.Name || "",
              email: lawFirm.email || "",
              phone: lawFirm.phone || "",
              address: lawFirm.address || "",
              imageUrl: lawFirm.imageUrl || "",
            };
          })
        );

        // start with everything
        filteredFirms = allFirms;
        renderIndex = 0;
        cardsContainer.innerHTML = "";
        renderNextBatch();
      }
    } else {
      const confirmAssign = await Swal.fire({
        title: "Designate Attorney",
        text: "Are you sure you want to designate this attorney contact?",
        icon: "question",
        showCancelButton: true,
        confirmButtonText: "Yes, assign",
      });

      if (confirmAssign.isConfirmed) {
        await userRef.update({ designatedLawyerId: clickedId });
        designatedId = clickedId;
        Swal.fire("Assigned", "Attorney designated successfully.", "success");
        //   location.reload();
        // fetch law firms
        const lawFirmsSnapshot = await db3.collection("LawFirm").get();

        allFirms = await Promise.all(
          lawFirmsSnapshot.docs.map(async (doc) => {
            const lawFirm = doc.data();
            const userId = lawFirm.userId;

            // get user doc to access Name
            const userDoc = await db3.collection("Users").doc(userId).get();
            const userData = userDoc.data() || {};

            return {
              id: doc.id,
              userId,
              Name: userData.Name || "",
              email: lawFirm.email || "",
              phone: lawFirm.phone || "",
              address: lawFirm.address || "",
              imageUrl: lawFirm.imageUrl || "",
            };
          })
        );

        // start with everything
        filteredFirms = allFirms;
        renderIndex = 0;
        cardsContainer.innerHTML = "";
        renderNextBatch();
      }
    }
  }

  // script for adding firm

  const videoUpload = document.getElementById("videoUpload");
  const photoUpload = document.getElementById("photoUpload");
  const documentUpload = document.getElementById("documentUpload");
  const addressInput = document.getElementById("address");

  videoUpload.addEventListener("change", function () {
    const file = this.files[0];
    const preview = document.getElementById("videoPreview");

    if (file) {
      const url = URL.createObjectURL(file);

      preview.innerHTML = `
      
        <p style="margin-top: 10px;">
          <a href="${url}" target="_blank" style="color: #007bff; text-decoration: none;">
            ${file.name}
          </a>
        </p>
      `;
    } else {
      preview.innerHTML = "";
    }
  });

  photoUpload.addEventListener("change", function () {
    const file = this.files[0];
    const preview = document.getElementById("photoPreview");
    if (file) {
      const url = URL.createObjectURL(file);
      preview.innerHTML = `<img src="${url}" alt="Image Preview" class="img-fluid rounded border" style="max-height: 200px;" />`;
    } else {
      preview.innerHTML = "";
    }
  });

  documentUpload.addEventListener("click", async function (e) {
    e.preventDefault();

    const address = addressInput.value.trim();
    if (!address) {
      Swal.fire({
        title: "Error",
        text: "Address field is required before uploading supporting document.",
        icon: "warning",
        confirmButtonText: "OK"
      });
      return;
    }

    try {
      const user = firebase.auth().currentUser;
      if (!user) throw new Error("User not logged in.");

      const uid = user.uid;
      const lawRef = db.collection("LawFirm").doc(uid);
      let lawDoc = await lawRef.get();
      let lawData = {};

      if (!lawDoc.exists) {
        // Create law firm document if it doesn't exist
        lawData = {
          address: address,
          userId: uid,
          createdDate: Date.now(),
          templateId: null,
          myCaseLawId: null
        };
        await lawRef.set(lawData);
      } else {
        lawData = lawDoc.data();
        // Update address if changed
        if (lawData.address !== address) {
          await lawRef.update({ address });
        }
      }

      // // Fetch templateId and myCaseLawId
       let documentTemplateId = lawData.templateId || "";
      // console.log(documentTemplateId,"documentTemplateId in fresh doc");
      
      
      const myCaseLawId = lawData.myCaseLawId || "null";

      // Open fresh-document API
      const apiUrl = `https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/fresh-document?doc_id=${uid}&template_id=${documentTemplateId}&myCaseLawId=${myCaseLawId}`;
      // const apiUrl = `https://duepro.com/duepro_docusign_apis/index.php/docusign/fresh-document?doc_id=${uid}&template_id=${documentTemplateId}&myCaseLawId=${myCaseLawId}`;
    window.open(apiUrl, "_blank");

    // Preview the file if already selected
    const file = documentUpload.files[0];
    if (file) {
      documentPreview.innerHTML = `<p>📄 ${file.name}</p>`;
      }

    } catch (err) {
      console.error("Error preparing fresh document:", err);
    Swal.fire("Error", err.message, "error");
    }
  });

</script>

<script>
  console.log("in law firm script")
  const storage2 = firebase.storage();
  const db4 = firebase.firestore();
  let existingLawFirmId = null;
  let autocomplete3;
  let userlat = null;
  let userlon = null;

  function initAutocomplete7() {
    const input = document.getElementById("addressfirm");
    autocomplete3 = new google.maps.places.Autocomplete(input);
    autocomplete3.setFields([
      "geometry",
      "address_components",
      "formatted_address",
    ]);

    autocomplete3.addListener("place_changed", function () {
      const place = autocomplete3.getPlace();
      if (!place.geometry) {
        Swal.fire(
          "Invalid Address",
          "No details found for selected address.",
          "warning"
        );
        return;
      }
      userlat = place.geometry.location.lat();
      userlon = place.geometry.location.lng();
      document.getElementById("firm_userlat").value = userlat;
      document.getElementById("firm_userlon").value = userlon;
    });
  }

  // function initAutocomplete7() {
  //   const input = document.getElementById("addressfirm");
  //   autocomplete3 = new google.maps.places.Autocomplete(input);
  //   autocomplete3.setFields([
  //     "geometry",
  //     "address_components",
  //     "formatted_address",
  //   ]);

  //   autocomplete3.addListener("place_changed", function () {
  //     const place = autocomplete3.getPlace();
  //     if (!place.geometry) {
  //       Swal.fire(
  //         "Invalid Address",
  //         "No details found for selected address.",
  //         "warning"
  //       );
  //       return;
  //     }
  //     userlat = place.geometry.location.lat();
  //     userlon = place.geometry.location.lng();
  //     document.getElementById("firm_userlat").value = userlat;
  //     document.getElementById("firm_userlon").value = userlon;
  //   });
  // }

  // window.onload = initAutocomplete7;
  window.addEventListener('load', initAutocomplete7);

  firebase.auth().onAuthStateChanged(async (user) => {
      console.log("in fire base auth")
    if (!user) {
      Swal.fire("Error", "You must be logged in.", "error");
      return;
    }

    const userDoc = await db4.collection("Users").doc(user.uid).get();
    const userData = userDoc.data();
    console.log("user data ss",userData)
    if (userData?.LawFirmId) {
      existingLawFirmId = userData.LawFirmId;
      const lawFirmDoc = await db4
        .collection("LawFirm")
        .doc(existingLawFirmId)
        .get();
      console.log("law firm data",lawFirmDoc.data)

      if (lawFirmDoc.exists) {
        const law = lawFirmDoc.data();

        if (Array.isArray(law.practiceAreas)) {
          $('#areas')
            .val(law.practiceAreas)
            .trigger('change'); // 🔥 REQUIRED
        }

        // Populate form fields
        document.getElementById("practice").value = law.bioPractice || "";
        document.getElementById("areas").value = law.practiceAreas || "";
        document.getElementById("firm_mobile").value = law.phone || "";
        document.getElementById("addressfirm").value = law.address || "";
        document.getElementById("firm_email").value = law.email || "";
        document.getElementById("website").value = law.website || "";
        $("#counties")
          .val(law.county || [])
          .trigger("change");

        if (law.userlat && law.userlon) {
          document.getElementById("userlat").value = law.userlat;
          document.getElementById("userlon").value = law.userlon;
          userlat = law.userlat;
          userlon = law.userlon;
        }

        // ✅ Show existing uploaded files if available
        if (law.imageUrl) {
          document.getElementById(
            "photoPreview"
          ).innerHTML = `<img src="${law.imageUrl}" alt="Uploaded Photo" class="img-fluid rounded border" style="max-height: 200px;" />`;
        }

              if (law.videoUrl) {
        document.getElementById("videoPreview").innerHTML =
          ` <p style="margin-top: 10px;">
      <a href="${law.videoUrl}" target="_blank" class="btn btn-sm btn-outline-primary">
       View Video
      </a>`;
      }

        // if (law.docUrl) {
        //   const fileName = law.docUrl.split("/").pop().split("?")[0]; // extract file name
        //   document.getElementById(
        //     "documentPreview"
        //   ).innerHTML = `<a href="${law.docUrl}" target="_blank" class="btn btn-sm btn-outline-primary">
        //     📄 View Uploaded Document
        //   </a>`;
        // }
      }
    }
  });

  
  document.querySelector("#firmform").addEventListener("submit", async (e) => {
    e.preventDefault();
    Swal.fire({
      title: "Please wait...",
      text: "Submiting",
      allowOutsideClick: false,
      allowEscapeKey: false,
      didOpen: () => {
        Swal.showLoading();
      },
    });
    try {
      const user = firebase.auth().currentUser;
      if (!user) {
        Swal.fire("Error", "You must be logged in.", "error");
        return;
      }

      const form = e.target;
      console.log("form", form);
      const address = form.addressfirm.value.trim();
      const clandlyAccessToken = form.clandlyToken.value.trim();

        let existingCalendlyToken = null;
        let existingScheduleEvent = null;

        if (existingLawFirmId) {
          const lawFirmSnap = await db
            .collection("LawFirm")
            .doc(existingLawFirmId)
            .get();

          if (lawFirmSnap.exists) {
            const lawFirmData = lawFirmSnap.data();
            existingCalendlyToken = lawFirmData.clandlyToken || null;
            existingScheduleEvent = lawFirmData.clandlyToken || null;
          }
        }  


      // Fallback geocoding if lat/lon not filled from autocomplete
      if (!userlat || !userlon) {
        try {
          const location = await new Promise((resolve, reject) => {
            const geocoder = new google.maps.Geocoder();
            geocoder.geocode({ address }, (results, status) => {
              if (status === "OK" && results[0]) {
                const loc = results[0].geometry.location;
                resolve({ lat: loc.lat(), lng: loc.lng() });
              } else reject("Geocoding failed: " + status);
            });
          });
          userlat = location.lat;
          userlon = location.lng;
        } catch (geoError) {
          Swal.fire(
            "Invalid Address",
          
            "error"
          );
          return;
        }
      }

      const storageRef = storage2.ref();
      const uploadFile = async (inputId, folder) => {
        const fileInput = document.getElementById(inputId);
        if (fileInput.files.length > 0) {
          const file = fileInput.files[0];
          const fileRef = storageRef.child(
            `lawfirm_uploads/${folder}/${Date.now()}_${file.name}`
          );
          await fileRef.put(file);
          return await fileRef.getDownloadURL();
        }
        return null;
      };

      const lawFirmData = {
        bioPractice: form.practice.value.trim(),
        practiceAreas: form.areas.value,
        phone: form.mobile.value.trim(),
        address: address,
        email: form.email.value.trim(),
        website: form.website.value.trim(),
        county: $("#counties").val(),
        userlat,
        userlon,
        userId: user.uid,
        updatedAt: Date.now(),
      };

      
        const photoUrl = await uploadFile("photoUpload", "photos");
        const videoUrl = await uploadFile("videoUpload", "videos");
        const docUrl = await uploadFile("document", "documents");

        if (photoUrl) lawFirmData.imageUrl = photoUrl;
        if (videoUrl) lawFirmData.videoUrl = videoUrl;
        if (docUrl) lawFirmData.docUrl = docUrl;

        let lawFirmRef;

        if (existingLawFirmId) {
          await db4
            .collection("LawFirm")
            .doc(existingLawFirmId)
            .update(lawFirmData);
          lawFirmRef = { id: existingLawFirmId };
        } else {
          lawFirmData.createdDate = Date.now();
          lawFirmRef = await db4.collection("LawFirm").add(lawFirmData);
          await db4
            .collection("Users")
            .doc(user.uid)
            .update({ LawFirmId: lawFirmRef.id });
        }
        // 2️⃣ Compare tokens & check scheduleEvent
        const isCalendlyTokenChanged = clandlyAccessToken &&
          clandlyAccessToken !== existingCalendlyToken;

        const isScheduleEventMissing = !existingScheduleEvent || existingScheduleEvent === "";

        if (clandlyAccessToken && (isCalendlyTokenChanged || isScheduleEventMissing)) {
          try {
            const calendlyUserUri = await fetchCalendlyUserURI(clandlyAccessToken);

            // 4️⃣ Store URI & token in Firestore
            await db.collection("LawFirm").doc(lawFirmRef.id).update({
              uri: calendlyUserUri,
              clandlyToken: clandlyAccessToken
            });

            // 5️⃣ Fetch event types
            const eventTypes = await fetchCalendlyEventTypes(
              clandlyAccessToken,
              calendlyUserUri
            );

            // 6️⃣ Prepare modal options
            const eventOptions = {};
            eventTypes.forEach(event => {
              eventOptions[event.uri] = `${event.name} (${event.duration} mins)`;
            });

            // 7️⃣ Show modal for event selection
            const { value: selectedEventUri } = await Swal.fire({
              title: "Select Consultation Type",
              input: "select",
              inputOptions: eventOptions,
              inputPlaceholder: "Select an event",
              showCancelButton: true,
              confirmButtonText: "Save",
              inputValidator: value =>
                !value ? "Please select an event" : null
            });

            // 8️⃣ Save selected event URI if user selected
            if (selectedEventUri) {
              await db.collection("LawFirm").doc(lawFirmRef.id).update({
                scheduleEvent: selectedEventUri,
              });
            }

          } catch (err) {
            console.error("❌ Calendly API Error:", err);
            Swal.close();
            Swal.fire("Calendly Error", "Invalid Calendly token", "error");
            return;
          }
        }

        Swal.fire(
          "Success",
          "Law firm information saved successfully.",
          "success"
        );

        // form.reset();
        // $('#counties').val(null).trigger('change');
        // userlat = null;
        // userlon = null;
      } catch (error) {
      console.error("Error saving law firm:", error);
      Swal.fire("Error", error.message, "error");
    }
  });

  // end script for addingfirm

</script>

<!-- script for adding profile -->
<script>
  const input = document.querySelector("#number");
  window.intlTelInput(input, {
    initialCountry: "auto", // Auto-detect country
    geoIpLookup: function (callback) {
      fetch("https://ipapi.co/json")
        .then((res) => res.json())
        .then((data) => callback(data.country_code))
        .catch(() => callback("us"));
    },
    utilsScript:
      "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js",
  });
</script>
<!-- Emergency User -->
<script>
  const db = firebase.firestore();
  const storage = firebase.storage();
  firebase.auth().onAuthStateChanged(async (user) => {
    if (user) {
      const uid = user.uid;

      try {
        const doc = await db.collection("Users").doc(uid).get();
        const data = doc.data();

        const defaultImage = "<?= base_url('assets/images/th.jpeg') ?>";
        const imageUrl = data.imageUrl || defaultImage;

        document.getElementById("userImage").src = imageUrl;

        document.getElementById("name").value = data.Name || "";
        document.getElementById("dob").value = data.userDOB
          ? new Date(data.userDOB).toISOString().split("T")[0]
          : "";
        document.getElementById("address").value = data.address || "";
         document.getElementById("number").value = data.userPhone || "";

        if (data.userPhone) {
          iti.setNumber(data.userPhone); // ✅ set intl-tel input
        }

        document.getElementById("pincode").value = data.pinCode || "";

        // ✅ Set lat/lon if exists
        if (data.userlat) document.getElementById("userlat").value = data.userlat;
        if (data.userlon) document.getElementById("userlon").value = data.userlon;

       

      } catch (error) {
        console.error("Error fetching user data:", error);
        Swal.fire("Error", "Unable to load profile data.", "error");
      }
    } else {
      Swal.fire("Not Logged In", "Please login to view your profile.", "warning");
      window.location.href = "<?= base_url('/'); ?>";
    }
  });

  
  firebase.auth().onAuthStateChanged(async (user) => {
    if (!user) {
      Swal.fire("Unauthorized", "You must be logged in to save contacts.", "warning");
      return;
    }

    const currentUserId = user.uid;


    const fullNameInput = document.getElementById("fullName");
    const emailInput = document.getElementById("em_email");

    // Load existing contact once for pre-fill
    let existingContactId = null;
    const initialSnap = await db
      .collection("Users")
      .doc(currentUserId)
      .collection("EmergencyContacts")
      .limit(1)
      .get();

    if (!initialSnap.empty) {
      const contactData = initialSnap.docs[0].data();
      existingContactId = initialSnap.docs[0].id;

      fullNameInput.value = contactData.name || "";
      emailInput.value = contactData.email || "";

      if (contactData.phone) {
        iti.setNumber(contactData.phone); // ✅ Set phone with flag
      }
    }

  });
</script>


<script>
 
  async function fetchCalendlyUserURI(accessToken) {
    try {
      const response = await fetch("https://api.calendly.com/users/me", {
        method: "GET",
        headers: {
          "Authorization": `Bearer ${accessToken}`,
          "Content-Type": "application/json"
        }
      });

      if (!response.ok) {
        throw new Error(`Calendly API Error: ${response.status}`);
      }

      const data = await response.json();
      return data.resource.uri;
    } catch (error) {
      console.error("Error fetching Calendly user URI:", error);
      throw error;
    }
  }

  
  async function fetchCalendlyEventTypes(accessToken, userUri) {
    try {
      const response = await fetch(
        `https://api.calendly.com/event_types?user=${encodeURIComponent(userUri)}`,
        {
          method: "GET",
          headers: {
            "Authorization": `Bearer ${accessToken}`,
            "Content-Type": "application/json"
          }
        }
      );

      if (!response.ok) {
        throw new Error(`Calendly Event Types Error: ${response.status}`);
      }

      const data = await response.json();
      return data.collection || [];
    } catch (error) {
      console.error("Error fetching Calendly event types:", error);
      throw error;
    }
  }

  // ============================================
  // INITIALIZE SELECT2 FOR PRACTICE AREAS
  // ============================================
  $(document).ready(function () {
    $('#areas').select2({
      placeholder: "Select practice areas",
      width: '100%',
      closeOnSelect: false
    });
    
    $('#counties').select2({
      placeholder: "Select counties",
      allowClear: true
    });
  });

  // ============================================
  // SYNC MY CASE BUTTON HANDLER
  // ============================================
  //  let syncBtn = document.getElementById("syncBtn");
    // syncBtn.addEventListener("click", async () => {
  //   const state = syncBtn.dataset.state;
  //   // ----------------------------------------
  //   //               SYNC WITH MYCASE
  //   // ----------------------------------------
  //   if (state === "sync") {
  //     const url = `https://buzzwaretechserver.site/mycase_apis/mycase/connect?id=${existingLawFirmId}`;
  //     window.open(url, "_blank");
  //     return;
  //   }
  //   // ----------------------------------------
  //   //               UNSYNC MYCASE
  //   // ----------------------------------------
  //   if (state === "unsync") {
  //     Swal.fire({
  //       title: "Unsync MyCase",
  //       text: "Before you continue, please note that new cases will no longer be created or updated in MyCase once unsynced. You can reconnect anytime in Law Firm Info → Sync with MyCase.",
  //       icon: "warning",
  //       showCancelButton: true,
  //       confirmButtonText: "Unsync",
  //       cancelButtonText: "Cancel"
  //     }).then(async (result) => {
  //       if (!result.isConfirmed) return;
  //       Swal.fire({
  //         title: "Unsyncing...",
  //         didOpen: () => Swal.showLoading(),
  //         allowOutsideClick: false
  //       });
  //       try {
  //         // Remove link from LawFirm document
  //         await db.collection("LawFirm")
  //           .doc(existingLawFirmId)
  //           .update({ myCaseLawId: null });
  //         // Remove token document
  //         await db.collection("mycase_tokens")
  //           .doc(existingLawFirmId)
  //           .delete();
  //         Swal.fire("Success", "Disconnected from MyCase.", "success");
  //       } catch (err) {
  //         Swal.fire("Error", err.message, "error");
  //       }
  //     });
  //   }
  // });

  // function listenToMyCaseToken(lawFirmId) {
  //   return db.collection("mycase_tokens")
  //   .doc(lawFirmId)
  //   .onSnapshot((snap) => {
  //     // const syncBtn = document.getElementById("syncBtn");

  //     if (!snap.exists || !snap.data()?.access_token) {
  //       // NOT CONNECTED
  //       syncBtn.textContent = "Sync with MyCase";
  //       syncBtn.dataset.state = "sync";
  //       syncBtn.classList.remove("btn-secondary");
  //       syncBtn.classList.add("btn-save");
  //       return;
  //     }

  //     // CONNECTED
  //     syncBtn.textContent = "Unsync MyCase";
  //     syncBtn.dataset.state = "unsync";
  //     syncBtn.classList.remove("btn-save");
  //     syncBtn.classList.add("btn-secondary");
  //   });
  // }

  
  firebase.auth().onAuthStateChanged(async (user) => {
    let existingLawFirmId = null;
    const db4 = firebase.firestore();
    const storage2 = firebase.storage();
    if (!user) {
      return;
    }

    const userDoc = await db4.collection("Users").doc(user.uid).get();
    const userData = userDoc.data();
    
    if (userData?.LawFirmId) {
      existingLawFirmId = userData.LawFirmId;

      const lawFirmDoc = await db4
        .collection("LawFirm")
        .doc(existingLawFirmId)
        .get();

        if (existingLawFirmId) {
        listenToMyCaseToken(existingLawFirmId);
      }

      if (lawFirmDoc.exists) {
        const law = lawFirmDoc.data();

        // Populate practice areas (Select2)
        if (Array.isArray(law.practiceAreas)) {
          $('#areas').val(law.practiceAreas).trigger('change');
        }

        // Populate form fields
        document.getElementById("practice").value = law.bioPractice || "";
        document.getElementById("firm_mobile").value = law.phone || "";
        document.getElementById("addressfirm").value = law.address || "";
        document.getElementById("firm_email").value = law.email || "";
        document.getElementById("website").value = law.website || "";
        document.getElementById("clandlyToken").value = law.clandlyToken || "";
        
        // Populate counties (Select2)
        $("#counties").val(law.county || []).trigger("change");

        // Store lat/lon
        if (law.userlat && law.userlon) {
          userlat = law.userlat;
          userlon = law.userlon;
          document.getElementById("firm_userlat").value = law.userlat;
          document.getElementById("firm_userlon").value = law.userlon;
        }

        // Show existing files
        if (law.imageUrl) {
          document.getElementById("photoPreview").innerHTML = 
            `<img src="${law.imageUrl}" alt="Uploaded Photo" class="img-fluid rounded border" style="max-height: 200px;" />`;
        }

        if (law.videoUrl) {
          document.getElementById("videoPreview").innerHTML =
            `<p style="margin-top: 10px;">
              <a href="${law.videoUrl}" target="_blank" class="btn btn-sm btn-outline-primary">
                View Video
              </a>
            </p>`;
        }

        // if (law.docUrl) {
        //   document.getElementById("documentPreview").innerHTML = 
        //     `<a href="${law.docUrl}" target="_blank" class="btn btn-sm btn-outline-primary">
        //       📄 View Uploaded Document
        //     </a>`;
        // }

        // Store existing Calendly data for reference
        if (law.uri && law.scheduleEvent) {
          document.getElementById('clandlyToken').setAttribute('data-uri', law.uri);
          document.getElementById('clandlyToken').setAttribute('data-event', law.scheduleEvent);
        }
      }
    }
  });

  document.addEventListener("DOMContentLoaded", function () {
    const popoverTriggerList = [].slice.call(
      document.querySelectorAll('[data-bs-toggle="popover"]')
    );

    popoverTriggerList.forEach(function (popoverTriggerEl) {
      new bootstrap.Popover(popoverTriggerEl);
    });
  });
</script>

