<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Due Pro</title>
    <link
      rel="shortcut icon"
      type="image/x-icon"
      href="../assets/images/Fav.png"
    />
    <!-- bootstrap style link -->
    <link
      href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
      rel="stylesheet"
    />
    <!-- font-awesome cdn -->
    <link
      rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
    />
     <!-- Google Font -->
    <link
      href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap"
      rel="stylesheet"
    />

    <!-- custom css -->
  <link rel="stylesheet" href="<?= base_url('assets/css/style.css'); ?>" />

    <style>
      .main90vh {
        overflow: hidden;
        min-height: 82vh;
      }
      .nav-b{
        background:#0412CA
      }
      .navT{
        color:#fff !important;
      }
      .ddm{
          background:#0412CA;
          color:#fff !important;
      }
      .ddm li a{
          color:#fff !important;
      }
      .ddm li a:hover{
        background:transparent
      }



        * {
        font-family: "Poppins", sans-serif;
      }

      /* ---------- Top Section ---------- */
      .section-top {
        background: #fff;
        color: #000;
        padding: 60px 0;
      }

      .logo-text {
        color: #3306e6;
        font-weight: 700;
        font-size: 40px;
      }

      .divider {
        border-top: 2px solid #45b4e4;
        width: 100%;
        margin: 8px 0 30px 0;
      }

      .scales-icon {
        width: 400px;
      }

      .top-text p {
        font-size: 22px;
        line-height: 1.6;
        margin-bottom: 15px;
      }

      /* ---------- Team Section ---------- */
      .section-team {
        background: linear-gradient(180deg, #0a0a32 0%, #2e2eb6 100%);
        color: #fff;
        padding: 80px 0;
        text-align: center;
      }

      .section-team h2 {
        font-weight: 600;
        font-size: 37px;
        margin-bottom: 50px;
      }

      .team-card {
        border: 2px solid #1ed2ff;
        /* border-radius: 6px; */
        padding: 0;
        background-color: transparent;
        transition: 0.3s;
      }
      /* 
      .team-card:hover {
        border-color: #1ed2ff;
      } */

      .team-card img {
        width: 100%;
        height: 300px;
        object-fit: cover;
        /* border-radius: 3px; */
      }

      .team-name {
        background: linear-gradient(to right, #1ed2ff, #2929a3);

        color: #000;
        font-weight: 600;
        padding: 5px 0;
        margin-top: 5px;
        width: 85%;
      }

      .team-role {
        font-size: 13px;
        margin-top: 3px;
      }

      /* ---------- Partner Section ---------- */
      .section-partners {
        background: linear-gradient(180deg, #0a0a32 0%, #2e2eb6 100%);
        color: #fff;
        padding: 60px 0 100px;
        text-align: center;
      }

      .section-partners h2 {
        font-weight: 600;
        font-size: 37px;
        margin-bottom: 40px;
      }

      .partner-logo {
        width: 100%;
        max-width: 100%;
        /* background-color: #fff; */
        border-radius: 6px;
        padding: 15px;
        margin: 15px auto;
        height: 200px;
      }

      @media (max-width: 768px) {
        .section-top {
          text-align: center;
        }
        .section-top img {
          margin-bottom: 20px;
        }
        .scales-icon {
          width: 200px;
        }
      }
      @media (max-width: 992px) {
        .scales-icon {
          width: 200px;
        }
          .team-card img {
        width: 100%;
        height: 450px;
        object-fit: cover;
        /* border-radius: 3px; */
      }
      }
      footer{
        position:static
      }
    </style>

    <!-- Open Graph meta tags -->
<meta property="og:title" content="DuePro" />
<meta property="og:description" content="DuePro empowers individuals and attorneys by simplifying legal alerts and emergency notifications." />
<meta property="og:url" content="https://duepro.com/" />
<meta property="og:type" content="website" />
<meta property="og:image" content="	https://duepro.com//assets/images/lg1.webp" />
<meta property="og:image:width" content="600" />
<meta property="og:image:height" content="600" />
  </head>

  <body class="">
    <!-- navbar -->
    <nav class="navbar navbar-expand-lg nav-b">
      <div class="container-fluid z-2">
        <a class="navbar-brand" href="#">
          <img src="<?= base_url(); ?>/assets/images/logo.png" alt="" />
        </a>
        <button
          class="navbar-toggler"
          type="button"
          data-bs-toggle="collapse"
          data-bs-target="#navbarSupportedContent"
          aria-controls="navbarSupportedContent"
          aria-expanded="false"
          aria-label="Toggle navigation"
        >
          <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
          <ul class="navbar-nav mb-2 mb-lg-0 ms-auto">
           <li class="nav-item">
              <a class="nav-link navT" href="<?= base_url('site/company'); ?>">Company</a>
            </li>
          <li class="nav-item">
            <div class="dropdown ">
  <a class="nav-link navT dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
   Platform
  </a>

  <ul class="dropdown-menu ddm">
    <li><a class="dropdown-item" href="<?= base_url('site/individuals'); ?>">Individuals</a></li>
    <li><a class="dropdown-item" href="<?= base_url('site/lawfirm'); ?>">Law Firms</a></li>
  
  </ul>
</div>
            </li>
            <li class="nav-item">

              <a class="nav-link navT" aria-current="page" href="<?= base_url('/'); ?>"
                >Login</a
              >
            </li>
           
          </ul>
        </div>
      </div>
    </nav>
    <!-- nav bar end -->

    <!-- main -->
  <main class="container-fluid  main90vh">
       <!-- ---------- TOP SECTION ---------- -->
    <section class="section-top">
      <div class="container">
        <div class="logo-text">DuePro</div>
        <div class="divider"></div>
        <div class="row align-items-start justify-content-between">
          <div class="col-md-4">
            <div>
              <img src="<?= base_url(); ?>/assets/images/lg1.webp" alt="DuePro Icon" class="scales-icon" />
            </div>
          </div>

          <div class="col-md-8 top-text">
            <p>Transforming how people hire an attorney — digitally and on demand, through technology.</p>
            <p>
             DuePro is a legal technology company based in Dallas, Texas, transforming how people connect with legal support in critical moments. With a single tap, users can alert their attorney and trusted emergency contact, share live GPS location, and automatically record audio or video—ensuring safety, transparency, and immediate legal response.

            </p>
            <p>
            Beyond emergencies, DuePro empowers users to hire attorneys directly through the app, sign contracts, and pay retainers securely—all in one seamless digital experience. For law firms, DuePro provides tools to receive real-time client alerts, get hired anytime, and receive payments instantly, strengthening client trust and responsiveness.

            </p>
            <p>
              Our mission is to redefine how people access legal help by combining personal safety, evidence capture, instant communication, and seamless hiring into one intuitive mobile experience. Our mission delves even deeper—by helping to minimize missing persons reports, reduce job loss from unnecessary detentions, and support jail population management and cost savings for cities.
            </p>
            <p>
            DuePro is a peace-of-mind gift to individuals, making legal protection accessible, immediate, and free for consumers. Whether you’re an individual protecting your rights or a law firm supporting your clients, DuePro keeps you connected, protected, and empowered—anytime, anywhere.
            </p>
          </div>
        </div>
      </div>
    </section>

    <!-- ---------- FOUNDING TEAM ---------- -->
    <section class="section-team">
      <div class="container">
        <h2>Meet the founding team</h2>
        <div class="row justify-content-center">
          <div class="col-12 col-sm-12 col-md-3 mb-4">
            <div class="team-card m-0">
              <img src="<?= base_url(); ?>/assets/images/t1.jpeg" alt="Team Member" />
            </div>
            <div class="team-name text-start px-2 mt-0">Mario Mendez</div>
            <div class="team-role text-start px-2">Co-Founder & CMO</div>
          </div>

          <div class="col-12 col-sm-12 col-md-3 mb-4">
            <div class="team-card m-0">
              <img src="<?= base_url(); ?>/assets/images/t2.jpeg" alt="Team Member" />
            </div>
            <div class="team-name text-start px-2 mt-0">Celeste Cerrillo</div>
            <div class="team-role text-start px-2">Co-Founder & CEO</div>
          </div>

          <div class="col-12 col-sm-12 col-md-3 mb-4">
            <div class="team-card m-0">
              <img src="<?= base_url(); ?>/assets/images/t3.jpeg" alt="Team Member" />
            </div>
            <div class="team-name text-start px-2 mt-0">Enrique Cerrillo</div>
            <div class="team-role text-start px-2">Co-Founder & CFO</div>
          </div>

          <div class="col-12 col-sm-12 col-md-3 mb-4">
            <div class="team-card m-0">
              <img src="<?= base_url(); ?>/assets/images/t4.jpeg" alt="Team Member" />
            </div>
            <div class="team-name text-start px-2 mt-0">Eric Puente</div>
            <div class="team-role text-start px-2">Co-Founder & COO</div>
          </div>
        </div>
      </div>
    </section>

    <!-- ---------- INVESTMENT PARTNERS ---------- -->
    <section class="section-partners">
      <div class="container">
        <h2>Investment Partners</h2>
        <div class="row justify-content-center">
          <div class="col-md-7">
            <div class="row">
              <div class="col-12 col-sm-12 col-md-6">
                <img src="<?= base_url(); ?>/assets/images/p1.webp" class="partner-logo" alt="Partner 1" />
              </div>

              <div class="col-12 col-sm-12 col-md-6">
                <img src="<?= base_url(); ?>/assets/images/p2.webp" class="partner-logo" alt="Partner 2" />
              </div>

              <div class="col-12 col-sm-12 col-md-6">
                <img src="<?= base_url(); ?>/assets/images/p3.webp" class="partner-logo" alt="Partner 3" />
              </div>

              <div class="col-12 col-sm-12 col-md-6">
                <img src="<?= base_url(); ?>/assets/images/p4.jpg" class="partner-logo" alt="Partner 4" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

  </main>
    <!-- main end -->
    <!-- footer  -->
    <footer class="footer p-2 d-flex justify-content-center align-items-center">
      <p class="text-center m-0 fs2 text-white">
        Copyright © 2024-2025 DuePro. All rights reserved.
      </p>
    </footer>
    <!-- footer end -->
<!--swal   sweetalert2 -->
 <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- bootstrap scripts   -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
   <!-- jquery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


  <!-- Firebase Scripts -->
 <!-- Firebase Scripts (Compat Versions) -->
  <!-- <script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-app-compat.js"></script>
  <script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-auth-compat.js"></script>
  <script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-database-compat.js"></script> -->
  <!-- Firebase SDKs (add in this order) -->
<script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-app-compat.js"></script>
<script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-auth-compat.js"></script>
<script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-firestore-compat.js"></script>






 

  </body>
</html>
