<script
  src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB0jx5yCf4vk4I5ridEorfPMqohEhpH1H4&libraries=places"
  async
></script>


<style>
  .swvl-loader {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.8);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 9999;
  }

  .swvl-loader .spinner {
    width: 60px;
    height: 60px;
    border: 6px solid rgb(231, 80, 60);
    border-top: 6px solid transparent;
    border-radius: 50%;
    animation: spin 0.9s linear infinite;
  }

  @keyframes spin {
    0% {
      transform: rotate(0deg);
    }

    100% {
      transform: rotate(360deg);
    }
  }
</style>

<!-- main -->
<main class="">
  <div class="container-fluid">
    <div id="cameraLoader" class="swvl-loader d-none">
      <div class="spinner"></div>
    </div>


    <div class="my-5">
      <p class="f6" data-i18n="legal_emergency" id="title">Legal emergency?</p>
      <p class="f7 mt-4" data-i18n="tap_to_record" id="Message">
        Tap the button to activate alerts and begin recording.
      </p>


      <div class="position-relative">
        <button class="btn mt-5 ripple-triple-btn d-block m-auto" id="rpl-butn">
          <img src="../assets/images/rp.png" alt="" id="rippleeffect" width="150px" />
        </button>
        <span class="ripple ripple1"></span>
        <span class="ripple ripple2"></span>
        <span class="ripple ripple3"></span>
      </div>

      <!-- <button class="btn mt-4 f6 d-block mx-auto">Cancel</button> -->

      <div class="modal fade" id="acceptInviteModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content">
            <div class="modal-header justify-content-center">
              <h5 class="modal-title ">Firm Invitation to Join</h5>
            </div>
            <div class="modal-body ">
              <div class="text-center">
                <p id="inviteText"></p>
              </div>
              
              <div class="card-wrapper">
                <div class="d-flex align-items-center gap-3 mt-3">
                <img id="inviteFirmImage" src="../assets/images/th.jpeg" alt="Firm Image" width="80" height="80" class="rounded">
                <div class="text-start">
                  <p id="inviteFirmName"></p>
                  <p id="inviteFirmAdmin">Firm Admin</p>
                </div>
              </div>
              <div class="">
                <p id="inviteFirmLocation"><i class="fa-solid fa-location-dot"></i> Location</p>
                <p id="inviteFirmPhone"><i class="fa-solid fa-phone"></i> Phone</p>
                <p id="inviteFirmWebsite"><i class="fa-solid fa-globe"></i> Website</p>
              </div>
              </div>

              <div class="d-flex gap-3 justify-content-between mt-4">
                <button class="btn btn-danger" id="rejectInviteBtn">Decline</button>
                <button class="btn btn-success" id="acceptInviteBtn">Accept</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>


<script>(g=>{var h,a,k,p="The Google Maps JavaScript API",c="google",l="importLibrary",q="__ib__",m=document,b=window;b=b[c]||(b[c]={});var d=b.maps||(b.maps={}),r=new Set,e=new URLSearchParams,u=()=>h||(h=new Promise(async(f,n)=>{await (a=m.createElement("script"));e.set("libraries",[...r]+"");for(k in g)e.set(k.replace(/[A-Z]/g,t=>"_"+t[0].toLowerCase()),g[k]);e.set("callback",c+".maps."+q);a.src=`https://maps.${c}apis.com/maps/api/js?`+e;d[q]=f;a.onerror=()=>h=n(Error(p+" could not load."));a.nonce=m.querySelector("script[nonce]")?.nonce||"";m.head.append(a)}));d[l]?console.warn(p+" only loads once. Ignoring:",g):d[l]=(f,...n)=>r.add(f)&&u().then(()=>d[l](f,...n))})
({key: "AIzaSyB0jx5yCf4vk4I5ridEorfPMqohEhpH1H4", v: "weekly"});</script>


<script>
  let isRecording = false;
  let stream;
  let mediaRecorder;
  let chunks = [];
  let alertDocId = null;
  let chunkCounter = 0;
  let stopTimeout;
  let stoppedEarly = false;
  const db = firebase.firestore();
  const storage = firebase.storage();
  let emergencyInProgress = false;

  // ------------------------ Auth + Setup ------------------------
  firebase.auth().onAuthStateChanged(async (user) => {
    const recordBtn = document.getElementById("rpl-butn");
    const titleEl = document.getElementById("title");
    const messageEl = document.getElementById("Message");

    if (!user) {
      titleEl.textContent = "Login Required";
      messageEl.textContent = "You must be logged in to access this page.";
      recordBtn.disabled = true;
      return;
    }

    // Fetch user data once
    const userDoc = await db.collection("Users").doc(user.uid).get();
    if (!userDoc.exists) {
      titleEl.textContent = "User Not Found";
      messageEl.textContent = "User data not found.";
      recordBtn.disabled = true;
      return;
    }
    currentUserData = userDoc.data();

    // 🔹 Profile + emergency contact check
    const isProfileIncomplete = !currentUserData.Name || !currentUserData.pinCode;
    const emergencySnapshot = await db.collection("Users").doc(user.uid).collection("EmergencyContacts").get();
    const hasNoEmergencyContacts = emergencySnapshot.empty;

    if (isProfileIncomplete || hasNoEmergencyContacts) {
      titleEl.textContent = "Personal Info Required";
      messageEl.textContent = "Please add your personal details and add emergency contact to continue.";
      recordBtn.disabled = true;
      document.querySelectorAll(".ripple").forEach(el => el.classList.add("d-none"));
      document.getElementById("rippleeffect").src = "../assets/images/rp3.png";
      return;
    }

    titleEl.textContent = "Legal emergency?";
    messageEl.textContent = "Tap the button to activate alerts and begin recording.";
    recordBtn.disabled = false;
    document.getElementById("rippleeffect").src = "../assets/images/rp.png";

    // ------------------------ Button Listener ------------------------
    // Remove old listeners
    const newRecordBtn = recordBtn.cloneNode(true);
    recordBtn.parentNode.replaceChild(newRecordBtn, recordBtn);

    newRecordBtn.addEventListener("click", async () => {
      if (emergencyInProgress) return; // prevent multiple starts
      emergencyInProgress = true;

      if (isRecording) {
        askForPin(user.uid, currentUserData.pinCode);
      } else {
        loader.classList.remove("d-none");
        isRecording = true;
        await startEmergency(user.uid, currentUserData);
        changeButtonToEmergency();
      }

      emergencyInProgress = false;
    });
  });

  async function check(){
    const userDoc = await  db.collection("Users").doc(user.uid).get();
    const userData = userDoc.data();
    // 🔹 Check the Firestore fields
    if (userData.isNewUser === true || userData.userInitalSetup === "new") {
        // ✅ Redirect to site/boarding
        window.location.href = "<?= base_url('site/getstarted'); ?>";
    }
  }
  check();

  // Improved reverse geocode function
  async function getAddressFromLatLng(lat, lng) {
    return new Promise((resolve, reject) => {
      if (!window.google?.maps?.Geocoder) {
        return reject("Google Maps Geocoder not loaded");
      }

      const geocoder = new google.maps.Geocoder();
      const latlng = { lat, lng };

      geocoder.geocode({ location: latlng }, (results, status) => {
        if (status !== "OK" || !results || !results.length) {
          return reject("Geocoding failed: " + status);
        }

        const result = results[0];
        const addressComponents = result.address_components;

        // More comprehensive city detection
        const cityObj = addressComponents.find(c =>
          c.types.includes("locality") || 
          c.types.includes("sublocality") ||
          c.types.includes("administrative_area_level_2")
        );

        // County/State District
        const countyObj = addressComponents.find(c =>
          c.types.includes("administrative_area_level_2") ||
          c.types.includes("administrative_area_level_1")
        );

        // Country
        const countryObj = addressComponents.find(c => 
          c.types.includes("country")
        );

        resolve({
          city: cityObj?.long_name || "Unknown",
          county: countyObj?.long_name || "Unknown",
          country: countryObj?.long_name || "Unknown",
          formattedAddress: result.formatted_address || "Unknown" // Bonus: full address
        });
      });
    });
  }

  // Alternative: More detailed location breakdown
  async function getDetailedAddressFromLatLng(lat, lng) {
    return new Promise((resolve, reject) => {
      if (!window.google?.maps?.Geocoder) {
        return reject("Google Maps Geocoder not loaded");
      }

      const geocoder = new google.maps.Geocoder();
      const latlng = { lat, lng };

      geocoder.geocode({ location: latlng }, (results, status) => {
        if (status !== "OK" || !results || !results.length) {
          return reject("Geocoding failed: " + status);
        }

        const result = results[0];
        const addressComponents = result.address_components;

        // Helper function to find component by type
        const findComponent = (...types) => {
          for (const type of types) {
            const comp = addressComponents.find(c => c.types.includes(type));
            if (comp) return comp.long_name;
          }
          return null;
        };

        resolve({
          // Most specific to least specific
          streetNumber: findComponent("street_number"),
          streetName: findComponent("route"),
          neighborhood: findComponent("neighborhood", "sublocality_level_1"),
          city: findComponent("locality", "administrative_area_level_2", "administrative_area_level_3"),
          county: findComponent("administrative_area_level_2", "administrative_area_level_1"),
          state: findComponent("administrative_area_level_1"),
          country: findComponent("country"),
          postalCode: findComponent("postal_code"),
          formattedAddress: result.formatted_address,
          
          // For your alert system, keep these main ones
          mainCity: findComponent("locality", "administrative_area_level_2") || "Unknown",
          mainCounty: findComponent("administrative_area_level_2", "administrative_area_level_1") || "Unknown",
          mainCountry: findComponent("country") || "Unknown"
        });
      });
    });
  }

  // Wait for Google Maps to be ready
  function waitForGoogleMaps() {
    return new Promise((resolve, reject) => {
      // Check if already loaded
      if (window.google?.maps?.Geocoder) {
        return resolve();
      }

      let attempts = 0;
      const maxAttempts = 100; // 10 seconds (100 * 100ms)

      const interval = setInterval(() => {
        attempts++;
        
        if (window.google?.maps?.Geocoder) {
          clearInterval(interval);
          resolve();
        } else if (attempts >= maxAttempts) {
          clearInterval(interval);
          reject("Google Maps API failed to load within 10 seconds");
        }
      }, 100);
    });
  }
  
  const startEmergency = async (uid, userData) => {

    const name = userData.Name;
    const lawyerId = userData.designatedLawyerId || "";
    const imigrationLawId = userData.designatedImmigrationLawyerId || "";

    let currentLat = userData.userlat || null;
    let currentLng = userData.userlon || null;
    let locationDetails = { 
      country: "Unknown", 
      city: "Unknown", 
      county: "Unknown" 
    };

    try {
      // Step 1: Get live GPS coordinates
      const location = await getCurrentLocation();
      currentLat = location.lat;
      currentLng = location.lng;
      console.log("Live location:", currentLat, currentLng);

      // Step 2: Wait for Google Maps API
      await waitForGoogleMaps();

      // Step 3: Reverse geocode
      locationDetails = await getAddressFromLatLng(currentLat, currentLng);
      console.log("Location details:", locationDetails);

    } catch (err) {
      console.warn("Location/geocoding failed:", err);
      
      // Fallback: Try to geocode stored coordinates if available
      if (currentLat && currentLng) {
        try {
          await waitForGoogleMaps();
          locationDetails = await getAddressFromLatLng(currentLat, currentLng);
          console.log("Used stored coordinates for geocoding");
        } catch (geocodeErr) {
          console.error("Stored coordinate geocoding also failed:", geocodeErr);
        }
      }
    }

    
    const docRef = db.collection("QuoteAlert").doc();
    alertDocId = docRef.id;
    chunkCounter = 0;

    // 🔍 Step 1: Fetch arrest details
    let offense = "N/A";
    let detainedPlace = "N/A";

    try {
      const upperName = name.toUpperCase();
      const res = await fetch(`https://us-central1-duepro-2cf60.cloudfunctions.net/widgets/searchnew?name=${encodeURIComponent(upperName)}`);
      const result = await res.json();

      if (result.success !== 0 && result.result) {
        const arrest = result.result;
        // offense = arrest.offense || "N/A";
            offense = Array.isArray(arrest.offense) ? arrest.offense : []
        detainedPlace = arrest.detention || "N/A";
      }
      else{
        offense = [];  // ✅ Empty array if API doesn't return data
      detainedPlace = "N/A";
      }
    } catch (err) {
      offense = [];     
      console.error("Arrest API error:", err);
    }

    // 🧾 Step 2: Create alert with fetched info
    const alertData = {
      LawId: lawyerId,
      imigrationLawId: imigrationLawId,
      userId: uid,
      isOptOut: false,
      isImmigrationOptOut: false,
      userLat: currentLat,
      userLng: currentLng,
      country: locationDetails.country,      // ✅ Use geocoded data
      county: locationDetails.county,        // ✅ Use geocoded data
      city: locationDetails.city,            // ✅ Use geocoded data

  // userLat: userData.userlat,
      // userLng: userData.userlon,
      // country: "Pakistan",
      // county: "Islamabad",
      // city: "Islamabad",

      createdDate: Date.now(),
      isActive: true,
      isInActive: true,
      isFalse: false,
      paidStatus: "0",
      qoutesDeposite: 0,
      qoutesPrice: 0,
      status: "request",
      videoUrl: "",
      videoImageUrl: "",
      title: `${name}`,
      videoUrls: [],
      isUserArchived: false,
      // isAttorneyAlerted :true,
      isAttorneyAlerted: !!lawyerId, // ✅ sets true if lawyerId is non-empty
      isNewHire:false,
      isLawArchived:false,
      offense,
      detainedPlace
    };

    await docRef.set(alertData);
    loader.classList.remove("d-none"); // Show spinner
    await startRecordingChunks();

    window.onbeforeunload = () => "Recording in progress. Do not leave or refresh.";
    stopTimeout = setTimeout(stopRecordingSession, 45 * 60 * 1000);
  };

  function getCurrentLocation() {
    return new Promise((resolve, reject) => {
      if (!navigator.geolocation) {
        return reject("Geolocation not supported");
      }

      navigator.geolocation.getCurrentPosition(
        (position) => {
          resolve({
            lat: position.coords.latitude,
            lng: position.coords.longitude,
          });
        },
        (error) => {
          reject(error.message || "Location error");
        },
        {
          enableHighAccuracy: true,
          timeout: 30000,      // ⬅️ 30 seconds
          maximumAge: 10000,   // ⬅️ allow cached GPS
        }
      );
    });
  }

  const loader = document.getElementById("cameraLoader");
  const startRecordingChunks = async () => {
    try {
      loader.classList.remove("d-none"); // Show spinner

      stream = await navigator.mediaDevices.getUserMedia({ video: true, audio: true });
      loader.classList.add("d-none"); // Hide spinner once ready
      mediaRecorder = new MediaRecorder(stream);

      mediaRecorder.ondataavailable = async (e) => {
        if (e.data.size > 0) chunks.push(e.data);
      };

    
      mediaRecorder.onstop = async () => {
        if (!chunks.length) return;

        const blob = new Blob(chunks, { type: 'video/webm' });
        const fileName = `video_chunk_${++chunkCounter}_${Date.now()}.webm`;
        const ref = storage.ref(`Videos/${alertDocId}/${fileName}`);

        // Upload in background
        ref.put(blob).then(async () => {
          const url = await ref.getDownloadURL();

          await db.collection("QuoteAlert").doc(alertDocId).update({
            videoUrls: firebase.firestore.FieldValue.arrayUnion(url),
            ...(chunkCounter === 1 && { videoUrl: url })
          });
        });

        chunks = [];

        if (isRecording) {
          mediaRecorder.start();
          setTimeout(() => mediaRecorder.stop(), 20000);
        }
      };


      mediaRecorder.start();
      setTimeout(() => mediaRecorder.stop(), 20000);
    } catch (err) {
        loader.classList.add("d-none"); // Hide spinner on error
        console.error("Error starting recording:", err);
        Swal.fire("Error", "Camera/mic permission error", "error");
        isRecording = false;
        resetButton();
      }
  };


  const stopRecordingSession = async () => {
    isRecording = false;
    clearTimeout(stopTimeout);
    resetButton(); // 👈 Reset button immediately

    let isSaving = true;

    // 🔒 Block navigation/refresh
    window.onbeforeunload = (e) => {
      if (isSaving) {
        e.preventDefault();
        e.returnValue = "Video is saving. Please wait...";
      }
    };

    if (mediaRecorder && mediaRecorder.state === "recording") {
      mediaRecorder.stop();
      await new Promise(resolve => {
        mediaRecorder.onstop = resolve;
      });
    }

    if (chunks.length) {
      const blob = new Blob(chunks, { type: 'video/webm' });
      const fileName = `video_chunk_${++chunkCounter}_${Date.now()}.webm`;
      const ref = storage.ref(`Videos/${alertDocId}/${fileName}`);
      await ref.put(blob);
      const url = await ref.getDownloadURL();

      await db.collection("QuoteAlert").doc(alertDocId).update({
        videoUrls: firebase.firestore.FieldValue.arrayUnion(url),
        ...(chunkCounter === 1 && { videoUrl: url }),
      });

      chunks = [];
    }

    if (stream) stream.getTracks().forEach(t => t.stop());

    // await db.collection("QuoteAlert").doc(alertDocId).update({
    //   isActive: true,
    //   status: "request"
    // });
    await db.collection("QuoteAlert").doc(alertDocId).update({
    isActive: true,
    isInActive: true,
    status: "request",
    isFalse: stoppedEarly === true
  });

    isSaving = false; // ✅ Allow navigation again
    window.onbeforeunload = null;
    stoppedEarly = false;
    // Swal.fire("Complete", "Emergency session finished and video saved.", "success");
  };


  const askForPin = async (uid, pin) => {
    const { value: input } = await Swal.fire({
      title: "Enter 4-digit PIN",
      input: "password",
      inputAttributes: { maxlength: 4, inputmode: "numeric" },
      showCancelButton: true,
      inputValidator: val => (!val || val.length !== 4 ? "Enter a valid 4-digit PIN" : null),
    });
    if (input === pin) {
      stoppedEarly = true; // ✅ Mark that we stopped early
      await stopRecordingSession();
      // Swal.fire("Stopped", "Emergency cancelled.", "success");
    } else if (input) {
      Swal.fire("Wrong PIN", "Try again.", "error");
    }
  };

  const changeButtonToEmergency = () => {
    document.getElementById("rippleeffect").src = "../assets/images/rp2.png";
    document.querySelectorAll(".ripple").forEach(el => el.style.background = "rgba(182, 47, 47, 0.4)");
  };

  const resetButton = () => {
    document.getElementById("rippleeffect").src = "../assets/images/rp.png";
    document.querySelectorAll(".ripple").forEach(el => el.style.background = "rgba(7, 20, 145, 0.4)");
  };

</script>

<script src="<?= base_url('/assets/js/model.js'); ?>"></script>
