  <!-- intlTelInput CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.min.css" />

  <main class="">
        <div class="container-fluid">
          <div class="my-5">
          <p class="f6" data-i18n="emergency_contact_label"></p>


            <!-- <button class="btn d-block m-auto mt-5 ripple-btn"><img src="../assets/images/buttton.png" alt=""
                        id="rippleeffect"></button> -->
            <div class="row justify-content-center">
              <div class="col-md-6">
              <form>
  <div class="mb-3">
    <label for="fullName" class="form-label custom-label" data-i18n="full_name_label"></label>
    <input
      type="text"
      class="form-control custom-input"
      id="fullName"
      placeholder=""
      data-i18n-placeholder="full_name_placeholder"
    />
  </div>

  <div class="mb-3">
    <label for="email" class="form-label custom-label" data-i18n="email_label"></label>
    <input
      type="email"
      class="form-control custom-input"
      id="email"
      placeholder=""
      data-i18n-placeholder="email_placeholder"
    />
  </div>

  <!-- <div class="mb-3">
    <label for="mobile" class="form-label custom-label" data-i18n="mobile_label"></label>
    <input
      type="tel"
      class="form-control custom-input"
      id="mobile"
      placeholder=""
      data-i18n-placeholder="mobile_placeholder"
    />
  </div> -->
<!-- Your HTML -->
<div class="mb-3">
  <label for="mobile" class="form-label custom-label" data-i18n="mobile_label"></label>
  <input
    type="tel"
    class="form-control custom-input"
    id="mobile"
    placeholder=""
    data-i18n-placeholder="mobile_placeholder"
  />
</div>
  <div class="row justify-content-center">
    <div class="col-md-6">
      <button type="submit" class="btn btn-save w-100" data-i18n="save_button"></button>
    </div>
  </div>
</form>

              </div>
            </div>
          </div>
        </div>
      </main>

<!-- intlTelInput JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js"></script>

<script>
  const input2 = document.querySelector("#mobile");

  // ✅ Properly initialize intlTelInput with utilsScript
  const iti = window.intlTelInput(input2, {
    initialCountry: "auto",
    geoIpLookup: function (callback) {
      fetch("https://ipapi.co/json")
        .then(res => res.json())
        .then(data => callback(data.country_code))
        .catch(() => callback("us"));
    },
    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js" // Required for validation
  });

  firebase.auth().onAuthStateChanged(async (user) => {
    if (!user) {
      Swal.fire("Unauthorized", "You must be logged in to save contacts.", "warning");
      return;
    }

    const currentUserId = user.uid;
    const db = firebase.firestore();
    const form = document.querySelector("form");

    const fullNameInput = document.getElementById("fullName");
    const emailInput = document.getElementById("email");

    // Load existing contact once for pre-fill
    let existingContactId = null;
    const initialSnap = await db
      .collection("Users")
      .doc(currentUserId)
      .collection("EmergencyContacts")
      .limit(1)
      .get();

    if (!initialSnap.empty) {
      const contactData = initialSnap.docs[0].data();
      existingContactId = initialSnap.docs[0].id;

      fullNameInput.value = contactData.name || "";
      emailInput.value = contactData.email || "";

      if (contactData.phone) {
        iti.setNumber(contactData.phone); // ✅ Set phone with flag
      }
    }

    form.addEventListener("submit", async function (e) {
      e.preventDefault();

      Swal.fire({
        title: "Please wait...",
        text: "Submitting",
        allowOutsideClick: false,
        allowEscapeKey: false,
        didOpen: () => {
          Swal.showLoading();
        }
      });

      const fullName = fullNameInput.value.trim();
      const email = emailInput.value.trim();
      const mobile = iti.getNumber(); // Full international number

      // ❌ Prevent user from entering their own phone number
      const currentUserDoc = await db.collection("Users").doc(currentUserId).get();
      const currentUserData = currentUserDoc.data();

      if (currentUserData.userPhone === mobile) {
        Swal.fire("Invalid Entry", "You cannot use your own phone number as an emergency contact.", "error");
        return;
      }


      // ✅ Validate phone number
      if (!mobile || !iti.isValidNumber()) {
        Swal.fire("Invalid Phone Number", "Please enter a valid phone number.", "error");
        return;
      }

      try {
        // 🔄 Re-check for existing EmergencyContact each submit
        const contactSnap = await db
          .collection("Users")
          .doc(currentUserId)
          .collection("EmergencyContacts")
          .limit(1)
          .get();

        if (!contactSnap.empty) {
          existingContactId = contactSnap.docs[0].id;
        } else {
          existingContactId = null;
        }

        // ✅ Check if number belongs to another user
        const matchedUsers = await db
          .collection("Users")
          .where("userPhone", "==", mobile)
          .get();

        let matchedUserId = null;
        if (!matchedUsers.empty) {
          matchedUserId = matchedUsers.docs[0].id;

          // Link both users
          await db.collection("Users").doc(currentUserId).update({
            designatedEmgContact: matchedUserId,
          });

          await db.collection("Users").doc(matchedUserId).set({
            userFriends: {
              [currentUserId]: "added",
            },
          }, { merge: true });
        }

        const emergencyData = {
          name: fullName,
          email: email,
          phone: mobile,
          referralcode: "Q8UL9D",
          userId: currentUserId,
        };

        if (existingContactId) {
          await db
            .collection("Users")
            .doc(currentUserId)
            .collection("EmergencyContacts")
            .doc(existingContactId)
            .update(emergencyData);
        } else {
          const newDocRef = await db
            .collection("Users")
            .doc(currentUserId)
            .collection("EmergencyContacts")
            .add(emergencyData);
          existingContactId = newDocRef.id;
        }

        Swal.fire("Success", "Emergency contact saved successfully.", "success");
      } catch (error) {
        console.error("Emergency contact error:", error);
        Swal.fire("Error", error.message, "error");
      }
    });
  });
</script>

<style>
  .iti--allow-dropdown{
    width: 100%;
  }
</style>
