<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<style>
  #loader {
    display: none;
  }
  .img-atr2{
    width:100%;
    max-height:240px !important;
  }
  .card-height-attor{
    height:260px !important
  }
  .find-attorney-title{
      /* font-size:24px; */
      font-weight:600;
      margin-bottom:20px;
  }
  .btn{
      display:flex;
      align-items:center;
      justify-content:center;
  }
  .contact {
    color: inherit;
  }
  .contact:hover {
    color: #0d6efd;
  }

  .attorney-img-col {
  background-color: #f8f9fa;
  display: flex;
  justify-content: center;
  align-items: center;
  border-radius: 10px;
  }

  .attorney-img {
    max-height: 200px;
    height: 100%;
    vertical-align: middle;
    max-width: 200px;
    width: 100%;
    border-radius: 10px;
    transition: all 0.3s ease-in-out;
  }

  @media (max-width: 768px) {
    .attorney-img-col {
      background-color: transparent !important;
    }

    .attorney-img {
      max-height: 160px;
      border-radius: 50%;
      width: 160px;
      height: 160px;
      object-fit: cover;
    }
  }

</style>
<main class="mb-5">
  <div class="container my-5">
    <div class="row g-3" id="attorneyList">
      <h3 class="find-attorney-title f6">Find an Attorney</h3>
      <div class="d-flex justify-content-center">
        <ul class="nav nav-tabs  n-tabs gap-2" id="lawTabs" role="tablist">
          <li class="nav-item" role="presentation">
            <button class="nav-link active" id="criminal-tab" data-bs-toggle="tab" data-bs-target="#criminal"
              type="button" role="tab">Criminal Defense</button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="immigration-tab" data-bs-toggle="tab" data-bs-target="#immigration"
              type="button" role="tab">Immigration</button>
          </li>
        </ul>
      </div> 
      <div id="loader" class="text-center my-5">
        <div class="spinner-border text-primary" role="status">
          <span class="visually-hidden">Loading...</span>
        </div>
      </div>
      <div class="tab-content mt-3" id="lawTabsContent">
        <div class="tab-pane fade show active" id="criminal" role="tabpanel" aria-labelledby="criminal-tab">
          <div class="row justify-content-center">
            <div class="col-md-12 my-2">
              <div class="row g-2" id="criminalCards"></div>
            </div>
          </div>
        </div>
        <div class="tab-pane fade" id="immigration" role="tabpanel" aria-labelledby="immigration-tab">
          <div class="row justify-content-center">
            <div class="col-md-12 my-2">
              <div class="row g-2" id="immigrationCards"></div>
            </div>
          </div>
        </div>
      </div>
      <!-- Request Quote button -->
      <div class="col-md-12 my-3">
      </div>
    </div>
</main>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCkDJWMAbK59HWDyHOb50Fajk-XpmonOZw&libraries=places"></script>
<script>
  const db = firebase.firestore();
  const loader = document.getElementById("loader");
    loader.style.display = "block"; // show loader before fetch

  const getQueryParam = (name) => new URLSearchParams(window.location.search).get(name);
  const baseDocId = getQueryParam("id");
  const criminalContainer = document.getElementById("criminalCards");
  const immigrationContainer = document.getElementById("immigrationCards");

  // --- Reverse geocode lat/lon to county using OpenStreetMap ---
  
  async function getCountyFromLatLng(lat, lng) {
    return new Promise((resolve, reject) => {
      const geocoder = new google.maps.Geocoder();
      const latlng = { lat: parseFloat(lat), lng: parseFloat(lng) };

      geocoder.geocode({ location: latlng }, (results, status) => {
        if (status === "OK") {
          if (!results || results.length === 0) {
            resolve("Unknown Country");
            return;
          }

          let country = null;

          // Loop all results and inside loop all address components
          for (let result of results) {
            if (!result.address_components) continue;

            for (let comp of result.address_components) {
              if (comp.types.includes("country")) {
                country = comp.long_name;
                break;
              }
            }

            if (country) break; // stop early if found
          }

          resolve(country || "Unknown Country");
        } else {
          console.error("Geocoder failed:", status);
          reject("Geocoder failed: " + status);
        }
      });
    });
  }

  firebase.auth().onAuthStateChanged(async (user) => {
    if (!user) return;

    loader.style.display = "block";

    try {
      // --- Fetch quote + law firms + current user ---
      const [quoteSnap, lawFirmsSnap, userSnap] = await Promise.all([
        db.collection("QuoteAlert").doc(baseDocId).get(),
        db.collection("LawFirm").get(),
        db.collection("Users").doc(user.uid).get(),
      ]);

      if (!quoteSnap.exists) {
        loader.style.display = "none";
          return Swal.fire({
            icon: "error",
            title: "Quote not found!",
            text: "The quote ID in the URL is invalid.",
          });
      }

      const quoteData = { id: quoteSnap.id, ...quoteSnap.data() };
      const currentUserData = userSnap.data();


       // --- Get user county ---
      const userLat = parseFloat(currentUserData.userlat);
      const userLon = parseFloat(currentUserData.userlon);
      
      const userCounty = await getCountyFromLatLng(userLat, userLon);

      // console.log("User county:", userCounty);
      // --- Filter out user's own firms ---
      const firms = lawFirmsSnap.docs
      
      .map(doc => ({ id: doc.id, ...doc.data() }))
      .filter(firm => firm.userId !== user.uid);
      
      // --- Fetch all firm users from Users collection ---
      const uniqueUserIds = [...new Set(firms.map(f => f.userId))];
      const userDocs = await Promise.all(
        uniqueUserIds.map(async (id) => {
          const userSnap = await db.collection("Users").doc(id).get();
            return userSnap.exists ? { id, ...userSnap.data() } : null;
          })
        );
        
        // return;
        // --- Create a lookup map for fast access ---
      const userMap = {};
      for (const u of userDocs.filter(Boolean)) {
        userMap[u.id] = u;
      }

        // --- Separate attorneys by type ---
      const criminalFirms = [];
      const immigrationFirms = [];

      for (const firm of firms) {
        console.log("firm",firm);
        
      const u = userMap[firm.userId] || {};
      const practiceAreas = normalizeArray(firm.practiceAreas);

      const attorney = {
        userId: firm.userId,
        name: firm.professionalName || "N/A",
        lawfirmName: firm.attachedWithLawfirmName?.trim()
            || firm.lawfirmName?.trim()
            || "NA",
        imageUrl: firm.professionalPic || "../assets/images/placeholder.png",
        address: firm.address || "Unknown",
        phone: firm.phone || "+0000000000",
        email: firm.email || "example@email.com",
        isBest: firm.isBest || false,
        practiceAreas,
        bioPractice: firm.bioPractice || "N/A",
        website: firm.website || "N/A",
      };

      if (practiceAreas.includes("criminal defense")) {
        criminalFirms.push(attorney);
      }

      if (practiceAreas.includes("immigration law")) {
        immigrationFirms.push(attorney);
      }
      }


      // --- Render lists ---
      loader.style.display = "none";

      // --- Fetch all existing quote requests by this user ---
      const userQuotesSnap = await db.collection("QuoteAlert")
        .where("userId", "==", user.uid)
        .get();
        // console.log("userQuotesSnap",userQuotesSnap);
        

      // const alreadyRequestedLawIds = [];
      // userQuotesSnap.forEach(doc => {
      //   const q = doc.data();
      //   if (q.LawId) alreadyRequestedLawIds.push(q.LawId);
      //   if (q.imigrationLawId) alreadyRequestedLawIds.push(q.imigrationLawId);
      // });

      const alreadyRequestedLawIds = Array.isArray(quoteData.findAttorney)
    ? quoteData.findAttorney
    : [];
       // --- Sort attorneys: designated → same county → rest ---
    function sortAttorneys(arr) {
      return arr.sort((a, b) => {
        const aDesignated = currentUserData.designatedLawyerId === a.userId || currentUserData.designatedImmigrationLawyerId === a.userId;
        const bDesignated = currentUserData.designatedLawyerId === b.userId || currentUserData.designatedImmigrationLawyerId === b.userId;
        if (aDesignated && !bDesignated) return -1;
        if (!aDesignated && bDesignated) return 1;

        const aSameCounty = a.county && a.county === userCounty;
        const bSameCounty = b.county && b.county === userCounty;
        if (aSameCounty && !bSameCounty) return -1;
        if (!aSameCounty && bSameCounty) return 1;

        return 0;
      });
    }

      // renderAttorneyList(criminalFirms, criminalContainer, quoteData, currentUserData, alreadyRequestedLawIds);
      // renderAttorneyList(immigrationFirms, immigrationContainer, quoteData, currentUserData, alreadyRequestedLawIds);
    renderAttorneyList(
      criminalFirms,
      criminalContainer,
      quoteData,
      currentUserData,
      alreadyRequestedLawIds,
      "criminal"
    );

    renderAttorneyList(
      immigrationFirms,
      immigrationContainer,
      quoteData,
      currentUserData,
      alreadyRequestedLawIds,
      "immigration"
    );


    document.body.addEventListener("click", async (e) => {
      if (!e.target.classList.contains("btn-request-quote")) return;

      const lawId = e.target.dataset.lawid;
      if (!quoteData?.id) {
        return Swal.fire({
          icon: "error",
          title: "Quote not loaded",
          text: "Cannot proceed without quote data.",
        });
      }

      try {
        Swal.fire({
          title: "Submitting...",
          allowOutsideClick: false,
          didOpen: () => Swal.showLoading(),
        });

        const isImmigration = e.target.closest("#immigrationCards") !== null;

        const baseRef = db.collection("QuoteAlert").doc(baseDocId);

        // Prevent duplicates
        if (Array.isArray(quoteData.findAttorney) &&
            quoteData.findAttorney.includes(lawId)) {

          return Swal.fire({
            icon: "info",
            title: "Already Requested",
            text: "This attorney has already been requested."
          });
        }
        await baseRef.update({
          findAttorney: firebase.firestore.FieldValue.arrayUnion(lawId)
        });

        // ✅ Prepare new cloned quote
        const newQuote = {
          ...quoteData,
          LawId: isImmigration ? "" : lawId,
          acceptedAttorneyType:"",
          imigrationLawId: isImmigration ? lawId : "",
          acceptedAttorneyLawFrimID:"",
          baseDocId: baseDocId,
          isLawArchived: false,
          isNewHire: true,
          isUserArchived: false,
          paidStatus: "0",
          qoutesDeposite: 0,
          qoutesPrice: 0,
          status: "request",
          isOptOut: false,
          isImmigrationOptOut: false,
          createdDate: Date.now(),
          updatedAt: firebase.firestore.FieldValue.serverTimestamp(),
        };

        console.log("newQuote",newQuote);
        

        delete newQuote.id; // remove old doc ID before adding

        // ✅ Add new QuoteAlert document
        await db.collection("QuoteAlert").add(newQuote);

        sessionStorage.removeItem("selectedAlert");

        // ✅ Update UI instantly without updating user designated lawyer
        e.target.textContent = "Requested";
        e.target.disabled = true;
        e.target.classList.add("card-requested");

        const redirectUrl = "<?= base_url('site/activityUser') ?>";
        const redirectTimer = setTimeout(() => (window.location.href = redirectUrl), 6000);

        Swal.fire({
          icon: "success",
          title: "New quote request created!",
          text: `Your ${isImmigration ? "immigration" : "criminal"} attorney has been linked.`,
          confirmButtonText: "OK",
          timer: 6000,
          timerProgressBar: true,
          willClose: () => clearTimeout(redirectTimer),
        });

      } catch (err) {
        console.error("Error creating quote:", err);
        Swal.fire({
          icon: "error",
          title: "Error!",
          text: "Could not create a new quote. Please try again.",
        });
      }
    });

    } catch (err) {
      console.error("Error loading data:", err);
      Swal.fire("Error", "Failed to load data.", "error");
    } finally {
      loader.style.display = "none";
    }
  });

  function normalizeArray(arr) {
    return Array.isArray(arr)
      ? arr.map(v => v.toLowerCase().trim())
      : typeof arr === "string"
        ? [arr.toLowerCase().trim()]
        : [];
  }

  // --- Render attorney cards ---
  function renderAttorneyList(attorneys, container, quoteData, currentUserData, alreadyRequestedLawIds, tabType) 
    {
    container.innerHTML = "";
    if (!attorneys.length) {
      container.innerHTML = `<div class="text-center my-3"><p>No attorneys found.</p></div>`;
      return;
    }
    const acceptedTypes = Array.isArray(quoteData?.hireAttorneyAcceptedType)
    ? quoteData.hireAttorneyAcceptedType
    : [];


      // ✅ Sort attorneys: designated attorneys on top
      attorneys.sort((a, b) => {
        const aDesignated =
          (tabType === "criminal" &&
            currentUserData?.designatedLawyerId === a.userId) ||
          (tabType === "immigration" &&
            currentUserData?.designatedImmigrationLawyerId === a.userId);

        const bDesignated =
          (tabType === "criminal" &&
            currentUserData?.designatedLawyerId === b.userId) ||
          (tabType === "immigration" &&
            currentUserData?.designatedImmigrationLawyerId === b.userId);

        if (aDesignated && !bDesignated) return -1;
        if (!aDesignated && bDesignated) return 1;
        return 0;
      });


    attorneys.forEach(attorney => {

      let label = "Request Quote";
      let isAlreadyRequested = false;
      let buttonClass = "";

      // 🚫 Case 0: Attorney type already accepted & paid
      const isAcceptedForThisTab =
        (tabType === "criminal" && acceptedTypes.includes("Criminal Defense")) ||
        (tabType === "immigration" && acceptedTypes.includes("Immigration Law"));

      if (isAcceptedForThisTab) {
        label = "Requested";
        isAlreadyRequested = true;
        buttonClass = "card-requested";
      }


      // ✅ Case 1: User already has this attorney designated

      const isAutoQuote =
        (tabType === "criminal" &&
          currentUserData?.designatedLawyerId === attorney.userId) ||
        (tabType === "immigration" &&
          currentUserData?.designatedImmigrationLawyerId === attorney.userId);

      if (isAutoQuote) {
        label = "Auto Quote Requested";
        isAlreadyRequested = true;
        buttonClass = "card-disable";
      }

      // ✅ Case 2: User already has quote alerts for this attorney
     
      else if (alreadyRequestedLawIds.includes(attorney.userId)) {
        label = "Requested";
        isAlreadyRequested = true;
        buttonClass = "card-requested";
      }


      const card = document.createElement("div");
      card.className = "col-md-10 col-lg-11 mx-auto my-3";
      card.innerHTML = `
        <div class="card shadow-sm border-0 rounded-4 overflow-hidden">
          <div class="row justify-content-center">
            <div class="col-md-4 text-center attorney-img-col p-3">
              <img src="${attorney.imageUrl}" alt="${attorney.name}" class="attorney-img img-fluid rounded-3" style="object-fit: cover;">
            </div>
            <div class="col-md-8 p-4 card-wrapper">
              <div class="d-flex justify-content-between align-items-end">
                <div>
                  <h5 class="fw-bold mb-1">${attorney.name}</h5>
                  <p class="text-muted small mb-2 text-capitalize">
                    ${attorney.lawfirmName}
                  </p>
                  <p class="text-muted small mb-2 text-capitalize">
                    ${attorney.practiceAreas.join(", ")}
                  </p>
                  </div>
                <div>${attorney.isBest ? `<span class="badge bg-warning text-dark mt-2 px-3 py-1">⭐ Best Attorney</span>` : ""}</div>
              </div>
              <div class="mt-2 mb-3">
                <div class="d-flex align-items-center mb-1 text-muted small">
                  <i class="fas fa-phone me-2 text-primary"></i><a class="contact" href="tel:${attorney.phone}">${attorney.phone}</a>
                </div>
                <div class="d-flex align-items-center mb-1 text-muted small">
                  <i class="fas fa-envelope me-2 text-primary"></i><a class="contact" href="mailto:${attorney.email}">${attorney.email}</a>
                </div>
                <div class="d-flex align-items-center text-muted small">
                  <i class="fas fa-map-marker-alt me-2 text-primary"></i>${attorney.address}
                </div>
                <div class="d-flex align-items-center text-muted small">
                  <i class="fas fa-briefcase me-2 text-primary"></i>
                  <span>${attorney.bioPractice || 'N/A'}</span>
                </div>

                <div class="d-flex align-items-center text-muted small">
                  <i class="fas fa-globe me-2 text-primary"></i>
                  <a 
                    href="${attorney.website || '#'}"
                    target="_blank"
                    class="text-muted text-decoration-none">
                    ${attorney.website || 'N/A'}
                  </a>
                </div>
              </div>
              <div class="d-flex justify-content-end gap-2">
                <button 
                  type="button"
                  class="btn btn-outline-primary px-4 py-1 scheduleConsultBtn" data-lawid="${attorney.userId}"
                  data-quoteid="${quoteData.id}">
                  Schedule Consult
                </button>
                <a href="<?= base_url('site/details') ?>?lawId=${attorney.userId}&quoteId=${quoteData.id}" class="btn btn-outline-primary px-4 py-1">View Details</a>
                <button class="btn btn-primary px-4 py-1 btn-request-quote ${buttonClass}" 
                  data-lawid="${attorney.userId}" ${isAlreadyRequested ? "disabled" : ""}> ${label}
                </button>
                               
              </div>
            </div>
          </div>
        </div>
      `;
      container.appendChild(card);
    });
    applyScheduleButtonState();
    
  }

  document.getElementById("attorneyList").addEventListener("click", async (e) => {
    if (!e.target.classList.contains("scheduleConsultBtn")) return;
    let buttonschedule = e.target;

    const { lawid: attorneyId, quoteid: quoteId } = e.target.dataset;

    

    Swal.fire({
      title: "Select a date",
      html: `<div id="calendarInline"></div>`,
      showCancelButton: true,
      showConfirmButton: false,
      didOpen: () => {
        flatpickr("#calendarInline", {
          inline: true,
          minDate: "today",
          dateFormat: "Y-m-d",
          onChange: (_, dateStr) => {
            Swal.close();
            fetchAvailableSlots(attorneyId, quoteId, dateStr);
          }
        });
      }
    });
  });

  async function fetchAvailableSlots(attorneyId, quoteId, selectedDate) {
    try {
      // 🔹 Fetch attorney record
      const attorneySnap = await db.collection("LawFirm").doc(attorneyId).get();

      if (!attorneySnap.exists) {
        throw new Error("Law firm not found");
      }

      const attorneyData = attorneySnap.data();

      const eventTypeURL = attorneyData?.scheduleEvent;
      const calendlyToken = attorneyData?.clandlyToken; // 🔐 MUST be token

      // ✅ Strict validation
      if (!eventTypeURL || !eventTypeURL.trim()) {
        throw new Error("Scheduling not configured");
      }

      if (!calendlyToken || !calendlyToken.trim()) {
        throw new Error("Calendly token missing");
      }

      Swal.fire({
        title: "Loading available slots...",
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
      });

      // ✅ UPDATE: Enforce 15-minute buffer for same-day scheduling
      const now = new Date();
      const selected = new Date(`${selectedDate}T00:00:00`);

      let startTime;
      if (now.toDateString() === selected.toDateString()) {
        startTime = new Date(now.getTime() + 15 * 60 * 1000);
      } else {
        startTime = selected;
      }

      const endTime = new Date(`${selectedDate}T23:59:59`);

      const startUTC = startTime.toISOString();
      const endUTC = endTime.toISOString();
      
      

      // 🔹 Calendly API
      const url = new URL("https://api.calendly.com/event_type_available_times");
      url.search = new URLSearchParams({
        event_type: eventTypeURL,
        start_time: startUTC,
        end_time: endUTC
      });

      const res = await fetch(url.toString(), {
        method: "GET",
        headers: {
          Authorization: `Bearer ${calendlyToken}`,
          "Content-Type": "application/json"
        }
      });

      if (!res.ok) {
        throw new Error("Calendly API failed");
      }

      const data = await res.json();

      const availableSlots = data.collection.filter(
        slot => slot.status === "available"
      );

      Swal.close();

      if (!availableSlots.length) {
        Swal.fire("No Slots", "No time slots available for this date", "info");
        return;
      }

      // ✅ Correct data received
      showTimeSlots(attorneyId, quoteId, selectedDate, availableSlots);

    } catch (err) {
      Swal.close();
      Swal.fire("Error", err.message, "error");
    }
  }

  async function showTimeSlots(attorneyId, quoteId, date, slots) {
    // Fetch attorney details from LawFirm + Users collection
    const attorneySnap = await db.collection("LawFirm").doc(attorneyId).get();
    if (!attorneySnap.exists) throw new Error("Law firm not found");
    const attorneyData = attorneySnap.data();

    // Try to fetch name from Users collection
    let attorneyName = "Unknown Attorney";
    try {
      const userSnap = await db.collection("Users").doc(attorneyId).get();
      if (userSnap.exists) {
        const userData = userSnap.data();
        attorneyName = userData?.Name 
                    || (userData?.firstName && userData?.lastName ? `${userData.firstName} ${userData.lastName}` : null)
                    || attorneyData?.name 
                    || "Unknown Attorney";
      } else {
        // fallback to LawFirm name
        attorneyName = attorneyData?.name || "Unknown Attorney";
      }
    } catch (err) {
      console.warn("Failed to fetch attorney name from Users collection:", err);
      attorneyName = attorneyData?.name || "Unknown Attorney";
    }

    const buttonsHTML = slots
      .map(slot => {
        const time = new Date(slot.start_time).toLocaleTimeString([], {
          hour: "2-digit",
          minute: "2-digit"
        });

        return `
          <button 
            class="time-slot btn btn-outline-primary m-1"
            data-start='${slot.start_time}'
          >
            ${time}
          </button>
        `;
      })
      .join("");

    Swal.fire({
      title: `Available Times – ${date}`,
      html: `<div class="d-flex flex-wrap justify-content-center">${buttonsHTML}</div>`,
      showCancelButton: true,
      showConfirmButton: false,

      didOpen: () => {
        document.querySelectorAll(".time-slot").forEach(btn => {
          btn.addEventListener("click", async () => {
             Swal.update({
               title: "Booking Consult ...",
               html: "Please Wait For a While",
               showCancelButton: false,
               showConfirmButton: false,
               allowOutsideClick: false,
              //  didOpen: () => Swal.showLoading(),
          });
                  // ✅ IMPORTANT: call loader explicitly
          Swal.showLoading();

            const start_time = btn.dataset.start;
            const bookedDate = start_time.split("T")[0]; // ✅ YYYY-MM-DD

            await scheduleCalendlyEvent({
              attorneyId: attorneyId,
              attorneyName: attorneyName, // now dynamic
              quoteId: quoteId,
              bookedDate, // ✅ pass date
              slot: { start_time },
              inviteeName: firebase.auth().currentUser.name || "Client",
              inviteeEmail: firebase.auth().currentUser.email
            });
          });
        });
      }
    });
  }

  async function getEventTypeURL(attorneyId) {
    const snap = await db.collection("LawFirm").doc(attorneyId).get();

    if (!snap.exists) {
      throw new Error("Law firm not found");
    }

    const data = snap.data();
    const scheduleEvent = data?.scheduleEvent;

    // ✅ strict validation
    if (
      !scheduleEvent ||
      typeof scheduleEvent !== "string" ||
      !scheduleEvent.trim()
    ) {
      throw new Error("Scheduling is not configured for this attorney");
    }

    return scheduleEvent.trim();
  }

  async function scheduleCalendlyEvent({
    attorneyId,
    attorneyName,
    quoteId,
    bookedDate,
    slot,
    inviteeName,
    inviteeEmail
  }) {
    try {
      // 🔹 Fetch attorney (LawFirm)
      const attorneySnap = await db.collection("LawFirm").doc(attorneyId).get();

      if (!attorneySnap.exists) {
        throw new Error("Law firm not found");
      }

      const attorneyData = attorneySnap.data();
      const eventTypeURL = attorneyData?.scheduleEvent;
      const token = attorneyData?.clandlyToken;

      if (!eventTypeURL || !eventTypeURL.trim()) {
        throw new Error("Scheduling not configured");
      }

      if (!token || !token.trim()) {
        throw new Error("Calendly token missing");
      }

      // 🔹 Calendly API request
      const response = await fetch("https://api.calendly.com/invitees", {
        method: "POST",
        headers: {
          Authorization: `Bearer ${token}`,
          "Content-Type": "application/json"
        },
        body: JSON.stringify({
          event_type: eventTypeURL,
          start_time: new Date(slot.start_time).toISOString(),
          invitee: {
            name: inviteeName,
            email: inviteeEmail,
            timezone: Intl.DateTimeFormat().resolvedOptions().timeZone
          },
          location: {
            kind: "zoom_conference"
          }
        })
      });

      const raw = await response.text();
      // console.log("Calendly invitee response:", raw);

      if (!response.ok) {
        throw new Error("Scheduling failed");
      }

      const decoded = JSON.parse(raw);
      const resource = decoded.resource;

      

      // 🔹 Save to Consult collection (MATCHING YOUR SCHEMA)
      await db.collection("Consult").add({
        attorneyId: attorneyId,
        attorneyName: attorneyName,
        userID: firebase.auth().currentUser.uid,

        documentID: quoteId,
        inviteeEmail: resource.email,

        cancel_url: resource.cancel_url,
        reschedule_url: resource.reschedule_url,
        scheduled_event_join_url: resource.uri,

        token: token,
        created_at: new Date(slot.start_time).getTime(),
      });



      // 2️⃣ Update Quote document
      await db.collection("QuoteAlert").doc(quoteId).set(
        {
          scheduledConsult: firebase.firestore.FieldValue.arrayUnion(attorneyId)
        },
        { merge: true }
      );
      await applyScheduleButtonState();

      Swal.fire(
        "Consult Scheduled 🎉",
        "Your consult has been successfully booked",
        "success"
      ).then(() => {
        window.location.href =
          `quotesUser?openConsults=1&docId=${quoteId}&consultDate=${bookedDate}`;
      });
    } catch (error) {
      Swal.fire("Error", error.message, "error");
    }
  }

  async function applyScheduleButtonState() {
    // 1️⃣ Get latest quote data
    const quoteSnap = await db
      .collection("QuoteAlert")
      .doc(baseDocId) // your current quote ID
      .get();

    if (!quoteSnap.exists) return;

    const quoteData = quoteSnap.data();

    const scheduledConsult = Array.isArray(quoteData.scheduledConsult)
      ? quoteData.scheduledConsult
      : [];

    // 2️⃣ Loop through all buttons
    document.querySelectorAll(".scheduleConsultBtn").forEach(btn => {
      const attorneyId = btn.dataset.lawid;

      if (scheduledConsult.includes(attorneyId)) {
        btn.disabled = true;
        btn.innerText = "Scheduled";
        btn.classList.remove("btn-primary");
        btn.classList.add("btn-secondary");
      } else {
        btn.disabled = false;
        btn.innerText = "Schedule Consult";
      }
    });
  }



</script>

<style>
   .card-wrapper {
    position: relative;
  }
  .card-disable{
    pointer-events: none;
    opacity: 0.6;
    position: absolute;
    top: 18px;
    background-color: #808080 !important;
  }
  .card-requested{
    pointer-events: none;
    opacity: 0.6;
    position: static;
    background-color: #808080 !important;
  }
  .flatpickr-calendar {
    border-right: none !important;
    overflow: clip;
  }

  .swal2-html-container{
    display: flex !important;
  }

  .card-wrapper {
    position: relative;
  }

  .card-disable{
    pointer-events: none;
    opacity: 0.6;
    position: absolute;
    top: 18px;
    background-color: #808080 !important;
  }

  .card-requested{
    pointer-events: none;
    opacity: 0.6;
    position: static;
    background-color: #808080 !important;
  }
</style>