<style>
  .pricing-card {
  transition: all 0.3s ease;
  }

  .pricing-card:hover {
    transform: translateY(-6px);
    box-shadow: 0 15px 40px rgba(0, 0, 0, 0.12);
  }

  .form-check-input{
    border-radius: 20px;
    cursor: pointer;
  }

  .form-check-input:checked{
    border-radius: 20px;
    cursor: pointer;
    background-color: #0412CA !important;
    border:none;
  }
  .form-check-input[type="radio"]:checked{
    background-image: none;
    background-color: #02077D;
  }
  .bg-success{
    background-color: rgb(207 215 211) !important;
    color: #0421CA;
    padding: 10px;
    border-radius: 30px;
  }
  .bg-round{
      background-color: #0421CA !important;
      color: white;
      padding:10px;
      border-radius: 30px;
  }
  .recommended-badge {
    opacity: 0;
    transform: translateY(-4px);
    pointer-events: none;
    transition: opacity 0.25s ease, transform 0.25s ease;
  }

  .recommended-badge.show {
    opacity: 1;
    transform: translateY(0);
    pointer-events: auto;
  }
  .subscription-card{
    display: flex;
    gap:10px;
    width: 100%;
    align-items: center;
  }
  .subscription-card img{
    object-fit: cover;
    max-width: 60px;
    width: 100%;
    border-radius:15px
  }
</style>

<main class="mb-5">
  <div class="container">
    <div class="my-5 text-center">
      <p class="fs-3 fw-bold mb-1">Choose Your Package</p>
      <div class="row g-4 justify-content-center flex-column m-4 align-items-center">

        <!-- Toggle Card -->
        <div class="col-lg-5 col-md-8 mt-2">
          <div class="card shadow-sm border-0 rounded-4">
            <div class="card-body">

              <div class="d-flex justify-content-center align-items-center gap-3">
                <span class="fw-semibold">Monthly</span>

                <div class="form-check form-switch fs-5 ">
                <input class="form-check-input" type="checkbox" id="billingToggle">
                </div>

                <span class="fw-semibold" style="color: #0421CA;">
                  Yearly
                  <span class="badge bg-success ms-1">Save 16%</span>
                </span>
              </div>

            </div>
          </div>
        </div>

        <!-- Pricing Card -->
        <div class="col-lg-5 col-md-8 mt-2">
          <div class="card pricing-card shadow-lg border-0 rounded-4 h-100">

            <div class="card-body text-start">

            <div class="d-flex align-items-center justify-content-between">
              <h4 class="fw-bold mb-2">Plus</h4>
              <span class="badge bg-primary mb-2 bg-round recommended-badge" id="recommendedBadge" >Recommended</span>
            </div>

              <div class="price display-6 fw-bold" id="priceText">
                $9.99/mo
              </div>

              <div class="text-muted mb-3" id="billingText">
                Billed monthly
              </div>

              <p class="">
                Upgrade to unlock expanded data, attorney discovery, quote comparisons,
                and legal guidance across all practice areas.
              </p>

              <ul class="list-unstyled small mt-3 text-muted">
                <li class="mb-2 d-flex gap-2"><div>✔</div> Arrest Details - View available arrest and booking information powered by integrated public arrest data to help attorneys act faster.</li>
                <li class="mb-2 d-flex gap-2"><div>✔</div> Find Attorney - Discover verified attorneys, compare quotes, schedule consultations, and hire directly in the app.</li>
                <li class="mb-2 d-flex gap-2"><div>✔</div> Add Incident - Create a legal request across any practice area, for yourself or someone else.</li>
              </ul>

              <button class="btn btn-primary w-100 py-2 mt-3 bg-round" id="subscribeBtn">
                Upgrade to Plus
              </button>

            </div>
          </div>
        </div>

        <div class="col-md-6 d-none">
          <div class="input-group mb-3">
            <label class="form-check-label fw-bold" for="check2">
              Enter Promo Code
            </label>
            <input type="text" class="form-control" id="couponCode" placeholder="Coupon Code">
          </div>
        </div>
      </div>
    </div>

    <!-- Subscription Modal -->
    <div class="modal fade" id="subscriptionModal" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content rounded-4">
          <div class="modal-header">
            <h5 class="modal-title">Your Subscription</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
          <div class="subscription-card d-flex mt-2 mb-2">
            <img src="../assets/images/appIcon.png" alt="" />
            <div class="subscription-title">
              <h5 class="title">User Subscription</h5>
              <p id="subscriptionType" class="m-0">Type: —</p>
              
            </div>
          </div>
            <p id="subscriptionDue">Renews On: —</p>
            <p id="subscriptionPrice">Price: —</p>

            <hr>

            <div class="mb-3">
              <label class="form-label fw-bold">Update Plan:</label>
              <select id="subscriptionPlanSelect" class="form-select">
                <option value="monthly">Monthly Subscription (1 month) <span class="text-right">$99.99</span></option>
                <option value="yearly">Yearly Subscription (1 year) <span>$999.99</span></option>
              </select>
            </div>

            <button id="updateSubscriptionBtn" class="btn btn-primary w-100 mb-2">
              Update Subscription
            </button>
            <button id="cancelSubscriptionBtn" class="btn btn-outline-danger w-100">
              Cancel Subscription
            </button>
            <p class="mt-2 text-muted small" id="cancelInfo">
              If you cancel now, you can still access your subscription until —.
            </p>
          </div>
        </div>
      </div>
    </div>

  </div>
</main>

<script src="https://js.stripe.com/v3/"></script>

<script>
  firebase.initializeApp(firebaseConfig);
  const db = firebase.firestore();
  const auth = firebase.auth();

  // DOM Elements
  const billingToggle = document.getElementById("billingToggle");
  const priceText = document.getElementById("priceText");
  const billingText = document.getElementById("billingText");
  const recommendedBadge = document.getElementById("recommendedBadge");
  const subscribeBtn = document.getElementById("subscribeBtn");
  const couponInput = document.getElementById("couponCode");

  let selectedPlan = "monthly";
  let currentUser, currentUserData;

  const PRICE_IDS = {
    monthly: "price_1SuaXSDBtwv2fMPqhUULEWc7",
    yearly:  "price_1SuaYHDBtwv2fMPqIkL76pEL"
  };
  const API_BASE =
    "https://us-central1-freeme-6e63a.cloudfunctions.net/subscriptionApi/subscription";

  async function startCheckout(userId, plan) {
    try {
      const priceId = PRICE_IDS[plan];
      if (!priceId) {
        throw new Error("Invalid plan selected");
      }

      const res = await fetch(
        `${API_BASE}/create-checkout`,
        {
          method: "POST",
          headers: {
            "Content-Type": "application/json"
          },
          body: JSON.stringify({
            userId: userId,
            priceId: priceId,
            type: "Users",
            successUrl: "<?= base_url('site/success') ?>",
            cancelUrl: "<?= base_url('site/cancel') ?>"
          })
        }
      );

      if (!res.ok) {
        throw new Error("Failed to create checkout session");
      }

      const data = await res.json();
      console.log("data", data);

      if (!data.url) {
        throw new Error("Checkout URL not returned");
      }

      // Redirect to Stripe
      window.location.href = data.url;

    } catch (err) {
      console.error("Checkout error:", err);
      Swal.fire("Error", err.message, "error");
    }
  }

  // ✅ Helper function to set user's current plan on toggle
  function setUserPlan(userPriceId) {
    // Determine if user has yearly or monthly plan
    if (userPriceId === PRICE_IDS.yearly) {
      billingToggle.checked = true;
      selectedPlan = "yearly";
      priceText.textContent = "$99.00/yr";
      billingText.textContent = "Save 16% with yearly billing";
      recommendedBadge.classList.add("show");
    } else if (userPriceId === PRICE_IDS.monthly) {
      billingToggle.checked = false;
      selectedPlan = "monthly";
      priceText.textContent = "$9.99/mo";
      billingText.textContent = "Billed monthly";
      recommendedBadge.classList.remove("show");
    }
  }

  // ✅ Helper to format dates as 27-Feb-2026
  function formatSubscriptionDate(date) {
    const day = String(date.getDate()).padStart(2, "0");
    const monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    const month = monthNames[date.getMonth()];
    const year = date.getFullYear();
    return `${day}-${month}-${year}`;
  }

  function normalizeToDate(value) {
    if (!value) return null;

    // Firestore Timestamp
    if (typeof value === "object" && typeof value.toDate === "function") {
      return value.toDate();
    }

    // Milliseconds timestamp (number)
    if (typeof value === "number") {
      return new Date(value);
    }

    return null;
  }


  // -------------------
  // Auth & subscription check
  // -------------------
  auth.onAuthStateChanged(async (user) => {
    if (!user) {
      Swal.fire("Login Required", "Please login to continue.", "warning");
      subscribeBtn.disabled = true;
      return;
    }

    currentUser = user;

    try {
      const userDoc = await db.collection("Users").doc(user.uid).get();
      if (!userDoc.exists) throw new Error("User record not found.");

      currentUserData = userDoc.data();
      console.log("Current user data:", currentUserData);

      // Check subscription statuses
      // const isLegacyActive = currentUserData.subscription_active === true;
      const isStripeActive = currentUserData.subscriptionStatus === "active";
      const userPriceId = currentUserData.subscriptionPriceId;

      // Show "Manage Subscription" ONLY if subscription is currently "active"
      if (isStripeActive) {
        // ✅ Set toggle to user's current plan
        if (userPriceId) {
          setUserPlan(userPriceId);
        }

        subscribeBtn.innerText = "Manage Subscription";
        subscribeBtn.classList.remove("btn-primary");
        subscribeBtn.classList.add("btn-outline-secondary");
        subscribeBtn.disabled = false;

        subscribeBtn.onclick = async (e) => {
          e.preventDefault();

          // Populate modal with current subscription data
          const modal = new bootstrap.Modal(document.getElementById("subscriptionModal"));
          
          // const typeText = currentUserData.subscriptionProductId ? "Plus Subscription" : "Plus Subscription";
          const typeText = currentUserData.subscriptionPriceId === PRICE_IDS.monthly 
          ? "Monthly Subscription" 
          : "Yearly Subscription";
          const endDate = normalizeToDate(currentUserData.subscriptionEndDate);

          const dueDate = endDate
            ? formatSubscriptionDate(endDate)
            : "—";
          const priceText = currentUserData.subscriptionPriceId === PRICE_IDS.monthly 
            ? "$9.99/month" 
            : "$99.00/year";

          document.getElementById("subscriptionType").innerText = `Type: ${typeText}`;
          document.getElementById("subscriptionDue").innerText = `Renews On: ${dueDate}`;
          document.getElementById("subscriptionPrice").innerText = `Price: ${priceText}`;
          document.getElementById("cancelInfo").innerText = `If you cancel now, you can still access your subscription until ${dueDate}.`;

          // Set dropdown to current plan
          const select = document.getElementById("subscriptionPlanSelect");
          if (currentUserData.subscriptionPriceId === PRICE_IDS.yearly) {
            select.value = "yearly";
          } else {
            select.value = "monthly";
          }

          modal.show();
        };

      } else {
        // ✅ User does NOT have active subscription
        // Default to yearly with recommended badge
        billingToggle.checked = true;
        billingToggle.dispatchEvent(new Event("change"));

        subscribeBtn.innerText = "Upgrade to Plus";
        subscribeBtn.classList.add("btn-primary");
        subscribeBtn.classList.remove("btn-outline-secondary");
        subscribeBtn.disabled = false;

        subscribeBtn.onclick = () => {
          Swal.fire({
            title: 'Processing...',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
          });
          sessionStorage.setItem("allowSuccessPage", "true");
          startCheckout(currentUser.uid, selectedPlan);
        };
      }

    } catch (err) {
      console.error("Auth or Firestore error:", err);
      Swal.fire("Error", err.message || "Failed to load subscription status.", "error");
      subscribeBtn.disabled = true;
    }
  });

  // ✅ Update Subscription Button Handler
  document.getElementById("updateSubscriptionBtn").onclick = async () => {
    const plan = document.getElementById("subscriptionPlanSelect").value;

    // If user selects same plan, show info message
    if ((plan === "monthly" && currentUserData.subscriptionPriceId === PRICE_IDS.monthly) ||
        (plan === "yearly" && currentUserData.subscriptionPriceId === PRICE_IDS.yearly)) {
      Swal.fire("Info", "You are already on this plan.", "info");
      return;
    }

    // Close modal and redirect to Stripe checkout to upgrade/downgrade
    bootstrap.Modal.getInstance(document.getElementById("subscriptionModal")).hide();
    sessionStorage.setItem("allowSuccessPage", "true");
    startCheckout(currentUser.uid, plan);
  };

  // ✅ Cancel Subscription Button Handler
  document.getElementById("cancelSubscriptionBtn").onclick = async () => {
    try {
      const result = await Swal.fire({
        title: 'Cancel Subscription?',
        text: "Your subscription will remain active until the end of the billing period.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, cancel it',
        cancelButtonText: 'No, keep it'
      });

      if (!result.isConfirmed) return;

      Swal.fire({
        title: 'Cancelling subscription...',
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
      });

      const res = await fetch(`${API_BASE}/cancel`, {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({
          userId: currentUser.uid,
          type: "Users",
        })
      });

      if (!res.ok) throw new Error("Cancellation failed");

      // Close modal
      bootstrap.Modal.getInstance(document.getElementById("subscriptionModal")).hide();

      Swal.fire("Cancelled", "Your subscription will end at the current billing period.", "success")
        .then(() => window.location.reload());

    } catch (err) {
      console.error(err);
      Swal.fire("Error", err.message || "Unable to cancel subscription", "error");
    }
  };

  // -------------------
  // Plan toggle handler
  // -------------------
  billingToggle.addEventListener("change", () => {
    if (billingToggle.checked) {
      selectedPlan = "yearly";
      priceText.textContent = "$99.00/yr";
      billingText.textContent = "Save 16% with yearly billing";
      recommendedBadge.classList.add("show");
    } else {
      selectedPlan = "monthly";
      priceText.textContent = "$9.99/mo";
      billingText.textContent = "Billed monthly";
      recommendedBadge.classList.remove("show");
    }
  });
</script>

