<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<!-- Bootstrap Icons -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
<!-- main -->
<style>
  .pro-image {
    width: 200px;
    height: 200px;
    border-radius: 50%;
    object-fit: cover;
    cursor: pointer;
  }

  .select2-container--default .select2-selection--multiple {
    border-radius: 15px;
    filter: drop-shadow(0px 5px 7.5px rgba(0, 0, 0, 0.05));
    background-color: #ffffff;
    padding-block: 0.6rem;
  }

  .select2-container--default .select2-selection--multiple.select2-selection--clearable {
    display: flex;
    border-radius: 15px;
    border: none;
    filter: drop-shadow(0px 5px 7.5px rgba(0, 0, 0, 0.05));
  }
  .selection .select2-selection.select2-selection--multiple{
    border-radius: 15px;
    filter: drop-shadow(0px 5px 7.5px rgba(0, 0, 0, 0.05));
    background-color: #ffffff;
    padding-block: 0.7rem;
    border:none;
    display: block;
    width: 100%;
    transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
  }

  /* Card style */
.profile-card {
  background: linear-gradient(180deg, #0412CA 0%, #F5F6FB 30%, #F5F6FB 80%);
  border-radius: 16px;
  box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
}

/* Make form fields readable on gradient */
.profile-card .professional_section_title {
  /* color: #ffffff; */
}

.profile-card .custom-input,
.profile-card .form-control,
.profile-card .form-select {
  background-color: #ffffff;
  border-radius: 10px;
}

.image-label {
  display: inline-block;   /* 🔑 limits clickable area */
  cursor: pointer;
}

.pro-image {
  width: 120px;            /* adjust size as needed */
  height: 120px;
  object-fit: cover;
  border-radius: 50%;
}
.image-label:hover .pro-image {
  transform: scale(1.05);
  transition: 0.2s ease;
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.25);
}
.profile-card label{
  color: #606060;
}


</style>

<main class="">
  <div class="container my-3">
    <div class="">
      <div class="row justify-content-center">
        <div class="col-md-7">
          <div class="profile-card p-4 p-md-5">
            <div class="row my-2 g-2 justify-content-center">
              <p class="fs-1 text-center professional_section_title text-white" data-i18n="professional_info"> 
              </p>
              <div class="col-md-12 text-center">
                <label for="pro-Image" class="image-label">
                  <img
                    class="pro-image"
                    src="../assets/images/th.jpeg"
                    alt="Profile Picture"
                    id="professionalImage"
                  />
                </label>
              </div>
            </div>
            <form class="my-2" id="profileForm">
              <div class="row g-2 mb-5">
                <input type="file" id="pro-Image" class="d-none" accept="image/*">
                
                <div class="col-md-12">
                  <label for="professionalName" class="custom-label mb-2" data-i18n="lawfirm_name">Law Firm Name</label>
                  <input class="form-control custom-input" type="text" name="professionalName" id="professionalName" required />
                </div>

                <div class="col-md-12">
                  <label for="mobile" class="custom-label mb-2" data-i18n="mobile_label"></label>
                  <input class="form-control custom-input" type="tel" id="mobile" name="mobile" />
                </div>

                <div class="col-md-12">
                  <label for="email" class="custom-label mb-2" data-i18n="email_label"></label>
                  <input class="form-control custom-input" type="email" id="email" name="email" />
                </div>
                
                <div class="col-md-12">
                  <label for="language" class="custom-label mb-2" data-i18n="language">Language</label>
                  <select class="form-control custom-input" id="language" name="language" multiple required>
                    <option value="English">English</option>
                    <option value="Spanish">Spanish</option>
                    <option value="Mandarin Chinese">Mandarin Chinese</option>
                    <option value="Arabic">Arabic</option>
                    <option value="Vietnamese">Vietnamese</option>
                    <option value="Haitian Creole">Haitian Creole</option>
                    <option value="Portuguese (Brazilian)">Portuguese (Brazilian)</option>
                    <option value="Tagalog (Filipino)">Tagalog (Filipino)</option>
                    <option value="Russian">Russian</option>
                    <option value="Ukrainian">Ukrainian</option>
                    <option value="Farsi">Farsi (Persian)</option>
                    <option value="Dari">Dari</option>
                    <option value="Pashto">Pashto</option>
                    <option value="Punjabi">Punjabi</option>
                    <option value="Hindi">Hindi</option>
                    <option value="Urdu">Urdu</option>
                    <option value="Amharic">Amharic</option>
                    <option value="Tigrinya">Tigrinya</option>
                    <option value="Somali">Somali</option>
                    <option value="Bengali">Bengali</option>
                    <option value="Nepali">Nepali</option>
                    <option value="K’iche’">K’iche’</option>
                    <option value="Mam">Mam</option>
                    <option value="Q’eqchi’">Q’eqchi’</option>
                    <option value="French">French</option>
                  </select>
                </div>
                
                <div class="col-md-12">
                  <label for="barNumber" class="custom-label mb-2">Bar Number</label>
                  <input class="form-control custom-input" type="text" name="barNumber" id="barNumber" required />
                </div>

                <div class="col-md-12">
                  <label for="areas" class="custom-label mb-2" data-i18n="practice_areas_label">
                    Practice Areas
                  </label>

                  <select class="form-select custom-input" id="areas" name="areas" multiple required>
                    <option value="Criminal Defense">Criminal Defense</option>
                    <option value="Traffic / Criminal Defense">Traffic / Criminal Defense</option>
                    <option value="Immigration Law">Immigration Law</option>
                    <option value="Personal Injury">Personal Injury</option>
                    <option value="Family Law">Family Law</option>
                    <option value="Employment Law">Employment Law</option>
                    <option value="Business / Corporate Law">Business / Corporate Law</option>
                    <option value="Real Estate">Real Estate</option>
                    <option value="Bankruptcy Law">Bankruptcy Law</option>
                    <option value="Tax Law">Tax Law</option>
                    <option value="Civil Litigation / Consumer Protection">Civil Litigation / Consumer Protection</option>
                    <option value="General Practice">General Practice</option>
                  </select>
                </div>
                
                

                <!-- <div class="col-md-12">
                  <label for="clandlyToken" class="custom-label mb-2">Calendly Token</label>
                  <input class="form-control custom-input" type="text" name="clandlyToken" id="clandlyToken" />
                </div> -->


                <div class="col-md-12">
                  <label for="clandlyToken" class="custom-label mb-2 d-flex align-items-center gap-1">
                    <span data-i18n="clandlyToken"></span>

                  <i
                    class="bi bi-info-circle-fill text-primary"
                    tabindex="0"
                    data-bs-toggle="popover"
                    data-bs-trigger="focus"
                    data-bs-html="true"
                    data-bs-placement="right"
                    data-bs-content="
                      <strong>How to generate Calendly Token</strong>
                      <ol style='padding-left:16px; margin-top:8px;'>
                        <li>Log in to Calendly and complete MFA if prompted</li>
                        <li>Open <b>Menu → Integrations & apps</b></li>
                        <li>Tap <b>API & Webhooks</b></li>
                        <li>
                          Under <b>Personal access tokens</b>,
                          tap <b>Get a token now → Continue</b>
                        </li>
                        <li>
                          Name your token (e.g. <i>DuePro Integration</i>) and tap
                          <b>Create token</b>. Complete MFA if prompted
                        </li>
                        <li>Copy the generated token and store it securely</li>
                        <li>
                          Open <b>DuePro → Law Firm Info → Calendly Token field → Paste token → Tap Update</b>
                        </li>
                      </ol>
                    "
                    style="cursor: pointer;margin-left: auto;margin-right: 15px;"
                  ></i>

                  </label>

                  <input class="form-control custom-input" id="clandlyToken" name="clandlyToken" />
                </div>

                <div class="col-md-12">
                  <label for="bio" class="custom-label mb-2">Bio</label>
                  <textarea class="form-control custom-input" name="bio" id="bio" rows="4"></textarea>
                </div>

                <div class="col-md-12 mt-4">
                  <div class="row justify-content-center">
                    <div class="col-md-12">
                      <button type="submit" id="updateBtn" class="btn btn-save w-100 text-white" data-i18n="save">Save Profile</button>
                    </div>
                  </div>
                </div>

              </div>
            </form>

            <div class="modal fade" id="acceptInviteModal" tabindex="-1">
              <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                  <div class="modal-header justify-content-center">
                    <h5 class="modal-title ">Firm Invitation to Join</h5>
                  </div>
                  <div class="modal-body ">
                    <div class="text-center">
                      <p id="inviteText"></p>
                    </div>
                    
                    <div class="card-wrapper">
                      <div class="d-flex align-items-center gap-3 mt-3">
                      <img id="inviteFirmImage" src="../assets/images/th.jpeg" alt="Firm Image" width="80" height="80" class="rounded">
                      <div class="text-start">
                        <p id="inviteFirmName"></p>
                        <p id="inviteFirmAdmin">Firm Admin</p>
                      </div>
                    </div>
                    <div class="">
                      <p id="inviteFirmLocation"><i class="fa-solid fa-location-dot"></i> Location</p>
                      <p id="inviteFirmPhone"><i class="fa-solid fa-phone"></i> Phone</p>
                      <p id="inviteFirmWebsite"><i class="fa-solid fa-globe"></i> Website</p>
                    </div>
                    </div>

                    <div class="d-flex gap-3 justify-content-between mt-4">
                      <button class="btn btn-danger" id="rejectInviteBtn">Decline</button>
                      <button class="btn btn-success" id="acceptInviteBtn">Accept</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>



<script>
  const db = firebase.firestore();
  const storage = firebase.storage();
  let selectedImageFile = null;

    // Firebase Auth State
  firebase.auth().onAuthStateChanged(async (user) => {
    if (user) {
      try {
        const doc = await db.collection("LawFirm").doc(user.uid).get();
        
        if (doc.exists) {
          const data = doc.data();
          console.log(data,"data");
          
          const defaultImage = "../assets/images/th.jpeg";
          
          // Set form values
          document.getElementById("professionalImage").src = data.professionalPic || defaultImage;
          document.getElementById("professionalName").value = data.professionalName || "";
          document.getElementById("barNumber").value = data.professionalBarNumber || "";
          document.getElementById("clandlyToken").value = data.clandlyToken || "";
          document.getElementById("bio").value = data.professionalBio || "";
          document.getElementById("email").value = data.email || "";
          document.getElementById("mobile").value = data.phone || "";

          if (Array.isArray(data.practiceAreas) && data.practiceAreas.length > 0) {
            $('#areas').val(data.practiceAreas).trigger('change');
          }

          if (Array.isArray(data.professionalLanguage) && data.professionalLanguage.length > 0) {
            $('#language').val(data.professionalLanguage).trigger('change');
          }

          // Store existing Calendly data for reference
          if (data.uri && data.scheduleEvent) {
            document.getElementById('clandlyToken').setAttribute('data-uri', data.uri);
            document.getElementById('clandlyToken').setAttribute('data-event', data.scheduleEvent);
          }
        }
      } catch (error) {
        console.error("Error fetching user data:", error);
        Swal.fire("Error", "Unable to load profile data.", "error");
      }
    } else {
      Swal.fire("Not Logged In", "Please login to view your profile.", "warning");
      window.location.href = "/";
    }
  });

  // ============================================
  // CALENDLY API FUNCTIONS
  // ============================================
  async function fetchCalendlyUserURI(accessToken) {
    try {
      const response = await fetch("https://api.calendly.com/users/me", {
        method: "GET",
        headers: {
          "Authorization": `Bearer ${accessToken}`,
          "Content-Type": "application/json"
        }
      });

      if (!response.ok) {
        throw new Error(`Calendly API Error: ${response.status}`);
      }

      const data = await response.json();
      return data.resource.uri;
    } catch (error) {
      console.error("Error fetching Calendly user URI:", error);
      throw error;
    }
  }

  async function fetchCalendlyEventTypes(accessToken, userUri) {
    try {
      const response = await fetch(
        `https://api.calendly.com/event_types?user=${encodeURIComponent(userUri)}`,
        {
          method: "GET",
          headers: {
            "Authorization": `Bearer ${accessToken}`,
            "Content-Type": "application/json"
          }
        }
      );

      if (!response.ok) {
        throw new Error(`Calendly Event Types Error: ${response.status}`);
      }

      const data = await response.json();
      return data.collection || [];
    } catch (error) {
      console.error("Error fetching Calendly event types:", error);
      throw error;
    }
  }

  // Initialize Select2
  $(document).ready(function() {
    $('#areas').select2({
      placeholder: "Select practice areas",
      allowClear: true,
      width: '100%',
      closeOnSelect: false
    });

    $('#language').select2({
      placeholder: "Select languages",
      allowClear: true,
      width: '100%',
      closeOnSelect: false
    });

    // Initialize Bootstrap Popovers
    const popoverTriggerList = [].slice.call(
      document.querySelectorAll('[data-bs-toggle="popover"]')
    );
    popoverTriggerList.forEach(function (popoverTriggerEl) {
      new bootstrap.Popover(popoverTriggerEl);
    });
  });

  // Image Upload Preview
  document.getElementById("pro-Image").addEventListener("change", (e) => {
    selectedImageFile = e.target.files[0];
    
    if (selectedImageFile) {
      // Validate file type
      if (!selectedImageFile.type.startsWith('image/')) {
        Swal.fire("Invalid File", "Please select an image file.", "error");
        selectedImageFile = null;
        return;
      }
      
      // Validate file size (max 5MB)
      if (selectedImageFile.size > 5 * 1024 * 1024) {
        Swal.fire("File Too Large", "Please select an image smaller than 5MB.", "error");
        selectedImageFile = null;
        return;
      }
      
      const reader = new FileReader();
      reader.onload = function(event) {
        document.getElementById("professionalImage").src = event.target.result;
      };
      reader.readAsDataURL(selectedImageFile);
    }
  });

  // Form Submission
  document.getElementById("profileForm").addEventListener("submit", async function(e) {
    e.preventDefault();
    
    const user = firebase.auth().currentUser;
    if (!user) {
      Swal.fire("Error", "User not logged in.", "error");
      return;
    }
    
    const selectedPracticeAreas = $('#areas').val();
    if (!selectedPracticeAreas || selectedPracticeAreas.length === 0) {
      Swal.fire("Validation Error", "Please select at least one practice area.", "warning");
      return;
    }
    
    const selectedLanguages = $('#language').val();
    if (!selectedLanguages || selectedLanguages.length === 0) {
      Swal.fire("Validation Error", "Please select at least one language.", "warning");
      return;
    }

    // Get Calendly token
    const calendlyToken = document.getElementById('clandlyToken').value.trim();

    // Get existing Calendly data from Firestore
    let existingCalendlyToken = null;
    let existingScheduleEvent = null;

    try {
      const lawFirmSnap = await db.collection("LawFirm").doc(user.uid).get();
      if (lawFirmSnap.exists) {
        const lawFirmData = lawFirmSnap.data();
        existingCalendlyToken = lawFirmData.clandlyToken || null;
        existingScheduleEvent = lawFirmData.scheduleEvent || null;
      }
    } catch (error) {
      console.error("Error fetching existing law firm data:", error);
    }

    // Check if Calendly token changed or scheduleEvent is missing
    const isCalendlyTokenChanged = calendlyToken && calendlyToken !== existingCalendlyToken;
    const isScheduleEventMissing = !existingScheduleEvent || existingScheduleEvent === "";

    // Only sync Calendly if token changed or event is missing
    if (calendlyToken && (isCalendlyTokenChanged || isScheduleEventMissing)) {
      try {
        Swal.fire({
          title: "Syncing...",
          text: "Connecting to Calendly...",
          allowOutsideClick: false,
          allowEscapeKey: false,
          didOpen: () => {
            Swal.showLoading();
          },
        });

        // Validate token by fetching user URI
        const calendlyUserUri = await fetchCalendlyUserURI(calendlyToken);
        
        // Fetch event types
        const eventTypes = await fetchCalendlyEventTypes(calendlyToken, calendlyUserUri);
        
        if (!eventTypes || eventTypes.length === 0) {
          throw new Error("No event types found in your Calendly account");
        }

        // Prepare modal options
        const eventOptions = {};
        eventTypes.forEach(event => {
          eventOptions[event.uri] = `${event.name} (${event.duration} mins)`;
        });

        Swal.close();

        // Show event selection modal
        const { value: selectedEventUri, isDismissed } = await Swal.fire({
          title: "Select Consultation Type",
          input: "select",
          inputOptions: eventOptions,
          inputPlaceholder: "Select an event",
          showCancelButton: true,
          confirmButtonText: "Save Selection",
          cancelButtonText: "Cancel",
          inputValidator: value => !value ? "Please select an event" : null
        });

        if (isDismissed || !selectedEventUri) {
          Swal.fire({
            icon: "info",
            title: "Calendly Sync Cancelled",
            text: "Profile will be saved without Calendly integration.",
            timer: 2000,
            showConfirmButton: false
          });
          // Continue with normal save without Calendly
        } else {
          // Store Calendly data in hidden attributes temporarily
          document.getElementById('clandlyToken').setAttribute('data-uri', calendlyUserUri);
          document.getElementById('clandlyToken').setAttribute('data-event', selectedEventUri);

          Swal.fire({
            icon: "success",
            title: "Calendly Synced",
            text: "Event type selected successfully!",
            timer: 1500,
            showConfirmButton: false
          });
        }

      } catch (error) {
        console.error("Calendly sync error:", error);
        const { isConfirmed } = await Swal.fire({
          icon: "error",
          title: "Calendly Sync Failed",
          text: error.message || "Invalid Calendly token. Continue without Calendly?",
          showCancelButton: true,
          confirmButtonText: "Continue Anyway",
          cancelButtonText: "Cancel"
        });

        if (!isConfirmed) {
          return; // Stop form submission
        }
      }
    }
    
    // Now proceed with saving the profile
    Swal.fire({
      title: "Please wait...",
      text: "Updating your profile",
      allowOutsideClick: false,
      allowEscapeKey: false,
      didOpen: () => {
        Swal.showLoading();
      }
    });

    const updatedData = {
      professionalName: document.getElementById("professionalName").value.trim(),
      professionalLanguage: selectedLanguages,
      professionalBarNumber: document.getElementById("barNumber").value.trim(),
      practiceAreas: selectedPracticeAreas,
      professionalBio: document.getElementById("bio").value.trim(),
      email: document.getElementById("email").value.trim(),
      phone: document.getElementById("mobile").value.trim(),
      updatedAt: Date.now(),
    };

    // Add / Remove Calendly info
    if (!calendlyToken || calendlyToken.trim() === "") {
      // ❌ Token removed → wipe Calendly data
      updatedData.clandlyToken = firebase.firestore.FieldValue.delete();
      updatedData.uri = firebase.firestore.FieldValue.delete();
      updatedData.scheduleEvent = firebase.firestore.FieldValue.delete();
    } else {
      // ✅ Token exists
      const calendlyUserUri = document
        .getElementById('clandlyToken')
        .getAttribute('data-uri');

      const calendlyEventUri = document
        .getElementById('clandlyToken')
        .getAttribute('data-event');

      if (calendlyUserUri && calendlyEventUri) {
        // Fresh or re-synced Calendly data
        updatedData.clandlyToken = calendlyToken;
        updatedData.uri = calendlyUserUri;
        updatedData.scheduleEvent = calendlyEventUri;
      } else if (existingCalendlyToken === calendlyToken) {
        // Token unchanged → keep existing
        updatedData.clandlyToken = calendlyToken;
      }
    }


    try {
      // Upload image if selected
      if (selectedImageFile) {
        const storageRef = storage.ref(`profileImages/${user.uid}/${Date.now()}_${selectedImageFile.name}`);
        const snapshot = await storageRef.put(selectedImageFile);
        const downloadURL = await snapshot.ref.getDownloadURL();
        updatedData.professionalPic = downloadURL;
      }

      // Update Firestore
      await db.collection("LawFirm").doc(user.uid).update(updatedData);
      
      const successMessage = calendlyToken && updatedData.scheduleEvent
        ? "Your profile has been updated successfully with Calendly integration!"
        : "Your profile has been updated successfully.";

      Swal.fire({
        title: "Success!",
        text: successMessage,
        icon: "success"
      });
      
      // Reset image file after successful upload
      selectedImageFile = null;

    } catch (error) {
      console.error("Error updating profile:", error);
      Swal.fire("Update Failed", error.message || "An error occurred while updating your profile.", "error");
    }
  });

</script>

<script src="<?= base_url('/assets/js/model.js'); ?>"></script>
