<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<style>
.atr-img-p {
  width: 100%;
  height: 220px ;
}

.positionABS {
  position: absolute;
  bottom: 0;
  right: 0;
}

.atr-img-p{
  width: 150px;
  height: 150px;
  border-radius: 50%;
  object-fit: cover;
}

@media(max-width:768px) {
  /* .btn-video {
    width: 100%;
  } */

  .positionABS {
    position: static;

  }
}

.flatpickr-calendar {
  border-right: none !important;
  overflow: clip;
}

.swal2-html-container {
  display: flex !important;
}

.btn-consult {
  max-width: 110px;
  width: 100%;
  padding: 10px;
  font-size: 14px;
  line-height: 1.2;
  border-radius: 6px;
  border: none;
  transition:
    background-color 0.2s ease,
    box-shadow 0.2s ease,
    transform 0.1s ease;
}

.btn-cancel {
  color: #fff !important;
  background-color: #dc3545;
}

.btn-cancel:hover {
  color: #fff !important;
  background-color: #b52a37;
}

.btn-reschedule {
  color: #fff !important;
  background-color: #0412CA;
}

.btn-reschedule:hover {
  color: #fff !important;
  background-color: #020ea0;
  /* darker */
}

.btn-join {
  color: #fff !important;
  background-color: #02077D;
}


.btn-join:hover {
  color: #fff !important;
  background-color: #01055a;
  /* darker */
}

.btn-consult:focus,
.btn-consult:active,
.btn-consult:focus-visible {
  outline: none !important;
  box-shadow: none !important;
}

.btn-consult:active {
  background-color: #02077D !important;
  transform: scale(0.97);
}

.btn-consult:disabled {
  background-color: #292c83ff !important;
  transform: scale(0.97);
}

.clearDate {
  position: absolute;
  padding: 0 5px;
  right: 20px;
  top: 45%;
  transform: translateY(-50%);
  cursor: pointer;
  font-weight: bold;
  color: #888;
}
/* Full width calendar styling */
.flatpickr-calendar {
  width: 100%;
  max-width: 100%;
}
.flatpickr-month{
      border-top: 4px solid #0412CA;
    margin-bottom: 10px;
}
.flatpickr-innerContainer .flatpickr-day.selected{
      background: #0412CA;
}

.flatpickr-days,
.flatpickr-weekdays,
.flatpickr-innerContainer,
.flatpickr-rContainer {
  width: 100%;
  display: block;
}

.flatpickr-calendar.inline {
  width: 100%;
  margin-top: 15px;
}

.dayContainer {
  max-width: none;
  width: 100%;
}

.flatpickr-day {
  max-width: none;
  width: 15% !important;
}

/* .flatpickr-days {
  width: 100%;
  display: block;
}

.flatpickr-weekdays {
  width: 100%;
}

.flatpickr-rContainer {
  width: 100%;
}

.flatpickr-innerContainer {
  display: block;
  width: 100%;
}

.flatpickr-calendar.animate.inline {
  width: 100%;
  margin-top: 15px;
}

.dayContainer {
  max-width: none;
  width: 100%;
}

.flatpickr-day{
  max-width: none;
  width: 15% !important;
} */

</style>
<main class="mb-5">
  <div class="container">
    <div class="my-5">
      <div class="d-flex justify-content-center">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs n-tabs gap-2 justify-content-center w-fit" id="contentTabs" role="tablist">
          <li class="nav-item" role="presentation">
            <button class="nav-link active" id="articles-tab" data-bs-toggle="tab" data-bs-target="#articles"
              type="button" role="tab" aria-controls="articles" aria-selected="true" data-i18n="active_quotes"></button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="videos-tab" data-bs-toggle="tab" data-bs-target="#videos" type="button"
              role="tab" aria-controls="videos" aria-selected="false" data-i18n="inactive_quotes"></button>
          </li>

          <li class="nav-item" role="presentation">
            <button class="nav-link" id="consults-tab" data-bs-toggle="tab" data-bs-target="#consults" type="button"
              role="tab" aria-controls="consults" aria-selected="false">
              Consults
            </button>

          </li>
        </ul>

      </div>

      <!-- Tab panes -->
      <div class="tab-content" id="contentTabsContent">
        <div class="tab-pane fade show active" id="articles" role="tabpanel" aria-labelledby="articles-tab">
          <div class="row">
            <div class="col-md-12 my-2">
              <form class="d-flex position-relative mt-2 mt-md-0" role="search">
                <input class="form-control me-2 search w-100 bg-white pe-4" type="search" placeholder="Search"
                  aria-label="Search" style="width: 350px" />
                <img src="<?= base_url('assets/images/icons/searchicon.png') ?>" alt="" width="15px" height="15px"
                  class="searchIcon" />
              </form>
            </div>
          </div>
          <div class="row my-2">


            <div class="col-md-12 my-2">
              <button class="btn btnLoad d-block mx-auto btn-same" data-i18n="load_more"></button>
            </div>
          </div>
        </div>
        <div class="tab-pane fade" id="videos" role="tabpanel" aria-labelledby="videos-tab">
          <div class="row">
            <div class="col-md-12 my-2">
              <form class="d-flex position-relative mt-2 mt-md-0" role="search">
                <input class="form-control me-2 search w-100 bg-white pe-4" type="search" placeholder="Search"
                  aria-label="Search" style="width: 350px" />
                <img src="<?= base_url('assets/images/icons/searchicon.png') ?>" alt="" width="15px" height="15px"
                  class="searchIcon" />
              </form>
            </div>
          </div>
          <div class="row my-2">


            <div class="col-md-12 my-2">
              <button class="btn btnLoad d-block mx-auto btn-same" data-i18n="load_more"></button>

            </div>
          </div>
        </div>
        <div class="tab-pane fade" id="consults" role="tabpanel" aria-labelledby="consults-tab">
          <div class="row">
            <div class="col-md-12 my-2 flex-column flex-md-row justify-content-md-between align-items-md-center gap-2">
              <form class="d-flex position-relative mt-2 mt-md-0 w-100" role="search">
                <input class="form-control me-2 search w-100 bg-white pe-4" type="search" placeholder="Search"
                  aria-label="Search" style="width: 350px" />
                <img src="<?= base_url('assets/images/icons/searchicon.png') ?>" alt="" width="15px" height="15px"
                  class="searchIcon" />
              </form>
              <!-- <div class="d-flex justify-content-center position-relative">
                <input class="date-input form-control me-2 search w-100 bg-white pe-4" 
                      id="datePicker" type="text" placeholder="Select Date" />
                <span id="clearDate" class="clearDate">×</span>
              </div> -->
              <!-- hide the input -->
              <input class="date-input form-control me-2 search w-100 bg-white pe-4" id="datePicker" type="text"
                placeholder="Select Date" hidden />

              <!-- calendar container -->
              <div id="calendar"></div>
            </div>
            <div class="row my-2" id="consultsRow">
              <!-- Static consult cards will be inserted here -->
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</main>

<script>(g=>{var h,a,k,p="The Google Maps JavaScript API",c="google",l="importLibrary",q="__ib__",m=document,b=window;b=b[c]||(b[c]={});var d=b.maps||(b.maps={}),r=new Set,e=new URLSearchParams,u=()=>h||(h=new Promise(async(f,n)=>{await (a=m.createElement("script"));e.set("libraries",[...r]+"");for(k in g)e.set(k.replace(/[A-Z]/g,t=>"_"+t[0].toLowerCase()),g[k]);e.set("callback",c+".maps."+q);a.src=`https://maps.${c}apis.com/maps/api/js?`+e;d[q]=f;a.onerror=()=>h=n(Error(p+" could not load."));a.nonce=m.querySelector("script[nonce]")?.nonce||"";m.head.append(a)}));d[l]?console.warn(p+" only loads once. Ignoring:",g):d[l]=(f,...n)=>r.add(f)&&u().then(()=>d[l](f,...n))})
({key: "AIzaSyB0jx5yCf4vk4I5ridEorfPMqohEhpH1H4", v: "weekly"});</script>

<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<script>
  const db = firebase.firestore();
  let active = [], inactive = [];
  let shownActive = 3, shownInactive = 3;
  let activeRow, inactiveRow, activeSearch, inactiveSearch;
  let currentUserId = null;
  let currentUserName = "";
  


  firebase.auth().onAuthStateChanged(async (user) => {
    if (!user) return;
    const uid = user.uid;
    currentUserId = user.uid;
    currentUserName = (await db.collection("Users").doc(currentUserId).get())?.get("Name") || "Unknown";
   
    
    let lastSelectedDate = null; // store toggle state
  
    flatpickr("#calendar", {
      inline: true,          // always show calendar
      dateFormat: "Y-m-d",
      onChange: function(selectedDates) {
        if (!selectedDates.length) return;
  
        const selectedDate = selectedDates[0];
        const selectedStr = selectedDate.toDateString();
  
        // toggle: if same date clicked again, reset filter
        if (lastSelectedDate === selectedStr) {
          lastSelectedDate = null;
          document.querySelectorAll(".flatpickr-day.selected").forEach(d => {
          d.classList.remove("selected");
        });
          loadUserConsults(); // show all consults
  
        } else {
          lastSelectedDate = selectedStr;
          filterConsultsByDate(selectedDate); // show filtered consults
        }
      }
    });

    // const dateInput = document.getElementById("datePicker");

    //   const fp = flatpickr(dateInput, {
    //     dateFormat: "Y-m-d",
    //     mode: "single",
    //     onChange(selectedDates) {
    //       if (!selectedDates.length) return;
    //       filterConsultsByDate(selectedDates[0]);
    //     }
    //   });
    


    //     flatpickr("#calendar", {
    //   inline: true,
    //   dateFormat: "Y-m-d",
    //   onChange(selectedDates) {
    //     if (!selectedDates.length) return;
    //     filterConsultsByDate(selectedDates[0]);
    //   }
    // });




      // document.getElementById("clearDate").addEventListener("click", () => {
      //   fp.clear();
      //   loadUserConsults();
      // });

    activeRow = document.querySelector("#articles .row.my-2");
    inactiveRow = document.querySelector("#videos .row.my-2");
    activeSearch = document.querySelector("#articles .search");
    inactiveSearch = document.querySelector("#videos .search");

    await loadAndRenderQuotes();

    activeRow.addEventListener("click", e => {
      if (e.target.matches(".btnLoad")) renderTab(active, activeRow, shownActive += 3);
      if (e.target.matches(".btn-arrest")) fetchArrestDetails(e.target.dataset.name);
      if (e.target.matches(".btn-video")) showVideos(JSON.parse(e.target.dataset.videos));
      if (e.target.closest(".btn-delete")) {
        const id = e.target.closest(".btn-delete").dataset.id;
        deleteQuote(id);
      }
    });

    inactiveRow.addEventListener("click", e => {
      if (e.target.matches(".btnLoad")) renderTab(inactive, inactiveRow, shownInactive += 3);
      if (e.target.matches(".btn-arrest")) fetchArrestDetails(e.target.dataset.name,e.target.dataset.id);
      if (e.target.matches(".btn-video")) showVideos(JSON.parse(e.target.dataset.videos));
      if (e.target.closest(".btn-delete")) {
        const id = e.target.closest(".btn-delete").dataset.id;
        deleteQuote(id);
      }
    });

    setupSearch(active, activeRow, activeSearch);
    setupSearch(inactive, inactiveRow, inactiveSearch);
  });

  function activateConsultsTab() {
    const consultTabBtn = document.querySelector("#consults-tab");
    const consultTabPane = document.querySelector("#consults");

    document.querySelectorAll("#contentTabs .nav-link")
      .forEach(tab => tab.classList.remove("active"));

    document.querySelectorAll(".tab-content .tab-pane")
      .forEach(pane => pane.classList.remove("active", "show"));

    consultTabBtn.classList.add("active");
    consultTabPane.classList.add("active", "show");
  }


  function filterConsultsByDate(selectedDate) {
    console.log("filterDate", selectedDate);
    
    const consultsRow = document.getElementById("consultsRow");

    // Get all consults from Firestore
    firebase.firestore()
      .collection("Consult")
      .where("attorneyId", "==", firebase.auth().currentUser.uid)
      .get()
      .then(snap => {
        const consults = snap.docs.map(doc => ({ id: doc.id, ...doc.data() }));

        // Filter for selected date
        const start = new Date(selectedDate);
        start.setHours(0,0,0,0);
        const end = new Date(selectedDate);
        end.setHours(23,59,59,999);

        const filtered = consults.filter(c => c.created_at >= start.getTime() && c.created_at <= end.getTime());

        // Render filtered consults
        renderConsults(filtered);
      });
  }

  // Render static consult cards
  const consultsRow = document.getElementById('consultsRow');

  
  async function renderConsults(consults) {
    const consultsRow = document.getElementById("consultsRow");
    consultsRow.innerHTML = "";
    if (consults.length === 0){
      consultsRow.innerHTML =
        `<p class="text-muted text-center">No consults scheduled on this Date</p>`;
      return;
    }

    for (let index = 0; index < consults.length; index++) {
      const c = consults[index];

      // 🔹 Fetch related QuoteAlert document for incident info
      let quoteData = {};
      try {
        const quoteSnap = await db.collection("QuoteAlert").doc(c.documentID).get();
        if (quoteSnap.exists) {
          quoteData = quoteSnap.data();
          console.log("quoteData",quoteData);
          
        }
      } catch (err) {
        console.warn("Failed to fetch quote data:", err);
      }

      const dateObj = new Date(c.created_at);
      const dateStr = dateObj.toLocaleDateString('en-US', {
        weekday: 'short',
        month: 'short',
        day: 'numeric'
      });
      const timeStr = dateObj.toLocaleTimeString('en-US', {
        hour: '2-digit',
        minute: '2-digit'
      });

      consultsRow.insertAdjacentHTML("beforeend", `
        <div class="col-md-12 my-2">
          <div class="card stCard">
            <div class="card-body">

              <!-- HEADER -->
              <div class="d-flex justify-content-between align-items-start mb-2">
                <div>
                  <p class="fp2 mb-1">
                    Consult with ${quoteData.personName || "Unnamed User"}
                  </p>
                  <p class="ft7 mb-0">
                    ${quoteData.incidentDateTime 
                      ? new Date(quoteData.incidentDateTime).toLocaleString() 
                      : "N/A"}
                  </p>
                </div>

                <span class="badge badge-success bg-success align-self-center">
                  Scheduled
                </span>
              </div>

              <hr class="my-2"/>

              <!-- CONTENT -->
              <div class="row g-2">
                <!-- LEFT INFO -->
                <div class="col-md-8">
                  <div class="d-flex flex-column gap-1">

                    <p class="mb-0 info-card-detail">
                      <strong>Incident Type:</strong> ${quoteData.incidentType || "N/A"}
                    </p>

                    <p class="mb-0 info-card-detail">
                      <strong>Meeting Time:</strong> ${dateStr} - ${timeStr}
                    </p>

                    <p class="mb-0 info-card-detail">
                      <strong>Description:</strong>
                      ${quoteData.incidentDescription || "N/A"}
                    </p>

                  </div>
                </div>

                <!-- RIGHT ACTIONS -->
                <div class="col-md-4 d-flex align-items-end justify-content-end">
                  <div class="d-flex gap-2 flex-wrap justify-content-end w-100">

                    <button 
                      class="btn btn-danger btn-cancel btn-consult"
                      data-index="${index}">
                      Cancel
                    </button>

                    <button 
                      class="btn btn-reschedule btn-consult"
                      data-index="${index}">
                      Reschedule
                    </button>

                    <button 
                      class="btn btn-join btn-consult"
                      data-index="${index}">
                      Join Call
                    </button>

                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
      `);
    }

    // Attach Join button click listeners
    consultsRow.querySelectorAll(".btn-join").forEach(btn => {
      btn.addEventListener("click", async (e) => {
        e.stopPropagation(); // ✅ prevent card click

        const idx = btn.dataset.index;
        const data = consults[idx];
        


        if (!data) {
          console.warn("Consult data not found");
          return;
        }

        if (!data.scheduled_event_join_url || !data.token) {
          alert("Unable to join meeting. Missing meeting data.");
          return;
        }

        const inviteIndex = data.scheduled_event_join_url.indexOf("/invitees");
        if (inviteIndex === -1) {
          console.error("Invalid joinCall URL");
          return;
        }

        const scheduledEventURL = data.scheduled_event_join_url.slice(0, inviteIndex);
        

        try {
          btn.disabled = true;
          btn.innerText = "Joining...";

          const res = await fetch(scheduledEventURL, {
            method: "GET",
            headers: {
              Authorization: `Bearer ${data.token}`,
              "Content-Type": "application/json"
            }
          });

          if (!res.ok) {
            throw new Error("Zoom API failed");
          }

          const json = await res.json();
          

          const joinURL = json?.resource?.location?.join_url;
          const password = json?.resource?.location?.data?.password;

          

          if (!joinURL) {
            throw new Error("Join URL missing");
          }

          showZoomAlert(joinURL, password || "N/A");

        } catch (err) {
          console.error("Join call error:", err);
          alert("Failed to join meeting. Please try again.");
        } finally {
          btn.disabled = false;
          btn.innerText = "Join Call";
        }
      });
    });

    // Attach Cancel button listeners
    consultsRow.querySelectorAll(".btn-cancel").forEach(btn => {
      btn.addEventListener("click", async (e) => {
        e.stopPropagation();

        const idx = btn.dataset.index;
        const data = consults[idx];
        if (!data) return;

        const confirmed = await confirmAction(
          "Cancel Consult?",
          "This meeting will be cancelled permanently.",
          "Yes, Cancel"
        );

        if (!confirmed) return; // ⛔ back safely

        try {
          btn.disabled = true;
          btn.innerText = "Cancelling...";

          // 1️⃣ Get attorney Calendly token
          const lawSnap = await db
            .collection("LawFirm")
            .doc(data.attorneyId)
            .get();

          if (!lawSnap.exists) {
            throw new Error("Attorney not found");
          }

          const token = lawSnap.data().clandlyToken;

          // 2️⃣ Cancel Calendly meeting FIRST
          await cancelCalendlyMeeting(
            data.scheduled_event_join_url,
            token
          );

          // 3️⃣ ONLY after Calendly success → update Firestore
          await deleteConsultAndUpdateQuote(data.id);

          // 4️⃣ Refresh UI
          await loadUserConsults();

        } catch (err) {
          console.error("Cancel error:", err);
          alert("Failed to cancel consult");
        } finally {
          btn.disabled = false;
          btn.innerText = "Cancel";
        }
      });
    });

    // 🔹 Reschedule buttons
    consultsRow.querySelectorAll(".btn-reschedule").forEach((btn) => {
      btn.addEventListener("click", async (e) => {
        e.stopPropagation();
        const idx = btn.dataset.index;
        const data = consults[idx];
        if (!data) return;

        const confirmed = await confirmAction(
          "Reschedule Consult?",
          "Your current meeting will be cancelled and rescheduled.",
          "Yes, Reschedule"
        );

        if (!confirmed) return; // ⛔ back safely

        try {
          btn.disabled = true;
          btn.innerText = "Rescheduling";

          
          // 1️⃣ Cancel existing meeting first
          const lawSnap = await db.collection("LawFirm").doc(data.attorneyId).get();
          if (!lawSnap.exists) throw new Error("Attorney not found");
          const token = lawSnap.data().clandlyToken;
          await cancelCalendlyMeeting(data.scheduled_event_join_url, token);
          await deleteConsultAndUpdateQuote(data.id);

          // 2️⃣ Start schedule flow (same as your current schedule code)
          Swal.fire({
            title: "Select a date",
            html: `<div id="calendarInline"></div>`,
            showCancelButton: true,
            showConfirmButton: false,
            didOpen: () => {
              flatpickr("#calendarInline", {
                inline: true,
                minDate: "today",
                dateFormat: "Y-m-d",
                onChange: (_, dateStr) => {
                  Swal.close();
                  fetchAvailableSlots(data.attorneyId, data.documentID, dateStr);
                },
              });
            },
          });
        } catch (err) {
          console.error(err);
          Swal.fire("Error", err.message, "error");
        } finally {
          btn.disabled = false;
          btn.innerText = "Reschedule";
        }
      });
    });
  }

  const consultSearch = document.querySelector('#consults .search');
  if (consultSearch) {
    consultSearch.addEventListener("input", async () => {
      const term = consultSearch.value.toLowerCase();
      const uid = firebase.auth().currentUser.uid;
      const snap = await firebase
        .firestore()
        .collection("Consult")
        .where("userID", "==", uid)
        .get();
        let consults = snap.docs.map(doc => ({
          id: doc.id,
          ...doc.data()
        }));
        
      

      const consultsSearched = snap.docs
      .map(doc => ({
        id: doc.id,
        ...doc.data()
      }))
      .filter(c =>
        c.attorneyName?.toLowerCase().includes(term) ||
        c.inviteeEmail?.toLowerCase().includes(term)
      );

      renderConsults(consultsSearched);
    });
  }

  const consultTabBtn = document.querySelector("#consults-tab");
  if (consultTabBtn) {
    consultTabBtn.addEventListener("click",  () => {
      loadUserConsults();
    });
  }

  async function loadUserConsults() {
    const consultsRow = document.getElementById("consultsRow");
    consultsRow.innerHTML = ""; // ✅ CLEAR first

    const uid = currentUserId;

    let snap = await firebase.firestore()
    .collection("Consult")
    .where("attorneyId", "==", uid)
    .get();

    if (snap.empty) {
      consultsRow.innerHTML =
        `<p class="text-muted text-center">No consults scheduled yet</p>`;
      return;
    }

    
    let consults = snap.docs.map(doc => ({
      id: doc.id,
      ...doc.data()
    }));

    renderConsults(consults); // ✅ SINGLE render call
  }

  async function confirmAction(title, text, confirmText = "Yes") {
    const result = await Swal.fire({
      title,
      text,
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#d33",
      cancelButtonColor: "#6c757d",
      confirmButtonText: confirmText,
      cancelButtonText: "No",
      reverseButtons: true,
    });

    return result.isConfirmed;
  }

  // function showZoomAlert(joinURL, password) {
  //   // Remove existing alert if present
  //   document.querySelector(".zoom-alert-wrapper")?.remove();

  //   const wrapper = document.createElement("div");
  //   wrapper.className = "zoom-alert-wrapper";
  //   wrapper.innerHTML = `
  //     <div class="zoom-alert" style="
  //       position:fixed;
  //       top:30%;
  //       left:50%;
  //       transform:translateX(-50%);
  //       background:#fff;
  //       padding:20px;
  //       border-radius:8px;
  //       z-index:9999;
  //       box-shadow:0 2px 10px rgba(0,0,0,0.3);
  //     ">
  //       <p><strong>Password:</strong> ${password}</p>
  //       <div class="d-flex gap-2 justify-content-end">
  //         <button class="btn btn-join btn-consult">Join Meeting</button>
  //         <button class="btn btn-secondary btn-sm btn-zoom-cancel">Cancel</button>
  //       </div>
  //     </div>
  //   `;

  //   document.body.appendChild(wrapper);

  //   wrapper.querySelector(".btn-zoom-join").onclick = () => {
  //     openZoomMeeting(joinURL);
  //     wrapper.remove();
  //   };

  //   wrapper.querySelector(".btn-zoom-cancel").onclick = () => {
  //     wrapper.remove();
  //   };
  // }

  function showZoomAlert(joinURL, password) {
    Swal.fire({
      title: "Ready to Join",
      // icon: "success",
      html: `
        <p><strong>Meeting Password:</strong> ${password}</p>
      `,
      confirmButtonText: "Join Now",
      showCancelButton: true,
      cancelButtonText: "Cancel",
    }).then(result => {
      if (result.isConfirmed) {
        openZoomMeeting(joinURL);
      }
    });
  }


  function openZoomMeeting(joinURL) {
    // Zoom app URL scheme
    const zoomAppURL = joinURL.replace("https://", "zoomus://");

    if (navigator.userAgent.match(/iPhone|iPad|iPod|Android/i)) {
      // Mobile: try app first
      window.location.href = zoomAppURL;
      setTimeout(() => window.open(joinURL, "_blank"), 500); // fallback to browser
    } else {
      // Desktop: open browser
      window.open(joinURL, "_blank");
    }
  }

  async function fetchAvailableSlots(attorneyId, quoteId, selectedDate) {
    try {
      // 🔹 Fetch attorney record
      const attorneySnap = await db.collection("LawFirm").doc(attorneyId).get();

      if (!attorneySnap.exists) {
        throw new Error("Law firm not found");
      }

      const attorneyData = attorneySnap.data();

      const eventTypeURL = attorneyData?.scheduleEvent;
      const calendlyToken = attorneyData?.clandlyToken; // 🔐 MUST be token

      // ✅ Strict validation
      if (!eventTypeURL || !eventTypeURL.trim()) {
        throw new Error("Scheduling not configured");
      }

      if (!calendlyToken || !calendlyToken.trim()) {
        throw new Error("Calendly token missing");
      }

      Swal.fire({
        title: "Loading available slots...",
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
      });

      // ✅ UPDATE: Enforce 15-minute buffer for same-day scheduling
      const now = new Date();
      const selected = new Date(`${selectedDate}T00:00:00`);

      let startTime;
      if (now.toDateString() === selected.toDateString()) {
        startTime = new Date(now.getTime() + 15 * 60 * 1000);
      } else {
        startTime = selected;
      }

      const endTime = new Date(`${selectedDate}T23:59:59`);

      const startUTC = startTime.toISOString();
      const endUTC = endTime.toISOString();

      // 🔹 Calendly API
      const url = new URL("https://api.calendly.com/event_type_available_times");
      url.search = new URLSearchParams({
        event_type: eventTypeURL,
        start_time: startUTC,
        end_time: endUTC
      });

      const res = await fetch(url.toString(), {
        method: "GET",
        headers: {
          Authorization: `Bearer ${calendlyToken}`,
          "Content-Type": "application/json"
        }
      });

      if (!res.ok) {
        throw new Error("Calendly API failed");
      }

      const data = await res.json();

      const availableSlots = data.collection.filter(
        slot => slot.status === "available"
      );

      Swal.close();

      if (!availableSlots.length) {
        Swal.fire("No Slots", "No time slots available for this date", "info");
        return;
      }

      // ✅ Correct data received
      showTimeSlots(attorneyId, quoteId, selectedDate, availableSlots);

    } catch (err) {
      Swal.close();
      Swal.fire("Error", err.message, "error");
    }
  }

   async function showTimeSlots(attorneyId, quoteId, date, slots) {
    // Fetch attorney details from LawFirm + Users collection
    const attorneySnap = await db.collection("LawFirm").doc(attorneyId).get();
    if (!attorneySnap.exists) throw new Error("Law firm not found");
    const attorneyData = attorneySnap.data();

    // Try to fetch name from Users collection
    let attorneyName = "Unknown Attorney";
    try {
      const userSnap = await db.collection("Users").doc(attorneyId).get();
      if (userSnap.exists) {
        const userData = userSnap.data();
        attorneyName = userData?.Name 
                    || (userData?.firstName && userData?.lastName ? `${userData.firstName} ${userData.lastName}` : null)
                    || attorneyData?.name 
                    || "Unknown Attorney";
      } else {
        // fallback to LawFirm name
        attorneyName = attorneyData?.name || "Unknown Attorney";
      }
    } catch (err) {
      console.warn("Failed to fetch attorney name from Users collection:", err);
      attorneyName = attorneyData?.name || "Unknown Attorney";
    }

    const buttonsHTML = slots
      .map(slot => {
        const time = new Date(slot.start_time).toLocaleTimeString([], {
          hour: "2-digit",
          minute: "2-digit"
        });

        return `
          <button 
            class="time-slot btn btn-outline-primary m-1"
            data-start='${slot.start_time}'
          >
            ${time}
          </button>
        `;
      })
      .join("");

    Swal.fire({
      title: `Available Times – ${date}`,
      html: `<div class="d-flex flex-wrap justify-content-center">${buttonsHTML}</div>`,
      showCancelButton: true,
      showConfirmButton: false,

      didOpen: () => {
        document.querySelectorAll(".time-slot").forEach(btn => {
          btn.addEventListener("click", async () => {
            Swal.close();

            const start_time = btn.dataset.start;

            await scheduleCalendlyEvent({
              attorneyId: attorneyId,
              attorneyName: attorneyName, // now dynamic
              quoteId: quoteId,
              slot: { start_time },
              // inviteeName: firebase.auth().currentUser.name || "Client",
              inviteeName: firebase.auth().currentUser.displayName || "Client",
              inviteeEmail: firebase.auth().currentUser.email
            });
          });
        });
      }
    });
  }

  async function getEventTypeURL(attorneyId) {
    const snap = await db.collection("LawFirm").doc(attorneyId).get();

    if (!snap.exists) {
      throw new Error("Law firm not found");
    }

    const data = snap.data();
    const scheduleEvent = data?.scheduleEvent;

    // ✅ strict validation
    if (
      !scheduleEvent ||
      typeof scheduleEvent !== "string" ||
      !scheduleEvent.trim()
    ) {
      throw new Error("Scheduling is not configured for this attorney");
    }

    return scheduleEvent.trim();
  }

  async function scheduleCalendlyEvent({
    attorneyId,
    attorneyName,
    quoteId,
    slot,
    inviteeName,
    inviteeEmail
  }) {
    try {
      // 🔹 Fetch attorney (LawFirm)
      const attorneySnap = await db.collection("LawFirm").doc(attorneyId).get();

      if (!attorneySnap.exists) {
        throw new Error("Law firm not found");
      }

      const attorneyData = attorneySnap.data();
      const eventTypeURL = attorneyData?.scheduleEvent;
      const token = attorneyData?.clandlyToken;

      if (!eventTypeURL || !eventTypeURL.trim()) {
        throw new Error("Scheduling not configured");
      }

      if (!token || !token.trim()) {
        throw new Error("Calendly token missing");
      }

      // 🔹 Calendly API request
      const response = await fetch("https://api.calendly.com/invitees", {
        method: "POST",
        headers: {
          Authorization: `Bearer ${token}`,
          "Content-Type": "application/json"
        },
        body: JSON.stringify({
          event_type: eventTypeURL,
          start_time: new Date(slot.start_time).toISOString(),
          invitee: {
            name: inviteeName,
            email: inviteeEmail,
            timezone: Intl.DateTimeFormat().resolvedOptions().timeZone
          },
          location: {
            kind: "zoom_conference"
          }
        })
      });

      const raw = await response.text();

      if (!response.ok) {
        throw new Error("Scheduling failed");
      }

      const decoded = JSON.parse(raw);
      const resource = decoded.resource;

      // 🔹 Save to Consult collection (MATCHING YOUR SCHEMA)
      await db.collection("Consult").add({
        attorneyId: attorneyId,
        attorneyName: attorneyName,
        userID: firebase.auth().currentUser.uid,

        documentID: quoteId,
        inviteeEmail: resource.email,

        cancel_url: resource.cancel_url,
        reschedule_url: resource.reschedule_url,
        scheduled_event_join_url: resource.uri,

        token: token,
        created_at: new Date(slot.start_time).getTime(),
      });

      // 2️⃣ Update Quote document
      await db.collection("QuoteAlert").doc(quoteId).set(
        {
          scheduledConsult: firebase.firestore.FieldValue.arrayUnion(attorneyId)
        },
        { merge: true }
      );
      Swal.fire(
        "Consult Scheduled 🎉",
        "Your consult has been successfully booked",
        "success"
        
      );
      await loadUserConsults();

    } catch (error) {
      Swal.fire("Error", error.message, "error");
    }
  }

  function extractCancellationUUID(urlString) {
    if (!urlString) return null;

    const start = urlString.indexOf("/scheduled_events/");
    const end = urlString.indexOf("/invitees/");

    if (start === -1 || end === -1) return null;

    return urlString.substring(
      start + "/scheduled_events/".length,
      end
    );
  }

  async function cancelCalendlyMeeting(joinURL, token) {
    console.log("Attempting to cancel Calendly meeting:", joinURL, token);
    
    const uuid = extractCancellationUUID(joinURL);

    console.log("UUID extracted OK:", uuid);
    
    if (!uuid) {
      throw new Error("Invalid cancellation URL");
    }

    const apiURL = `https://api.calendly.com/scheduled_events/${uuid}/cancellation`;

    const res = await fetch(apiURL, {
      method: "POST",
      headers: {
        Authorization: `Bearer ${token}`,
        "Content-Type": "application/json"
      }
    });

    if (!res.ok) {
      throw new Error(`Calendly cancel failed (${res.status})`);
    }
    let json = await res.json();

    return true;
  }

  async function onCancelConsult(data) {
    try {

      // 1️⃣ Get attorney (law firm) token
      const lawFirmSnap = await db
        .collection("LawFirm")
        .doc(data.attorneyId)
        .get();

      if (!lawFirmSnap.exists) {
        throw new Error("Attorney does not exist");
      }

      const lawFirm = lawFirmSnap.data();
      const token = lawFirm.clandlyToken;

      // 2️⃣ Cancel Calendly meeting
      await cancelCalendlyMeeting(data.scheduled_event_join_url, token);

      // 3️⃣ Delete Consult document
      await db.collection("Consult").doc(data.docId).delete();

      // 4️⃣ Remove attorneyId from scheduledConsult array
      const quoteRef = db.collection("QuoteAlert").doc(data.documentID);

      await quoteRef.update({
        scheduledConsult: firebase.firestore.FieldValue.arrayRemove(
          data.attorneyId
        )
      });

      hideLoader();
      reloadConsultList();

    } catch (err) {
      hideLoader();
      console.error("Cancel failed:", err);
      alert(err.message);
    }
  }

  async function deleteConsultAndUpdateQuote(consultDocId) {
    try {
      // 1️⃣ Get consult document
      const consultRef = db.collection("Consult").doc(consultDocId);
      const consultSnap = await consultRef.get();

      if (!consultSnap.exists) {
        throw new Error("Consult document not found");
      }

      const consultData = consultSnap.data();

      const quoteId = consultData.documentID;      // QuoteAlert doc id
      const attorneyId = consultData.attorneyId;   // value inside scheduledConsult[]

      if (!quoteId || !attorneyId) {
        throw new Error("Missing documentID or attorneyId");
      }

      // 2️⃣ Delete consult document
      await consultRef.delete();

      // 3️⃣ Remove attorneyId from QuoteAlert.scheduledConsult
      await db.collection("QuoteAlert")
        .doc(quoteId)
        .update({
          scheduledConsult: firebase.firestore.FieldValue.arrayRemove(attorneyId)
        });

      console.log("✅ Consult deleted & Quote updated");

    } catch (error) {
      console.error("❌ Delete consult failed:", error.message);
    }
  }

  async function loadAndRenderQuotes() {
    const db = firebase.firestore();
    const user = firebase.auth().currentUser;
    if (!user) return;

    const uid = user.uid;
    const snapshot = await db.collection("QuoteAlert")
      .where("acceptedAttorneyLawFrimID", "==", uid).get();

    const quotesWithUser = await Promise.all(
      snapshot.docs.map(async (doc) => {
        const data = doc.data();

        // 🔹 Fetch user
        const userDoc = await db.collection("Users").doc(data.userId).get();
        const userData = userDoc.exists ? userDoc.data() : {};

        const isManualIncident = data.quoteType === "Manual Incident";
        const isImmigrationIncident =
          isManualIncident &&
          data.incidentType &&
          data.incidentType.includes("Immigration");

        // ✅ SINGLE merged object
        const q = {
          id: doc.id,

          // QuoteAlert fields
          ...data,

          // User fields (EXPLICIT — safest)
          designatedLawyerId: userData.designatedLawyerId,
          designatedImmigrationLawyerId: userData.designatedImmigrationLawyerId,
          userName: userData.Name || "Unknown",
          userPhone: userData.userPhone || "N/A",
          userAddress: userData.address || "N/A",

          countryOfCitizenship: userData.countryOfCitizenship || "N/A",
          visaType: userData.visaType || "N/A",
          visaExpiryDate: userData.visaExpiryDate
            ? new Date(userData.visaExpiryDate).toLocaleDateString()
            : "N/A",
          ANumber: userData.ANumber || "N/A",

          userDOB: userData.userDOB
            ? new Date(userData.userDOB).toLocaleDateString()
            : "N/A",

          userImage:
            userData.imageUrl ||
            "<?= base_url('assets/images/th.jpeg') ?>",

          // Flags
          isManualIncident,
          isImmigrationIncident,

          date: new Date(data.createdDate),
        };

        return q;
      })
    );

    const all = quotesWithUser.filter(q => q.qoutesPrice > 0)
      .sort((a, b) => new Date(b.createdDate) - new Date(a.createdDate));

    active = all.filter(q => q.isInActive);
    inactive = all.filter(q => !q.isInActive);
    shownActive = 3;
    shownInactive = 3;

    renderTab(active, activeRow, shownActive);
    renderTab(inactive, inactiveRow, shownInactive);
  }

  function renderTab(quotes, containerRow, shownCount) {
    containerRow.innerHTML = "";

    quotes.slice(0, shownCount).forEach(q => {
      
      let actionsHtml = "";

      if (q.docUrl) {
        actionsHtml += `
          <a href="${q.docUrl}" target="_blank"
            class="btn btn-primary btn-sm px-3 btn-width border-15">
            View Document
          </a>
        `;
      }

      if (q.videoUrls?.length) {
        actionsHtml += `
          <button
            class="btn btn-save btn-sm px-3 btn-width btn-arrest"
            data-name="${q.userName || ''}"
            data-id="${q.id}">
            Arrest Details
          </button>

          <button
            class="btn btn-secondary btn-sm px-3 btn-width btn-video border-15"
            data-videos='${JSON.stringify(q.videoUrls)}'>
            View Videos
          </button>
        `;
      }

      /* ===========================
        INFO SECTION
      =========================== */
      let infoHtml = "";

      if (!q.isManualIncident) {
        const mapLink = (q.userLat && q.userLng)
        ? `https://www.google.com/maps?q=${q.userLat},${q.userLng}`
        : `https://www.google.com/maps/search/?api=1&query=${encodeURIComponent(
            [q.city, q.county, q.country].filter(Boolean).join(" ")
          )}`;

          infoHtml = `
          
          <p class="ft7 mb-2">Designated Attorney ${currentUserName}</p>
          <p class="ft7 mb-1">
            <i class="fas fa-phone me-2 text-primary"></i>
            <a href="tel:${q.userPhone}" class="text-decoration-none ft7 mb-0">
              ${q.userPhone}
            </a>
          </p>

          <p class="ft7 mb-1">
            <i class="fas fa-map-marker-alt me-2 text-primary"></i>
            <a href="${mapLink}" target="_blank" class="text-decoration-none ft7 mb-0">
              ${[q.city, q.county, q.country].filter(Boolean).join(", ")}
            </a>
          </p>



          <div class="mt-2">
            <p class="mb-1 fw-bold text-success mb-0 mt-2 w-100">Immigration Info</p>
            <p class="ft7 mb-0">Citizenship: ${q.countryOfCitizenship}</p>
            <p class="ft7 mb-0">Visa Type: ${q.visaType}</p>
            <p class="ft7 mb-0">Visa Expiry: ${q.visaExpiryDate}</p>
            <p class="ft7 mb-0">A-Number: ${q.ANumber}</p>
          </div>
          <div class="d-flex align-items-center gap-2 flex-wrap">
            <p class="ft7">Detained At: <strong>${q.detainedPlace || "N/A"}</strong></p>
            <p class="ft7"><strong>Charge(s):</strong>
            ${
              Array.isArray(q.offense) && q.offense.length
                  ? q.offense.map(o =>
                  `${o.chargedesc || "Unknown"} (${o.severity || "-"}) – ${o.warrantissuedagency || "Unknown Agency"}`
                  ).join("<br>")
                  : "N/A"
                  }
                  </p>
          </div>
        `;
      }

      if (q.isManualIncident) {
        infoHtml = `
          <p class="ft7 mb-1">
            <i class="fas fa-phone me-2 text-primary"></i>
            <a href="tel:${q.userPhone}" class="text-decoration-none ft7 mb-0">
              ${q.userPhone}
            </a>
          </p>

          <p class="ft7 mb-1">
            <i class="fas fa-map-marker-alt me-2 text-primary"></i>
            <a href="https://maps.google.com/?q=${encodeURIComponent(q.incidentLocation)}" 
              target="_blank" class="text-decoration-none ft7 mb-0">
              ${q.incidentLocation}
            </a>
          </p>

          <p class="ft7 mb-1"><strong>Incident Type:</strong> ${q.incidentType || "N/A"}</p>
          <p class="ft7 mb-1"><strong>Description:</strong> ${q.incidentDescription || "N/A"}</p>
        `;

        if (q.isImmigrationIncident) {
          infoHtml += `
            <div class="mt-2">
              <p class="fw-bold text-success mb-1 mt-2 w-100">Immigration Info</p>
              <p class="ft7 mb-0">Citizenship: ${q.countryOfCitizenship}</p>
              <p class="ft7 mb-0">Visa Type: ${q.visaType}</p>
              <p class="ft7 mb-0">Visa Expiry: ${q.visaExpiryDate}</p>
              <p class="ft7 mb-0">A-Number: ${q.ANumber}</p>
            </div>
          `;
        }
      }

      const dateStr = q.date.toLocaleDateString(undefined, {
        month: "long",
        day: "2-digit",
        year: "numeric"
      });
      const timeStr = q.date.toLocaleTimeString();

      /* ===========================
        CARD UI
      =========================== */
      containerRow.insertAdjacentHTML("beforeend", `
        <div class="col-md-12 my-2">
          <div class="card stCard">
            <div class="card-body">
              <div class="row g-3">

                <!-- LEFT: IMAGE -->
                <div class="col-md-3 d-flex justify-content-center ">
                  <img class="atr-img-p" src="${q.userImage}" alt="User">
                </div>

                <!-- RIGHT: CONTENT -->
                <div class="col-md-9">

                  <!-- HEADER -->
                  <div class="d-flex justify-content-between align-items-center">
                    <p class="fp2 mb-0 me-auto ">Quote for ${q.title || q.personName}</p>
                    ${
                      q.paidStatus == 0
                        ? `<span class="badge bg-danger me-2">Pending</span>`
                        : `<span class="badge bg-success me-2">Hired</span>`
                    }
                    <div>
                     <!-- <a href="<?= base_url('site/chatUser') ?>?receiverId=${q.userId}" class="btn btn-save start-chat-btn">
                        <i class="fa-regular fa-message"></i>
                      </a> -->

                      <a href="<?= base_url('site/chatLawer') ?>?receiverId=${q.userId}" 
                        class="btn btn-save start-chat-btn premium-chat"
                        data-receiver-id="${q.userId}">
                        <i class="fa-regular fa-message"></i>
                      </a>
                    </div>
                  </div>

                  <p class="ft7 mb-2">Incident on ${dateStr} ${timeStr}</p>
                  <p class="ft7 mb-1">Date Of Birth: <strong>${q.userDOB}</strong></p>

                  ${infoHtml}

                  <!-- CHARGES -->
                  <div class="">
                    

                  </div>

                  <!-- META -->
                  <div class="d-flex gap-4 flex-wrap mt-2">
                    <p class="ft7">Quote: <strong>$${q.qoutesPrice}</strong></p>
                    <p class="ft7">Deposit: <strong>$${q.qoutesDeposite}</strong></p>
                    
                    <p class="ft7">Attorney Alerted: <strong>${q.isAttorneyAlerted ? "Yes" : "No"}</strong></p>
                  </div>

                  <!-- ACTIONS -->
                  <div class="d-flex justify-content-end gap-2 flex-wrap mt-3">
                    ${actionsHtml}
                    <button class="btn btn-danger btn-sm px-3 btn-width border-15 btn-delete"
                      data-id="${q.id}">
                      <i class="fa fa-trash"></i> Delete
                    </button>
                  </div>

                </div>
              </div>
            </div>
          </div>
        </div>
      `);
    });

    if (shownCount < quotes.length) {
      containerRow.insertAdjacentHTML("beforeend", `
        <div class="col-md-12 my-2 text-center d-flex justify-content-center">
          <button class="btn btnLoad btn-same">Load More</button>
        </div>
      `);
    }
  }

  document.addEventListener('DOMContentLoaded', () => {
  const contentTabsContent = document.getElementById('contentTabsContent'); // or whatever container

  contentTabsContent.addEventListener('click', async (e) => {
      const chatBtn = e.target.closest('.premium-chat');
      if (!chatBtn) return; // not a chat button

      e.preventDefault(); // stop default navigation

      const allowed = await checkAttorneyMembershipAccess({
        redirectTo: "<?= base_url('site/subscriptionAttorney'); ?>"
      });

      if (!allowed) return; // non-members blocked

      // ✅ allowed → navigate
      const receiverId = chatBtn.dataset.receiverId;
      window.location.href = `<?= base_url('site/chatLawer') ?>?receiverId=${receiverId}`;
    });
  });


  async function deleteQuote(quoteId) {
    const confirm = await Swal.fire({
      title: "Are you sure?",
      text: "This will permanently delete this quote.",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Yes, delete it!",
      cancelButtonText: "Cancel"
    });

    if (confirm.isConfirmed) {
      try {
        await firebase.firestore().collection("QuoteAlert").doc(quoteId).delete();
        Swal.fire("Deleted", "The quote has been deleted.", "success");
        await loadAndRenderQuotes();
      } catch (err) {
        console.error("Delete failed:", err);
        Swal.fire("Error", "Failed to delete the quote.", "error");
      }
    }
  }

  function setupSearch(quotes, row, input) {
    input.addEventListener("input", () => {
      const term = input.value.trim().toLowerCase();

      const filtered = quotes.filter(q =>
        q.title.toLowerCase().includes(term) ||
        (Array.isArray(q.offense) && q.offense.some(o =>
          o.chargedesc?.toLowerCase().includes(term) ||
          o.severity?.toLowerCase().includes(term) ||
          o.warrantissuedagency?.toLowerCase().includes(term)
        ))
      );

      renderTab(filtered, row, filtered.length);
    });
  }

  function showVideos(videoUrls) {
    const embedHTML = videoUrls.map(url => `
      <video controls width="100%" class="my-2">
        <source src="${url}" type="video/webm" />
        Your browser does not support the video tag.
      </video>`).join("");
    Swal.fire({
      title: 'Recorded Videos',
      html: `<div style="max-height:400px;overflow-y:auto">${embedHTML}</div>`,
      width: 700
    });
  }

  async function fetchArrestDetails(name, alertId) {
    try {
      const upperName = name.toUpperCase();
      let arrest = null;

      // 🔹 Try API first
      try {
        const res = await fetch(`https://us-central1-duepro-2cf60.cloudfunctions.net/widgets/searchnew?name=${encodeURIComponent(upperName)}`);
        const result = await res.json();
        if (result.success !== 0 && result.result) {
          arrest = result.result;
        }
      } catch (apiError) {
        console.warn("API fetch failed:", apiError);
      }

      // 🔹 If API failed, fallback to Firestore
      if (!arrest) {
        const alertDoc = await firebase.firestore().collection("QuoteAlert").doc(alertId).get();
        if (alertDoc.exists) {
          const data = alertDoc.data();
          if (Array.isArray(data.offense) && data.offense.length > 0) {
            arrest = {
              fullName: name,
              offense: data.offense,
              detention: data.detainedPlace || 'N/A'
            };
          }
        }
      }

      // 🔹 If no arrest found anywhere
      if (!arrest) {
        return Swal.fire("No Record", "No arrest record found.", "info");
      }

      const arrestDate = arrest.arrestDate ? new Date(arrest.arrestDate).toLocaleString() : "N/A";

      Swal.fire({
        title: `Arrest Details`,
        html: `
          <p><strong>Name:</strong> ${arrest.fullName || name}</p>
          <p><strong>Gender:</strong> ${arrest.gender || 'N/A'}</p>
          <p><strong>Age:</strong> ${arrest.age || 'N/A'}</p>
          <p><strong>Address:</strong> ${arrest.address || 'N/A'}</p>
          <p><strong>City/State/Zip:</strong> ${arrest.cityStateZip || 'N/A'}</p>
          <p><strong>Offense:</strong><br>
            ${
              Array.isArray(arrest.offense) && arrest.offense.length
                ? arrest.offense.map(o =>
                    `${o.chargedesc || 'Unknown'} (${o.severity || '-'}) - ${o.warrantissuedagency || 'Unknown Agency'}`
                  ).join('<br>')
                : 'N/A'
            }
          </p>
          <p><strong>Detention:</strong> ${arrest.detention || 'N/A'}</p>
          <p><strong>Arrest Date:</strong> ${arrestDate}</p>
        `,
        confirmButtonText: 'Close'
      });

    } catch (err) {
      console.error(err);
      Swal.fire("Error", "Failed to fetch arrest details.", "error");
    }
  }

</script>

