<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<style>
  .atr-img-p{
    width: 100% ;
    height:209px;
  }
  .stCard{
      /* height:245px !important; */
  }
  .st-image{
      cursor:pointer;
  }
  .btn-view{
      position:absolute;
      right:0;
      bottom:0;
  }
  @media(max-width:768px){
       .btn-view{
      position:static;
   
  }

  }
  .flatpickr-calendar {
    border-right: none !important;
    overflow: clip;
  }

  .swal2-html-container{
    display: flex !important;
  }

  .btn-consult {
    max-width: 110px;
    width: 100%;
    padding: 10px;
    font-size: 14px;
    line-height: 1.2;
    border-radius: 6px;
    border: none;
    transition: 
      background-color 0.2s ease,
      box-shadow 0.2s ease,
      transform 0.1s ease;
  }

  .btn-cancel {
    color: #fff !important;
    background-color: #dc3545;
  }

  .btn-cancel:hover {
    color: #fff !important;
    background-color: #b52a37;
  }

  .btn-reschedule {
    color: #fff !important;
    background-color: #0412CA;
  }

  .btn-reschedule:hover {
    color: #fff !important;
    background-color: #020ea0; /* darker */
  }

  .btn-join {
    color: #fff !important;
    background-color: #02077D;
  }
  
  
  .btn-join:hover {
    color: #fff !important;
    background-color: #01055a; /* darker */
  }
  
  .btn-consult:focus,
  .btn-consult:active,
  .btn-consult:focus-visible {
    outline: none !important;
    box-shadow: none !important;
  }
  
  .btn-consult:active {
    background-color: #02077D !important;
    transform: scale(0.97);
  }
  .btn-consult:disabled {
    background-color: #292c83ff !important;
    transform: scale(0.97);
  }

  .clearDate{
    position: absolute;
    padding: 0 5px;
    right: 20px;
    top: 45%;
    transform: translateY(-50%);
    cursor: pointer;
    font-weight: bold;
    color: #888;
  }

  .flatpickr-month{
    border-top: 4px solid #0412CA;
    margin-bottom: 10px;
  }
  .flatpickr-innerContainer .flatpickr-day.selected{
    background: #0412CA;
  }

    /* Full width calendar styling */
  .flatpickr-calendar {
    width: 100%;
    max-width: 100%;
  }

  .flatpickr-days,
  .flatpickr-weekdays,
  .flatpickr-innerContainer,
  .flatpickr-rContainer {
    width: 100%;
    display: block;
  }

  .flatpickr-calendar.inline {
    width: 100%;
    margin-top: 15px;
  }

  .dayContainer {
    max-width: none;
    width: 100%;
  }

  .flatpickr-day {
    max-width: none;
    width: 15% !important;
  }

</style>
<main class="atr-img-p mb-5">
  <div class="container">
    <div class="my-5">
      <div class="d-flex justify-content-center">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs n-tabs gap-2 justify-content-center w-fit" id="contentTabs" role="tablist">
          <li class="nav-item" role="presentation">
            <button class="nav-link active" id="articles-tab" data-bs-toggle="tab" data-bs-target="#articles"
              type="button" role="tab" aria-controls="articles" aria-selected="true">
              Active Quotes
            </button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="videos-tab" data-bs-toggle="tab" data-bs-target="#videos" type="button"
              role="tab" aria-controls="videos" aria-selected="false">
              Inactive Quotes
            </button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="consults-tab" data-bs-toggle="tab" data-bs-target="#consults" type="button"
              role="tab" aria-controls="consults" aria-selected="false">
              Consults
            </button>

          </li>
        </ul>
      </div>

      <!-- Tab panes -->


      <div class="tab-content" id="contentTabsContent">
        <div class="tab-pane fade" id="articles" role="tabpanel" aria-labelledby="articles-tab">
          <div class="row">
            <div class="col-md-12 my-2">
              <form class="d-flex position-relative mt-2 mt-md-0" role="search">
                <input class="form-control me-2 search w-100 bg-white pe-4" type="search" placeholder="Search"
                  aria-label="Search" style="width: 350px" />
                <img src="<?= base_url('assets/images/icons/searchicon.png') ?>" alt="" width="15px" height="15px"
                  class="searchIcon" />
              </form>
            </div>
          </div>
          <div class="row my-2">



            <div class="col-md-12 my-2">
              <button class="btn btnLoad d-block mx-auto btn-same">
                Load More
              </button>
            </div>
          </div>
        </div>
        <div class="tab-pane fade" id="videos" role="tabpanel" aria-labelledby="videos-tab">
          <div class="row">
            <div class="col-md-12 my-2">
              <form class="d-flex position-relative mt-2 mt-md-0" role="search">
                <input class="form-control me-2 search w-100 bg-white pe-4" type="search" placeholder="Search"
                  aria-label="Search" style="width: 350px" />
                <img src="<?= base_url('assets/images/icons/searchicon.png') ?>" alt="" width="15px" height="15px"
                  class="searchIcon" />
              </form>
            </div>
          </div>
          <div class="row my-2">



            <div class="col-md-12 my-2">
              <button class="btn btnLoad d-block mx-auto btn-same">
                Load More
              </button>
            </div>
          </div>

        </div>
        <div class="tab-pane fade" id="consults" role="tabpanel" aria-labelledby="consults-tab">
          <div class="row">
            <div class="col-md-12 my-2 flex-column flex-md-row justify-content-md-between align-items-md-center gap-2">
              <form class="d-flex position-relative mt-2 mt-md-0 w-100" role="search">
                <input class="form-control me-2 search w-100 bg-white pe-4" type="search" placeholder="Search"
                  aria-label="Search" style="width: 350px" />
                <img src="<?= base_url('assets/images/icons/searchicon.png') ?>" alt="" width="15px" height="15px"
                  class="searchIcon" />
              </form>
              <!-- <div class="d-flex justify-content-center position-relative">
                <input class="date-input form-control me-2 search w-100 bg-white pe-4" 
                      id="datePicker" type="text" placeholder="Select Date" />
                <span id="clearDate" class="clearDate">×</span>
              </div> -->

              <input class="date-input form-control me-2 search w-100 bg-white pe-4" id="datePicker" type="text"
                placeholder="Select Date" hidden />

              <!-- calendar container -->
              <div id="calendar"></div>
            </div>

          </div>
          <div class="row my-2" id="consultsRow">
            <!-- Static consult cards will be inserted here -->
          </div>
        </div>

      </div>


    </div>
  </div>


  </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<script>
  const db = firebase.firestore();
  let currentUserId = null;
  let shouldAutoOpenConsults = false;
  let consultMode = "all"; // "all" | "date"
  let activeConsultDate = null;


  firebase.auth().onAuthStateChanged(async (user) => {
      if (!user) return;

      const uid = user.uid;
      currentUserId = user.uid;

      let lastSelectedDate = null; // store toggle state

    // flatpickr("#calendar", {
    //   inline: true,          // always show calendar
    //   dateFormat: "Y-m-d",
    //   onChange: function(selectedDates) {
    //     if (!selectedDates.length) return;

    //     const selectedDate = selectedDates[0];
    //     const selectedStr = selectedDate.toDateString();

    //     // toggle: if same date clicked again, reset filter
    //     if (lastSelectedDate === selectedStr) {
    //       lastSelectedDate = null;
    //       document.querySelectorAll(".flatpickr-day.selected").forEach(d => {
    //       d.classList.remove("selected");
    //     });
    //       loadUserConsults(); // show all consults

    //     } else {
    //       lastSelectedDate = selectedStr;
    //       filterConsultsByDate(selectedDate); // show filtered consults
    //     }
    //   }
    // });
    let calendarInstance = null;
    calendarInstance = flatpickr("#calendar", {
      inline: true,
      dateFormat: "Y-m-d",
      onChange(selectedDates) {
        if (!selectedDates.length) return;

        const selectedDate = selectedDates[0];
        const selectedStr = selectedDate.toDateString();

        // 🔁 TOGGLE OFF
        if (lastSelectedDate === selectedStr) {
          lastSelectedDate = null;
          consultMode = "all";
          activeConsultDate = null;

          document
            .querySelectorAll(".flatpickr-day.selected")
            .forEach(d => d.classList.remove("selected"));

          loadUserConsults();
          return;
        }

        // 🎯 FILTER MODE
        lastSelectedDate = selectedStr;
        consultMode = "date";
        activeConsultDate = selectedDate;

        filterConsultsByDate(selectedDate);
      }
    });

    // calendarInstance = flatpickr("#calendar", {
    //   inline: true,
    //   dateFormat: "Y-m-d",
    //   onChange: function (selectedDates) {
    //     if (!selectedDates.length) return;

    //     const selectedDate = selectedDates[0];
    //     const selectedStr = selectedDate.toDateString();

    //     // toggle behavior (already correct)
    //     if (lastSelectedDate === selectedStr) {
    //       lastSelectedDate = null;
    //       document.querySelectorAll(".flatpickr-day.selected")
    //         .forEach(d => d.classList.remove("selected"));

    //       loadUserConsults(); // show all
    //     } else {
    //       lastSelectedDate = selectedStr;
    //       filterConsultsByDate(selectedDate);
    //     }
    //   }
    // });

    if (shouldAutoOpenConsults && consultDateParam && calendarInstance) {
      const autoDate = new Date(consultDateParam);

      consultMode = "date";
      activeConsultDate = autoDate;
      lastSelectedDate = autoDate.toDateString();

      // 🚫 prevent onChange loop
      calendarInstance.setDate(autoDate, false);

      filterConsultsByDate(autoDate);
      clearURLParams();
    }


  



      // const dateInput = document.getElementById("datePicker");

      // const fp = flatpickr(dateInput, {
      //   dateFormat: "Y-m-d",
      //   mode: "single",
      //   onChange(selectedDates) {
      //     if (!selectedDates.length) return;
      //     filterConsultsByDate(selectedDates[0]);
      //   }
      // });


      // document.getElementById("clearDate").addEventListener("click", () => {
      //   fp.clear();
      //   loadUserConsults();
      // });



      // Step 1: Fetch own + friends' quotes
      const userDoc = await db.collection("Users").doc(uid).get();
      const userData = userDoc.data();
      
      const userFriendsMap = userData.userFriends || {};
      const friendIds = Object.keys(userFriendsMap);

      const quoteRef = db.collection("QuoteAlert");

      // Fetch own quotes and handle undefined isUserArchived
      const ownSnap = await quoteRef
        .where("userId", "==", uid)
        .get();
      
      const ownQuotes = ownSnap.docs.map(d => {
        const data = d.data();
        // Treat undefined/null isUserArchived as false
        const isUserArchived = data.isUserArchived === true;
        return {
          id: d.id,
          ...data,
          date: new Date(data.createdDate),
          isUserArchived: isUserArchived
        };
      }).filter(q => !q.isUserArchived && q.qoutesPrice > 0); // Filter out archived quotes

      let friendQuotes = [];
      for (let i = 0; i < friendIds.length; i += 10) {
        const chunk = friendIds.slice(i, i + 10);
        const friendSnap = await quoteRef
          .where("userId", "in", chunk)
          .get();
        
        const chunkQuotes = friendSnap.docs.map(d => {
          const data = d.data();
          // Treat undefined/null isUserArchived as false
          const isUserArchived = data.isUserArchived === true;
          return {
            id: d.id,
            ...data,
            date: new Date(data.createdDate),
            isUserArchived: isUserArchived
          };
        }).filter(q => !q.isUserArchived && q.qoutesPrice > 0); // Filter out archived quotes
        
        friendQuotes.push(...chunkQuotes);
      }

    //   const all = [...ownQuotes, ...friendQuotes]
    //     .sort((a, b) => b.date - a.date); // Using Date objects (more reliable)
        const all = [...ownQuotes, ...friendQuotes]
      .sort((a, b) => new Date(b.date) - new Date(a.date)) // Sort newest first
      .filter((item, index, self) => 
        index === self.findIndex(q => q.id === item.id)    // Keep only one per ID
      );

      
      
      // Collect all attorney IDs used in quotes
      const attorneyIds = new Set();

      all.forEach(q => {
        if (q.LawId) attorneyIds.add(q.LawId);
        if (q.imigrationLawId) attorneyIds.add(q.imigrationLawId);
      });

      // Fetch attorney user profiles
      const attorneyUserMap = new Map();

      for (let i = 0; i < [...attorneyIds].length; i += 10) {
        const chunk = [...attorneyIds].slice(i, i + 10);

        const snap = await db
          .collection("Users")
          .where(firebase.firestore.FieldPath.documentId(), "in", chunk)
          .get();

        snap.forEach(doc => {
          attorneyUserMap.set(doc.id, doc.data());
        });
      }


      all.forEach(q => {
        let lawIdToUse;

        if (!q.acceptedAttorneyType || q.acceptedAttorneyType === "Criminal Defense") {
          lawIdToUse = q.LawId;
        } else {
          lawIdToUse = q.imigrationLawId;
        }

        const attorneyUser = attorneyUserMap.get(lawIdToUse);

        q.renderLawId = lawIdToUse;

        q.attorneyName = attorneyUser?.Name || "Unknown Attorney";
        q.attorneyImage =
          attorneyUser?.imageUrl ||
          "<?= base_url('assets/images/placeholder.png') ?>";

        q.attorneyEmail = attorneyUser?.email || "";
      });

      // Step 4: Filter active/inactive
      const active = all.filter(q => q.isInActive);
      const inactive = all.filter(q => !q.isInActive);
      let shownActive = 3, shownInactive = 3;

      
      if (shouldAutoOpenConsults) {
        activateConsultsTab();

        // Only load ALL if no date filter
        if (!consultDateParam) {
          loadUserConsults();
        }
      }


      

      // Step 6: Setup rows + search + load more
      const activeRow = document.querySelector("#articles .row.my-2");
      const inactiveRow = document.querySelector("#videos .row.my-2");
      const activeSearch = document.querySelector("#articles .search");
      const inactiveSearch = document.querySelector("#videos .search");

      renderTab(active, activeRow, shownActive);

      renderTab(inactive, inactiveRow, shownInactive);

      activeRow.addEventListener("click", e => {
        if (e.target.matches(".btnLoad")) renderTab(active, activeRow, shownActive += 3);
      });
      inactiveRow.addEventListener("click", e => {
        if (e.target.matches(".btnLoad")) renderTab(inactive, inactiveRow, shownInactive += 3);
      });

      function setupSearch(quotes, row, input) {
        input.addEventListener("input", () => {
          const term = input.value.trim().toLowerCase();

          const filtered = quotes.filter(q =>
            q.title.toLowerCase().includes(term) ||
            (Array.isArray(q.offense) &&
              q.offense.some(o =>
                o.chargedesc && o.chargedesc.toLowerCase().includes(term)
              )
            )
          );

          renderTab(filtered, row, filtered.length);
        });
      }

      setupSearch(active, activeRow, activeSearch);
      setupSearch(inactive, inactiveRow, inactiveSearch);
  });

  // Step 5: Render function
  function renderTab(quotes, containerRow, shownCount) {
    containerRow.innerHTML = "";
    const slice = quotes.slice(0, shownCount);
    slice.forEach(q => {

      const incidentHtml =
        q.quoteType === "Manual Incident"
          ? `
              <p class="ft7">
                Incident Type:
                <strong>${q.incidentType || "N/A"}</strong>
              </p>
              <p class="ft7">
                Description:
                <strong>${q.incidentDescription || "N/A"}</strong>
              </p>
            `
          : `
              <p class="ft7">
                Quote From:
                <strong>${q.attorneyName || "N/A"}</strong>
                <strong>(${q.acceptedAttorneyType || "N/A"})</strong>
              </p>
              <p class="ft7">
                Charge(s):
                <strong>
                  ${
                    Array.isArray(q.offense) && q.offense.length
                      ? q.offense.map(o => o.chargedesc || "N/A").join(", ")
                      : "N/A"
                  }
                </strong>
              </p>
            `;

      
      const dateStr = q.date.toLocaleDateString(undefined, {
        month: 'long', day: '2-digit', year: 'numeric'
      });
      const timeStr = q.date.toLocaleTimeString();
      containerRow.insertAdjacentHTML("beforeend", `
        <div class="col-md-12 my-2">
          <div class="card stCard" data-law-id="${
          q.renderLawId
    // !q.acceptedAttorneyType
    //   ? q.LawId
    //   : q.acceptedAttorneyType === 'Criminal Defense'
    //     ? q.LawId
    //     : q.imigrationLawId
      }"
            data-quote-id="${q.id}">
            <div class="card-body">
              <div class="row g-2">
                <div class="col-md-3 st-image d-flex justify-content-center align-items-center">
                  <img class="atr-img-p" style="width:200px; height:200px; border-radius:100px;" src="${q.attorneyImage}" alt="Attorney" />
                </div>
                <div class="col-md-9 position-relative">
                  <div class="d-flex justify-content-between align-items-center">
                    <p class="fp2 mb-0">Quote for ${q.title || q.personName}</p>
                    ${q.paidStatus == 0 
                    ? '<p class="badge badge-danger bg-danger">Pending</p>' 
                    : '<p class="badge badge-success bg-success">Hired</p>'}
                    </div>
                    
                  <p class="ft7 my-2">Incident Date: ${dateStr} ${timeStr}</p>
                  <div class="d-flex align-items-start gap-1 flex-column mt-2">
                
                     ${incidentHtml}

                    <p class="ft7">
                      Attorney Quote:
                      <strong>$${q.qoutesPrice}</strong>
                    </p>
                    <p class="ft7">
                      Deposit:
                      <strong>$${q.qoutesDeposite}</strong>
                    </p>
                  
                  </div>
                <div class="d-flex justify-content-end">
      
        <button class="btn btn-save  mt-2 btn-width btn-view d-flex justify-content-center align-items-center">View</button>
            </div>
                </div>
              </div>
            </div>
            
          </div>
        </div>
      `);
    });

    if (shownCount < quotes.length) {
      containerRow.insertAdjacentHTML("beforeend", `
        <div class="col-md-12 my-2">
          <button class="btn btnLoad d-block mx-auto btn-same">Load More</button>
        </div>
      `);
    }

    // Step 7: Setup click handlers for cards and buttons 
    containerRow.querySelectorAll('.stCard').forEach(card => {
      const quoteId = card.getAttribute('data-quote-id');
      const lawId = card.getAttribute('data-law-id');
      const immigrationLawId = card.getAttribute('data-immigration-law-id');

      // Card click (excluding button)
      card.addEventListener('click', (e) => {
        if (e.target.classList.contains('btn-view')) return; // skip button itself
        window.location.href = `<?= base_url('site/attorneyDetail') ?>?lawId=${encodeURIComponent(lawId)}&quoteId=${encodeURIComponent(quoteId)}&immigrationLawId=${encodeURIComponent(immigrationLawId)}`;
      });

      // View button click (same action)
      const viewBtn = card.querySelector('.btn-view');
      if (viewBtn) {
        viewBtn.addEventListener('click', (e) => {
          e.stopPropagation(); // prevent bubbling
          window.location.href = `<?= base_url('site/attorneyDetail') ?>?lawId=${encodeURIComponent(lawId)}&quoteId=${encodeURIComponent(quoteId)}&immigrationLawId=${encodeURIComponent(immigrationLawId)}`;
        });
      }
    });

    

  }

  function activateConsultsTab() {
    const consultTabBtn = document.querySelector("#consults-tab");
    const consultTabPane = document.querySelector("#consults");

    document.querySelectorAll("#contentTabs .nav-link")
      .forEach(tab => tab.classList.remove("active"));

    document.querySelectorAll(".tab-content .tab-pane")
      .forEach(pane => pane.classList.remove("active", "show"));

    consultTabBtn.classList.add("active");
    consultTabPane.classList.add("active", "show");
  }

  function filterConsultsByDate(selectedDate) {
    const consultsRow = document.getElementById("consultsRow");

    // Get all consults from Firestore
    firebase.firestore()
      .collection("Consult")
      .where("userID", "==", firebase.auth().currentUser.uid)
      .get()
      .then(snap => {
        const consults = snap.docs.map(doc => ({ id: doc.id, ...doc.data() }));

        // Filter for selected date
        const start = new Date(selectedDate);
        start.setHours(0,0,0,0);
        const end = new Date(selectedDate);
        end.setHours(23,59,59,999);

        const filtered = consults.filter(c => c.created_at >= start.getTime() && c.created_at <= end.getTime());

        // Render filtered consults
        renderConsults(filtered);
      });
  }

  // Render static consult cards
  const consultsRow = document.getElementById('consultsRow');

  async function renderConsults(consults) {
    const consultsRow = document.getElementById("consultsRow");
    consultsRow.innerHTML = "";

    for (let index = 0; index < consults.length; index++) {
      const c = consults[index];

      // 🔹 Fetch related QuoteAlert document for incident info
      let quoteData = {};
      try {
        const quoteSnap = await db.collection("QuoteAlert").doc(c.documentID).get();
        if (quoteSnap.exists) {
          quoteData = quoteSnap.data();
        }
      } catch (err) {
        console.warn("Failed to fetch quote data:", err);
      }

      const dateObj = new Date(c.created_at);
      const dateStr = dateObj.toLocaleDateString('en-US', {
        weekday: 'short',
        month: 'short',
        day: 'numeric'
      });
      const timeStr = dateObj.toLocaleTimeString('en-US', {
        hour: '2-digit',
        minute: '2-digit'
      });

      consultsRow.insertAdjacentHTML("beforeend", `
        <div class="col-md-12 my-2">
          <div class="card stCard">
            <div class="card-body">

              <!-- HEADER -->
              <div class="d-flex justify-content-between align-items-start mb-2">
                <div>
                  <p class="fp2 mb-1">
                    Consult with ${c.attorneyName || "Attorney"}
                  </p>
                  <p class="ft7 mb-0">
                    ${quoteData.incidentDateTime 
                      ? new Date(quoteData.incidentDateTime).toLocaleString() 
                      : "N/A"}
                  </p>
                </div>

                <span class="badge badge-success bg-success align-self-center">
                  Scheduled
                </span>
              </div>

              <hr class="my-2"/>

              <!-- CONTENT -->
              <div class="row g-2">
                <!-- LEFT INFO -->
                <div class="col-md-8">
                  <div class="d-flex flex-column gap-1">

                    <p class="mb-0 info-card-detail">
                      <strong>Incident Type:</strong> ${quoteData.incidentType || "N/A"}
                    </p>

                    <p class="mb-0 info-card-detail">
                      <strong>Meeting Time:</strong> ${dateStr} - ${timeStr}
                    </p>

                    <p class="mb-0 info-card-detail">
                      <strong>Description:</strong>
                      ${quoteData.incidentDescription || "N/A"}
                    </p>

                  </div>
                </div>

                <!-- RIGHT ACTIONS -->
                <div class="col-md-4 d-flex align-items-end justify-content-end">
                  <div class="d-flex gap-2 flex-wrap justify-content-end w-100">

                    <button 
                      class="btn btn-danger btn-cancel btn-consult"
                      data-index="${index}">
                      Cancel
                    </button>

                    <button 
                      class="btn btn-reschedule btn-consult"
                      data-index="${index}">
                      Reschedule
                    </button>

                    <button 
                      class="btn btn-join btn-consult"
                      data-index="${index}">
                      Join Call
                    </button>

                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
      `);
    }

    // Attach Join button click listeners
    consultsRow.querySelectorAll(".btn-join").forEach(btn => {
      btn.addEventListener("click", async (e) => {
        e.stopPropagation(); // ✅ prevent card click

        const idx = btn.dataset.index;
        const data = consults[idx];
        


        if (!data) {
          console.warn("Consult data not found");
          return;
        }

        if (!data.scheduled_event_join_url || !data.token) {
          alert("Unable to join meeting. Missing meeting data.");
          return;
        }

        const inviteIndex = data.scheduled_event_join_url.indexOf("/invitees");
        if (inviteIndex === -1) {
          console.error("Invalid joinCall URL");
          return;
        }

        const scheduledEventURL = data.scheduled_event_join_url.slice(0, inviteIndex);
        

        try {
          btn.disabled = true;
          btn.innerText = "Joining...";

          const res = await fetch(scheduledEventURL, {
            method: "GET",
            headers: {
              Authorization: `Bearer ${data.token}`,
              "Content-Type": "application/json"
            }
          });

          if (!res.ok) {
            throw new Error("Zoom API failed");
          }

          const json = await res.json();
          

          const joinURL = json?.resource?.location?.join_url;
          const password = json?.resource?.location?.data?.password;

          

          if (!joinURL) {
            throw new Error("Join URL missing");
          }

          showZoomAlert(joinURL, password || "N/A");

        } catch (err) {
          console.error("Join call error:", err);
          alert("Failed to join meeting. Please try again.");
        } finally {
          btn.disabled = false;
          btn.innerText = "Join Call";
        }
      });
    });

    // Attach Cancel button listeners
    consultsRow.querySelectorAll(".btn-cancel").forEach(btn => {
      btn.addEventListener("click", async (e) => {
        e.stopPropagation();

        const idx = btn.dataset.index;
        const data = consults[idx];
        if (!data) return;

        const confirmed = await confirmAction(
          "Cancel Consult?",
          "This meeting will be cancelled permanently.",
          "Yes, Cancel"
        );

        if (!confirmed) return; // ⛔ back safely

        try {
          btn.disabled = true;
          btn.innerText = "Cancelling...";

          // 1️⃣ Get attorney Calendly token
          const lawSnap = await db
            .collection("LawFirm")
            .doc(data.attorneyId)
            .get();

          if (!lawSnap.exists) {
            throw new Error("Attorney not found");
          }

          const token = lawSnap.data().clandlyToken;

          // 2️⃣ Cancel Calendly meeting FIRST
          await cancelCalendlyMeeting(
            data.scheduled_event_join_url,
            token
          );

          // 3️⃣ ONLY after Calendly success → update Firestore
          await deleteConsultAndUpdateQuote(data.id);

          // 4️⃣ Refresh UI
          await loadUserConsults();

        } catch (err) {
          console.error("Cancel error:", err);
          alert("Failed to cancel consult");
        } finally {
          btn.disabled = false;
          btn.innerText = "Cancel";
        }
      });
    });

    // 🔹 Reschedule buttons
    consultsRow.querySelectorAll(".btn-reschedule").forEach((btn) => {
      btn.addEventListener("click", async (e) => {
        e.stopPropagation();
        const idx = btn.dataset.index;
        const data = consults[idx];
        if (!data) return;

        const confirmed = await confirmAction(
          "Reschedule Consult?",
          "Your current meeting will be cancelled and rescheduled.",
          "Yes, Reschedule"
        );

        if (!confirmed) return; // ⛔ back safely

        try {
          btn.disabled = true;
          btn.innerText = "Rescheduling";

          
          // 1️⃣ Cancel existing meeting first
          const lawSnap = await db.collection("LawFirm").doc(data.attorneyId).get();
          if (!lawSnap.exists) throw new Error("Attorney not found");
          const token = lawSnap.data().clandlyToken;
          await cancelCalendlyMeeting(data.scheduled_event_join_url, token);
          await deleteConsultAndUpdateQuote(data.id);

          // 2️⃣ Start schedule flow (same as your current schedule code)
          Swal.fire({
            title: "Select a date",
            html: `<div id="calendarInline"></div>`,
            showCancelButton: true,
            showConfirmButton: false,
            didOpen: () => {
              flatpickr("#calendarInline", {
                inline: true,
                minDate: "today",
                dateFormat: "Y-m-d",
                onChange: (_, dateStr) => {
                  Swal.close();
                  fetchAvailableSlots(data.attorneyId, data.documentID, dateStr);
                },
              });
            },
          });
        } catch (err) {
          console.error(err);
          Swal.fire("Error", err.message, "error");
        } finally {
          btn.disabled = false;
          btn.innerText = "Reschedule";
        }
      });
    });
  }

  const consultSearch = document.querySelector('#consults .search');
  if (consultSearch) {
    consultSearch.addEventListener("input", async () => {
      const term = consultSearch.value.toLowerCase();
      const uid = firebase.auth().currentUser.uid;
      const snap = await firebase
        .firestore()
        .collection("Consult")
        .where("userID", "==", uid)
        .get();
        let consults = snap.docs.map(doc => ({
          id: doc.id,
          ...doc.data()
        }));
        
      

      const consultsSearched = snap.docs
      .map(doc => ({
        id: doc.id,
        ...doc.data()
      }))
      .filter(c =>
        c.attorneyName?.toLowerCase().includes(term) ||
        c.inviteeEmail?.toLowerCase().includes(term)
      );

      renderConsults(consultsSearched);
    });
  }

  // Check URL param for opening Consults tab
  const urlParams = new URLSearchParams(window.location.search);
  const openConsults = urlParams.get("openConsults"); // e.g., ?openConsults=1
  let filterDocId = urlParams.get("docId");
  const consultDateParam = urlParams.get("consultDate"); // ✅ NEW  

  if (openConsults) {
    shouldAutoOpenConsults = true;
  }

  if (openConsults) {
    const consultTabBtn = document.querySelector("#consults-tab");
    const articlesTabPane = document.querySelector("#articles");
    const consultTabPane = document.querySelector("#consults");

    if (consultTabBtn && articlesTabPane && consultTabPane) {
      // Remove active/show from Articles tab and pane
      document.querySelectorAll("#contentTabs .nav-link").forEach(tab => tab.classList.remove("active"));
      document.querySelectorAll(".tab-content .tab-pane").forEach(pane => pane.classList.remove("active", "show"));

      // Activate Consults tab and pane
      consultTabBtn.classList.add("active");
      consultTabPane.classList.add("active", "show");
      loadUserConsults();

    }
  } else {
    // Default: show Articles tab
    document.querySelector("#articles-tab").classList.add("active");
    document.querySelector("#articles").classList.add("active", "show");
  }

  const consultTabBtn = document.querySelector("#consults-tab");
  if (consultTabBtn) {
    consultTabBtn.addEventListener("click",  () => {
      loadUserConsults();
    });
  }

  function clearURLParams() {
    const url = new URL(window.location);
    url.searchParams.delete("openConsults");
    url.searchParams.delete("docId");
    url.searchParams.delete("consultDate"); 

    filterDocId = null;

    window.history.replaceState({}, document.title, url.pathname + url.search);
  }
  
  async function loadUserConsults() {
    const consultsRow = document.getElementById("consultsRow");
    consultsRow.innerHTML = ""; // ✅ CLEAR first

    const uid = currentUserId;

    let snap = await firebase.firestore()
    .collection("Consult")
    .where("userID", "==", uid)
    .get();

    if (snap.empty) {
      consultsRow.innerHTML =
        `<p class="text-muted text-center">No consults scheduled yet</p>`;
      return;
    }

    
    let consults = snap.docs.map(doc => ({
      id: doc.id,
      ...doc.data()
    }));

    // 🔥 Filter consults by QuoteAlert document
    if (filterDocId) {
      consults = consults.filter(c => c.documentID === filterDocId);
      clearURLParams();
    }

    renderConsults(consults); // ✅ SINGLE render call
  }

  async function confirmAction(title, text, confirmText = "Yes") {
    const result = await Swal.fire({
      title,
      text,
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#d33",
      cancelButtonColor: "#6c757d",
      confirmButtonText: confirmText,
      cancelButtonText: "No",
      reverseButtons: true,
    });

    return result.isConfirmed;
  }

  function showZoomAlert(joinURL, password) {
    Swal.fire({
      title: "Ready to Join",
      // icon: "success",
      html: `
        <p><strong>Meeting Password:</strong> ${password}</p>
      `,
      confirmButtonText: "Join Now",
      showCancelButton: true,
      cancelButtonText: "Cancel",
    }).then(result => {
      if (result.isConfirmed) {
        openZoomMeeting(joinURL);
      }
    });
  }
  // function showZoomAlert(joinURL, password) {
  //   // Remove existing alert if present
  //   document.querySelector(".zoom-alert-wrapper")?.remove();

  //   const wrapper = document.createElement("div");
  //   wrapper.className = "zoom-alert-wrapper";
  //   wrapper.innerHTML = `
  //     <div class="zoom-alert" style="
  //       position:fixed;
  //       top:30%;
  //       left:50%;
  //       transform:translateX(-50%);
  //       background:#fff;
  //       padding:20px;
  //       border-radius:8px;
  //       z-index:9999;
  //       box-shadow:0 2px 10px rgba(0,0,0,0.3);
  //     ">
  //       <p><strong>Password:</strong> ${password}</p>
  //       <div class="d-flex gap-2 justify-content-end">
  //         <button class="btn btn-join btn-consult">Join Meeting</button>
  //         <button class="btn btn-secondary btn-sm btn-zoom-cancel">Cancel</button>
  //       </div>
  //     </div>
  //   `;

  //   document.body.appendChild(wrapper);

  //   wrapper.querySelector(".btn-zoom-join").onclick = () => {
  //     openZoomMeeting(joinURL);
  //     wrapper.remove();
  //   };

  //   wrapper.querySelector(".btn-zoom-cancel").onclick = () => {
  //     wrapper.remove();
  //   };
  // }

  function openZoomMeeting(joinURL) {
    // Zoom app URL scheme
    const zoomAppURL = joinURL.replace("https://", "zoomus://");

    if (navigator.userAgent.match(/iPhone|iPad|iPod|Android/i)) {
      // Mobile: try app first
      window.location.href = zoomAppURL;
      setTimeout(() => window.open(joinURL, "_blank"), 500); // fallback to browser
    } else {
      // Desktop: open browser
      window.open(joinURL, "_blank");
    }
  }

  async function fetchAvailableSlots(attorneyId, quoteId, selectedDate) {
    try {
      // 🔹 Fetch attorney record
      const attorneySnap = await db.collection("LawFirm").doc(attorneyId).get();

      if (!attorneySnap.exists) {
        throw new Error("Law firm not found");
      }

      const attorneyData = attorneySnap.data();

      const eventTypeURL = attorneyData?.scheduleEvent;
      const calendlyToken = attorneyData?.clandlyToken; // 🔐 MUST be token

      // ✅ Strict validation
      if (!eventTypeURL || !eventTypeURL.trim()) {
        throw new Error("Scheduling not configured");
      }

      if (!calendlyToken || !calendlyToken.trim()) {
        throw new Error("Calendly token missing");
      }

      Swal.fire({
        title: "Loading available slots...",
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
      });

      // ✅ UPDATE: Enforce 15-minute buffer for same-day scheduling
      const now = new Date();
      const selected = new Date(`${selectedDate}T00:00:00`);

      let startTime;
      if (now.toDateString() === selected.toDateString()) {
        startTime = new Date(now.getTime() + 15 * 60 * 1000);
      } else {
        startTime = selected;
      }

      const endTime = new Date(`${selectedDate}T23:59:59`);

      const startUTC = startTime.toISOString();
      const endUTC = endTime.toISOString();

      // 🔹 Calendly API
      const url = new URL("https://api.calendly.com/event_type_available_times");
      url.search = new URLSearchParams({
        event_type: eventTypeURL,
        start_time: startUTC,
        end_time: endUTC
      });

      const res = await fetch(url.toString(), {
        method: "GET",
        headers: {
          Authorization: `Bearer ${calendlyToken}`,
          "Content-Type": "application/json"
        }
      });

      if (!res.ok) {
        throw new Error("Calendly API failed");
      }

      const data = await res.json();

      const availableSlots = data.collection.filter(
        slot => slot.status === "available"
      );

      Swal.close();

      if (!availableSlots.length) {
        Swal.fire("No Slots", "No time slots available for this date", "info");
        return;
      }

      // ✅ Correct data received
      showTimeSlots(attorneyId, quoteId, selectedDate, availableSlots);

    } catch (err) {
      Swal.close();
      Swal.fire("Error", err.message, "error");
    }
  }

   async function showTimeSlots(attorneyId, quoteId, date, slots) {
    // Fetch attorney details from LawFirm + Users collection
    const attorneySnap = await db.collection("LawFirm").doc(attorneyId).get();
    if (!attorneySnap.exists) throw new Error("Law firm not found");
    const attorneyData = attorneySnap.data();

    // Try to fetch name from Users collection
    let attorneyName = "Unknown Attorney";
    try {
      const userSnap = await db.collection("Users").doc(attorneyId).get();
      if (userSnap.exists) {
        const userData = userSnap.data();
        attorneyName = userData?.Name 
                    || (userData?.firstName && userData?.lastName ? `${userData.firstName} ${userData.lastName}` : null)
                    || attorneyData?.name 
                    || "Unknown Attorney";
      } else {
        // fallback to LawFirm name
        attorneyName = attorneyData?.name || "Unknown Attorney";
      }
    } catch (err) {
      console.warn("Failed to fetch attorney name from Users collection:", err);
      attorneyName = attorneyData?.name || "Unknown Attorney";
    }

    const buttonsHTML = slots
      .map(slot => {
        const time = new Date(slot.start_time).toLocaleTimeString([], {
          hour: "2-digit",
          minute: "2-digit"
        });

        return `
          <button 
            class="time-slot btn btn-outline-primary m-1"
            data-start='${slot.start_time}'
          >
            ${time}
          </button>
        `;
      })
      .join("");

    Swal.fire({
      title: `Available Times – ${date}`,
      html: `<div class="d-flex flex-wrap justify-content-center">${buttonsHTML}</div>`,
      showCancelButton: true,
      showConfirmButton: false,

      didOpen: () => {
        document.querySelectorAll(".time-slot").forEach(btn => {
          btn.addEventListener("click", async () => {
            Swal.close();

            const start_time = btn.dataset.start;

            await scheduleCalendlyEvent({
              attorneyId: attorneyId,
              attorneyName: attorneyName, // now dynamic
              quoteId: quoteId,
              slot: { start_time },
              // inviteeName: firebase.auth().currentUser.name || "Client",
              inviteeName: firebase.auth().currentUser.displayName || "Client",
              inviteeEmail: firebase.auth().currentUser.email
            });
          });
        });
      }
    });
  }

  async function getEventTypeURL(attorneyId) {
    const snap = await db.collection("LawFirm").doc(attorneyId).get();

    if (!snap.exists) {
      throw new Error("Law firm not found");
    }

    const data = snap.data();
    const scheduleEvent = data?.scheduleEvent;

    // ✅ strict validation
    if (
      !scheduleEvent ||
      typeof scheduleEvent !== "string" ||
      !scheduleEvent.trim()
    ) {
      throw new Error("Scheduling is not configured for this attorney");
    }

    return scheduleEvent.trim();
  }

  async function scheduleCalendlyEvent({
    attorneyId,
    attorneyName,
    quoteId,
    slot,
    inviteeName,
    inviteeEmail
  }) {
    try {
      // 🔹 Fetch attorney (LawFirm)
      const attorneySnap = await db.collection("LawFirm").doc(attorneyId).get();

      if (!attorneySnap.exists) {
        throw new Error("Law firm not found");
      }

      const attorneyData = attorneySnap.data();
      const eventTypeURL = attorneyData?.scheduleEvent;
      const token = attorneyData?.clandlyToken;

      if (!eventTypeURL || !eventTypeURL.trim()) {
        throw new Error("Scheduling not configured");
      }

      if (!token || !token.trim()) {
        throw new Error("Calendly token missing");
      }

      // 🔹 Calendly API request
      const response = await fetch("https://api.calendly.com/invitees", {
        method: "POST",
        headers: {
          Authorization: `Bearer ${token}`,
          "Content-Type": "application/json"
        },
        body: JSON.stringify({
          event_type: eventTypeURL,
          start_time: new Date(slot.start_time).toISOString(),
          invitee: {
            name: inviteeName,
            email: inviteeEmail,
            timezone: Intl.DateTimeFormat().resolvedOptions().timeZone
          },
          location: {
            kind: "zoom_conference"
          }
        })
      });

      const raw = await response.text();

      if (!response.ok) {
        throw new Error("Scheduling failed");
      }

      const decoded = JSON.parse(raw);
      const resource = decoded.resource;

      // 🔹 Save to Consult collection (MATCHING YOUR SCHEMA)
      await db.collection("Consult").add({
        attorneyId: attorneyId,
        attorneyName: attorneyName,
        userID: firebase.auth().currentUser.uid,

        documentID: quoteId,
        inviteeEmail: resource.email,

        cancel_url: resource.cancel_url,
        reschedule_url: resource.reschedule_url,
        scheduled_event_join_url: resource.uri,

        token: token,
        created_at: new Date(slot.start_time).getTime(),
      });

      // 2️⃣ Update Quote document
      await db.collection("QuoteAlert").doc(quoteId).set(
        {
          scheduledConsult: firebase.firestore.FieldValue.arrayUnion(attorneyId)
        },
        { merge: true }
      );
      Swal.fire(
        "Consult Scheduled 🎉",
        "Your consult has been successfully booked",
        "success"
        
      );
      await loadUserConsults();

    } catch (error) {
      Swal.fire("Error", error.message, "error");
    }
  }

  function extractCancellationUUID(urlString) {
    if (!urlString) return null;

    const start = urlString.indexOf("/scheduled_events/");
    const end = urlString.indexOf("/invitees/");

    if (start === -1 || end === -1) return null;

    return urlString.substring(
      start + "/scheduled_events/".length,
      end
    );
  }

  async function cancelCalendlyMeeting(joinURL, token) {
    // console.log("Attempting to cancel Calendly meeting:", joinURL, token);
    
    const uuid = extractCancellationUUID(joinURL);

    // console.log("UUID extracted OK:", uuid);
    
    if (!uuid) {
      throw new Error("Invalid cancellation URL");
    }

    const apiURL = `https://api.calendly.com/scheduled_events/${uuid}/cancellation`;

    const res = await fetch(apiURL, {
      method: "POST",
      headers: {
        Authorization: `Bearer ${token}`,
        "Content-Type": "application/json"
      }
    });

    if (!res.ok) {
      throw new Error(`Calendly cancel failed (${res.status})`);
    }
    let json = await res.json();

    return true;
  }

  async function onCancelConsult(data) {
    try {

      // 1️⃣ Get attorney (law firm) token
      const lawFirmSnap = await db
        .collection("LawFirm")
        .doc(data.attorneyId)
        .get();

      if (!lawFirmSnap.exists) {
        throw new Error("Attorney does not exist");
      }

      const lawFirm = lawFirmSnap.data();
      const token = lawFirm.clandlyToken;

      // 2️⃣ Cancel Calendly meeting
      await cancelCalendlyMeeting(data.scheduled_event_join_url, token);

      // 3️⃣ Delete Consult document
      await db.collection("Consult").doc(data.docId).delete();

      // 4️⃣ Remove attorneyId from scheduledConsult array
      const quoteRef = db.collection("QuoteAlert").doc(data.documentID);

      await quoteRef.update({
        scheduledConsult: firebase.firestore.FieldValue.arrayRemove(
          data.attorneyId
        )
      });

      hideLoader();
      reloadConsultList();

    } catch (err) {
      hideLoader();
      console.error("Cancel failed:", err);
      alert(err.message);
    }
  }

  async function deleteConsultAndUpdateQuote(consultDocId) {
    try {
      // 1️⃣ Get consult document
      const consultRef = db.collection("Consult").doc(consultDocId);
      const consultSnap = await consultRef.get();

      if (!consultSnap.exists) {
        throw new Error("Consult document not found");
      }

      const consultData = consultSnap.data();

      const quoteId = consultData.documentID;      // QuoteAlert doc id
      const attorneyId = consultData.attorneyId;   // value inside scheduledConsult[]

      if (!quoteId || !attorneyId) {
        throw new Error("Missing documentID or attorneyId");
      }

      // 2️⃣ Delete consult document
      await consultRef.delete();

      // 3️⃣ Remove attorneyId from QuoteAlert.scheduledConsult
      await db.collection("QuoteAlert")
        .doc(quoteId)
        .update({
          scheduledConsult: firebase.firestore.FieldValue.arrayRemove(attorneyId)
        });

      console.log("✅ Consult deleted & Quote updated");

    } catch (error) {
      console.error("❌ Delete consult failed:", error.message);
    }
  }

  function showLoader() {
    document.getElementById("loaderOverlay2").style.display = "flex";
  }

  function hideLoader() {
    const hideLoad = document.getElementById("loaderOverlay2");
    if (!hideLoad) return; // ✅ prevent crash
    hideLoad.style.display = "none";
  }

</script>