  <!-- main -->
  <main class="">
    <div class="container-fluid">
      <div class="my-5 min-h-80">
        <p class="f6" data-i18n="support"></p>

        <div class="row justify-content-center">
          <div class="col-md-6">
            <form>
              <div class="mb-3">
                <label for="fullName" class="form-label custom-label" data-i18n="full_name"></label>
            <input
              type="text"
              class="form-control custom-input"
              id="fullName"
              placeholder=""
              required
              data-i18n-placeholder="enter_full_name"
            />
              </div>

              <div class="mb-3">
                <label for="email" class="form-label custom-label" data-i18n="email"></label>
                <input type="email" class="form-control custom-input" id="email" placeholder="" required
                  data-i18n-placeholder="enter_email" />
              </div>

              <div class="mb-3">
                <label for="message" class="form-label custom-label" data-i18n="message"></label>
            <textarea
              class="form-control custom-input"
              id="message"
              name="message"
              rows="5"
              required
              data-i18n-placeholder="enter_message"
            ></textarea>
              </div>

              <div class="row justify-content-center">
                <div class="col-md-6">
                  <button type="submit" class="btn btn-save w-100" data-i18n="submit"></button>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>

  </main>

<script src="<?= base_url('assets/js/subscription.js'); ?>"></script>

<script>
  firebase.auth().onAuthStateChanged(async (user) => {
    if (!user) return;

    const allowed = await checkMembershipAccess({
      redirectTo: "<?php echo base_url('site/membership'); ?>"
    });

    if (!allowed) return;

    // ✅ Page logic continues ONLY if allowed
    console.log("User allowed to access support page");
  });

  document.querySelector("form").addEventListener("submit", function (e) {
    e.preventDefault();

    const fullName = document.getElementById("fullName").value.trim();
    const email = document.getElementById("email").value.trim();
    const message = document.getElementById("message").value.trim();

    // Validation
    if (!fullName || !email || !message) {
      Swal.fire("Missing Fields", "Please fill in all required fields.", "warning");
      return;
    }

    // Optional: Email format check
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailRegex.test(email)) {
      Swal.fire("Invalid Email", "Please enter a valid email address.", "warning");
      return;
    }

    // Log values (you can remove this later)
    console.log("Full Name:", fullName);
    console.log("Email:", email);
    console.log("Message:", message);

    // Simulate sending email
    Swal.fire("Success", "Your email has been successfully sent!", "success");

    // Optionally reset form
    document.querySelector("form").reset();
  });
</script>
