window.checkMembershipAccess = async function ({redirectTo = "<?php echo base_url('site/membership'); ?>" , showAlert = true} = {}) {

  firebase.initializeApp(firebaseConfig)
  
  const user = firebase.auth().currentUser;
  if (!user) {
    window.location.href = "<?php echo base_url('site/login'); ?>";
    return false;
  }

  try {
    const userDoc = await firebase
      .firestore()
      .collection("Users")
      .doc(user.uid)
      .get();

    if (!userDoc.exists) {
      window.location.href = "<?php echo base_url('site/login'); ?>";
      return false;
    }

    const data = userDoc.data();
    const now = new Date();

    const isCanceledButValid =
      data.subscriptionStatus === "canceled" &&
      data.subscriptionEndDate &&
      data.subscriptionEndDate.toMillis() > now.getTime();

    const hasAccess =
      data.allowAllFeatureFree === true ||
      data.subscription_active === true ||
      data.subscriptionStatus === "active"||
      isCanceledButValid;

    if (hasAccess) return true;

    // 🔒 NO ACCESS → show modal
    if (showAlert) {
      const result = await Swal.fire({
        title: "You've discovered a premium feature!",
        html: `
          <p class="mb-0">
            Upgrade to <strong>DuePro Plus</strong> to unlock it.
          </p>
        `,
        icon: "info",
        showCancelButton: true,
        confirmButtonText: "Continue",
        cancelButtonText: "Close",
        confirmButtonColor: "#0421CA",
        cancelButtonColor: "#6c757d",
        reverseButtons: true,
        allowOutsideClick: false
      });

      if (result.isConfirmed) {
        window.location.href = redirectTo;   // 👉 Membership page
      } 
      // else {
      //   window.history.back();               // 👉 Go back safely
      // }
    }

    return false;

  } catch (err) {
    console.error("Membership check failed:", err);
    Swal.fire("Error", "Something went wrong. Please try again.", "error");
    return false;
  }
};

window.checkAttorneyMembershipAccess = async function ({
  redirectTo = "<?php echo base_url('site/subscriptionAttorney'); ?>" , showAlert = true
} = {}) {

  const user = firebase.auth().currentUser;
  if (!user) {
    window.location.href = "<?php echo base_url('site/login'); ?>";
    return false;
  }

  try {
    const db = firebase.firestore();

    // 1️⃣ Get attorney law firm doc
    const lawfirmDoc = await db
      .collection("LawFirm")
      .doc(user.uid)
      .get();

    if (!lawfirmDoc.exists) {
      window.location.href = "<?php echo base_url('site/login'); ?>";
      return false;
    }

    const data = lawfirmDoc.data();
    const now = new Date();


    // ✅ Check if canceled but still valid (hasn't expired yet)
    const isUserCanceledButValid =
      data.subscriptionStatus === "canceled" &&
      data.subscriptionEndDate &&
      data.subscriptionEndDate.toMillis() > now.getTime();

    // 2️⃣ Check own subscription
    const hasOwnAccess =
      data.allowAllFeatureFree === true ||
      data.subscription_active === true ||
      data.subscriptionStatus === "active" || 
      isUserCanceledButValid;

    if (hasOwnAccess) return true;

    // 3️⃣ 🔗 If attached with another law firm → check parent
    if (data.attachedWithLawfirmId) {
      const parentFirmDoc = await db
        .collection("LawFirm")
        .doc(data.attachedWithLawfirmId)
        .get();

      if (parentFirmDoc.exists) {
        const parentData = parentFirmDoc.data();

        const isCanceledButValid =
        parentData.subscriptionStatus === "canceled" &&
        parentData.subscriptionEndDate &&
        parentData.subscriptionEndDate.toMillis() > now.getTime();

        const parentHasAccess =
          parentData.allowAllFeatureFree === true ||
          parentData.subscription_active === true ||
          parentData.subscriptionStatus === "active" ||
          isCanceledButValid;

        if (parentHasAccess) {
          return true; // ✅ inherited access
        }
      }
    }

    // 🔒 NO ACCESS → show modal
    if (showAlert) {
      const result = await Swal.fire({
        title: "You've discovered a premium feature!",
        html: `
          <p class="mb-0">
            Upgrade to <strong>DuePro Plus</strong> to unlock it.
          </p>
        `,
        icon: "info",
        showCancelButton: true,
        confirmButtonText: "Continue",
        cancelButtonText: "Close",
        confirmButtonColor: "#0421CA",
        cancelButtonColor: "#6c757d",
        reverseButtons: true,
        allowOutsideClick: false
      });

      if (result.isConfirmed) {
        window.location.href = redirectTo;
      }
    }

    return false;

  } catch (err) {
    console.error("Membership check failed:", err);
    Swal.fire("Error", "Something went wrong. Please try again.", "error");
    return false;
  }
};

// window.checkMembershipAccess = async function ({
//   redirectTo = "/dashboard",
//   showAlert = true
// } = {}) {

//   firebase.initializeApp(firebaseConfig)
  
//   const user = firebase.auth().currentUser;
//   if (!user) {
//     window.location.href = "/login";
//     return false;
//   }

//   try {
//     const userDoc = await firebase
//       .firestore()
//       .collection("Users")
//       .doc(user.uid)
//       .get();

//     if (!userDoc.exists) {
//       window.location.href = "/login";
//       return false;
//     }

//     const data = userDoc.data();
//     const now = new Date();

//     // ✅ Check multiple subscription scenarios
//     const hasAllFeatureFree = data.allowAllFeatureFree === true;
//     const hasLegacyActive = data.subscription_active === true;
//     const hasStripeActive = data.subscriptionStatus === "active";
    
//     // ✅ Check if canceled but still valid (hasn't expired yet)
//     const isCanceledButValid =
//       data.subscriptionStatus === "canceled" &&
//       data.subscriptionEndDate &&
//       data.subscriptionEndDate.toMillis() > now.getTime();

//     const hasAccess = 
//       hasAllFeatureFree || 
//       hasLegacyActive || 
//       hasStripeActive || 
//       isCanceledButValid;

//     if (hasAccess) return true;

//     // 🔒 NO ACCESS → show modal
//     if (showAlert) {
//       const result = await Swal.fire({
//         title: "You've discovered a premium feature!",
//         html: `
//           <p class="mb-0">
//             Upgrade to <strong>DuePro Plus</strong> to unlock it.
//           </p>
//         `,
//         icon: "info",
//         showCancelButton: true,
//         confirmButtonText: "Continue",
//         cancelButtonText: "Close",
//         confirmButtonColor: "#0421CA",
//         cancelButtonColor: "#6c757d",
//         reverseButtons: true,
//         allowOutsideClick: false
//       });

//       if (result.isConfirmed) {
//         window.location.href = redirectTo;   // 👉 Membership page
//       }
//     }

//     return false;

//   } catch (err) {
//     console.error("Membership check failed:", err);
//     Swal.fire("Error", "Something went wrong. Please try again.", "error");
//     return false;
//   }
// };

// window.checkAttorneyMembershipAccess = async function ({
//   redirectTo = "site/dashboard",
//   showAlert = true
// } = {}) {

//   const user = firebase.auth().currentUser;
//   if (!user) {
//     window.location.href = "site/login";
//     return false;
//   }

//   try {
//     const db = firebase.firestore();
//     const now = new Date();

//     // 1️⃣ Get attorney law firm doc
//     const lawfirmDoc = await db
//       .collection("LawFirm")
//       .doc(user.uid)
//       .get();

//     if (!lawfirmDoc.exists) {
//       window.location.href = "site/login";
//       return false;
//     }

//     const data = lawfirmDoc.data();

//     // 2️⃣ Check own subscription with all scenarios
//     const hasAllFeatureFree = data.allowAllFeatureFree === true;
//     const hasLegacyActive = data.subscription_active === true;
//     const hasStripeActive = data.subscriptionStatus === "active";
    
//     // ✅ Check if canceled but still valid (hasn't expired yet)
//     const isCanceledButValid =
//       data.subscriptionStatus === "canceled" &&
//       data.subscriptionEndDate &&
//       data.subscriptionEndDate.toMillis() > now.getTime();

//     const hasOwnAccess = 
//       hasAllFeatureFree || 
//       hasLegacyActive || 
//       hasStripeActive || 
//       isCanceledButValid;

//     if (hasOwnAccess) return true;

//     // 3️⃣ 🔗 If attached with another law firm → check parent
//     if (data.attachedWithLawfirmId) {
//       const parentFirmDoc = await db
//         .collection("LawFirm")
//         .doc(data.attachedWithLawfirmId)
//         .get();

//       if (parentFirmDoc.exists) {
//         const parentData = parentFirmDoc.data();

//         const parentHasAllFeatureFree = parentData.allowAllFeatureFree === true;
//         const parentHasLegacyActive = parentData.subscription_active === true;
//         const parentHasStripeActive = parentData.subscriptionStatus === "active";
        
//         // ✅ Check if parent's subscription is canceled but still valid
//         const parentIsCanceledButValid =
//           parentData.subscriptionStatus === "canceled" &&
//           parentData.subscriptionEndDate &&
//           parentData.subscriptionEndDate.toMillis() > now.getTime();

//         const parentHasAccess = 
//           parentHasAllFeatureFree || 
//           parentHasLegacyActive || 
//           parentHasStripeActive || 
//           parentIsCanceledButValid;

//         if (parentHasAccess) {
//           return true; // ✅ inherited access
//         }
//       }
//     }

//     // 🔒 NO ACCESS → show modal
//     if (showAlert) {
//       const result = await Swal.fire({
//         title: "You've discovered a premium feature!",
//         html: `
//           <p class="mb-0">
//             Upgrade to <strong>DuePro Plus</strong> to unlock it.
//           </p>
//         `,
//         icon: "info",
//         showCancelButton: true,
//         confirmButtonText: "Continue",
//         cancelButtonText: "Close",
//         confirmButtonColor: "#0421CA",
//         cancelButtonColor: "#6c757d",
//         reverseButtons: true,
//         allowOutsideClick: false
//       });

//       if (result.isConfirmed) {
//         window.location.href = redirectTo;
//       }
//     }

//     return false;

//   } catch (err) {
//     console.error("Membership check failed:", err);
//     Swal.fire("Error", "Something went wrong. Please try again.", "error");
//     return false;
//   }
// };