# Order Module Documentation

## Overview
The Order Module provides comprehensive order management functionality with advanced date filtering capabilities. It allows administrators to view, filter, and manage orders from the Firebase Orders collection.

## Features

### 1. Date Filtering
- **Today's Orders**: Shows only orders from the current date
- **Date Range Filter**: Filter orders between specific start and end dates
- **All Orders**: View all orders without date restrictions

### 2. Status Management
- Update order status (Pending, Confirmed, Processing, Shipped, Delivered, Cancelled)
- Visual status indicators with color-coded badges
- Bulk status updates

### 3. Order Management
- View detailed order information
- Delete orders
- Customer information display
- Order items and pricing details

## File Structure

### Models
- `application/models/Order_model.php` - Contains all database operations for orders

### Controllers
- `application/controllers/Dashboard.php` - Contains order management methods:
  - `orders()` - Main orders listing with filters
  - `update_order_status()` - Update order status
  - `delete_order()` - Delete an order
  - `view_order()` - View detailed order information

### Views
- `application/views/orders.php` - Main orders listing page with filters
- `application/views/view_order.php` - Detailed order view page

## Usage

### Accessing the Order Module
1. Navigate to the sidebar menu
2. Click on "Orders" (already configured in sidebar.php)
3. The system will default to showing today's orders

### Filtering Orders

#### Today's Orders (Default)
- Automatically shows orders from the current date
- No additional configuration needed

#### Date Range Filter
1. Select "Date Range" from the Filter Type dropdown
2. Choose Start Date and End Date
3. Optionally select a specific status
4. Click "Apply Filter"

#### All Orders
- Select "All Orders" to view all orders regardless of date

### Order Status Management
1. Click the "Status" dropdown button next to any order
2. Select the new status from the dropdown
3. Confirm the status change

### Viewing Order Details
1. Click the "View" button next to any order
2. View comprehensive order information including:
   - Customer details
   - Shipping information
   - Order items
   - Payment information
   - Order notes

## Firebase Collection Structure

The module expects orders to be stored in the Firebase "Orders" collection with the following structure:

```json
{
  "orderId": {
    "date": 1640995200000,  // Timestamp in milliseconds
    "status": "pending",    // pending, confirmed, processing, shipped, delivered, cancelled
    "customerName": "John Doe",
    "customerEmail": "john@example.com",
    "customerPhone": "+1234567890",
    "customerId": "customer_firebase_id",
    "totalAmount": 99.99,
    "paymentMethod": "credit_card",
    "shippingMethod": "standard",
    "shippingAddress": {
      "address": "123 Main St",
      "city": "New York",
      "state": "NY",
      "postalCode": "10001",
      "country": "USA"
    },
    "items": [
      {
        "productName": "Product 1",
        "productId": "product_id",
        "quantity": 2,
        "price": 49.99
      }
    ],
    "notes": "Special delivery instructions"
  }
}
```

## API Methods

### Order Model Methods

#### `get_all_orders()`
Returns all orders from the Orders collection.

#### `get_today_orders()`
Returns orders from the current date only.

#### `get_orders_by_date_range($start_date, $end_date)`
Returns orders within a specific date range.
- Parameters: Start date and end date in Y-m-d format
- Returns: Array of orders

#### `get_orders_with_filters($start_date, $end_date, $status)`
Returns orders filtered by date range and optional status.
- Parameters: Start date, end date, and optional status
- Returns: Array of filtered orders

#### `update_order_status($order_id, $status)`
Updates the status of a specific order.
- Parameters: Order ID and new status
- Returns: Boolean success status

#### `delete_order($order_id)`
Deletes an order from the collection.
- Parameters: Order ID
- Returns: Boolean success status

## Configuration

### Required Dependencies
- CodeIgniter Framework
- Firebase PHP SDK
- Bootstrap 4 (for UI components)
- DataTables (for table functionality)

### Firebase Configuration
Ensure Firebase is properly configured in:
- `application/config/firebase.php`
- Firebase service account key file

## Customization

### Adding New Status Types
1. Update the status dropdown options in `orders.php` and `view_order.php`
2. Add corresponding badge classes in the `getStatusBadgeClass()` function
3. Update the Firebase collection structure if needed

### Modifying Date Filtering
The date filtering logic can be customized in the `Order_model.php` file by modifying the timestamp conversion and Firebase query methods.

## Troubleshooting

### Common Issues

1. **Orders not displaying**: Check Firebase connection and collection name
2. **Date filters not working**: Verify date format and timestamp conversion
3. **Status updates failing**: Check Firebase permissions and data structure

### Debug Mode
Enable debug mode in CodeIgniter to see detailed error messages:
```php
$config['log_threshold'] = 4; // In application/config/config.php
```

## Support
For technical support or feature requests, please refer to the main application documentation or contact the development team.
