<div class="main">
	<p class="fd-3">Ride Details</p>

	<?php $r = isset($ride) ? $ride : array(); ?>

	<div class="card m-card mb-3">
		<div class="card-body">
			<table class="table table-bordered table-striped mb-0">
				<tbody>
					<?php if(isset($r['bookingId'])) { ?>
					<tr>
						<th style="width: 220px;">Booking ID</th>
						<td><?php echo htmlspecialchars($r['bookingId']); ?></td>
					</tr>
					<?php } ?>
					<?php if(isset($r['status'])) { ?>
					<tr>
						<th>Status</th>
						<td><span class="badge bg-primary"><?php echo htmlspecialchars($r['status']); ?></span></td>
					</tr>
					<?php } ?>
					<?php if(isset($r['bookingType'])) { ?>
					<tr>
						<th>Booking Type</th>
						<td><?php echo htmlspecialchars($r['bookingType']); ?></td>
					</tr>
					<?php } ?>
					<?php if(isset($r['userId'])) { ?>
					<tr>
						<th>User ID</th>
						<td><?php echo htmlspecialchars($r['userId']); ?></td>
					</tr>
					<?php } ?>
					<?php if(isset($r['driverId'])) { ?>
					<tr>
						<th>Driver ID</th>
						<td><?php echo htmlspecialchars($r['driverId']); ?></td>
					</tr>
					<?php } ?>
					<?php if(isset($r['carType'])) { ?>
					<tr>
						<th>Car Type</th>
						<td><?php echo htmlspecialchars($r['carType']); ?></td>
					</tr>
					<?php } ?>
					<?php if(isset($r['price'])) { ?>
					<tr>
						<th>Price</th>
						<td>$<?php echo htmlspecialchars($r['price']); ?></td>
					</tr>
					<?php } ?>
					<?php if(isset($r['estimatedDistance'])) { ?>
					<tr>
						<th>Estimated Distance</th>
						<td><?php echo htmlspecialchars($r['estimatedDistance']); ?> km</td>
					</tr>
					<?php } ?>
					<?php if(isset($r['estimatedDuration'])) { ?>
					<tr>
						<th>Estimated Duration</th>
						<td><?php echo htmlspecialchars($r['estimatedDuration']); ?> mins</td>
					</tr>
					<?php } ?>
					<?php if(isset($r['pickupDate'])) { ?>
					<tr>
						<th>Pickup Date</th>
						<td><?php echo date('d F, Y h:i A', $r['pickupDate']/1000); ?></td>
					</tr>
					<?php } ?>
					<?php if(isset($r['createdAt'])) { ?>
					<tr>
						<th>Created At</th>
						<td><?php echo is_numeric($r['createdAt']) ? date('d F, Y h:i A', intval($r['createdAt'])) : htmlspecialchars($r['createdAt']); ?></td>
					</tr>
					<?php } ?>
					<?php if(isset($r['scheduledDateTime']) && !empty($r['scheduledDateTime'])) { ?>
					<tr>
						<th>Scheduled For</th>
						<td><?php echo htmlspecialchars($r['scheduledDateTime']); ?></td>
					</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>
	</div>

	<div class="row g-3">
		<div class="col-md-6">
			<div class="card m-card h-100">
				<div class="card-body">
					<p class="fd-5 mb-3">Locations</p>
					<table class="table table-sm table-bordered mb-0">
						<tbody>
							<?php if(isset($r['pickUp']['address'])) { ?>
							<tr>
								<th style="width: 180px;">Pickup Location</th>
								<td><?php echo htmlspecialchars($r['pickUp']['address']); ?></td>
							</tr>
							<?php } elseif(isset($r['pickupLocation'])) { ?>
							<tr>
								<th>Pickup Location</th>
								<td><?php echo htmlspecialchars($r['pickupLocation']); ?></td>
							</tr>
							<?php } ?>
							<?php if(isset($r['destinations'][0]['address'])) { ?>
							<tr>
								<th>Drop-off Location</th>
								<td><?php echo htmlspecialchars($r['destinations'][0]['address']); ?></td>
							</tr>
							<?php } elseif(isset($r['dropLocation'])) { ?>
							<tr>
								<th>Drop-off Location</th>
								<td><?php echo htmlspecialchars($r['dropLocation']); ?></td>
							</tr>
							<?php } ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="col-md-6">
			<div class="card m-card h-100">
				<div class="card-body">
					<p class="fd-5 mb-3">Payment</p>
					<table class="table table-sm table-bordered mb-0">
					<tbody>

<tr>
	<th style="width: 180px;">Payment Status</th>
	<td><?php echo "Paid"; ?></td>
</tr>


<tr>
	<th>Amount</th>
	<td>
		<?php echo '$'.$r['price']; ?>
	</td>
</tr>
<tr>
	<th>Method</th>
	<td><?php echo "Card"; ?></td>
</tr>

</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
	<?php if(isset($r['routeDetails']) && is_array($r['routeDetails'])) { ?>
	<div class="card m-card mt-3">
		<div class="card-body">
			<p class="fd-5 mb-3">Route Details</p>
			<table class="table table-sm table-bordered mb-0">
				<tbody>
					<tr>
						<th style="width: 220px;">Distance</th>
						<td><?php echo $r['distance']; ?></td>
					</tr>
					<tr>
						<th>Duration</th>
						<td><?php echo $r['time']; ?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<?php } ?>

	<?php
	// Generic key/value dump for any additional fields (simple scalars only)
	$knownKeys = array('bookingId','status','bookingType','userId','driverId','carType','price','estimatedDistance','estimatedDuration','pickupDate','createdAt','scheduledDateTime','pickUp','destinations','pickupLocation','dropLocation','paymentStatus','paymentDetails','routeDetails');
	$extra = array();
	if(is_array($r)){
		foreach($r as $k => $v){
			if(in_array($k, $knownKeys)) continue;
			if(is_scalar($v)) { $extra[$k] = $v; }
		}
	}
	?>
	<?php if(empty($extra)) { ?>
	<div class="card m-card mt-3">
		<div class="card-body">
			<p class="fd-5 mb-3">More Information</p>
			<table class="table table-sm table-bordered mb-0">
				<tbody>
					<?php foreach($extra as $k => $v) { ?>
					<tr>
						<th style="width: 220px; "><?php echo htmlspecialchars(ucwords(str_replace('_',' ',$k))); ?></th>
						<td><?php echo htmlspecialchars((string)$v); ?></td>
					</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>
	</div>
	<?php } ?>

	<div class="mt-3">
		<a href="<?php echo base_url('dashboard/complete_ride'); ?>" class="btn btn-secondary">Back to Rides</a>
	</div>
</div>

