<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Customer extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->model('customer_model');
		$this->load->model('common');
		$this->load->helper(array('form', 'url', 'string'));
		$this->load->library('form_validation');
		$this->load->library('session');
	}

	public function getDetail($id='2BtLSx35cxZah9w6EMGumhxHTmX2'){
		
			$data['user'] = $this->common->readdatadocument("Users",$id);
				// echo "<pre>";
				// print_r($data);
				// echo "</pre>";
				$this->load->view('vehicle_view',$data);

	}	

	public function index()
	{
		$data['customerlist'] = $this->common->readdatafromcollectionwhereclause("Users","userRole","=","user");
		$this->template->template_render('customer_management', $data);
	}

	public function contacts()
	{
		$data['customerlist'] = $this->common->readdatafromcollectionwhereclause("Contacts");
		$this->template->template_render('contact_management', $data);
	}

	public function fixers()
	{
		$fixers = $this->common->readdatafromcollectionwhereclause("Users","userRole","=","fixer");
		$allFixers = array();
		foreach($fixers as $key => $fixer){
			$allFixers[$key] = $fixer;
			$country = $this->common->readdatadocument("Countries",$fixer['country']);
			$allFixers[$key]['country'] = $country['name'];
			$city = $this->common->readdatadocument("Cities",$fixer['city']);
			$allFixers[$key]['city'] = $city['name'];
		}
		$data['customerlist'] = $allFixers;
		$this->template->template_render('fixer_management', $data);
	}

	public function suspendCustomer()
	{
		$id = $this->uri->segment(3);
		$data["isActive"] = false;
		$this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'User Suspended');
		redirect(base_url().'customer');
	}

	public function unSuspendCustomer()
	{
		$id = $this->uri->segment(3);
		
		$data["isActive"] = true;
		$this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'User Activated');
		redirect(base_url().'customer');
	}
	public function suspendFixer()
	{
		$id = $this->uri->segment(3);
		$data["isActive"] = false;
		$this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'Fixer Suspended');
		redirect(base_url().'customer/fixers');
	}

	public function unSuspendFixer()
	{
		$id = $this->uri->segment(3);
		
		$data["isActive"] = true;
		$this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'Fixer Activated');
		redirect(base_url().'customer/fixers');
	}


	public function approve()
	{
		$id = $this->uri->segment(3);
		
		$data["isApproved"] = true;
		$this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'Fixer Approved');
		redirect(base_url().'customer/fixers');
	}
	public function unapprove()
	{
		$id = $this->uri->segment(3);
		
		$data["isApproved"] = false;
		$this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'Fixer UnApproved');
		redirect(base_url().'customer/fixers');
	}
	public function deleteCustomer()
	{
		$id = $this->uri->segment(3);
		
		$response = $this->common->delete_customer($id);
		if (!$response) {
			$this->session->set_flashdata('warningmessage', 'Something went wrong while deleting user.');
			redirect(base_url().'customer');
		}
		$response = $this->common->deletedatamodel("Users", $id);
		$this->session->set_flashdata('successmessage', 'User Deleted Successfully');
		redirect(base_url().'customer');
	}
	public function deleteFixer()
	{
		$id = $this->uri->segment(3);
		
		$response = $this->common->delete_customer($id);
		if (!$response) {
			$this->session->set_flashdata('warningmessage', 'Something went wrong while deleting fixer.');
			redirect(base_url().'customer/fixers');
		}
		$response = $this->common->deletedatamodel("Users", $id);
		$this->session->set_flashdata('successmessage', 'Fixer Deleted Successfully');
		redirect(base_url().'customer/fixers');
	}
	public function deleteContact()
	{
		$id = $this->uri->segment(3);
		
		$this->common->deletedatamodel("Contacts", $id);
		$this->session->set_flashdata('successmessage', 'Contact Deleted Successfully');
		redirect(base_url().'customer/contacts');
	}

	public function addcustomer()
	{
		$this->template->template_render('customer_add');
	}
	public function fixerdetails($id)
	{
		$data["fixer"] = $this->common->readdatadocument("Users", $id);
		$country = $this->common->readdatadocument("Countries", $data["fixer"]['country']);
		$data["fixer"]['country'] = $country['name'];
		$city = $this->common->readdatadocument("Cities", $data["fixer"]['city']);
		$data["fixer"]['city'] = $city['name'];
		$jobCategory = $this->common->readdatadocument("category", $data["fixer"]['jobCategory']);
		$data["fixer"]['jobCategory'] = $jobCategory['name'];

		$this->template->template_render('fixerdetails', $data);
	}
	//editcustomer
	public function editcustomers($id)
	{


		$data['id'] = $id;

		$data["customerdetails"] = $this->common->readdatadocument("Users", $id);

		$this->template->template_render('editcustomer', $data);
	}
	public function userreset()
	{
		$this->template->template_render('user_reset_credentials');
	}

	public function insertcustomer()
	{
		$data = $this->input->post();
		$data["userRole"] = "user";
		$data["city"] = NULL;
		$data["state"] = NULL;
		$data["token"] = NULL;
		$data["workAddress"] = NULL;
		$data["zipcode"] = NULL;
		$data["lat"] = 0;
		$data["lng"] = 0;
		$data["image"] = NULL;
		$data["clientSecret"] = NULL;
		$data["cusId"] = NULL;
		$data["ratings"] = NULL;
		$data["isApproved"] = TRUE;
		$data["isActive"] = true;

		$response = $this->customer_model->add_customer($data);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'New customer added successfully');
			redirect('customer');
		} else {
			$errormsg = 'Error! User already Exists.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('customer/addcustomer');
		}
	}



	public function updatecustomerdata($id)
	{
		$da = $this->input->post();
		//print_r($da);
		if ($da['newpassword'] != "") {

			$da['password'] = $da['newpassword'];
			$da['newpassword'] = "";
			$flag = $this->customer_model->update_customerpassword($id, $da['password']);




			if ($flag) {
				$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
				$this->session->set_flashdata('successmessage', 'User has been updated successfully');
			} else {
				$this->session->set_flashdata('warningmessage', 'Something wrong, Please try again later');

				redirect(base_url().'customer/editcustomer/'.$id);
			}
		} else {
			$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
			$this->session->set_flashdata('successmessage', 'User has been updated successfully');
		}



		redirect(base_url().'customer');
	}

	public function editcustomer()
	{
		$c_id = $this->uri->segment(3);
		$data['id'] = $c_id;
		$data['customerdetails'] = $this->customer_model->get_customerdetails($c_id);
		

		$this->template->template_render('editcustomer', $data);
	}

	public function resetCustomer()
	{
		// $data = $this->input->post();
		foreach ($_POST as $key => $val) {
			if (strpos($key, "new") === 0) {
				$name = substr($key, 3);
				$data["new"][$name] = $val;
			}
		}
		foreach ($_POST as $key => $val) {
			if (strpos($key, "old") === 0) {
				$name = substr($key, 3);
				$data["old"][$name] = $val;
			}
		}
		// print_r($data);
		// exit;
		$response = $this->customer_model->update_customer($data);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'Customer updated successfully.');
			redirect('customer');
		} else {
			$errormsg = 'Error! Something went Wrong. Either the user does not exist or password does not match.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('customer/userreset');
		}
	}

	public function updatecustomer()
	{
		$testxss = xssclean($_POST);
		if ($testxss) {
			$response = $this->customer_model->update_customer($this->input->post());
			if ($response) {
				$this->session->set_flashdata('successmessage', 'Customer updated successfully..');
				redirect('customer');
			} else {
				$this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
				redirect('customer');
			}
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('customer');
		}
	}
}