<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark"><?php echo (isset($event)) ? 'Edit Product' : 'Add Country' ?>
                </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?= base_url(); ?>/dashboard">Dashboard</a></li>
                    <li class="breadcrumb-item active"><?php echo (isset($event)) ? 'Edit Product' : 'Add Product' ?></li>
                </ol>
            </div>
        </div>
    </div>
</div>

<section class="content">
    <div class="container-fluid">
        <?php
            if(isset($event)){
                $endPoint = "updateproduct";
            }else{
                $endPoint = "insertproduct";
            }
        ?>
        <form method="post" id="customer_add" class="card" action="<?php echo base_url() . "dashboard/". $endPoint ; ?>" enctype="multipart/form-data">
            <div class="card-body">

                <div class="row">
                    <input type="hidden" name="id" value="<?php echo (isset($event)) ? $event['id'] : '' ?>">

                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Product Title</label>
                            <input type="text" required="true" class="form-control" value="<?php echo (isset($event)) ? $event['title'] : '' ?>" name="title" placeholder="Title">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Short Description</label>
                            <input type="text" required="true" class="form-control" value="<?php echo (isset($event)) ? $event['shortDescription'] : '' ?>" name="shortDescription" placeholder="Short Description" maxlength="256">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Price</label>
                            <input type="number" required="true" class="form-control" step="0.01" value="<?php echo (isset($event)) ? $event['price'] : '' ?>" name="price" placeholder="Price">
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-group">
                            <label class="form-label">Image</label>
                            <input type="file" class="form-control" name="image">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Product Type</label>
                            <select class="form-control" name="type" id="type" onchange="showSizes()" required>
                                <option value="" selected>Select Product Type</option>
                                <option value="shirt" <?=$event['type']=='shirt'?'selected':''?>>Shirt</option>
                                <option value="jacket" <?=$event['type']=='jacket'?'selected':''?>>Jacket</option>
                                <option value="trouser" <?=$event['type']=='trouser'?'selected':''?>>Trouser</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-6 mt-2" id="shirtSizesId" style="display: none;">
                        <label class="form-label">Shirt/Jacket Sizes</label><br>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="checkbox" name="shirtSizes[]" id="inlineCheckbox1" value="S" <?=in_array('S', $event['shirtSizes'])?'checked':''?>>
                            <label class="form-check-label" for="inlineCheckbox1">S</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="checkbox" name="shirtSizes[]" id="inlineCheckbox2" value="M" <?=in_array('M', $event['shirtSizes'])?'checked':''?>>
                            <label class="form-check-label" for="inlineCheckbox2">M</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="checkbox" name="shirtSizes[]" id="inlineCheckbox3" value="L" <?=in_array('L', $event['shirtSizes'])?'checked':''?>>
                            <label class="form-check-label" for="inlineCheckbox2">L</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="checkbox" name="shirtSizes[]" id="inlineCheckbox4" value="XL" <?=in_array('XL', $event['shirtSizes'])?'checked':''?>>
                            <label class="form-check-label" for="inlineCheckbox2">XL</label>
                        </div>
                    </div>
                    <div class="col-6 mt-2" id="trouserSizesId" style="display: none;">
                        <label class="form-label">Trouser Sizes</label><br>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="checkbox" name="trouserSizes[]" id="inlineCheckbox5" value="30" <?=in_array('30', $event['trouserSizes'])?'checked':''?>>
                            <label class="form-check-label" for="inlineCheckbox1">30</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="checkbox" name="trouserSizes[]" id="inlineCheckbox6" value="32" <?=in_array('32', $event['trouserSizes'])?'checked':''?>>
                            <label class="form-check-label" for="inlineCheckbox2">32</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="checkbox" name="trouserSizes[]" id="inlineCheckbox7" value="34" <?=in_array('34', $event['trouserSizes'])?'checked':''?>>
                            <label class="form-check-label" for="inlineCheckbox2">34</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="checkbox" name="trouserSizes[]" id="inlineCheckbox8" value="36" <?=in_array('36', $event['trouserSizes'])?'checked':''?>>
                            <label class="form-check-label" for="inlineCheckbox2">36</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="checkbox" name="trouserSizes[]" id="inlineCheckbox9" value="38" <?=in_array('38', $event['trouserSizes'])?'checked':''?>>
                            <label class="form-check-label" for="inlineCheckbox2">38</label>
                        </div>
                    </div>

                    <div class="col-2">
                        <?php if(isset($event['image']) && !empty($event['image'])) { ?>
                        <img src="<?=$event['image']?>" width="100" height="100">
                        <?php } ?>
                    </div>

                    <div class="col-12">
                        <div class="form-group">
                            <label class="form-label">Long Description</label><br>
                            <textarea name="description" rows="10" cols="80"><?php echo (isset($event)) ? $event['description'] : '' ?></textarea>
                        </div>
                    </div>

                    <div class="modal-footer">

                        <button type="submit" class="btn btn-primary"> <?php echo (isset($event)) ? 'Update Product' : 'Add Product' ?></button>
                    </div>
                </div>
        </form>
    </div>
</section>
<script>
function showSizes() {
    let type = $('#type').val();
    if (type == 'shirt' || type == 'jacket') {
        $('#trouserSizesId').hide();
        $('#shirtSizesId').show();
    } else if (type == 'trouser') {
        $('#shirtSizesId').hide();
        $('#trouserSizesId').show();
    } else {
        $('#shirtSizesId').hide();
        $('#trouserSizesId').hide();
    }
}
window.onload = showSizes();
</script>