<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Test extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('firebase');
    }

    /**
     * Upload tile icons to Firebase Storage and save tile data to Firestore
     */
    public function saveTiles()
    {
        // Only main tiles (exclude "Others")
        $mainTiles = [
            ['tile_name' => 'Session Packets', 'file' => FCPATH . 'public/admin_assets/images/tile-icon1.png', 'type' => 'main'],
            ['tile_name' => 'Class Sections', 'file' => FCPATH . 'public/admin_assets/images/tile-icon2.png', 'type' => 'main'],
            ['tile_name' => 'Admin Chat', 'file' => FCPATH . 'public/admin_assets/images/tile-icon3.png', 'type' => 'main'],
            ['tile_name' => 'Patterns', 'file' => FCPATH . 'public/admin_assets/images/tile-icon4.png', 'type' => 'main'],
            ['tile_name' => 'Dressing Ride Times', 'file' => FCPATH . 'public/admin_assets/images/tile-icon5.png', 'type' => 'main'],
            ['tile_name' => 'Programs', 'file' => FCPATH . 'public/admin_assets/images/tile-icon6.png', 'type' => 'main'],
            ['tile_name' => 'Scholarships', 'file' => FCPATH . 'public/admin_assets/images/tile-icon7.png', 'type' => 'main'],
            ['tile_name' => 'Map', 'file' => FCPATH . 'public/admin_assets/images/tile-icon8.png', 'type' => 'main'],
            ['tile_name' => 'Rules', 'file' => FCPATH . 'public/admin_assets/images/tile-icon9.png', 'type' => 'main'],
            ['tile_name' => 'Statistics', 'file' => FCPATH . 'public/admin_assets/images/tile-icon10.png', 'type' => 'main'],
        ];

        $saved = [];

        // Helper function to generate slug
        $generateSlug = function ($string) {
            $slug = preg_replace('/[^A-Za-z0-9 ]/', '', $string); // remove special chars
            $slug = strtolower(trim($slug));
            return str_replace(' ', '_', $slug);
        };

        foreach ($mainTiles as $tile) {
            // Generate a Firestore document ID
            $tileId = $this->firebase->generateDocumentId('tiles');

            // Upload icon to Firebase Storage
            $storagePath = "tiles/tile_$tileId.png";
            $tileUrl = $this->firebase->uploadFile($tile['file'], $storagePath);

            if (!$tileUrl) {
                log_message('error', "Failed to upload icon for tile: {$tile['tile_name']}");
                continue;
            }

            // Firestore document data
            $data = [
                'tile_id' => $tileId,
                'tile_name' => $tile['tile_name'],
                'tile_url' => $tileUrl,
                'type' => $tile['type'],
                'slug' => $generateSlug($tile['tile_name'])
            ];

            // Save document using the same ID as tile_id
            $this->firebase->setDocumentByPath("tiles/$tileId", $data);

            $saved[] = $data;
        }

        echo '<pre>';
        echo "Main tiles uploaded and saved successfully:\n";
        print_r($saved);
        echo '</pre>';
    }



}
