<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Welcome extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		// $load->helper('url');
		$this->load->helper('url');
		$this->load->model('admin/User_model');
		$this->load->model('admin/Content_model');
		$this->load->library('session'); // load session first
		$this->load->helper('auth');  // Load auth helper
		check_admin();
	}

	public function index()
	{
		$data['total_users'] = count($this->User_model->getAllUsers());
		$data['active_events'] = $this->Content_model->countEventsByStatus('Active');
		$data['closed_events'] = $this->Content_model->countPastEvents();

		$data['scheduled_events'] = count($this->Content_model->getAllSchedules());
		$data['upcoming_events'] = $this->Content_model->eventsForDashboard();
		$data['new_users'] = $this->User_model->UserForDashboard();


		$data['page_title'] = 'dashboard';
		$data['active_menu'] = 'dashboard';
		$data['content_view'] = 'welcome_message';
		$this->load->view('admin/layouts/main', $data);
	}
}
