<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Content_managementController extends CI_Controller
{
    protected $collectionName = 'events';
    protected $iconLink = "https://firebasestorage.googleapis.com/v0/b/ringsideproduction.firebasestorage.app/o/tiles%2Floginlogo.png?alt=media&token=9c9e7264-071f-4eca-a3ce-80499307fa42";

    public function __construct()
    {
        parent::__construct();
        $this->load->library('session');
        $this->load->model('admin/Content_model');
        $this->load->model('admin/User_model');

        $this->load->helper('url');
        $this->load->helper('auth');
        check_admin();
    }

    public function contentManagement()
    {
        $data['page_title'] = 'content management';
        $data['active_menu'] = 'content';
        $data['content_view'] = 'admin/pages/content_management';
        $data['events'] = $this->Content_model->getAllEvents();
        // print_r($data['events']);
        // exit;
        $data['schedules'] = $this->Content_model->getAllSchedules();

        $this->load->view('admin/layouts/main', $data);
    }

    public function addEvent()
    {


        $data['page_title'] = 'add event';
        $data['active_menu'] = 'add_event';
        $data['content_view'] = 'admin/pages/add_event';
        // print_r($data);
        // exit;

        $this->load->view('admin/layouts/main', $data);
    }

    public function saveEvent()
    {
        $this->output->set_content_type('application/json');

        $eventData = $this->input->post(NULL, true);
        $files     = $_FILES;



        // --------------------------------------------------
        // STEP 0: VALIDATION
        // --------------------------------------------------
        $validation = $this->Content_model->validateEventData($eventData);
        if (!$validation['valid']) {
            echo json_encode([
                'success' => false,
                'message' => implode('<br>', $validation['errors'])
            ]);
            return;
        }

        if (strtotime($eventData['start_date']) <= time()) {
            echo json_encode([
                'success' => false,
                'message' => 'Start date must be in the future'
            ]);
            return;
        }

        // --------------------------------------------------
        // STEP 1: SETUP
        // --------------------------------------------------
        $eventId          = $this->Content_model->generateEventId();
        $enableAdminChat  = !empty($eventData['enable_admin_messages']);
        $categories       = [];
        $allTiles         = [];

        // Parse selected_tiles JSON string
        $selectedTilesJson = $eventData['selected_tiles'] ?? '{}';
        $selectedTiles = json_decode($selectedTilesJson, true);
        if (!is_array($selectedTiles)) {
            $selectedTiles = [];
        }

        // --------------------------------------------------
        // STEP 2: LOAD MAIN TILES FROM DB
        // --------------------------------------------------
        $mainTilesFromDB = $this->Content_model->getTiles(true);

        // Create a map of slug => tile data
        $mainTilesMap = [];
        foreach ($mainTilesFromDB as $tile) {
            $mainTilesMap[$tile['slug']] = $tile;
        }

        // --------------------------------------------------
        // STEP 3: PROCESS SELECTED TILES
        // --------------------------------------------------
        foreach ($selectedTiles as $frontendSlug => $tileSelectionData) {
            $subsections = $tileSelectionData['subsections'] ?? [];

            // Skip if no subsections
            if (empty($subsections)) {
                continue;
            }

            // Convert hyphen to underscore for database consistency
            $dbSlug = str_replace('-', '_', $frontendSlug);

            // The key used in $_POST and $_FILES (from frontend)
            $postKey = str_replace('-', '_', $frontendSlug);

            // Check if this is a main tile from DB
            if (isset($mainTilesMap[$dbSlug])) {
                // Main tile from database
                $tile = $mainTilesMap[$dbSlug];

                $allTiles[] = [
                    'tile_id'     => $tile['tile_id'],
                    'tile_name'   => $tile['tile_name'],
                    'slug'        => $dbSlug,
                    'post_key'    => $postKey,
                    'tile_url'    => $tile['tile_url'],
                    'type'        => $tile['type'],
                    'subsections' => $subsections
                ];
            } else {
                // Custom tile - need to create it
                $customName = isset($eventData['tiles_custom'][$frontendSlug])
                    ? $eventData['tiles_custom'][$frontendSlug]
                    : ucfirst(str_replace(['_', '-'], ' ', $frontendSlug));

                $newTileId = uniqid();

                // Insert custom tile into databas
                $this->Content_model->insertTile([
                    'tile_id'    => $newTileId,
                    'tile_name'  => $customName,
                    'slug'       => $dbSlug,
                    'type'       => 'other',
                    'is_custom'  => 1,
                    'tile_url'   => $this->iconLink,
                    'created_at' => round(microtime(true) * 1000)
                ]);

                $allTiles[] = [
                    'tile_id'     => $newTileId,
                    'tile_name'   => $customName,
                    'slug'        => $dbSlug,
                    'post_key'    => $postKey,
                    'tile_url'    => $this->iconLink,
                    'type'        => 'other',
                    'subsections' => $subsections
                ];
            }
        }

        // --------------------------------------------------
        // STEP 4: PROCESS TILES DATA & UPLOAD FILES
        // This will filter out subsections without PDFs
        // --------------------------------------------------
        $tiles = $this->Content_model->processTilesData($eventData, $files, $eventId, $allTiles);

        // --------------------------------------------------
        // STEP 4.5: BUILD CATEGORIES ONLY FOR TILES WITH VALID SUBSECTIONS
        // --------------------------------------------------
        foreach ($allTiles as $tile) {
            $slug = $tile['slug'];

            // Only add to categories if the tile has valid subsections (with PDFs)
            if (isset($tiles[$slug]) && !empty($tiles[$slug]['subsections'])) {
                $categories[] = $tile['tile_id'];
            }
        }

        // --------------------------------------------------
        // STEP 5: SAVE TILES AS NESTED COLLECTIONS
        // Only tiles with valid subsections will be in $tiles
        // --------------------------------------------------
        $this->Content_model->saveTilesAsNestedCollection($eventId, $tiles);

        // --------------------------------------------------
        // STEP 6: ADD ADMIN CHAT IF ENABLED
        // --------------------------------------------------
        if ($enableAdminChat) {
            $adminChatTile = null;
            foreach ($mainTilesFromDB as $tile) {
                if ($tile['slug'] === 'admin_chat') {
                    $adminChatTile = $tile;
                    break;
                }
            }

            if ($adminChatTile) {
                $categories[] = $adminChatTile['tile_id'];

                $this->Content_model->saveTilesAsNestedCollection($eventId, [
                    'admin_chat' => [
                        'type' => 'main',
                        'sections' => 1,
                        'subsections' => [
                            [
                                'name' => 'Admin Messages',
                                'pdfs' => []
                            ]
                        ]
                    ]
                ]);
            }
        }

        // --------------------------------------------------
        // STEP 7: FINAL EVENT DATA
        // --------------------------------------------------
        $milliseconds = round(microtime(true) * 1000);
        // Get all user IDs
        // $usersIds = $this->User_model->getAllUserIds();

        // Prepare event_members map
        // $eventMembers = [];
        // foreach ($usersIds as $uid) {
        //     $eventMembers[$uid] = 'added';
        // }
        // 'event_members'         => $eventMembers,

        $finalEvent = [
            'event_name'            => $eventData['event_name'],
            'start_date'            => strtotime($eventData['start_date']) * 1000,
            'end_date'              => strtotime($eventData['end_date']) * 1000,
            'enable_admin_messages' => $enableAdminChat,
            'event_location'        => $eventData['event_location'] ?? '',
            'created_at'            => $milliseconds,
            'updated_at'            => $milliseconds,
            'categories'            => $categories
        ];

        // --------------------------------------------------
        // STEP 8: SCHEDULE DATA
        // --------------------------------------------------
        $scheduleData = [
            'event_id'   => $eventId,
            'name'       => $finalEvent['event_name'],
            'date'       => $finalEvent['start_date'],
            'end_date'   => $finalEvent['end_date'],
            'host'       => 'RingSide Production',
            'location'   => $finalEvent['event_location'],
            'created_at' => $milliseconds,
            'updated_at' => $milliseconds
        ];

        // --------------------------------------------------
        // STEP 9: SAVE EVENT & SCHEDULE
        // --------------------------------------------------
        $this->Content_model->updateEvent($eventId, $finalEvent);
        $this->Content_model->addSchedule($scheduleData);

        echo json_encode([
            'success'  => true,
            'message'  => 'Event created successfully',
            'redirect' => base_url('admin/content')
        ]);
    }

    public function editEvent($id = null)
    {
        if (!$id) {
            $this->session->set_flashdata('error', 'Invalid event ID');
            redirect('admin/dashboard/contentManagement');
            return;
        }

        $event = $this->Content_model->getEventById($id);

        // print_r($event);
        // exit;
        if (!$event) {
            $this->session->set_flashdata('error', 'Event not found');
            redirect('admin/dashboard/contentManagement');
            return;
        }

        $data['page_title'] = 'Edit Event';
        $data['active_menu'] = 'content';
        $data['content_view'] = 'admin/pages/edit_event';
        $data['event'] = $event;
        $data['event_id'] = $id;
        // print_r($data);
        // exit;

        $this->load->view('admin/layouts/main', $data);
    }
    /**
     * Update Event
     */
    public function updateEvent()
    {
        $this->output->set_content_type('application/json');

        $eventData = $this->input->post(NULL, true);
        $files     = $_FILES;

        $eventId = $eventData['event_id'] ?? null;

        if (!$eventId) {
            echo json_encode([
                'success' => false,
                'message' => 'Event ID is required'
            ]);
            return;
        }

        // --------------------------------------------------
        // STEP 0: VALIDATION
        // --------------------------------------------------
        $validation = $this->Content_model->validateEventData($eventData);
        if (!$validation['valid']) {
            echo json_encode([
                'success' => false,
                'message' => implode('<br>', $validation['errors'])
            ]);
            return;
        }

        // --------------------------------------------------
        // STEP 1: SETUP
        // --------------------------------------------------
        $enableAdminChat  = !empty($eventData['enable_admin_messages']);
        $categories       = [];
        $allTiles         = [];

        // Parse selected_tiles JSON string
        $selectedTilesJson = $eventData['selected_tiles'] ?? '{}';
        $selectedTiles = json_decode($selectedTilesJson, true);
        if (!is_array($selectedTiles)) {
            $selectedTiles = [];
        }

        // --------------------------------------------------
        // STEP 2: LOAD MAIN TILES FROM DB
        // --------------------------------------------------
        $mainTilesFromDB = $this->Content_model->getTiles(true);

        // Create a map of slug => tile data
        $mainTilesMap = [];
        foreach ($mainTilesFromDB as $tile) {
            $mainTilesMap[$tile['slug']] = $tile;
        }

        // --------------------------------------------------
        // STEP 3: GET EXISTING EVENT TO FIND CUSTOM TILES
        // --------------------------------------------------
        $existingEvent = $this->Content_model->getEventById($eventId);
        $existingCategories = $existingEvent['categories'] ?? [];
        $mainTileIds = array_column($mainTilesFromDB, 'tile_id');

        // --------------------------------------------------
        // STEP 4: PROCESS SELECTED TILES
        // --------------------------------------------------
        foreach ($selectedTiles as $frontendSlug => $tileSelectionData) {
            $subsections = $tileSelectionData['subsections'] ?? [];

            // Skip if no subsections
            if (empty($subsections)) {
                continue;
            }

            // Convert hyphen to underscore for database consistency
            $dbSlug = str_replace('-', '_', $frontendSlug);

            // The key used in $_POST and $_FILES (from frontend)
            $postKey = str_replace('-', '_', $frontendSlug);

            // Check if this is a main tile from DB
            if (isset($mainTilesMap[$dbSlug])) {
                // Main tile from database
                $tile = $mainTilesMap[$dbSlug];

                $allTiles[] = [
                    'tile_id'     => $tile['tile_id'],
                    'tile_name'   => $tile['tile_name'],
                    'slug'        => $dbSlug,
                    'post_key'    => $postKey,
                    'tile_url'    => $tile['tile_url'],
                    'type'        => $tile['type'],
                    'subsections' => $subsections
                ];
            } else {
                // Custom tile - check if it exists or create new
                $customTileId = null;

                // Find if this custom tile already exists
                foreach ($existingCategories as $catId) {
                    if (!in_array($catId, $mainTileIds)) {
                        // This is a custom tile - check if it matches our slug
                        $existingTile = $this->Content_model->getTileById($catId);
                        if ($existingTile && $existingTile['slug'] === $dbSlug) {
                            $customTileId = $catId;
                            break;
                        }
                    }
                }

                // If not found, create new custom tile
                if (!$customTileId) {
                    $customName = isset($eventData['tiles_custom'][$frontendSlug])
                        ? $eventData['tiles_custom'][$frontendSlug]
                        : ucfirst(str_replace(['_', '-'], ' ', $frontendSlug));

                    $customTileId = uniqid();

                    $this->Content_model->insertTile([
                        'tile_id'    => $customTileId,
                        'tile_name'  => $customName,
                        'slug'       => $dbSlug,
                        'type'       => 'other',
                        'is_custom'  => 1,
                        'tile_url'   => $this->iconLink,
                        'created_at' => round(microtime(true) * 1000)
                    ]);
                }

                $allTiles[] = [
                    'tile_id'     => $customTileId,
                    'tile_name'   => $eventData['tiles_custom'][$frontendSlug] ?? ucfirst(str_replace(['_', '-'], ' ', $frontendSlug)),
                    'slug'        => $dbSlug,
                    'post_key'    => $postKey,
                    'tile_url'    => $this->iconLink,
                    'type'        => 'other',
                    'subsections' => $subsections
                ];
            }
        }

        // --------------------------------------------------
        // STEP 5: PROCESS TILES DATA & UPLOAD FILES
        // This will filter out subsections without PDFs
        // --------------------------------------------------
        $tiles = $this->Content_model->processTilesDataForUpdate($eventData, $files, $eventId, $allTiles);

        // --------------------------------------------------
        // STEP 5.5: BUILD CATEGORIES ONLY FOR TILES WITH VALID SUBSECTIONS
        // --------------------------------------------------
        foreach ($allTiles as $tile) {
            $slug = $tile['slug'];

            // Only add to categories if the tile has valid subsections (with PDFs)
            if (isset($tiles[$slug]) && !empty($tiles[$slug]['subsections'])) {
                $categories[] = $tile['tile_id'];
            }
        }

        // --------------------------------------------------
        // STEP 6: DELETE TILES THAT ARE NO LONGER SELECTED
        // --------------------------------------------------
        $selectedTileSlugs = array_column($allTiles, 'slug');
        $existingTileSlugs = array_keys($existingEvent);

        // Filter to only tile slugs (exclude metadata like event_name, categories, etc.)
        $excludeKeys = [
            'event_name',
            'start_date',
            'end_date',
            'enable_admin_messages',
            'event_location',
            'created_at',
            'updated_at',
            'event_members',
            'categories'
        ];
        $existingTileSlugs = array_diff($existingTileSlugs, $excludeKeys);

        $tilesToDelete = array_diff($existingTileSlugs, $selectedTileSlugs);

        foreach ($tilesToDelete as $slugToDelete) {
            $this->Content_model->deleteTileSubcollection($eventId, $slugToDelete);
        }

        // --------------------------------------------------
        // STEP 7: UPDATE TILES AS NESTED COLLECTIONS
        // Only tiles with valid subsections will be in $tiles
        // --------------------------------------------------
        $this->Content_model->updateTilesAsNestedCollection($eventId, $tiles);

        // --------------------------------------------------
        // STEP 8: HANDLE ADMIN CHAT
        // --------------------------------------------------
        $adminChatTile = null;
        foreach ($mainTilesFromDB as $tile) {
            if ($tile['slug'] === 'admin_chat') {
                $adminChatTile = $tile;
                break;
            }
        }

        if ($enableAdminChat && $adminChatTile) {
            $categories[] = $adminChatTile['tile_id'];

            // Check if admin_chat already exists
            $existingAdminChat = $this->Content_model->getEventTileData($eventId, 'admin_chat');

            if (empty($existingAdminChat)) {
                // Create new admin_chat
                $this->Content_model->saveTilesAsNestedCollection($eventId, [
                    'admin_chat' => [
                        'type' => 'main',
                        'sections' => 1,
                        'subsections' => [
                            [
                                'name' => 'Admin Messages',
                                'pdfs' => []
                            ]
                        ]
                    ]
                ]);
            }
        } else {
            // Delete admin_chat if it was disabled
            $this->Content_model->deleteTileSubcollection($eventId, 'admin_chat');
        }

        // --------------------------------------------------
        // STEP 9: UPDATE EVENT DATA
        // --------------------------------------------------
        $milliseconds = round(microtime(true) * 1000);

        $finalEvent = [
            'event_name'            => $eventData['event_name'],
            'start_date'            => strtotime($eventData['start_date']) * 1000,
            'end_date'              => strtotime($eventData['end_date']) * 1000,
            'enable_admin_messages' => $enableAdminChat,
            'event_location'        => $eventData['event_location'] ?? '',
            'updated_at'            => $milliseconds,
            'categories'            => $categories
        ];

        // --------------------------------------------------
        // STEP 10: UPDATE SCHEDULE
        // --------------------------------------------------
        $scheduleData = [
            'name'       => $finalEvent['event_name'],
            'date'       => $finalEvent['start_date'],
            'end_date'   => $finalEvent['end_date'],
            'location'   => $finalEvent['event_location'],
            'updated_at' => $milliseconds
        ];

        // Find and update the schedule
        $schedules = $this->Content_model->getAllSchedules();
        foreach ($schedules as $schedule) {
            if (isset($schedule['id']) && strpos($schedule['id'], $eventId) !== false) {
                $this->Content_model->updateSchedule($schedule['id'], $scheduleData);
                break;
            }
        }

        // --------------------------------------------------
        // STEP 11: SAVE EVENT
        // --------------------------------------------------
        $this->Content_model->updateEvent($eventId, $finalEvent);

        echo json_encode([
            'success'  => true,
            'message'  => 'Event updated successfully',
            'redirect' => base_url('admin/content')
        ]);
    }

    public function viewEvent($id)
    {
        if ($id) {
            $event = $this->Content_model->getEventById($id);
            // Fetch user IDs from event_members
            $userIds = !empty($event['event_members']) ? array_keys($event['event_members']) : [];

            // Get full user info
            $users = $this->User_model->getUsersByIds($userIds);

            // Replace event_members with actual user info
            $event['event_members'] = $users;
            $data['event'] = $event;

            // print_r($event['event_members']);
            // die;
        } else {
            $data['event'] = '';
        }




        $data['page_title'] = 'Event details';
        $data['active_menu'] = 'event';
        $data['content_view'] = 'admin/pages/view_event';
        $this->load->view('admin/layouts/main', $data);
    }
    public function deleteEvent($id = null)
    {
        $response = ['success' => false, 'message' => ''];

        if (!$id) {
            $response['message'] = 'Invalid event ID';
            echo json_encode($response);
            return;
        }

        $this->Content_model->deleteEventFiles($id);
        $result = $this->Content_model->deleteEvent($id);

        if ($result) {
            $response['success'] = true;
            $response['message'] = 'Event deleted successfully';
        } else {
            $response['message'] = 'Failed to delete event';
        }

        echo json_encode($response);
    }

    public function tile($id = null)
    {
        if (!$id) {
            echo json_encode(['success' => false, 'message' => 'Tile ID missing']);
            exit;
        }

        $tile = $this->Content_model->getTileById($id);
        if (!$tile) {
            echo json_encode(['success' => false, 'message' => 'Tile not found']);
            exit;
        }

        echo json_encode(['success' => true, 'data' => $tile]);
        exit;
    }

    public function getTiles()
    {
        $tiles = $this->Content_model->getTiles();

        $response = [
            'success' => true,
            'tiles'   => $tiles
        ];

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function createCustomTile($data)
    {
        $this->Content_model->insertTile($data);

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode([
                'success' => true,
                'tile'    => $data
            ]));
    }
}
