<?php
defined('BASEPATH') or exit('No direct script access allowed');

class SettingsController extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library(['session', 'firebase']);
        $this->load->helper('url');
        $this->load->helper('auth');
        check_admin();
    }

    public function settings()
    {
        $admin_id = $this->session->userdata('user_id');

        // Fetch current admin data from Firebase
        $data['admin'] = $this->firebase->getDocument('admin', $admin_id);

        $data['page_title'] = 'Settings';
        $data['active_menu'] = 'settings';
        $data['content_view'] = 'admin/pages/settings';
        $this->load->view('admin/layouts/main', $data);
    }

    public function updatePassword()
    {
        $this->output->set_content_type('application/json');

        $admin_id = $this->session->userdata('user_id');
        $old_pass = $this->input->post('old_password');
        $new_pass = $this->input->post('new_password');

        $admin_data = $this->firebase->getDocument('admin', $admin_id);

        // Verify Old Password
        if ($admin_data['password'] !== $old_pass) {
            echo json_encode(['success' => false, 'message' => 'Current password does not match.']);
            return;
        }

        // Update Password in Firebase
        $update = $this->firebase->updateDocument('admin', $admin_id, ['password' => $new_pass]);

        if ($update) {
            echo json_encode(['success' => true, 'message' => 'Password updated successfully!']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to update database.']);
        }
    }

    public function getFirebaseConfig()
    {
        $frontendConfig = [
            "apiKey" => "AIzaSyASFXCaLCHNFf8j8hCAFsAZKZWzRp_GfX0",
            "authDomain" => "ringsideproduction.firebaseapp.com",
            "projectId" => "ringsideproduction",
            "storageBucket" => "ringsideproduction.appspot.com",
            "messagingSenderId" => "131634452982",
            "appId" => "1:131634452982:web:1155f4e5a61db6fd664fd7",
            "measurementId" => "G-BH70QS1CP8"
        ];



        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($frontendConfig));
    }


}