<?php
defined('BASEPATH') or exit('No direct script access allowed');

class UserController extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('admin/User_model');
        $this->load->helper('url');
        $this->load->library('session');
        $this->load->helper('auth');
        check_admin();
    }

    // USERS PAGE
    public function users()
    {
        $data['page_title'] = 'Users';
        $data['active_menu'] = 'users';
        $data['content_view'] = 'admin/pages/users';
        $data['users'] = $this->User_model->getAllUsers();

        $this->load->view('admin/layouts/main', $data);
    }

    // ACTIVATE / DEACTIVATE
    public function toggleStatus($id)
    {
        $this->output->set_content_type('application/json');

        if (!$id) {
            echo json_encode(['success' => false, 'message' => 'Invalid user']);
            return;
        }

        $updated = $this->User_model->toggleUserStatus($id);

        if ($updated) {
            echo json_encode(['success' => true, 'message' => 'User status updated']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to update status']);
        }
    }
}
