<?php
defined('BASEPATH') or exit('No direct script access allowed');

// Composer autoload
require FCPATH . 'vendor/autoload.php';

use Kreait\Firebase\Factory;

class TestFirebase
{
    protected $firestore;

    public function __construct()
    {
        $serviceAccountPath = APPPATH . 'config/ringsideproduction.json';
        $factory = (new Factory)->withServiceAccount($serviceAccountPath);
        $this->firestore = $factory->createFirestore()->database();
    }


    // Insert full test data for all tables
    public function insert_full_test_data()
    {
        $now = time();

        // ======== ADMIN (Multiple Admins) ========
        $adminRef1 = $this->firestore->collection('admin')->newDocument();
        $adminRef1->set([
            'username' => 'superadmin',
            'email' => 'admin@example.com',
            'password_hash' => password_hash('123456', PASSWORD_BCRYPT),
            'full_name' => 'Super Admin',
            'role' => 'SuperAdmin',
            'is_super_admin' => true,
            'last_login' => $now,
            'created_at' => $now
        ]);
        $adminId1 = $adminRef1->id();

        $adminRef2 = $this->firestore->collection('admin')->newDocument();
        $adminRef2->set([
            'username' => 'moderator',
            'email' => 'moderator@example.com',
            'password_hash' => password_hash('123456', PASSWORD_BCRYPT),
            'full_name' => 'John Moderator',
            'role' => 'Moderator',
            'is_super_admin' => false,
            'last_login' => $now - 3600,
            'created_at' => $now - 86400
        ]);
        $adminId2 = $adminRef2->id();

        $adminRef3 = $this->firestore->collection('admin')->newDocument();
        $adminRef3->set([
            'username' => 'eventmanager',
            'email' => 'eventmanager@example.com',
            'password_hash' => password_hash('123456', PASSWORD_BCRYPT),
            'full_name' => 'Sarah Manager',
            'role' => 'EventManager',
            'is_super_admin' => false,
            'last_login' => $now - 7200,
            'created_at' => $now - 172800
        ]);
        $adminId3 = $adminRef3->id();

        // ======== USERS (Multiple Users) ========
        $userRef1 = $this->firestore->collection('users')->newDocument();
        $userRef1->set([
            'email' => 'john@example.com',
            'password_hash' => password_hash('123456', PASSWORD_BCRYPT),
            'first_name' => 'John',
            'last_name' => 'Doe',
            'phone' => '+1234567890',
            'is_active' => true,
            'created_at' => $now,
            'updated_at' => $now
        ]);
        $userId1 = $userRef1->id();

        $userRef2 = $this->firestore->collection('users')->newDocument();
        $userRef2->set([
            'email' => 'jane@example.com',
            'password_hash' => password_hash('123456', PASSWORD_BCRYPT),
            'first_name' => 'Jane',
            'last_name' => 'Smith',
            'phone' => '+1234567891',
            'is_active' => true,
            'created_at' => $now - 86400,
            'updated_at' => $now - 86400
        ]);
        $userId2 = $userRef2->id();

        $userRef3 = $this->firestore->collection('users')->newDocument();
        $userRef3->set([
            'email' => 'mike@example.com',
            'password_hash' => password_hash('123456', PASSWORD_BCRYPT),
            'first_name' => 'Mike',
            'last_name' => 'Johnson',
            'phone' => '+1234567892',
            'is_active' => true,
            'created_at' => $now - 172800,
            'updated_at' => $now - 172800
        ]);
        $userId3 = $userRef3->id();

        $userRef4 = $this->firestore->collection('users')->newDocument();
        $userRef4->set([
            'email' => 'sarah@example.com',
            'password_hash' => password_hash('123456', PASSWORD_BCRYPT),
            'first_name' => 'Sarah',
            'last_name' => 'Williams',
            'phone' => '+1234567893',
            'is_active' => false,
            'created_at' => $now - 259200,
            'updated_at' => $now - 259200
        ]);
        $userId4 = $userRef4->id();

        // ======== HORSES (Multiple Horses) ========
        $horseRef1 = $this->firestore->collection('horses')->newDocument();
        $horseRef1->set([
            'user_id' => $userId1,
            'horse_name' => 'Lightning',
            'breed' => 'Thoroughbred',
            'color' => 'Brown',
            'date_of_birth' => '2018-05-10',
            'registration_number' => 'H123',
            'gender' => 'Male',
            'additional_info' => 'Champion in local events',
            'created_at' => $now,
            'updated_at' => $now
        ]);
        $horseId1 = $horseRef1->id();

        $horseRef2 = $this->firestore->collection('horses')->newDocument();
        $horseRef2->set([
            'user_id' => $userId1,
            'horse_name' => 'Thunder',
            'breed' => 'Arabian',
            'color' => 'White',
            'date_of_birth' => '2019-03-15',
            'registration_number' => 'H124',
            'gender' => 'Female',
            'additional_info' => 'Great endurance',
            'created_at' => $now - 86400,
            'updated_at' => $now - 86400
        ]);
        $horseId2 = $horseRef2->id();

        $horseRef3 = $this->firestore->collection('horses')->newDocument();
        $horseRef3->set([
            'user_id' => $userId2,
            'horse_name' => 'Storm',
            'breed' => 'Quarter Horse',
            'color' => 'Black',
            'date_of_birth' => '2017-07-20',
            'registration_number' => 'H125',
            'gender' => 'Male',
            'additional_info' => 'Excellent for jumping',
            'created_at' => $now - 172800,
            'updated_at' => $now - 172800
        ]);
        $horseId3 = $horseRef3->id();

        $horseRef4 = $this->firestore->collection('horses')->newDocument();
        $horseRef4->set([
            'user_id' => $userId2,
            'horse_name' => 'Midnight',
            'breed' => 'Appaloosa',
            'color' => 'Spotted',
            'date_of_birth' => '2020-01-10',
            'registration_number' => 'H126',
            'gender' => 'Female',
            'additional_info' => 'Young and learning',
            'created_at' => $now - 259200,
            'updated_at' => $now - 259200
        ]);
        $horseId4 = $horseRef4->id();

        $horseRef5 = $this->firestore->collection('horses')->newDocument();
        $horseRef5->set([
            'user_id' => $userId3,
            'horse_name' => 'Shadow',
            'breed' => 'Morgan',
            'color' => 'Bay',
            'date_of_birth' => '2016-11-05',
            'registration_number' => 'H127',
            'gender' => 'Male',
            'additional_info' => 'Experienced in dressage',
            'created_at' => $now - 345600,
            'updated_at' => $now - 345600
        ]);
        $horseId5 = $horseRef5->id();

        // ======== RIDERS (Multiple Riders) ========
        $riderRef1 = $this->firestore->collection('riders')->newDocument();
        $riderRef1->set([
            'user_id' => $userId1,
            'first_name' => 'Alice',
            'last_name' => 'Smith',
            'date_of_birth' => '2015-08-20',
            'email' => 'alice@example.com',
            'phone' => '+1987654321',
            'experience_level' => 'Intermediate',
            'additional_info' => '3 years of experience',
            'created_at' => $now,
            'updated_at' => $now
        ]);
        $riderId1 = $riderRef1->id();

        $riderRef2 = $this->firestore->collection('riders')->newDocument();
        $riderRef2->set([
            'user_id' => $userId1,
            'first_name' => 'Bob',
            'last_name' => 'Thompson',
            'date_of_birth' => '2012-04-15',
            'email' => 'bob@example.com',
            'phone' => '+1987654322',
            'experience_level' => 'Advanced',
            'additional_info' => 'Multiple competition wins',
            'created_at' => $now - 86400,
            'updated_at' => $now - 86400
        ]);
        $riderId2 = $riderRef2->id();

        $riderRef3 = $this->firestore->collection('riders')->newDocument();
        $riderRef3->set([
            'user_id' => $userId2,
            'first_name' => 'Emma',
            'last_name' => 'Davis',
            'date_of_birth' => '2016-09-10',
            'email' => 'emma@example.com',
            'phone' => '+1987654323',
            'experience_level' => 'Beginner',
            'additional_info' => 'Started 6 months ago',
            'created_at' => $now - 172800,
            'updated_at' => $now - 172800
        ]);
        $riderId3 = $riderRef3->id();

        $riderRef4 = $this->firestore->collection('riders')->newDocument();
        $riderRef4->set([
            'user_id' => $userId2,
            'first_name' => 'Oliver',
            'last_name' => 'Brown',
            'date_of_birth' => '2014-06-25',
            'email' => 'oliver@example.com',
            'phone' => '+1987654324',
            'experience_level' => 'Intermediate',
            'additional_info' => 'Loves jumping',
            'created_at' => $now - 259200,
            'updated_at' => $now - 259200
        ]);
        $riderId4 = $riderRef4->id();

        $riderRef5 = $this->firestore->collection('riders')->newDocument();
        $riderRef5->set([
            'user_id' => $userId3,
            'first_name' => 'Sophia',
            'last_name' => 'Wilson',
            'date_of_birth' => '2013-12-30',
            'email' => 'sophia@example.com',
            'phone' => '+1987654325',
            'experience_level' => 'Advanced',
            'additional_info' => 'Professional aspirations',
            'created_at' => $now - 345600,
            'updated_at' => $now - 345600
        ]);
        $riderId5 = $riderRef5->id();

        // ======== HORSE-RIDERS (Multiple Relationships) ========
        $this->firestore->collection('horse_riders')->newDocument()->set([
            'horse_id' => $horseId1,
            'rider_id' => $riderId1,
            'is_primary' => true,
            'created_at' => $now
        ]);

        $this->firestore->collection('horse_riders')->newDocument()->set([
            'horse_id' => $horseId2,
            'rider_id' => $riderId2,
            'is_primary' => true,
            'created_at' => $now - 86400
        ]);

        $this->firestore->collection('horse_riders')->newDocument()->set([
            'horse_id' => $horseId3,
            'rider_id' => $riderId3,
            'is_primary' => true,
            'created_at' => $now - 172800
        ]);

        $this->firestore->collection('horse_riders')->newDocument()->set([
            'horse_id' => $horseId4,
            'rider_id' => $riderId4,
            'is_primary' => true,
            'created_at' => $now - 259200
        ]);

        $this->firestore->collection('horse_riders')->newDocument()->set([
            'horse_id' => $horseId5,
            'rider_id' => $riderId5,
            'is_primary' => true,
            'created_at' => $now - 345600
        ]);

        // Secondary rider for horse 1
        $this->firestore->collection('horse_riders')->newDocument()->set([
            'horse_id' => $horseId1,
            'rider_id' => $riderId2,
            'is_primary' => false,
            'created_at' => $now - 43200
        ]);

        // ======== EVENTS (Multiple Events) ========
        $eventRef1 = $this->firestore->collection('events')->newDocument();
        $eventRef1->set([
            'event_name' => 'Winter Show',
            'description' => 'Annual Winter Equestrian Show',
            'start_date' => '2025-12-25',
            'end_date' => '2025-12-28',
            'location' => 'Central Arena',
            'rules' => 'Standard Equestrian Rules',
            'prize_list' => 'Trophies and Medals',
            'registration_fee' => 150.00,
            'status' => 'Published',
            'created_by' => $adminId1,
            'created_at' => $now,
            'updated_at' => $now
        ]);
        $eventId1 = $eventRef1->id();

        $eventRef2 = $this->firestore->collection('events')->newDocument();
        $eventRef2->set([
            'event_name' => 'Spring Championship',
            'description' => 'Regional Spring Championship Series',
            'start_date' => '2026-03-15',
            'end_date' => '2026-03-18',
            'location' => 'Riverside Equestrian Center',
            'rules' => 'FEI Rules Apply',
            'prize_list' => 'Cash Prizes up to $10,000',
            'registration_fee' => 250.00,
            'status' => 'Draft',
            'created_by' => $adminId2,
            'created_at' => $now - 86400,
            'updated_at' => $now - 86400
        ]);
        $eventId2 = $eventRef2->id();

        $eventRef3 = $this->firestore->collection('events')->newDocument();
        $eventRef3->set([
            'event_name' => 'Summer Jump Fest',
            'description' => 'Show jumping competition for all levels',
            'start_date' => '2026-06-10',
            'end_date' => '2026-06-12',
            'location' => 'Meadow Fields Arena',
            'rules' => 'USEF Jumping Rules',
            'prize_list' => 'Ribbons and Prizes',
            'registration_fee' => 100.00,
            'status' => 'Published',
            'created_by' => $adminId3,
            'created_at' => $now - 172800,
            'updated_at' => $now - 172800
        ]);
        $eventId3 = $eventRef3->id();

        $eventRef4 = $this->firestore->collection('events')->newDocument();
        $eventRef4->set([
            'event_name' => 'Fall Classic',
            'description' => 'Traditional fall horse show',
            'start_date' => '2026-09-20',
            'end_date' => '2026-09-22',
            'location' => 'Oak Hill Stables',
            'rules' => 'Standard Competition Rules',
            'prize_list' => 'Trophies for Top 3',
            'registration_fee' => 175.00,
            'status' => 'Cancelled',
            'created_by' => $adminId1,
            'created_at' => $now - 259200,
            'updated_at' => $now - 259200
        ]);
        $eventId4 = $eventRef4->id();

        // ======== EVENT ADDONS (Multiple Addons) ========
        $addonRef1 = $this->firestore->collection('event_addons')->newDocument();
        $addonRef1->set([
            'event_id' => $eventId1,
            'addon_name' => 'Meal Package',
            'description' => 'Includes breakfast and lunch',
            'price' => 25.00,
            'is_available' => true,
            'created_at' => $now
        ]);
        $addonId1 = $addonRef1->id();

        $addonRef2 = $this->firestore->collection('event_addons')->newDocument();
        $addonRef2->set([
            'event_id' => $eventId1,
            'addon_name' => 'Stable Rental',
            'description' => 'Private stable for your horse',
            'price' => 50.00,
            'is_available' => true,
            'created_at' => $now
        ]);
        $addonId2 = $addonRef2->id();

        $addonRef3 = $this->firestore->collection('event_addons')->newDocument();
        $addonRef3->set([
            'event_id' => $eventId1,
            'addon_name' => 'Photography Package',
            'description' => 'Professional photos of your performance',
            'price' => 75.00,
            'is_available' => true,
            'created_at' => $now
        ]);
        $addonId3 = $addonRef3->id();

        $addonRef4 = $this->firestore->collection('event_addons')->newDocument();
        $addonRef4->set([
            'event_id' => $eventId2,
            'addon_name' => 'VIP Seating',
            'description' => 'Premium viewing area',
            'price' => 100.00,
            'is_available' => true,
            'created_at' => $now - 86400
        ]);
        $addonId4 = $addonRef4->id();

        $addonRef5 = $this->firestore->collection('event_addons')->newDocument();
        $addonRef5->set([
            'event_id' => $eventId3,
            'addon_name' => 'Extra Training Session',
            'description' => 'One hour training before competition',
            'price' => 40.00,
            'is_available' => true,
            'created_at' => $now - 172800
        ]);
        $addonId5 = $addonRef5->id();

        // ======== EVENT REGISTRATIONS (Multiple Registrations) ========
        $registrationRef1 = $this->firestore->collection('event_registrations')->newDocument();
        $registrationRef1->set([
            'user_id' => $userId1,
            'event_id' => $eventId1,
            'horse_id' => $horseId1,
            'rider_id' => $riderId1,
            'total_amount' => 250.00,
            'status' => 'Confirmed',
            'registration_date' => $now,
            'created_at' => $now,
            'updated_at' => $now
        ]);
        $registrationId1 = $registrationRef1->id();

        $registrationRef2 = $this->firestore->collection('event_registrations')->newDocument();
        $registrationRef2->set([
            'user_id' => $userId1,
            'event_id' => $eventId1,
            'horse_id' => $horseId2,
            'rider_id' => $riderId2,
            'total_amount' => 150.00,
            'status' => 'Pending',
            'registration_date' => $now - 3600,
            'created_at' => $now - 3600,
            'updated_at' => $now - 3600
        ]);
        $registrationId2 = $registrationRef2->id();

        $registrationRef3 = $this->firestore->collection('event_registrations')->newDocument();
        $registrationRef3->set([
            'user_id' => $userId2,
            'event_id' => $eventId1,
            'horse_id' => $horseId3,
            'rider_id' => $riderId3,
            'total_amount' => 225.00,
            'status' => 'Confirmed',
            'registration_date' => $now - 86400,
            'created_at' => $now - 86400,
            'updated_at' => $now - 86400
        ]);
        $registrationId3 = $registrationRef3->id();

        $registrationRef4 = $this->firestore->collection('event_registrations')->newDocument();
        $registrationRef4->set([
            'user_id' => $userId2,
            'event_id' => $eventId3,
            'horse_id' => $horseId4,
            'rider_id' => $riderId4,
            'total_amount' => 140.00,
            'status' => 'Confirmed',
            'registration_date' => $now - 172800,
            'created_at' => $now - 172800,
            'updated_at' => $now - 172800
        ]);
        $registrationId4 = $registrationRef4->id();

        $registrationRef5 = $this->firestore->collection('event_registrations')->newDocument();
        $registrationRef5->set([
            'user_id' => $userId3,
            'event_id' => $eventId3,
            'horse_id' => $horseId5,
            'rider_id' => $riderId5,
            'total_amount' => 100.00,
            'status' => 'Cancelled',
            'registration_date' => $now - 259200,
            'created_at' => $now - 259200,
            'updated_at' => $now - 259200
        ]);
        $registrationId5 = $registrationRef5->id();

        // ======== REGISTRATION ADDONS (Multiple Addon Selections) ========
        $this->firestore->collection('registration_addons')->newDocument()->set([
            'registration_id' => $registrationId1,
            'addon_id' => $addonId1,
            'quantity' => 1,
            'price' => 25.00,
            'created_at' => $now
        ]);

        $this->firestore->collection('registration_addons')->newDocument()->set([
            'registration_id' => $registrationId1,
            'addon_id' => $addonId2,
            'quantity' => 1,
            'price' => 50.00,
            'created_at' => $now
        ]);

        $this->firestore->collection('registration_addons')->newDocument()->set([
            'registration_id' => $registrationId1,
            'addon_id' => $addonId3,
            'quantity' => 1,
            'price' => 75.00,
            'created_at' => $now
        ]);

        $this->firestore->collection('registration_addons')->newDocument()->set([
            'registration_id' => $registrationId3,
            'addon_id' => $addonId1,
            'quantity' => 2,
            'price' => 50.00,
            'created_at' => $now - 86400
        ]);

        $this->firestore->collection('registration_addons')->newDocument()->set([
            'registration_id' => $registrationId3,
            'addon_id' => $addonId2,
            'quantity' => 1,
            'price' => 50.00,
            'created_at' => $now - 86400
        ]);

        $this->firestore->collection('registration_addons')->newDocument()->set([
            'registration_id' => $registrationId4,
            'addon_id' => $addonId5,
            'quantity' => 1,
            'price' => 40.00,
            'created_at' => $now - 172800
        ]);

        // ======== CLASSES (Multiple Classes) ========
        $classRef1 = $this->firestore->collection('classes')->newDocument();
        $classRef1->set([
            'class_name' => 'Beginner Dressage',
            'description' => 'Basic dressage training for beginners',
            'class_type' => 'Training',
            'requirements' => 'None',
            'enrollment_fee' => 50.00,
            'max_participants' => 10,
            'status' => 'Open',
            'created_by' => $adminId1,
            'created_at' => $now,
            'updated_at' => $now
        ]);
        $classId1 = $classRef1->id();

        $classRef2 = $this->firestore->collection('classes')->newDocument();
        $classRef2->set([
            'class_name' => 'Intermediate Jumping',
            'description' => 'Jumping techniques for intermediate riders',
            'class_type' => 'Competition',
            'requirements' => 'At least 1 year experience',
            'enrollment_fee' => 75.00,
            'max_participants' => 8,
            'status' => 'Open',
            'created_by' => $adminId2,
            'created_at' => $now - 86400,
            'updated_at' => $now - 86400
        ]);
        $classId2 = $classRef2->id();

        $classRef3 = $this->firestore->collection('classes')->newDocument();
        $classRef3->set([
            'class_name' => 'Advanced Show Jumping',
            'description' => 'Professional level show jumping',
            'class_type' => 'Competition',
            'requirements' => 'Advanced level riders only',
            'enrollment_fee' => 100.00,
            'max_participants' => 6,
            'status' => 'Full',
            'created_by' => $adminId3,
            'created_at' => $now - 172800,
            'updated_at' => $now - 172800
        ]);
        $classId3 = $classRef3->id();

        $classRef4 = $this->firestore->collection('classes')->newDocument();
        $classRef4->set([
            'class_name' => 'Western Pleasure',
            'description' => 'Western riding style training',
            'class_type' => 'Training',
            'requirements' => 'Western tack required',
            'enrollment_fee' => 60.00,
            'max_participants' => 12,
            'status' => 'Open',
            'created_by' => $adminId1,
            'created_at' => $now - 259200,
            'updated_at' => $now - 259200
        ]);
        $classId4 = $classRef4->id();

        $classRef5 = $this->firestore->collection('classes')->newDocument();
        $classRef5->set([
            'class_name' => 'Trail Riding Basics',
            'description' => 'Introduction to trail riding',
            'class_type' => 'Training',
            'requirements' => 'Suitable for all levels',
            'enrollment_fee' => 40.00,
            'max_participants' => 15,
            'status' => 'Closed',
            'created_by' => $adminId2,
            'created_at' => $now - 345600,
            'updated_at' => $now - 345600
        ]);
        $classId5 = $classRef5->id();

        // ======== CLASS ENROLLMENTS (Multiple Enrollments) ========
        $this->firestore->collection('class_enrollments')->newDocument()->set([
            'user_id' => $userId1,
            'class_id' => $classId1,
            'horse_id' => $horseId1,
            'rider_id' => $riderId1,
            'status' => 'Confirmed',
            'admin_notes' => 'First time enrollment',
            'enrollment_date' => $now,
            'created_at' => $now,
            'updated_at' => $now
        ]);

        $this->firestore->collection('class_enrollments')->newDocument()->set([
            'user_id' => $userId1,
            'class_id' => $classId2,
            'horse_id' => $horseId2,
            'rider_id' => $riderId2,
            'status' => 'Confirmed',
            'admin_notes' => 'Experienced rider',
            'enrollment_date' => $now - 3600,
            'created_at' => $now - 3600,
            'updated_at' => $now - 3600
        ]);

        $this->firestore->collection('class_enrollments')->newDocument()->set([
            'user_id' => $userId2,
            'class_id' => $classId1,
            'horse_id' => $horseId3,
            'rider_id' => $riderId3,
            'status' => 'Pending',
            'admin_notes' => 'Needs approval',
            'enrollment_date' => $now - 86400,
            'created_at' => $now - 86400,
            'updated_at' => $now - 86400
        ]);

        $this->firestore->collection('class_enrollments')->newDocument()->set([
            'user_id' => $userId2,
            'class_id' => $classId4,
            'horse_id' => $horseId4,
            'rider_id' => $riderId4,
            'status' => 'Confirmed',
            'admin_notes' => '',
            'enrollment_date' => $now - 172800,
            'created_at' => $now - 172800,
            'updated_at' => $now - 172800
        ]);

        $this->firestore->collection('class_enrollments')->newDocument()->set([
            'user_id' => $userId3,
            'class_id' => $classId3,
            'horse_id' => $horseId5,
            'rider_id' => $riderId5,
            'status' => 'Confirmed',
            'admin_notes' => 'Advanced level rider',
            'enrollment_date' => $now - 259200,
            'created_at' => $now - 259200,
            'updated_at' => $now - 259200
        ]);

        $this->firestore->collection('class_enrollments')->newDocument()->set([
            'user_id' => $userId3,
            'class_id' => $classId2,
            'horse_id' => $horseId5,
            'rider_id' => $riderId5,
            'status' => 'Cancelled',
            'admin_notes' => 'Cancelled by user',
            'enrollment_date' => $now - 345600,
            'created_at' => $now - 345600,
            'updated_at' => $now - 345600
        ]);

        // ======== PAYMENTS (Multiple Payments) ========
        $this->firestore->collection('payments')->newDocument()->set([
            'user_id' => $userId1,
            'registration_id' => $registrationId1,
            'stripe_payment_id' => 'pi_123456789',
            'amount' => 250.00,
            'currency' => 'USD',
            'payment_method' => 'Card',
            'payment_status' => 'Completed',
            'payment_date' => $now,
            'created_at' => $now
        ]);

        $this->firestore->collection('payments')->newDocument()->set([
            'user_id' => $userId1,
            'registration_id' => $registrationId2,
            'stripe_payment_id' => 'pi_987654321',
            'amount' => 150.00,
            'currency' => 'USD',
            'payment_method' => 'Card',
            'payment_status' => 'Pending',
            'payment_date' => $now - 3600,
            'created_at' => $now - 3600
        ]);

        $this->firestore->collection('payments')->newDocument()->set([
            'user_id' => $userId2,
            'registration_id' => $registrationId3,
            'stripe_payment_id' => 'pi_456789123',
            'amount' => 225.00,
            'currency' => 'USD',
            'payment_method' => 'Card',
            'payment_status' => 'Completed',
            'payment_date' => $now - 86400,
            'created_at' => $now - 86400
        ]);

        $this->firestore->collection('payments')->newDocument()->set([
            'user_id' => $userId2,
            'registration_id' => $registrationId4,
            'stripe_payment_id' => 'pi_789123456',
            'amount' => 140.00,
            'currency' => 'USD',
            'payment_method' => 'PayPal',
            'payment_status' => 'Completed',
            'payment_date' => $now - 172800,
            'created_at' => $now - 172800
        ]);

        $this->firestore->collection('payments')->newDocument()->set([
            'user_id' => $userId3,
            'registration_id' => $registrationId5,
            'stripe_payment_id' => 'pi_321654987',
            'amount' => 100.00,
            'currency' => 'USD',
            'payment_method' => 'Card',
            'payment_status' => 'Refunded',
            'payment_date' => $now - 259200,
            'created_at' => $now - 259200
        ]);

        // Additional payments for class enrollments
        $this->firestore->collection('payments')->newDocument()->set([
            'user_id' => $userId1,
            'registration_id' => null,
            'stripe_payment_id' => 'pi_111222333',
            'amount' => 50.00,
            'currency' => 'USD',
            'payment_method' => 'Card',
            'payment_status' => 'Completed',
            'payment_date' => $now - 7200,
            'created_at' => $now - 7200
        ]);

        $this->firestore->collection('payments')->newDocument()->set([
            'user_id' => $userId2,
            'registration_id' => null,
            'stripe_payment_id' => 'pi_444555666',
            'amount' => 60.00,
            'currency' => 'USD',
            'payment_method' => 'Card',
            'payment_status' => 'Failed',
            'payment_date' => $now - 129600,
            'created_at' => $now - 129600
        ]);

        // ======== SCHEDULES (Multiple Schedules) ========
        $this->firestore->collection('schedules')->newDocument()->set([
            'event_id' => $eventId1,
            'title' => 'Opening Ceremony',
            'description' => 'Welcome and introduction to the Winter Show',
            'event_datetime' => $now + 86400,
            'location' => 'Main Arena',
            'additional_info' => 'All participants must attend',
            'created_at' => $now,
            'updated_at' => $now
        ]);

        $this->firestore->collection('schedules')->newDocument()->set([
            'event_id' => $eventId1,
            'title' => 'Beginner Dressage Competition',
            'description' => 'Competition for beginner level riders',
            'event_datetime' => $now + 90000,
            'location' => 'Arena A',
            'additional_info' => 'Check-in 30 minutes before',
            'created_at' => $now,
            'updated_at' => $now
        ]);

        $this->firestore->collection('schedules')->newDocument()->set([
            'event_id' => $eventId1,
            'title' => 'Intermediate Jumping',
            'description' => 'Show jumping for intermediate riders',
            'event_datetime' => $now + 93600,
            'location' => 'Arena B',
            'additional_info' => 'Height: 1.0m - 1.2m',
            'created_at' => $now,
            'updated_at' => $now
        ]);

        $this->firestore->collection('schedules')->newDocument()->set([
            'event_id' => $eventId1,
            'title' => 'Awards Ceremony',
            'description' => 'Prize distribution for all winners',
            'event_datetime' => $now + 97200,
            'location' => 'Main Arena',
            'additional_info' => 'All participants welcome',
            'created_at' => $now,
            'updated_at' => $now
        ]);

        $this->firestore->collection('schedules')->newDocument()->set([
            'event_id' => $eventId2,
            'title' => 'Registration and Check-in',
            'description' => 'Participant registration for Spring Championship',
            'event_datetime' => $now + 7776000,
            'location' => 'Registration Desk',
            'additional_info' => 'Bring all required documents',
            'created_at' => $now - 86400,
            'updated_at' => $now - 86400
        ]);

        $this->firestore->collection('schedules')->newDocument()->set([
            'event_id' => $eventId3,
            'title' => 'Practice Session',
            'description' => 'Open practice for all participants',
            'event_datetime' => $now + 14515200,
            'location' => 'Practice Arena',
            'additional_info' => 'First come, first served',
            'created_at' => $now - 172800,
            'updated_at' => $now - 172800
        ]);

        $this->firestore->collection('schedules')->newDocument()->set([
            'event_id' => $eventId3,
            'title' => 'Main Competition',
            'description' => 'Summer Jump Fest main event',
            'event_datetime' => $now + 14518800,
            'location' => 'Main Arena',
            'additional_info' => 'Spectators welcome',
            'created_at' => $now - 172800,
            'updated_at' => $now - 172800
        ]);

        // ======== MESSAGES (Multiple Messages) ========
        $this->firestore->collection('messages')->newDocument()->set([
            'sender_id' => $adminId1,
            'recipient_id' => $userId1,
            'subject' => 'Welcome to Ringside Productions',
            'message_body' => 'Welcome to Ringside Productions! We are excited to have you join us.',
            'attachment_url' => '',
            'is_read' => true,
            'is_broadcast' => false,
            'sent_at' => $now - 86400,
            'read_at' => $now - 80000
        ]);

        $this->firestore->collection('messages')->newDocument()->set([
            'sender_id' => $adminId1,
            'recipient_id' => $userId1,
            'subject' => 'Winter Show Registration Confirmed',
            'message_body' => 'Your registration for Winter Show has been confirmed. See you there!',
            'attachment_url' => '',
            'is_read' => false,
            'is_broadcast' => false,
            'sent_at' => $now,
            'read_at' => null
        ]);

        $this->firestore->collection('messages')->newDocument()->set([
            'sender_id' => $adminId2,
            'recipient_id' => $userId2,
            'subject' => 'Important Event Updates',
            'message_body' => 'Please note the schedule changes for upcoming events.',
            'attachment_url' => 'https://example.com/schedule.pdf',
            'is_read' => true,
            'is_broadcast' => false,
            'sent_at' => $now - 172800,
            'read_at' => $now - 170000
        ]);

        $this->firestore->collection('messages')->newDocument()->set([
            'sender_id' => $adminId3,
            'recipient_id' => $userId3,
            'subject' => 'Class Enrollment Approved',
            'message_body' => 'Your enrollment in Advanced Show Jumping has been approved.',
            'attachment_url' => '',
            'is_read' => false,
            'is_broadcast' => false,
            'sent_at' => $now - 259200,
            'read_at' => null
        ]);

        // Broadcast message to all
        $this->firestore->collection('messages')->newDocument()->set([
            'sender_id' => $adminId1,
            'recipient_id' => null,
            'subject' => 'New Safety Guidelines',
            'message_body' => 'All participants must review the updated safety guidelines before attending any events.',
            'attachment_url' => 'https://example.com/safety.pdf',
            'is_read' => false,
            'is_broadcast' => true,
            'sent_at' => $now - 43200,
            'read_at' => null
        ]);

        $this->firestore->collection('messages')->newDocument()->set([
            'sender_id' => $adminId2,
            'recipient_id' => $userId2,
            'subject' => 'Payment Reminder',
            'message_body' => 'Your payment for event registration is pending. Please complete it soon.',
            'attachment_url' => '',
            'is_read' => false,
            'is_broadcast' => false,
            'sent_at' => $now - 3600,
            'read_at' => null
        ]);

        // ======== NOTIFICATIONS (Multiple Notifications) ========
        $this->firestore->collection('notifications')->newDocument()->set([
            'user_id' => $userId1,
            'title' => 'New Event Available',
            'content' => 'Winter Show is now open for registration!',
            'notification_type' => 'Update',
            'is_read' => true,
            'is_broadcast' => false,
            'sent_at' => $now - 86400,
            'read_at' => $now - 85000
        ]);

        $this->firestore->collection('notifications')->newDocument()->set([
            'user_id' => $userId1,
            'title' => 'Registration Confirmed',
            'content' => 'Your registration for Winter Show has been confirmed.',
            'notification_type' => 'Alert',
            'is_read' => false,
            'is_broadcast' => false,
            'sent_at' => $now,
            'read_at' => null
        ]);

        $this->firestore->collection('notifications')->newDocument()->set([
            'user_id' => $userId1,
            'title' => 'Payment Successful',
            'content' => 'Your payment of $250.00 has been processed successfully.',
            'notification_type' => 'Alert',
            'is_read' => false,
            'is_broadcast' => false,
            'sent_at' => $now - 1800,
            'read_at' => null
        ]);

        $this->firestore->collection('notifications')->newDocument()->set([
            'user_id' => $userId2,
            'title' => 'Schedule Update',
            'content' => 'The schedule for Winter Show has been updated. Please check the new times.',
            'notification_type' => 'Update',
            'is_read' => true,
            'is_broadcast' => false,
            'sent_at' => $now - 172800,
            'read_at' => $now - 170000
        ]);

        $this->firestore->collection('notifications')->newDocument()->set([
            'user_id' => $userId2,
            'title' => 'Class Enrollment Pending',
            'content' => 'Your enrollment in Beginner Dressage is pending admin approval.',
            'notification_type' => 'Alert',
            'is_read' => false,
            'is_broadcast' => false,
            'sent_at' => $now - 86400,
            'read_at' => null
        ]);

        $this->firestore->collection('notifications')->newDocument()->set([
            'user_id' => $userId3,
            'title' => 'Refund Processed',
            'content' => 'Your refund of $100.00 has been processed and will appear in 5-7 business days.',
            'notification_type' => 'Alert',
            'is_read' => false,
            'is_broadcast' => false,
            'sent_at' => $now - 259200,
            'read_at' => null
        ]);

        // Broadcast notification
        $this->firestore->collection('notifications')->newDocument()->set([
            'user_id' => null,
            'title' => 'System Maintenance',
            'content' => 'The system will undergo maintenance on Dec 25th from 2 AM to 4 AM.',
            'notification_type' => 'Update',
            'is_read' => false,
            'is_broadcast' => true,
            'sent_at' => $now - 43200,
            'read_at' => null
        ]);

        $this->firestore->collection('notifications')->newDocument()->set([
            'user_id' => null,
            'title' => 'New Feature Available',
            'content' => 'Check out our new mobile app for easier event registration!',
            'notification_type' => 'Update',
            'is_read' => false,
            'is_broadcast' => true,
            'sent_at' => $now - 7200,
            'read_at' => null
        ]);

        // ======== INFORMATIVE SECTIONS (Multiple Sections) ========
        $this->firestore->collection('informative_sections')->newDocument()->set([
            'section_type' => 'AboutUs',
            'title' => 'About Ringside Productions',
            'content' => 'Ringside Productions is dedicated to providing the best equestrian events and training opportunities. With over 20 years of experience, we bring excellence to every show.',
            'attachment_url' => 'https://example.com/about-image.jpg',
            'display_order' => 1,
            'is_active' => true,
            'created_by' => $adminId1,
            'created_at' => $now - 604800,
            'updated_at' => $now - 604800
        ]);

        $this->firestore->collection('informative_sections')->newDocument()->set([
            'section_type' => 'FAQ',
            'title' => 'Frequently Asked Questions',
            'content' => 'Q: How do I register? A: Click on the events tab and select your event. Q: What are the payment options? A: We accept all major credit cards and PayPal.',
            'attachment_url' => '',
            'display_order' => 2,
            'is_active' => true,
            'created_by' => $adminId1,
            'created_at' => $now - 518400,
            'updated_at' => $now - 518400
        ]);

        $this->firestore->collection('informative_sections')->newDocument()->set([
            'section_type' => 'Rules',
            'title' => 'Competition Rules and Guidelines',
            'content' => '1. All riders must wear proper safety equipment. 2. Horses must have current health certificates. 3. Unsportsmanlike conduct will result in disqualification.',
            'attachment_url' => 'https://example.com/rules.pdf',
            'display_order' => 3,
            'is_active' => true,
            'created_by' => $adminId2,
            'created_at' => $now - 432000,
            'updated_at' => $now - 432000
        ]);

        $this->firestore->collection('informative_sections')->newDocument()->set([
            'section_type' => 'Contact',
            'title' => 'Contact Information',
            'content' => 'Email: info@ringsideproductions.com, Phone: +1-555-RINGSIDE, Address: 123 Equestrian Way, Horse City, HC 12345',
            'attachment_url' => '',
            'display_order' => 4,
            'is_active' => true,
            'created_by' => $adminId1,
            'created_at' => $now - 345600,
            'updated_at' => $now - 345600
        ]);

        $this->firestore->collection('informative_sections')->newDocument()->set([
            'section_type' => 'Safety',
            'title' => 'Safety Guidelines',
            'content' => 'Safety is our top priority. All participants must follow safety protocols including wearing helmets, proper footwear, and maintaining control of their horses at all times.',
            'attachment_url' => 'https://example.com/safety-guidelines.pdf',
            'display_order' => 5,
            'is_active' => true,
            'created_by' => $adminId3,
            'created_at' => $now - 259200,
            'updated_at' => $now - 259200
        ]);

        $this->firestore->collection('informative_sections')->newDocument()->set([
            'section_type' => 'News',
            'title' => 'Latest Updates',
            'content' => 'Spring Championship registration opens January 15th! New training facility opening soon. Check back for more updates.',
            'attachment_url' => '',
            'display_order' => 6,
            'is_active' => true,
            'created_by' => $adminId1,
            'created_at' => $now - 172800,
            'updated_at' => $now - 172800
        ]);

        $this->firestore->collection('informative_sections')->newDocument()->set([
            'section_type' => 'Sponsors',
            'title' => 'Our Sponsors',
            'content' => 'Thank you to our sponsors: Equestrian Equipment Co., Horse Health Products, Premium Stable Supplies, and many more!',
            'attachment_url' => 'https://example.com/sponsors-logo.png',
            'display_order' => 7,
            'is_active' => true,
            'created_by' => $adminId2,
            'created_at' => $now - 86400,
            'updated_at' => $now - 86400
        ]);

        // Inactive section
        $this->firestore->collection('informative_sections')->newDocument()->set([
            'section_type' => 'Archive',
            'title' => 'Archived Information',
            'content' => 'This section contains old information that is no longer relevant.',
            'attachment_url' => '',
            'display_order' => 8,
            'is_active' => false,
            'created_by' => $adminId3,
            'created_at' => $now - 1209600,
            'updated_at' => $now - 1209600
        ]);

        return "✅ Full comprehensive test data inserted successfully into Firestore!\n\n" .
            "Summary:\n" .
            "- 3 Admins\n" .
            "- 4 Users\n" .
            "- 5 Horses\n" .
            "- 5 Riders\n" .
            "- 6 Horse-Rider relationships\n" .
            "- 4 Events\n" .
            "- 5 Event Addons\n" .
            "- 5 Event Registrations\n" .
            "- 6 Registration Addons\n" .
            "- 5 Classes\n" .
            "- 6 Class Enrollments\n" .
            "- 7 Payments\n" .
            "- 7 Schedules\n" .
            "- 6 Messages\n" .
            "- 8 Notifications\n" .
            "- 8 Informative Sections";
    }
    public function get_all_data()
    {
        $collections = [
            'admin',
            'users',
            'horses',
            'riders',
            'horse_riders',
            'events',
            'event_addons',
            'event_registrations',
            'registration_addons',
            'classes',
            'class_enrollments',
            'payments',
            'schedules',
            'messages',
            'notifications',
            'informative_sections'
        ];

        $allData = [];

        foreach ($collections as $collectionName) {
            $documents = $this->firestore->collection($collectionName)->documents();
            $allData[$collectionName] = [];

            foreach ($documents as $document) {
                if ($document->exists()) {
                    $allData[$collectionName][$document->id()] = $document->data();
                }
            }
        }

        return $allData;
    }
    // Export data to JSON file
    public function export_to_json($filename = 'firestore_export.json')
    {
        $data = $this->get_all_data();
        $jsonData = json_encode($data, JSON_PRETTY_PRINT);

        $filePath = FCPATH . $filename;
        file_put_contents($filePath, $jsonData);

        return $filePath; // Returns the path to downloaded JSON file
    }
}
