<?php
defined('BASEPATH') or exit('No direct script access allowed');

use Twilio\Rest\Client;

class Twilio_lib
{

    protected $client;
    protected $from;
    protected $serviceSid;


    public function __construct()
    {
        $CI = &get_instance();
        $CI->config->load('twilio');

        $sid   = $CI->config->item('twilio_sid');
        $token = $CI->config->item('twilio_auth_token');
        $this->serviceSid = $CI->config->item('twilio_service_sid');

        $this->from   = $CI->config->item('twilio_number');
        $this->client = new Client($sid, $token);
    }

    public function send_sms($to, $message)
    {
        return $this->client->messages->create(
            $to,
            [
                'messagingServiceSid' => $this->serviceSid,
                // 'from' => $this->from,
                'body' => $message
            ]
        );
    }
}
