<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Setting_model extends CI_Model
{

    private $table = 'settings';
    private $sponsors = 'sponsors';

    public function __construct()
    {
        return parent::__construct();
        $this->load->library('firebase');
    }

    public function getFirebaseConfig()
    {
        $configFile = APPPATH . 'config/ringsideproduction.json';
        if (!file_exists($configFile)) {
            show_error('Firebase config not found', 500);
        }

        $json = file_get_contents($configFile);
        $configData = json_decode($json, true);

        if (!isset($configData['firebase'])) {
            show_error('Invalid Firebase config', 500);
        }

        // Return Firebase part as JSON
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($configData['firebase']));
    }

    public function addSponsor($data)
    {
        return $this->firebase->setDocument($this->sponsors, $data);
    }
    public function getSponsors()
    {
        $documents = $this->firebase->getCollection($this->sponsors);

        $sponsors = [];

        foreach ($documents as $docId => $data) {
            $data['id'] = $docId;
            $sponsors[] = $data;
        }

        usort($sponsors, function ($a, $b) {
            return ($b['createdDate'] ?? 0) <=> ($a['createdDate'] ?? 0);
        });

        return $sponsors;
    }

    public function deleteSponsor($id)
    {
        return $this->firebase->deleteDocument($this->sponsors, $id);
    }
}
