<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title : 'RINGSIDE'; ?></title>
    <!-- Toast Notification CSS -->
    <link rel="stylesheet" href="<?php echo base_url('public/admin_assets/css/toast.css'); ?>">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@2.5.0/fonts/remixicon.css" rel="stylesheet">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo base_url('public/admin_assets/css/styles.css'); ?>">
    <!-- Apple (iOS / Safari) -->
    <link rel="apple-touch-icon" sizes="180x180"
        href="<?php echo base_url('public/admin_assets/images/apple-touch-icon.png'); ?>">

    <!-- Standard favicons -->
    <link rel="icon" type="image/png" sizes="96x96"
        href="<?php echo base_url('public/admin_assets/images/favicon-96x96.png'); ?>">

    <link rel="icon" type="image/svg+xml"
        href="<?php echo base_url('public/admin_assets/images/favicon.svg'); ?>">

    <link rel="icon" type="image/x-icon"
        href="<?php echo base_url('public/admin_assets/images/favicon.ico'); ?>">

    <!-- Web App / PWA -->
    <link rel="manifest"
        href="<?php echo base_url('public/admin_assets/images/site.webmanifest'); ?>">

    <script>
        /**
         * Global FCM runtime config
         * Loaded ONCE for all admin pages
         */
        window.fcmConfig = {
            firebaseConfigUrl: "<?= base_url('admin/getFirebaseConfig'); ?>",
            saveTokenUrl: "<?= base_url('admin/saveFcmToken'); ?>",
            faviconUrl: "<?= base_url('public/admin_assets/images/favicon-96x96.png'); ?>"
        };
    </script>
    <script src="https://www.gstatic.com/firebasejs/9.22.0/firebase-app-compat.js"></script>
    <script src="https://www.gstatic.com/firebasejs/9.22.0/firebase-messaging-compat.js"></script>
    <script src="https://www.gstatic.com/firebasejs/9.22.0/firebase-firestore-compat.js"></script>


    <!-- FCM core logic -->
    <script src="<?= base_url('public/admin_assets/js/fcm-admin.js'); ?>"></script>


</head>

<body>
    <main class="ringside container-fluid p-0">
        <div class="sidebar-wrapper d-flex">

            <!-- Toggle Button (visible only below 992px) -->
            <div class="sidebar-toggle d-lg-none m-2" id="sidebarToggle">
                <span></span>
                <span></span>
                <span></span>
            </div>

            <!-- Sidebar -->
            <nav id="sidebar" class="sidebar-section">
                <div class="sidebar d-flex flex-column h-100">

                    <div class="logo mb-4 text-center">
                        <a href="<?php echo base_url(''); ?>">
                            <img src="<?php echo base_url('public/admin_assets/images/RingsideLogo-2.png'); ?>"
                                class="img-fluid" alt="Ringside Logo">
                        </a>
                    </div>

                    <ul class="sidebar-menu nav flex-column flex-grow-1 gap-2">
                        <li class="nav-list <?php echo ($active_menu == 'analytics') ? 'active' : ''; ?> nav-item">
                            <a class="nav-link d-flex align-items-center" href="<?php echo base_url(''); ?>">
                                <div class="btn btn-wrapper me-2 nav-btn">
                                    <img class="primary"
                                        src="<?php echo base_url('public/admin_assets/images/Analytics1.png'); ?>"
                                        alt="">
                                </div>
                                <p class="m-0 link-text">Analytics</p>
                            </a>
                        </li>

                        <li class="nav-list <?php echo ($active_menu == 'users') ? 'active' : ''; ?> nav-item">
                            <a class="nav-link d-flex align-items-center" href="<?php echo base_url('admin/users'); ?>">
                                <div class="btn-wrapper me-2">
                                    <img class="primary"
                                        src="<?php echo base_url('public/admin_assets/images/Users.png'); ?>" alt="">
                                </div>
                                <p class="m-0 link-text">Users</p>
                            </a>
                        </li>

                        <li class="nav-list <?php echo ($active_menu == 'content') ? 'active' : ''; ?> nav-item">
                            <a class="nav-link d-flex align-items-center"
                                href="<?php echo base_url('admin/content'); ?>">
                                <div class="btn-wrapper me-2">
                                    <img class="primary"
                                        src="<?php echo base_url('public/admin_assets/images/Content Management.png'); ?>"
                                        alt="">
                                </div>
                                <p class="m-0 link-text">Content Management</p>
                            </a>
                        </li>

                        <li class="nav-list <?php echo ($active_menu == 'notifications') ? 'active' : ''; ?> nav-item">
                            <a class="nav-link d-flex align-items-center"
                                href="<?php echo base_url('admin/notifications'); ?>">
                                <div class="btn-wrapper me-2">
                                    <img class="primary"
                                        src="<?php echo base_url('public/admin_assets/images/Notifications.png'); ?>"
                                        alt="">
                                </div>
                                <p class="m-0 link-text">Notifications</p>
                            </a>
                        </li>
                        <li class="nav-list <?php echo ($active_menu == 'requests') ? 'active' : ''; ?> nav-item">
                            <a class="nav-link d-flex align-items-center" href="<?php echo base_url('admin/requests'); ?>">
                                <div class="btn-wrapper me-2">
                                    <i class="ri-add-circle-line"></i> <!-- Icon for Add/Scratch -->
                                </div>
                                <p class="m-0 link-text">Add/Scratch Request</p>
                            </a>
                        </li>
                        <li class="nav-list <?php echo ($active_menu == 'messages') ? 'active' : ''; ?> nav-item">
                            <a class="nav-link d-flex align-items-center" href="<?php echo base_url('admin/messages'); ?>">
                                <div class="btn-wrapper me-2">
                                    <i class="ri-chat-3-line"></i> <!-- Icon for Chats -->
                                </div>
                                <p class="m-0 link-text">Chats</p>
                            </a>
                        </li>
                        <li class="nav-list <?php echo ($active_menu == 'text-message') ? 'active' : ''; ?> nav-item">
                            <a class="nav-link d-flex align-items-center" href="<?php echo base_url('admin/text-message'); ?>">
                                <div class="btn-wrapper me-2">
                                    <i class="ri-message-2-line"></i> <!-- Icon for Text Message -->
                                </div>
                                <p class="m-0 link-text">Text Message</p>
                            </a>
                        </li>
                        <li class="nav-list <?php echo ($active_menu == 'sponsors') ? 'active' : ''; ?> nav-item">
                            <a class="nav-link d-flex align-items-center" href="<?php echo base_url('admin/sponsors'); ?>">
                                <div class="btn-wrapper me-2">
                                    <i class="ri-gift-line"></i>
                                </div>
                                <p class="m-0 link-text">Sponsors</p>
                            </a>
                        </li>

                    </ul>

                    <ul class="nav flex-column mb-3 mt-auto">
                        <li class="nav-list <?php echo ($active_menu == 'settings') ? 'active' : ''; ?> nav-item">
                            <a class="nav-link d-flex align-items-center"
                                href="<?php echo base_url('admin/settings'); ?>">
                                <div class="btn-wrapper me-2">
                                    <img class="primary"
                                        src="<?php echo base_url('public/admin_assets/images/Settings.png'); ?>" alt="">
                                </div>
                                <p class="m-0 link-text">Settings</p>
                            </a>
                        </li>
                        <li class="nav-list nav-item">
                            <a class="nav-link d-flex align-items-center" href="<?php echo base_url('admin/logout'); ?>">
                                <div class="btn-wrapper me-2">
                                    <!-- Remixicon logout icon -->
                                    <i class="ri-logout-box-line" style="font-size: 20px;"></i>
                                </div>
                                <p class="m-0 link-text">Logout</p>
                            </a>
                        </li>
                    </ul>




                </div>
            </nav>

            <!-- Main Content Area - This is where page content will be loaded -->
            <?php $this->load->view($content_view); ?>

        </div>
    </main>

    <!-- Custom JavaScript -->
    <script src="<?php echo base_url('public/admin_assets/js/scripts.js'); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


</body>

</html>