<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Ringside Production</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

    <style>
        @import url("/assets/fonts/HelveticaNeue-Light.otf");
        @import url("/assets/fonts/HelveticaNeue-Medium.otf");

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: "Helvetica Neue", sans-serif;
            /* Matches your global body background */
            background: linear-gradient(90deg, #ead97c 0%, #d2b767 47%, #c3a259 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .login-container {
            /* Matches the sidebar-section style */
            background: rgba(255, 255, 255, 0.3);
            backdrop-filter: blur(10px);
            border-radius: 24px;
            border: 1px solid rgba(195, 162, 89, 0.2);
            overflow: hidden;
            width: 100%;
            max-width: 480px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
        }

        .login-header {
            padding: 40px 40px 20px 40px;
            text-align: center;
            color: #000;
        }


        .login-header i {
            font-size: 60px;
            margin-bottom: 15px;
            color: #000;
        }

        .login-header h1 {
            font-size: 28px;
            font-weight: 500;
            margin-bottom: 5px;
        }

        .login-header p {
            font-size: 14px;
            color: #5e5e5e;
        }

        .login-body {
            padding: 30px 40px 50px 40px;
        }

        /* Form Inputs matching your .login-form style */
        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            font-weight: 500;
            color: #000;
            margin-bottom: 8px;
            font-size: 14px;
            display: block;
        }

        .form-control {
            background: rgba(255, 255, 255, 0.3) !important;
            border: 1px solid #c3a25933 !important;
            border-radius: 20px !important;
            font-weight: 300;
            font-size: 18px;
            color: #5e5e5e;
            padding: 10px 25px 10px 45px !important;
            height: 55px;
            width: 100%;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            box-shadow: 0 0 0 3px rgba(195, 162, 89, 0.2);
            border-color: #c3a259 !important;
            outline: none;
        }

        .input-group {
            position: relative;
        }

        .input-group-icon {
            position: absolute;
            left: 18px;
            top: 50%;
            transform: translateY(-50%);
            color: #5e5e5e;
            z-index: 10;
        }

        /* Button matching your .login-button / .btn style */
        .btn-login {
            width: 100%;
            padding: 15px;
            background: linear-gradient(180deg, #616161 0%, #000000 100%);
            border: none;
            border-radius: 30px;
            color: #ffffff;
            font-size: 18px;
            font-weight: 400;
            cursor: pointer;
            transition: opacity 0.3s ease;
            margin-top: 10px;
        }

        .btn-login:hover {
            opacity: 0.9;
            color: #fff;
        }

        .forgot-password {
            text-align: right;
            margin-top: 15px;
        }

        .forgot-password a {
            text-decoration: underline;
            color: #000000;
            font-size: 14px;
        }

        /* Error/Alert Styles */
        .error-alert {
            background: rgba(220, 53, 69, 0.1);
            border-radius: 12px;
            padding: 12px;
            margin-bottom: 20px;
            display: none;
            color: #a94442;
            font-size: 14px;
            border: 1px solid #ebccd1;
        }

        .error-alert.show {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        /* Custom Swal for your theme */
        .swal2-confirm {
            background: linear-gradient(180deg, #616161 0%, #000000 100%) !important;
            border-radius: 30px !important;
        }
    </style>
</head>

<body>
    <div class="login-container">
        <div class="login-header">

            <img
                class="login-logo"
                src="<?php echo base_url('public/admin_assets/images/loginlogo.png'); ?>"
                alt="RINGSIDE Logo">

            <!-- <h3>Ringside Production LLC</h3> -->

        </div>


        <div class="login-body">
            <div id="errorAlert" class="error-alert">
                <i class="fas fa-exclamation-circle"></i>
                <div class="error-content">
                    <span id="errorMessage"></span>
                </div>
            </div>

            <form id="loginForm">
                <div class="form-group">
                    <label class="form-label">Email Address</label>
                    <div class="input-group">
                        <i class="fas fa-envelope input-group-icon"></i>
                        <input type="email" class="form-control" id="email" name="email" placeholder="email@example.com"
                            required>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Password</label>
                    <div class="input-group">
                        <i class="fas fa-lock input-group-icon"></i>
                        <input type="password" class="form-control" id="password" name="password" placeholder="••••••••"
                            required>
                    </div>
                </div>

                <button type="submit" class="btn-login" id="loginBtn">
                    <span id="btnText">Sign In</span>
                    <span id="btnSpinner" class="d-none">
                        <span class="spinner-border spinner-border-sm"></span>
                    </span>
                </button>
            </form>

            <div class="forgot-password">
                <a href="#" onclick="showForgotPassword(); return false;">Forgot Password?</a>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        // Close error alert
        function closeError() {
            const errorAlert = document.getElementById('errorAlert');
            errorAlert.classList.remove('show');

            // Remove error styling from inputs
            document.getElementById('email').classList.remove('error-input');
            document.getElementById('password').classList.remove('error-input');
        }

        // Show error alert
        // Show error alert
        function showError(title, message, highlightFields = []) {
            const errorAlert = document.getElementById('errorAlert');
            const errorTitle = document.getElementById('errorTitle');
            const errorMessage = document.getElementById('errorMessage');

            // Update text content
            if (errorTitle) errorTitle.textContent = title;
            if (errorMessage) errorMessage.textContent = message;

            // Show the box
            errorAlert.classList.add('show');

            // Highlight error fields
            highlightFields.forEach(fieldId => {
                const field = document.getElementById(fieldId);
                if (field) {
                    field.style.borderColor = "#dc3545"; // Manual highlight since .error-input class might be missing
                    field.classList.add('error-input');
                }
            });

            // Scroll to top to show error
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        }

        // Close error alert
        function closeError() {
            const errorAlert = document.getElementById('errorAlert');
            if (errorAlert) errorAlert.classList.remove('show');

            // Reset borders on inputs
            const inputs = ['email', 'password'];
            inputs.forEach(id => {
                const el = document.getElementById(id);
                if (el) {
                    el.style.borderColor = "";
                    el.classList.remove('error-input');
                }
            });
        }

        // Show forgot password modal
        function showForgotPassword() {
            Swal.fire({
                icon: 'info',
                title: 'Forgot Password?',
                text: 'Please contact the system administrator to reset your password.',
                confirmButtonText: 'Okay, Got it'
            });
        }

        // Handle form submission with async/await
        document.getElementById('loginForm').addEventListener('submit', async function(e) {
            e.preventDefault();

            // Close any existing errors
            closeError();

            const email = document.getElementById('email').value.trim();
            const password = document.getElementById('password').value;
            const loginBtn = document.getElementById('loginBtn');
            const btnText = document.getElementById('btnText');
            const btnSpinner = document.getElementById('btnSpinner');

            // Basic validation
            if (!email || !password) {
                showError('Missing Information', 'Please enter both email and password', ['email', 'password']);
                return;
            }

            // Email format validation
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailRegex.test(email)) {
                showError('Invalid Email', 'Please enter a valid email address', ['email']);
                return;
            }

            // Disable button and show spinner
            loginBtn.disabled = true;
            btnText.classList.add('d-none');
            btnSpinner.classList.remove('d-none');

            try {
                // Send login request using async/await
                const response = await fetch('<?php echo base_url('admin/processLogin'); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: new URLSearchParams({
                        email: email,
                        password: password
                    })
                });

                const data = await response.json();

                if (data.success) {
                    // Success - Show SweetAlert and redirect
                    await Swal.fire({
                        icon: 'success',
                        title: 'Welcome Back!',
                        text: data.message,
                        showConfirmButton: false,
                        timer: 1800,
                        timerProgressBar: true
                    });

                    // Redirect to dashboard
                    window.location.href = data.redirect;
                } else {
                    // Error - Show inline error message
                    let highlightFields = [];

                    if (data.message.toLowerCase().includes('email')) {
                        highlightFields = ['email'];
                    } else if (data.message.toLowerCase().includes('password')) {
                        highlightFields = ['password'];
                    } else {
                        highlightFields = ['email', 'password'];
                    }

                    showError('Authentication Failed', data.message, highlightFields);

                    // Re-enable button
                    loginBtn.disabled = false;
                    btnText.classList.remove('d-none');
                    btnSpinner.classList.add('d-none');
                }
            } catch (error) {
                // Network or server error
                console.error('Login error:', error);
                showError('Server Error', 'Unable to connect to the server. Please try again later.', []);

                // Re-enable button
                loginBtn.disabled = false;
                btnText.classList.remove('d-none');
                btnSpinner.classList.add('d-none');
            }
        });

        // Remove error styling when user starts typing
        document.getElementById('email').addEventListener('input', function() {
            this.classList.remove('error-input');
        });

        document.getElementById('password').addEventListener('input', function() {
            this.classList.remove('error-input');
        });

        // Auto-dismiss success alerts after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert-success');
            alerts.forEach(alert => {
                alert.style.transition = 'opacity 0.5s ease';
                alert.style.opacity = '0';
                setTimeout(() => alert.remove(), 500);
            });
        }, 5000);
    </script>
</body>

</html>