<section class="analytics-dashboard">
    <?php if ($this->session->flashdata('toast_success')): ?>
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: '<?= $this->session->flashdata('toast_success'); ?>',
                    timer: 2000,
                    showConfirmButton: false
                });
            });
        </script>
    <?php endif; ?>

    <?php if ($this->session->flashdata('toast_error')): ?>
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: '<?= $this->session->flashdata('toast_error'); ?>',
                    timer: 2000,
                    showConfirmButton: false
                });
            });
        </script>
    <?php endif; ?>


    <div class="title-wrapper">
        <h1 class="title">Content Management</h1>
    </div>

    <div class="user-page">
        <!-- Top Search + Filter -->
        <div class="top-bar">
            <div class="search-box">
                <i class="ri-search-line"></i>
                <input type="text" id="searchInput" placeholder="Search Events...">
            </div>

            <select id="eventFilter" class="form-select filter-select" style="width:180px;">
                <option value="All Events">All Schedules</option>
                <option value="Active Events">Active</option>
                <option value="Upcoming Events">Upcoming</option>
                <option value="Past Events">Past</option>
            </select>
        </div>

        <div class="events-page">

            <!-- Tabs -->
            <div class="tab-buttons">
                <button class="tab-btn active" data-tab="events">Events</button>
                <!-- <button class="tab-btn" data-tab="schedule">Schedule</button> -->
            </div>

            <!-- EVENTS SECTION -->
            <div class="events-wrapper section" id="eventsSection">

                <!-- Header -->
                <div class="d-flex justify-content-between align-items-center mb-3 events-header">
                    <h2 class="title">Events</h2>
                    <a href="<?php echo base_url('admin/add-event'); ?>" class="btn btn-warning add-event-btn">Add
                        Event</a>
                </div>

                <!-- Table -->
                <div class="table-responsive table-wrapper">
                    <table class="table align-middle">
                        <thead class="">
                            <tr>
                                <th>Name</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody id="eventsTableBody">
                            <?php if (!empty($events)): ?>
                                <?php foreach ($events as $event): ?>
                                    <tr>
                                        <td>
                                            <div class="user-info">
                                                <img src="<?php echo isset($event['img']) && $event['img'] ? $event['img'] : base_url('public/admin_assets/images/users-profile.png'); ?>"
                                                    alt="">
                                                <span><?php echo htmlspecialchars($event['name']); ?></span>
                                            </div>
                                        </td>
                                        <td class="date">
                                            <?php
                                            if (!empty($event['start_date'])) {
                                                $timestamp = intval($event['start_date'] / 1000); // convert ms → seconds
                                                echo date('M d, Y', $timestamp);
                                            } else {
                                                echo 'N/A';
                                            }
                                            ?>
                                        </td>

                                        <td class="status"><?php echo htmlspecialchars($event['status']); ?></td>
                                        <td>


                                            <button class="btn-secondary"
                                                onclick="window.location.href='<?php echo base_url('admin/events/edit/' . $event['id']); ?>'"> Edit </button>

                                            <button class="btn-secondary btn-delete"
                                                onclick="deleteEvent('<?php echo $event['id']; ?>')">
                                                <img src="<?php echo base_url('public/admin_assets/images/delete.png'); ?>"
                                                    alt=""
                                                    style="width:16px; height:16px; vertical-align:middle; margin-right:5px;">
                                                Delete
                                            </button>

                                            <button class="btn-secondary btn-view"
                                                onclick="window.location.href='<?php echo base_url('event/details/' . $event['id']); ?>'">
                                                <img src="<?php echo base_url('public/admin_assets/images/view.png'); ?>" alt=""
                                                    style="width:16px; height:16px; vertical-align:middle; margin-right:5px;">
                                                View
                                            </button>
                                        </td>

                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="4" class="text-center">No events found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="pagination-wrapper" id="eventsPagination" style="margin-top:10px; text-align:center;"></div>


            <!-- SCHEDULE SECTION -->
            <div class="events-schedule section" id="scheduleSection" style="display:none;">
                <div class="events-header">
                    <h2 class="title">Schedule</h2>
                    <!-- <button class="add-event-btn open-schedule-modal">Add Schedule</button> -->
                </div>

                <div class="table-responsive table-wrapper">
                    <table class="table align-middle">
                        <thead class="">
                            <tr>
                                <th>Name</th>
                                <th>Date</th>
                                <th>Hosted By</th>
                                <th>Location</th>
                                <!-- <th>Actions</th> -->
                            </tr>
                        </thead>

                        <tbody id="scheduleTableBody">
                            <?php if (!empty($schedules)): ?>
                                <?php foreach ($schedules as $schedule): ?>
                                    <tr>
                                        <td>
                                            <div class="user-info">
                                                <img src="<?php echo isset($schedule['img']) && $schedule['img'] ? $schedule['img'] : base_url('public/admin_assets/images/users-profile.png'); ?>"
                                                    alt="">
                                                <span><?php echo htmlspecialchars($schedule['name']); ?></span>
                                            </div>
                                        </td>
                                        <td class="date"><?php echo htmlspecialchars($schedule['date']); ?></td>
                                        <td><?php echo htmlspecialchars($schedule['host']); ?></td>
                                        <td><?php echo htmlspecialchars($schedule['location']); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="5" class="text-center">No schedules found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- SCHEDULE MODAL -->
        <div class="ringside schedule-modal" id="scheduleModal">
            <div class="schedule-modal-bg"></div>

            <div class="schedule-modal-content">
                <h2 class="modal-title">Add Schedule</h2>

                <form id="scheduleForm" method="post" action="<?php echo base_url('schedule/add'); ?>">
                    <div class="form-wrapper">

                        <!-- First Row -->
                        <div class="row g-3">
                            <div class="col-12 col-md-6">
                                <div class="form-group">
                                    <label for="scheduleName">Name</label>
                                    <input type="text" name="name" id="scheduleName" class="form-control"
                                        placeholder="Name" required />
                                </div>
                            </div>

                            <div class="col-12 col-md-6 position-relative">
                                <div class="form-group">
                                    <label for="scheduleDate">Date/Time</label>
                                    <input type="datetime-local" name="date" id="scheduleDate" class="form-control"
                                        required />
                                </div>
                            </div>
                        </div>

                        <!-- Second Row -->
                        <div class="row g-3">
                            <div class="col-12 col-md-6">
                                <div class="form-group">
                                    <label for="scheduleHost">Hosted By</label>
                                    <input type="text" name="host" id="scheduleHost" class="form-control"
                                        placeholder="Type here" required />
                                </div>
                            </div>

                            <div class="col-12 col-md-6">
                                <div class="form-group">
                                    <label for="scheduleLocation">Location</label>
                                    <input type="text" name="location" id="scheduleLocation" class="form-control"
                                        placeholder="Location" required />
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="modal-buttons">
                        <button type="button" class="btn-cancel close-modal">Cancel</button>
                        <button type="submit" class="btn btn-upload" id="uploadSchedule">Upload Schedule</button>
                    </div>
                </form>
            </div>
        </div>

    </div>
</section>



<script>
    document.addEventListener("DOMContentLoaded", () => {
        // -------------------- DATA --------------------
        let currentPage = 1;
        const rowsPerPage = 10;
        let eventsData = <?php echo json_encode($events ?? []); ?>;
        let scheduleData = <?php echo json_encode($schedules ?? []); ?>;
        let eventSearchQuery = "";
        let eventSelectedFilter = "All Events";

        // -------------------- FILTER & SEARCH --------------------
        document.getElementById("eventFilter").addEventListener("change", function() {
            eventSelectedFilter = this.value;
            renderEvents();
            renderSchedule();
        });

        document.getElementById("searchInput").addEventListener("input", function() {
            eventSearchQuery = this.value.toLowerCase().trim();
            renderEvents();
            renderSchedule();
        });

        // -------------------- RENDER EVENTS --------------------
        function renderEvents() {
            const body = document.getElementById("eventsTableBody");
            const pagination = document.getElementById("eventsPagination");
            body.innerHTML = "";
            pagination.innerHTML = "";

            let filteredEvents = eventsData;
            const now = Date.now();

            // -------- FILTERING --------
            if (eventSelectedFilter === "Upcoming Events") {
                filteredEvents = filteredEvents.filter(ev => ev.start_date > now);
            } else if (eventSelectedFilter === "Past Events") {
                filteredEvents = filteredEvents.filter(ev => ev.start_date < now);
            } else if (eventSelectedFilter === "Active Events") {
                const todayStart = new Date().setHours(0, 0, 0, 0);
                const todayEnd = new Date().setHours(23, 59, 59, 999);
                filteredEvents = filteredEvents.filter(
                    ev => ev.start_date >= todayStart && ev.start_date <= todayEnd
                );
            }

            if (eventSearchQuery) {
                filteredEvents = filteredEvents.filter(ev =>
                    ev.name.toLowerCase().includes(eventSearchQuery) ||
                    ev.status.toLowerCase().includes(eventSearchQuery)
                );
            }

            if (!filteredEvents.length) {
                body.innerHTML = '<tr><td colspan="4" class="text-center">No events found</td></tr>';
                return;
            }

            // -------- PAGINATION --------
            const totalPages = Math.ceil(filteredEvents.length / rowsPerPage);
            if (currentPage > totalPages) currentPage = 1;

            const start = (currentPage - 1) * rowsPerPage;
            const paginatedEvents = filteredEvents.slice(start, start + rowsPerPage);

            paginatedEvents.forEach(ev => {
                const formattedDate = new Date(ev.start_date).toLocaleDateString('en-US', {
                    month: 'short',
                    day: '2-digit',
                    year: 'numeric'
                });

                body.innerHTML += `
        <tr>
            <td>
                <div class="user-info">
                    <img src="${ev.img || '<?php echo base_url('public/admin_assets/images/users-profile.png'); ?>'}"
                        style="width:40px;height:40px;border-radius:50%;">
                    <span>${ev.name}</span>
                </div>
            </td>
            <td class="date">${formattedDate}</td>
            <td>
                <button class="btn-secondary"
                    onclick="window.location.href='<?php echo base_url('admin/events/edit/'); ?>${ev.id}'">
                    Edit
                </button>
                <button class="btn-secondary btn-delete" onclick="deleteEvent('${ev.id}')">
                    Delete
                </button>
                <button class="btn-secondary btn-view"
                    onclick="window.location.href='<?php echo base_url('event/details/'); ?>${ev.id}'">
                    View
                </button>
            </td>
        </tr>`;
            });

            // -------- PAGINATION UI --------

            // Previous button
            pagination.innerHTML += `
    <button class="btn-primary" style="background-color: #000000"
        ${currentPage === 1 ? 'disabled' : ''}
        onclick="goToPage(${currentPage - 1})"
        style="margin:0 4px;">
        Previous
    </button>
`;

            // Current page number (only one shown)
            pagination.innerHTML += `
    <button class="btn-primary active" style="background-color: #000000"
        disabled
        style="margin:0 4px;">
        ${currentPage}
    </button>
`;

            // Next button
            pagination.innerHTML += `
    <button class="btn-primary" style="background-color: #000000"
        ${currentPage === totalPages ? 'disabled' : ''}
        onclick="goToPage(${currentPage + 1})"
        style="margin:0 4px;">
        Next
    </button>
`;

        }

        function goToPage(page) {
            currentPage = page;
            renderEvents();
        }

        window.goToPage = goToPage;
        document.getElementById("eventFilter").addEventListener("change", function() {
            eventSelectedFilter = this.value;
            currentPage = 1;
            renderEvents();
        });

        document.getElementById("searchInput").addEventListener("input", function() {
            eventSearchQuery = this.value.toLowerCase().trim();
            currentPage = 1;
            renderEvents();
        });




        // -------------------- RENDER SCHEDULE --------------------
        function renderSchedule() {
            const body = document.getElementById("scheduleTableBody");
            body.innerHTML = "";

            let filteredSchedule = scheduleData;
            const now = Date.now(); // Current time in milliseconds

            // --- Dynamic Time Filtering ---
            if (eventSelectedFilter === "Upcoming Events") {
                // Start time is in the future
                filteredSchedule = filteredSchedule.filter(sc => sc.start_ms > now);
            } else if (eventSelectedFilter === "Past Events") {
                // End time is in the past
                filteredSchedule = filteredSchedule.filter(sc => sc.end_ms < now);
            } else if (eventSelectedFilter === "Active Events") {
                // Current time is between start and end
                filteredSchedule = filteredSchedule.filter(sc => now >= sc.start_ms && now <= sc.end_ms);
            }

            // --- Search Filtering ---
            if (eventSearchQuery) {
                filteredSchedule = filteredSchedule.filter(sc =>
                    sc.name.toLowerCase().includes(eventSearchQuery) ||
                    sc.host.toLowerCase().includes(eventSearchQuery) ||
                    sc.location.toLowerCase().includes(eventSearchQuery)
                );
            }

            if (!filteredSchedule.length) {
                body.innerHTML = '<tr><td colspan="5" class="text-center">No schedules found</td></tr>';
                return;
            }

            filteredSchedule.forEach(sc => {
                // Determine badge color for visual status


                body.innerHTML += `
            <tr>
                <td>
                    <div class="user-info">
                        <img src="${sc.img || '<?php echo base_url('public/admin_assets/images/users-profile.png'); ?>'}">
                        <span>${sc.name}</span>
                    </div>
                </td>
                <td class="date">
                    ${sc.date}
                </td>
                <td>${sc.host}</td>
                <td>${sc.location}</td>
            </tr>
        `;
            });
        }

        // Initial render
        renderEvents();
        renderSchedule();

        // -------------------- TAB SWITCH --------------------
        document.querySelectorAll(".tab-btn").forEach(btn => {
            btn.addEventListener("click", () => {
                document.querySelectorAll(".tab-btn").forEach(b => b.classList.remove("active"));
                btn.classList.add("active");

                document.getElementById("eventsSection").style.display = btn.dataset.tab === "events" ? "block" : "none";
                document.getElementById("scheduleSection").style.display = btn.dataset.tab === "schedule" ? "block" : "none";
            });
        });

        // -------------------- DELETE FUNCTIONS --------------------
        async function deleteEvent(id) {
            const result = await Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            });

            if (!result.isConfirmed) return;

            Swal.fire({
                title: 'Deleting...',
                text: 'Please wait',
                allowOutsideClick: false,
                allowEscapeKey: false,
                didOpen: () => Swal.showLoading()
            });

            try {
                const res = await fetch(`<?php echo base_url('admin/events/delete/'); ?>${id}`, {
                    method: 'DELETE'
                });
                const data = await res.json();
                Swal.close();

                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Deleted!',
                        text: data.message,
                        timer: 1500,
                        showConfirmButton: false
                    });
                    eventsData = eventsData.filter(ev => ev.id !== id);
                    renderEvents();
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: data.message || 'Something went wrong'
                    });
                }
            } catch (err) {
                Swal.close();
                Swal.fire({
                    icon: 'error',
                    title: 'Server Error',
                    text: 'Please try again later'
                });
            }
        }

        async function deleteSchedule(id) {
            const result = await Swal.fire({
                title: 'Are you sure?',
                text: "Do you want to delete this schedule?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            });

            if (!result.isConfirmed) return;

            Swal.fire({
                title: 'Deleting...',
                text: 'Please wait',
                allowOutsideClick: false,
                allowEscapeKey: false,
                didOpen: () => Swal.showLoading()
            });

            try {
                const res = await fetch(`<?php echo base_url('/schedule/delete/'); ?>${id}`, {
                    method: 'DELETE'
                });
                const data = await res.json();
                Swal.close();

                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Deleted!',
                        text: data.message,
                        timer: 1500,
                        showConfirmButton: false
                    });
                    scheduleData = scheduleData.filter(sc => sc.id !== id);
                    renderSchedule();
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: data.message || 'Something went wrong'
                    });
                }
            } catch (err) {
                Swal.close();
                Swal.fire({
                    icon: 'error',
                    title: 'Server Error',
                    text: 'Please try again later'
                });
            }
        }

        window.deleteEvent = deleteEvent;
        window.deleteSchedule = deleteSchedule;

        // -------------------- SCHEDULE MODAL --------------------
        const scheduleModal = document.getElementById("scheduleModal");

        // Open Add Modal
        document.querySelector(".open-schedule-modal")?.addEventListener("click", () => {
            // Reset form
            scheduleForm.reset();
            document.getElementById('scheduleIdInput')?.remove();
            document.querySelector('#scheduleModal .modal-title').textContent = 'Add Schedule';
            document.getElementById('uploadSchedule').textContent = 'Add Schedule';
            scheduleModal.style.display = 'flex';
        });

        document.querySelectorAll(".close-modal").forEach(btn => btn.addEventListener("click", () => scheduleModal.style.display = "none"));
        window.addEventListener("click", e => {
            if (e.target === scheduleModal) scheduleModal.style.display = "none";
        });

        // -------------------- FORM SUBMISSION WITH ASYNC --------------------
        const scheduleForm = document.getElementById("scheduleForm"); // SPECIFICALLY TARGET SCHEDULE FORM

        async function submitForm(form) {
            if (!validateForm(form)) {
                Swal.fire({
                    icon: 'error',
                    title: 'Missing information',
                    text: 'Please fill all required fields'
                });
                return;
            }

            Swal.fire({
                title: 'Uploading...',
                text: 'Please wait',
                allowOutsideClick: false,
                allowEscapeKey: false,
                didOpen: () => Swal.showLoading()
            });

            const formData = new FormData(form);
            try {
                // Using addOrUpdate route
                const res = await fetch('<?php echo base_url("schedule/addOrUpdate"); ?>', {
                    method: 'POST',
                    body: formData
                });
                const data = await res.json();
                Swal.close();

                if (data.success) {
                    // Update local scheduleData array
                    const existingIndex = scheduleData.findIndex(sc => sc.id == data.schedule.id);
                    if (existingIndex > -1) {
                        scheduleData[existingIndex] = data.schedule;
                    } else {
                        scheduleData.push(data.schedule);
                    }

                    renderSchedule();
                    scheduleModal.style.display = 'none';
                    form.reset();
                    document.getElementById('scheduleIdInput')?.remove();

                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: data.message,
                        timer: 1500,
                        showConfirmButton: false,
                        didClose: () => {
                            window.location.reload();
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: data.message || 'Something went wrong'
                    });
                }
            } catch (err) {
                Swal.close();
                Swal.fire({
                    icon: 'error',
                    title: 'Server Error',
                    text: 'Please try again later'
                });
            }
        }

        scheduleForm?.addEventListener('submit', e => {
            e.preventDefault();
            submitForm(scheduleForm);
        });

        function validateForm(form) {
            let valid = true;
            form.querySelectorAll('[required]').forEach(input => {
                if (!input.value.trim()) valid = false;
            });
            return valid;
        }

        // -------------------- OPEN EDIT SCHEDULE MODAL --------------------
        function openEditScheduleModal(id) {
            const schedule = scheduleData.find(sc => sc.id === id);
            if (!schedule) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Schedule not found'
                });
                return;
            }

            // Fill modal inputs with existing data
            document.getElementById('scheduleName').value = schedule.name;
            document.getElementById('scheduleDate').value = formatDateTimeForInput(schedule.date);
            document.getElementById('scheduleHost').value = schedule.host;
            document.getElementById('scheduleLocation').value = schedule.location;

            // Add or update hidden id input
            let idInput = document.getElementById('scheduleIdInput');
            if (!idInput) {
                idInput = document.createElement('input');
                idInput.type = 'hidden';
                idInput.id = 'scheduleIdInput';
                idInput.name = 'id';
                document.getElementById('scheduleForm').appendChild(idInput);
            }
            idInput.value = id;

            // Change modal title and button
            document.querySelector('#scheduleModal .modal-title').textContent = 'Edit Schedule';
            document.getElementById('uploadSchedule').textContent = 'Update Schedule';

            // Open modal
            scheduleModal.style.display = 'flex';
        }

        // Convert date from "Dec 31, 2025 19:00" to input[type=datetime-local] format "YYYY-MM-DDTHH:MM"
        function formatDateTimeForInput(dateStr) {
            const date = new Date(dateStr);
            const yyyy = date.getFullYear();
            const mm = String(date.getMonth() + 1).padStart(2, '0');
            const dd = String(date.getDate()).padStart(2, '0');
            const hh = String(date.getHours()).padStart(2, '0');
            const min = String(date.getMinutes()).padStart(2, '0');
            return `${yyyy}-${mm}-${dd}T${hh}:${min}`;
        }

        window.openEditScheduleModal = openEditScheduleModal;

    });
</script>
<style>
    .pagination-wrapper button:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
</style>