<!-- Analytics Dashboard -->
<section class="analytics-dashboard">



    <!-- Page Titles -->
    <div class="title-wrapper">
        <h1 class="title">Analytics Dashboard</h1>
        <p class="subtitle">Overview of your equestrian event platform</p>
    </div>

    <!-- Top Cards -->
    <div class="card-group">

        <!-- Total Users -->
        <div class="card">
            <div class="card-icon-wrapper">
                <div class="btn btn-wrapper btn-card">
                    <img class="icon" src="<?= base_url('public/admin_assets/images/Total Users.png'); ?>" alt="">
                </div>
            </div>
            <h3 class="card-title">Total Users</h3>
            <div class="toll-wrapper">
                <h2 class="toll"><?= $total_users ?? 0; ?></h2>
                <a href="<?= base_url('admin/users'); ?>" class="btn btn-wrapper btn-card">
                    <img src="<?= base_url('public/admin_assets/images/Path 23500.png'); ?>" alt="">
                </a>
            </div>
        </div>

        <!-- Active Events -->
        <div class="card">
            <div class="card-icon-wrapper">
                <div class="btn btn-wrapper btn-card">
                    <img class="icon" src="<?= base_url('public/admin_assets/images/Active Events.png'); ?>" alt="">
                </div>
            </div>
            <h3 class="card-title">Active Events</h3>
            <div class="toll-wrapper">
                <h2 class="toll"><?= $active_events ?? 0; ?></h2>
                <a href="<?= base_url('admin/content'); ?>" class="btn btn-wrapper btn-card">
                    <img src="<?= base_url('public/admin_assets/images/Path 23500.png'); ?>" alt="">
                </a>
            </div>
        </div>

        <!-- Closed Events -->
        <div class="card">
            <div class="card-icon-wrapper">
                <div class="btn btn-wrapper btn-card">
                    <img class="icon" src="<?= base_url('public/admin_assets/images/Active Events.png'); ?>" alt="">
                </div>
            </div>
            <h3 class="card-title">Closed Events</h3>
            <div class="toll-wrapper">
                <h2 class="toll"><?= $closed_events ?? 0; ?></h2>
                <a href="<?= base_url('admin/content'); ?>" class="btn btn-wrapper btn-card">
                    <img src="<?= base_url('public/admin_assets/images/Path 23500.png'); ?>" alt="">
                </a>
            </div>
        </div>

        <!-- Scheduled -->
        <div class="card">
            <div class="card-icon-wrapper">
                <div class="btn btn-wrapper btn-card">
                    <img class="icon" src="<?= base_url('public/admin_assets/images/Scheduled.png'); ?>" alt="">
                </div>
            </div>
            <h3 class="card-title">Scheduled</h3>
            <div class="toll-wrapper">
                <h2 class="toll"><?= $scheduled_events ?? 0; ?></h2>
                <a href="<?= base_url('admin/content/schedule'); ?>" class="btn btn-wrapper btn-card">
                    <img src="<?= base_url('public/admin_assets/images/Path 23500.png'); ?>" alt="">
                </a>
            </div>
        </div>

    </div>

    <!-- Bottom Dashboard -->
    <div class="dashboard">

        <!-- Upcoming Events -->
        <section class="card">
            <div class="card-header">
                <h2 class="card-header-title">Upcoming Events</h2>
                <a href="<?= base_url('admin/content'); ?>">View All</a>
            </div>

            <div class="event-list">
                <?php if (!empty($upcoming_events)): ?>
                    <?php foreach ($upcoming_events as $event): ?>
                        <div class="event-item">
                            <img src="<?= base_url('public/admin_assets/images/users-profile.png'); ?>" alt="">
                            <div class="event-info">
                                <h3 class="title"><?= htmlspecialchars($event['name'] ?? 'N/A'); ?></h3>
                                <div class="event-calender">
                                    <p>Date:
                                        <span>
                                            <?= (!empty($event['start_date']) && $event['start_date'] != 'N/A')
                                                ? date('d M Y', strtotime($event['start_date']))
                                                : 'TBD'; ?>
                                        </span>
                                    </p>
                                </div>
                            </div>
                            <span class="tag"><?= isset($event['tiles_count']) ? (int) $event['tiles_count'] : 0; ?> Tiles</span>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p class="text-muted">No upcoming events found</p>
                <?php endif; ?>
            </div>
        </section>

        <!-- New Users -->
        <section class="card">
            <div class="card-header">
                <h2 class="card-header-title">New Users</h2>
                <a href="<?= base_url('admin/users'); ?>">View All</a>
            </div>

            <div class="user-list">
                <?php if (!empty($new_users)): ?>
                    <?php foreach ($new_users as $user): ?>
                        <div class="user-item">
                            <div class="user-info">
                                <h3 class="title"><?= htmlspecialchars($user['name'] ?? 'N/A'); ?></h3>
                                <p><span><?= htmlspecialchars($user['email'] ?? '—'); ?></span></p>
                            </div>
                            <span class="time">
                                <?php
                                $created = isset($user['created_at']) ? (int) $user['created_at'] : time();
                                $diff = time() - $created;
                                if ($diff < 3600) {
                                    echo floor($diff / 60) . ' min ago';
                                } elseif ($diff < 86400) {
                                    echo floor($diff / 3600) . ' hours ago';
                                } else {
                                    echo floor($diff / 86400) . ' days ago';
                                }
                                ?>
                            </span>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p class="text-muted">No new users found</p>
                <?php endif; ?>
            </div>
        </section>



    </div>

</section>