<section class="analytics-dashboard">
    <div class="notification-content">
        <div class="title-wrapper">
            <h1 class="title">Settings</h1>
        </div>
        <!-- Notification Status Card -->
        <div class="page-group">
            <div class="events-header">
                <h2 class="title">Push Notifications</h2>
            </div>
            <div class="form-wrapper">
                <div class="notification-status" id="notificationStatus">
                    <p id="statusText">Checking notification status...</p>
                </div>
                <button id="enableNotifications" class="btn btn-save-wrapper" style="display: none;">
                    Enable Notifications
                </button>
            </div>
        </div>

        <div class="user-page">
            <div class="page-group">
                <div class="events-header">
                    <h2 class="title">Admin Information</h2>
                </div>

                <div class="form-wrapper">
                    <div class="form-row">
                        <div class="form-group">
                            <label class="label-title">Admin Name</label>
                            <input type="text" value="<?= $admin['name'] ?? 'Admin User'; ?>" readonly>
                        </div>
                        <div class="form-group">
                            <label class="label-title">Email Address</label>
                            <input type="email" value="<?= $admin['email'] ?? ''; ?>" readonly>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label class="label-title">Role</label>
                            <input type="text" value="<?= ucfirst($admin['userType'] ?? 'Admin'); ?>" readonly>
                        </div>

                    </div>
                </div>
            </div>

            <div class="page-group">
                <div class="events-header">
                    <h2 class="title">Password Reset</h2>
                </div>

                <form id="passwordForm" class="form-wrapper">
                    <div class="form-row">
                        <div class="form-group">
                            <label for="old-password" class="label-title">Old Password</label>
                            <input id="old-password" name="old_password" type="password" placeholder="••••••••••••"
                                required />
                        </div>
                        <div class="form-group">
                            <label for="new-password" class="label-title">New Password</label>
                            <input id="new-password" name="new_password" type="password" placeholder="••••••••••••"
                                required />
                        </div>
                    </div>
                    <div class="d-flex justify-content-end mt-2">
                        <button type="submit" class="btn btn-save-wrapper" id="savePasswordBtn">
                            <span id="btnText">Save Password</span>
                            <div id="btnSpinner" class="spinner-border spinner-border-sm d-none" role="status"></div>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
<script>
    // Base URLs from PHP
    const fcmConfig = {
        firebaseConfigUrl: '<?php echo base_url("admin/getFirebaseConfig"); ?>',
        saveTokenUrl: '<?php echo base_url("admin/saveFcmToken"); ?>',
        faviconUrl: '<?php echo base_url("public/admin_assets/images/favicon-96x96.png"); ?>'
    };

    // Check notification permission status on page load
    document.addEventListener('DOMContentLoaded', () => {
        checkNotificationStatus();

        const enableBtn = document.getElementById('enableNotifications');
        if (enableBtn) {
            enableBtn.addEventListener('click', async () => {
                await window.initializeAdminFCM();
                checkNotificationStatus();
            });
        }
    });

    function checkNotificationStatus() {
        const statusText = document.getElementById('statusText');
        const enableBtn = document.getElementById('enableNotifications');

        if (!('Notification' in window)) {
            statusText.innerHTML = '<strong>Not Supported:</strong> Your browser does not support notifications';
            statusText.style.color = '#dc3545';
            return;
        }

        const permission = Notification.permission;

        if (permission === 'granted') {
            statusText.innerHTML = '<strong>Enabled:</strong> You will receive push notifications for new messages';
            statusText.style.color = '#28a745';
            enableBtn.style.display = 'none';
        } else if (permission === 'denied') {
            statusText.innerHTML = '<strong>Blocked:</strong> Please enable notifications in your browser settings';
            statusText.style.color = '#dc3545';
            enableBtn.style.display = 'none';
        } else {
            statusText.innerHTML = '<strong>Not Enabled:</strong> Click below to enable push notifications';
            statusText.style.color = '#ffc107';
            enableBtn.style.display = 'inline-block';
        }
    }
</script>

<style>
    .notification-status {
        padding: 15px;
        background: rgba(255, 255, 255, 0.5);
        border-radius: 10px;
        margin-bottom: 15px;
    }

    .notification-status p {
        margin: 0;
        font-size: 16px;
        font-weight: 500;
    }

    /* Styling to match your Ringside App Theme */
    .search-bar-wrapper input[type="text"] {
        width: 100%;
        padding: 12px 15px;
        font-size: 16px;
        border-radius: 12px;
        border: none;
        background: rgba(255, 255, 255, 0.3);
        outline: none;
        color: #000;
        margin-bottom: 20px;
    }

    .form-row {
        display: flex;
        gap: 15px;
    }

    @media (max-width: 767.98px) {
        .form-row {
            flex-direction: column;
        }
    }

    .form-group {
        flex: 1;
        margin-top: 15px;
    }

    .form-group .label-title {
        font-size: 14px;
        font-weight: 500;
        color: #5D5D5D;
        margin-bottom: 8px;
        display: block;
    }

    .form-group input {
        width: 100%;
        padding: 15px 20px;
        font-size: 16px;
        border: 1px solid rgba(195, 162, 89, 0.2);
        border-radius: 12px;
        background: #D2B767;
        /* Your app gold */
        outline: none;
        font-weight: 400;
        color: #000;
    }

    /* Styling for Read-only inputs to look slightly different */
    .form-group input[readonly] {
        background: rgba(210, 183, 103, 0.5);
        cursor: not-allowed;
    }

    .page-group {
        background: rgba(255, 255, 255, 0.3);
        border-radius: 20px;
        padding: 25px;
        margin-bottom: 25px;
        backdrop-filter: blur(5px);
    }

    .btn-save-wrapper {
        margin-top: 25px;
        background: linear-gradient(180deg, #616161 0%, #000000 100%);
        padding: 15px 35px;
        border-radius: 15px;
        border: none;
        color: #fff;
        transition: transform 0.2s;
        cursor: pointer;
    }

    .btn-save-wrapper:hover {
        transform: translateY(-2px);
        opacity: 0.9;
    }

    .btn-save-wrapper:disabled {
        opacity: 0.6;
        cursor: not-allowed;
    }
</style>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.getElementById('passwordForm').addEventListener('submit', async function(e) {
        e.preventDefault();

        const btn = document.getElementById('savePasswordBtn');
        const btnText = document.getElementById('btnText');
        const spinner = document.getElementById('btnSpinner');
        const oldPass = document.getElementById('old-password').value;
        const newPass = document.getElementById('new-password').value;

        // Validation
        if (newPass.length < 6) {
            Swal.fire('Error', 'New password must be at least 6 characters.', 'error');
            return;
        }

        // Show Loading State
        btn.disabled = true;
        btnText.textContent = "Updating...";
        spinner.classList.remove('d-none');

        try {
            const response = await fetch('<?php echo base_url("admin/updatePassword"); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    'old_password': oldPass,
                    'new_password': newPass
                })
            });

            const result = await response.json();

            if (result.success) {
                await Swal.fire({
                    icon: 'success',
                    title: 'Updated!',
                    text: result.message,
                    timer: 2000,
                    showConfirmButton: false
                });
                this.reset(); // Clear the password fields
            } else {
                Swal.fire('Failed', result.message, 'error');
            }
        } catch (error) {
            console.error('Update error:', error);
            Swal.fire('Error', 'Could not connect to server.', 'error');
        } finally {
            // Revert Button State
            btn.disabled = false;
            btnText.textContent = "Save Password";
            spinner.classList.add('d-none');
        }
    });

    // Simple search filter for page groups (Optional UX)
    document.getElementById('search').addEventListener('input', function(e) {
        const term = e.target.value.toLowerCase();
        const groups = document.querySelectorAll('.page-group');
        groups.forEach(group => {
            const text = group.innerText.toLowerCase();
            group.style.display = text.includes(term) ? 'block' : 'none';
        });
    });
</script>