<section class="analytics-dashboard">


    <div class="title-wrapper">
        <h1 class="title">User Management</h1>
        <p class="subtitle">Manage all registered users and their profiles</p>
    </div>

    <div class="user-page">

        <!-- Top Search + Filter -->
        <div class="top-bar">
            <div class="search-box">
                <i class="ri-search-line"></i>
                <input type="text" id="searchInput" placeholder="Search Users...">
            </div>

            <select id="userFilter" class="form-select filter-select" style="width:150px;">
                <option value="All Users">All Users</option>
                <option value="Active">Active</option>
                <option value="Inactive">Inactive</option>
            </select>
        </div>

        <!-- Table Container -->
        <div class="events-wrapper">
            <div class="table-responsive table-wrapper">
                <table class="table align-middle">
                    <thead class="">
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                        </tr>
                    </thead>

                    <tbody id="userTableBody">
                        <?php foreach ($users as $user): ?>
                            <tr>
                                <td><?= htmlspecialchars($user['fullname'] ?? '-') ?></td>
                                <td><?= htmlspecialchars($user['email'] ?? '-') ?></td>
                                <td><?= htmlspecialchars($user['phoneNumber'] ?? '-') ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>

                </table>
            </div>
        </div>
        <div class="pagination-wrapper" id="usersPagination"
            style="margin-top:10px; text-align:center;"></div>


    </div>
</section>

<!-- Additional JS for this page -->
<script>
    document.addEventListener('DOMContentLoaded', () => {

        const searchInput = document.getElementById('searchInput');
        const userFilter = document.getElementById('userFilter');
        const tableBody = document.getElementById('userTableBody');
        const pagination = document.getElementById('usersPagination');

        const rowsPerPage = 10;
        let currentPage = 1;

        function getFilteredRows() {
            const searchText = searchInput.value.toLowerCase().trim();
            const filterVal = userFilter.value;

            return Array.from(tableBody.querySelectorAll('tr')).filter(row => {
                const name = row.children[0].innerText.toLowerCase();
                const email = row.children[1].innerText.toLowerCase();
                const phone = row.children[2].innerText.toLowerCase();

                const matchesSearch =
                    name.includes(searchText) ||
                    email.includes(searchText) ||
                    phone.includes(searchText);

                return matchesSearch;
            });
        }

        function renderTable() {
            const rows = getFilteredRows();
            pagination.innerHTML = "";

            tableBody.querySelectorAll('tr').forEach(r => r.style.display = 'none');

            if (!rows.length) {
                return;
            }

            const totalPages = Math.ceil(rows.length / rowsPerPage);
            if (currentPage > totalPages) currentPage = 1;

            const start = (currentPage - 1) * rowsPerPage;
            const paginatedRows = rows.slice(start, start + rowsPerPage);

            paginatedRows.forEach(row => row.style.display = '');

            // Previous
            pagination.innerHTML += `
            <button class="btn-primary"  style="background-color: #000000"
                ${currentPage === 1 ? 'disabled' : ''}
                onclick="goToUserPage(${currentPage - 1})">
                Previous
            </button>
        `;

            // Page number
            pagination.innerHTML += `
            <button class="btn-primary active"  style="background-color: #000000" disabled>
                ${currentPage}
            </button>
        `;

            // Next
            pagination.innerHTML += `
            <button class="btn-primary" style="background-color: #000000"
                ${currentPage === totalPages ? 'disabled' : ''}
                onclick="goToUserPage(${currentPage + 1})">
                Next
            </button>
        `;
        }

        function goToUserPage(page) {
            currentPage = page;
            renderTable();
        }

        window.goToUserPage = goToUserPage;

        searchInput.addEventListener('input', () => {
            currentPage = 1;
            renderTable();
        });

        userFilter.addEventListener('change', () => {
            currentPage = 1;
            renderTable();
        });

        // Initial render
        renderTable();
    });
</script>
<style>
    .pagination-wrapper button:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
</style>