<!DOCTYPE html>
<html lang="en">

<head>
    <link rel="stylesheet" href="<?php echo base_url('public/admin_assets/css/event-details.css'); ?>">
</head>

<body>
    <section class="analytics-dashboard">

        <div class="title-wrapper">
            <div class="d-flex justify-content-between align-items-center">
                <h1 class="title">Event Details</h1>
                <div class="action-buttons-wrapper">
                    <a href="<?php echo base_url('admin/content'); ?>" class="btn btn-back">
                        <i class="ri-arrow-left-line"></i> Back
                    </a>
                </div>
            </div>
        </div>

        <div class="user-page">
            <?php if (!empty($event)): ?>
                <div class="events-wrapper">
                    <div class="events-header">
                        <h2 class="title">Event Information</h2>

                    </div>
                    <div class="event-info-grid">
                        <div class="info-item">
                            <label>Event Name</label>
                            <p><?php echo htmlspecialchars($event['event_name']); ?></p>
                        </div>
                        <div class="info-item">
                            <label>Start Date & Time</label>
                            <p class="date"><?php echo date('M d, Y H:i', $event['start_date'] / 1000); ?></p>
                        </div>
                        <div class="info-item">
                            <label>End Date & Time</label>
                            <p class="date"><?php echo date('M d, Y H:i', $event['end_date'] / 1000); ?></p>
                        </div>
                        <div class="info-item">
                            <label>Admin Messages</label>
                            <p><?php echo !empty($event['enable_admin_messages']) ? 'Enabled' : 'Disabled'; ?></p>
                        </div>
                    </div>
                </div>

                <div class="events-page">
                    <div class="title-wrapper" style="margin-top: 20px; margin-bottom: 15px;">
                        <h2 class="title">Event Content</h2>
                    </div>

                    <?php
                    $tileKeys = array_diff(array_keys($event), [
                        'end_date',
                        'updated_at',
                        'enable_admin_messages',
                        'created_at',
                        'event_name',
                        'categories',
                        'start_date',
                        'status',
                        'admin_chat',
                        'event_members'
                    ]);
                    $hasContent = false;
                    ?>
                    <?php if (!empty($event['event_members'])): ?>
                        <div class="events-wrapper tile-section-wrapper" style="margin-bottom: 20px;">
                            <div class="tile-header-toggle" onclick="toggleTileSection('event_members')">
                                <div class="events-header">
                                    <h3 class="title">Event Members</h3>
                                    <div class="d-flex align-items-center" style="gap: 10px;">
                                        <span class="tile-badge"><?php echo count($event['event_members']); ?> Member<?php echo count($event['event_members']) != 1 ? 's' : ''; ?></span>
                                        <i class="ri-arrow-down-s-line toggle-arrow" id="icon-event_members"></i>
                                    </div>
                                </div>
                            </div>

                            <div class="tile-content-area" id="content-event_members" style="display: none;">
                                <ul class="event-members-list">
                                    <?php foreach ($event['event_members'] as $member): ?>
                                        <li><?php echo htmlspecialchars($member['fullname']); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    <?php endif; ?>


                    <?php foreach ($tileKeys as $tileKey): ?>
                        <?php if (!empty($event[$tileKey]) && is_array($event[$tileKey])): ?>
                            <?php $hasContent = true;
                            $subsections = $event[$tileKey];
                            $subsectionCount = count($subsections); ?>
                            <div class="events-wrapper tile-section-wrapper" style="margin-bottom: 20px;">
                                <div class="tile-header-toggle" onclick="toggleTileSection('<?php echo $tileKey; ?>')">
                                    <div class="events-header">
                                        <h3 class="title"><?php echo ucwords(str_replace('_', ' ', $tileKey)); ?></h3>
                                        <div class="d-flex align-items-center" style="gap: 10px;">
                                            <span class="tile-badge"><?php echo $subsectionCount; ?>
                                                Section<?php echo $subsectionCount != 1 ? 's' : ''; ?></span>
                                            <i class="ri-arrow-down-s-line toggle-arrow" id="icon-<?php echo $tileKey; ?>"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="tile-content-area" id="content-<?php echo $tileKey; ?>" style="display: none;">
                                    <?php foreach ($subsections as $subsectionId => $subsection): ?>
                                        <div class="subsection-wrapper">
                                            <div class="subsection-header-area">
                                                <?php if (is_array($subsection) && isset($subsection['name'])): ?>
                                                    <h4 class="subsection-title">
                                                        <i class="ri-file-list-3-line"></i>
                                                        <?php echo htmlspecialchars($subsection['name']); ?>
                                                    </h4>
                                                <?php endif; ?>

                                            </div>
                                            <div class="subsection-content">
                                                <?php if (!empty($subsection['information'])): ?>
                                                    <div class="subsection-info-block"><label>Information</label>
                                                        <p><?php echo nl2br(htmlspecialchars($subsection['information'])); ?></p>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if (!empty($subsection['pdfs'])): ?>
                                                    <div class="pdf-section">
                                                        <label><i class="ri-file-pdf-line"></i> Attached PDFs</label>
                                                        <div class="pdf-items-list">
                                                            <?php foreach ($subsection['pdfs'] as $pdf):
                                                                $filename = preg_replace(
                                                                    '/^\d+_\d+_/',
                                                                    '',
                                                                    urldecode(basename(parse_url($pdf, PHP_URL_PATH)))
                                                                );
                                                            ?>
                                                                <div class="pdf-row">
                                                                    <div class="pdf-icon-box"><i class="ri-file-pdf-2-fill"></i></div>
                                                                    <div class="pdf-info"><span
                                                                            class="pdf-filename"><?php echo htmlspecialchars($filename); ?></span>
                                                                    </div>

                                                                    <div class="pdf-buttons">
                                                                        <a href="https://docs.google.com/viewer?url=<?php echo urlencode($pdf); ?>&embedded=true"
                                                                            target="_blank"
                                                                            class="btn btn-icon-action">
                                                                            <i class="ri-eye-line">View</i>
                                                                        </a>


                                                                        <a href="<?php echo $pdf . '&response-content-disposition=attachment'; ?>"
                                                                            class="btn btn-icon-action">
                                                                            <i class="ri-download-line">Download</i>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            <?php endforeach; ?>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <script>
        function toggleTileSection(tileKey) {
            const content = document.getElementById('content-' + tileKey);
            const icon = document.getElementById('icon-' + tileKey);
            content.style.display = content.style.display === 'none' ? 'block' : 'none';
            icon.style.transform = content.style.display === 'block' ? 'rotate(180deg)' : 'rotate(0deg)';
        }
    </script>
</body>
<style>
    .event-members-list {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
        gap: 10px;
        list-style: none;
        padding: 0;
        margin: 10px 0 0 0;
    }

    .event-members-list li {
        padding: 6px 10px;
        border-radius: 6px;
        text-align: center;
        font-weight: 500;
        background: linear-gradient(180deg, #ead97c 0%, #d2b767 47%, #c3a259 100%);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        /* centers content vertically inside the li */
        box-shadow: 0 6px 14px rgba(0, 0, 0, 0.15);
        transition: transform 0.2s ease, box-shadow 0.2s ease, background 0.2s ease;
    }

    /* PDF Section Grid */
    .pdf-items-list {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
        gap: 16px;
        margin-top: 12px;
    }

    /* PDF Card */
    .pdf-row {
        background: linear-gradient(180deg, #ead97c 0%, #d2b767 47%, #c3a259 100%);
        border-radius: 14px;
        padding: 16px;
        display: flex;
        flex-direction: column;
        align-items: center;
        box-shadow: 0 6px 14px rgba(0, 0, 0, 0.15);
        transition: transform 0.2s ease, box-shadow 0.2s ease, background 0.2s ease;
    }

    /* PDF Card Hover */
    .event-members-list li:hover,
    .pdf-row:hover {
        transform: translateY(-4px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.25);
        background: linear-gradient(180deg, #f5e29b 0%, #e0c25a 47%, #d1a959 100%);
    }

    /* Hide left icon box (optional but clean) */
    .pdf-icon-box {
        display: none;
    }

    /* PDF Name Box */
    .pdf-info {
        width: 100%;
        background: rgba(255, 255, 255, 0.35);
        border-radius: 10px;
        padding: 14px 10px;
        text-align: center;
        margin-bottom: 10px;
    }

    /* PDF Filename */
    .pdf-filename {
        font-size: 14px;
        font-weight: 500;
        color: #2b2b2b;
        word-break: break-word;
    }

    /* Buttons BELOW the box */
    .pdf-buttons {
        display: flex;
        gap: 6px;
        width: 100%;
        justify-content: center;
    }

    /* Button sizing – compact */
    .pdf-buttons .btn {
        min-width: 76px;
        padding: 1px 2px;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 4px;
        border-radius: 8px;
        font-size: 9px;
        font-weight: 500;
        white-space: nowrap;
        line-height: 1;
        transition: all 0.2s ease;
    }

    /* Fix <i> icon spacing */
    .pdf-buttons .btn i {
        display: inline-flex;
        align-items: center;
        gap: 2px;
        font-style: normal;
        line-height: 1;
        font-size: 14px;
    }

    /* Button hover */
    .pdf-buttons .btn:hover {
        background: linear-gradient(180deg, #616161 0%, #000000 100%);
        color: #ffffff;
        transform: translateY(-2px);
    }
</style>

</html>