<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/firestore/v1/bloom_filter.proto

namespace Google\Cloud\Firestore\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A sequence of bits, encoded in a byte array.
 * Each byte in the `bitmap` byte array stores 8 bits of the sequence. The only
 * exception is the last byte, which may store 8 _or fewer_ bits. The `padding`
 * defines the number of bits of the last byte to be ignored as "padding". The
 * values of these "padding" bits are unspecified and must be ignored.
 * To retrieve the first bit, bit 0, calculate: `(bitmap[0] & 0x01) != 0`.
 * To retrieve the second bit, bit 1, calculate: `(bitmap[0] & 0x02) != 0`.
 * To retrieve the third bit, bit 2, calculate: `(bitmap[0] & 0x04) != 0`.
 * To retrieve the fourth bit, bit 3, calculate: `(bitmap[0] & 0x08) != 0`.
 * To retrieve bit n, calculate: `(bitmap[n / 8] & (0x01 << (n % 8))) != 0`.
 * The "size" of a `BitSequence` (the number of bits it contains) is calculated
 * by this formula: `(bitmap.length * 8) - padding`.
 *
 * Generated from protobuf message <code>google.firestore.v1.BitSequence</code>
 */
class BitSequence extends \Google\Protobuf\Internal\Message
{
    /**
     * The bytes that encode the bit sequence.
     * May have a length of zero.
     *
     * Generated from protobuf field <code>bytes bitmap = 1;</code>
     */
    private $bitmap = '';
    /**
     * The number of bits of the last byte in `bitmap` to ignore as "padding".
     * If the length of `bitmap` is zero, then this value must be `0`.
     * Otherwise, this value must be between 0 and 7, inclusive.
     *
     * Generated from protobuf field <code>int32 padding = 2;</code>
     */
    private $padding = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $bitmap
     *           The bytes that encode the bit sequence.
     *           May have a length of zero.
     *     @type int $padding
     *           The number of bits of the last byte in `bitmap` to ignore as "padding".
     *           If the length of `bitmap` is zero, then this value must be `0`.
     *           Otherwise, this value must be between 0 and 7, inclusive.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Firestore\V1\BloomFilter::initOnce();
        parent::__construct($data);
    }

    /**
     * The bytes that encode the bit sequence.
     * May have a length of zero.
     *
     * Generated from protobuf field <code>bytes bitmap = 1;</code>
     * @return string
     */
    public function getBitmap()
    {
        return $this->bitmap;
    }

    /**
     * The bytes that encode the bit sequence.
     * May have a length of zero.
     *
     * Generated from protobuf field <code>bytes bitmap = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setBitmap($var)
    {
        GPBUtil::checkString($var, False);
        $this->bitmap = $var;

        return $this;
    }

    /**
     * The number of bits of the last byte in `bitmap` to ignore as "padding".
     * If the length of `bitmap` is zero, then this value must be `0`.
     * Otherwise, this value must be between 0 and 7, inclusive.
     *
     * Generated from protobuf field <code>int32 padding = 2;</code>
     * @return int
     */
    public function getPadding()
    {
        return $this->padding;
    }

    /**
     * The number of bits of the last byte in `bitmap` to ignore as "padding".
     * If the length of `bitmap` is zero, then this value must be `0`.
     * Otherwise, this value must be between 0 and 7, inclusive.
     *
     * Generated from protobuf field <code>int32 padding = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setPadding($var)
    {
        GPBUtil::checkInt32($var);
        $this->padding = $var;

        return $this;
    }

}

