<style>
.city-management-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(114, 165, 101, 0.2);
}

.city-stats-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-left: 4px solid;
    height: 100%;
}

.city-stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.city-stats-card.primary { border-left-color: #72A565; }
.city-stats-card.success { border-left-color: #48bb78; }
.city-stats-card.warning { border-left-color: #ed8936; }
.city-stats-card.info { border-left-color: #4299e1; }
.city-stats-card.danger { border-left-color: #f56565; }

.city-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    border: none;
    overflow: hidden;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.city-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.city-card .card-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    border-bottom: 2px solid #e2e8f0;
    padding: 1.25rem 1.5rem;
    font-weight: 600;
    color: #2d3748;
}

.city-card .card-body {
    padding: 1.5rem;
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.stats-number.success {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.stats-number.warning {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.stats-number.info {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.action-btn-group {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.btn-modern {
    border-radius: 10px;
    padding: 0.6rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    border: none;
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.btn-modern-primary {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
}

.btn-modern-info {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.btn-modern-success {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.btn-modern-warning {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}
</style>

<!-- Header Section -->
<div class="city-management-header">
    <div class="row align-items-center">
        <div class="col-md-8">
            <h2 class="mb-2">
                <i class="fa-solid fa-city"></i> Market Management
            </h2>
            <p class="mb-0 opacity-75">Manage each market independently - settings, analytics, vendors, drivers, and orders</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?= base_url() . 'dashboard/addcity' ?>" class="btn btn-light btn-modern btn-modern-primary">
                <i class="fa-solid fa-plus"></i> Add New Market
            </a>
        </div>
    </div>
</div>

<!-- Overall Statistics -->
<div class="row mb-4">
    <div class="col-md-3 mb-3">
        <div class="city-stats-card primary">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">Total Markets</h6>
                    <h3 class="stats-number mb-0"><?php echo count($cities); ?></h3>
                </div>
                <div>
                    <i class="fa-solid fa-city fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="city-stats-card success">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">Total Orders</h6>
                    <h3 class="stats-number success mb-0"><?php echo isset($overallStats['totalOrders']) ? $overallStats['totalOrders'] : 0; ?></h3>
                </div>
                <div>
                    <i class="fa-solid fa-shopping-cart fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="city-stats-card info">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">Total Revenue</h6>
                    <h3 class="stats-number info mb-0">$<?php echo isset($overallStats['totalRevenue']) ? number_format($overallStats['totalRevenue'], 2) : '0.00'; ?></h3>
                </div>
                <div>
                    <i class="fa-solid fa-dollar-sign fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="city-stats-card warning">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">Active Drivers</h6>
                    <h3 class="stats-number warning mb-0"><?php echo isset($overallStats['totalDrivers']) ? $overallStats['totalDrivers'] : 0; ?></h3>
                </div>
                <div>
                    <i class="fa-solid fa-users fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- City Cards -->
<?php if (!empty($cities)): ?>
    <?php foreach ($cities as $cityId => $city): 
        $cityStats = isset($cityStatsData[$cityId]) ? $cityStatsData[$cityId] : array(
            'orders' => 0,
            'revenue' => 0,
            'drivers' => 0,
            'vendors' => 0,
            'pendingOrders' => 0
        );
    ?>
    <div class="city-card">
        <div class="card-header">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <h5 class="mb-0">
                        <i class="fa-solid fa-map-marker-alt text-primary"></i> 
                        <?php echo isset($city['cityName']) ? htmlspecialchars($city['cityName']) : 'Unknown City'; ?>
                    </h5>
                    <small class="text-muted">
                        <?php echo isset($city['state']) ? htmlspecialchars($city['state']) : ''; ?>, 
                        <?php echo isset($city['country']) ? htmlspecialchars($city['country']) : ''; ?>
                    </small>
                </div>
                <div class="col-md-6 text-end">
                    <span class="badge bg-primary">Market ID: <?php echo $cityId; ?></span>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row mb-3">
                <div class="col-md-2">
                    <div class="text-center">
                        <h4 class="stats-number mb-1"><?php echo $cityStats['orders']; ?></h4>
                        <small class="text-muted">Total Orders</small>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="text-center">
                        <h4 class="stats-number success mb-1">$<?php echo number_format($cityStats['revenue'], 2); ?></h4>
                        <small class="text-muted">Revenue</small>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="text-center">
                        <h4 class="stats-number info mb-1"><?php echo $cityStats['drivers']; ?></h4>
                        <small class="text-muted">Drivers</small>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="text-center">
                        <h4 class="stats-number warning mb-1"><?php echo $cityStats['vendors']; ?></h4>
                        <small class="text-muted">Vendors</small>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="text-center">
                        <h4 class="stats-number danger mb-1"><?php echo $cityStats['pendingOrders']; ?></h4>
                        <small class="text-muted">Pending</small>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="text-center">
                        <?php if (isset($city['hqAddress']) && $city['hqAddress'] != ''): ?>
                            <i class="fa-solid fa-check-circle text-success fa-2x mb-1"></i>
                            <br><small class="text-muted">HQ Set</small>
                        <?php else: ?>
                            <i class="fa-solid fa-exclamation-circle text-warning fa-2x mb-1"></i>
                            <br><small class="text-muted">HQ Missing</small>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <div class="action-btn-group">
                <a href="<?= base_url('dashboard/city_settings/' . $cityId) ?>" class="btn btn-sm btn-modern btn-modern-primary">
                    <i class="fa-solid fa-cog"></i> Settings
                </a>
                <a href="<?= base_url('dashboard/city_analytics/' . $cityId) ?>" class="btn btn-sm btn-modern btn-modern-info">
                    <i class="fa-solid fa-chart-line"></i> Analytics
                </a>
                <a href="<?= base_url('orders?filter_city=' . $cityId) ?>" class="btn btn-sm btn-modern btn-modern-success">
                    <i class="fa-solid fa-shopping-cart"></i> Orders
                </a>
                <a href="<?= base_url('dashboard/cityzones/' . $cityId) ?>" class="btn btn-sm btn-modern btn-modern-warning">
                    <i class="fa-solid fa-map"></i> Zones
                </a>
                <a href="<?= base_url('dashboard/editcity/' . $cityId) ?>" class="btn btn-sm btn-modern btn-modern-info">
                    <i class="fa-solid fa-edit"></i> Edit
                </a>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
<?php else: ?>
    <div class="city-card">
        <div class="card-body text-center py-5">
            <i class="fa-solid fa-city fa-3x text-muted mb-3"></i>
            <h5 class="text-muted">No Cities Found</h5>
            <p class="text-muted">Get started by adding your first market.</p>
            <a href="<?= base_url('dashboard/addcity') ?>" class="btn btn-modern btn-modern-primary">
                <i class="fa-solid fa-plus"></i> Add First Market
            </a>
        </div>
    </div>
<?php endif; ?>

<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
