<style>
.form-header-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(114, 165, 101, 0.2);
}

.form-card-modern {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    border: none;
    overflow: hidden;
}

.form-card-modern .card-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    border-bottom: 2px solid #e2e8f0;
    padding: 1.25rem 1.5rem;
    font-weight: 600;
    color: #2d3748;
}

.form-card-modern .card-body {
    padding: 2rem;
}

.form-label-modern {
    font-weight: 600;
    color: #2d3748;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.form-control-modern {
    border-radius: 10px;
    border: 2px solid #e2e8f0;
    padding: 0.75rem 1rem;
    transition: all 0.3s ease;
}

.form-control-modern:focus {
    border-color: #72A565;
    box-shadow: 0 0 0 3px rgba(114, 165, 101, 0.1);
    outline: none;
}

.btn-submit-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    border: none;
    color: white;
    padding: 0.75rem 2rem;
    border-radius: 10px;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(114, 165, 101, 0.3);
}

.btn-submit-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(114, 165, 101, 0.4);
    color: white;
}

.info-box {
    background: #f7fafc;
    border-left: 4px solid #72A565;
    padding: 1rem;
    border-radius: 8px;
    margin-bottom: 1.5rem;
}

.info-box i {
    color: #72A565;
    margin-right: 0.5rem;
}

.form-check-input:checked {
    background-color: #72A565;
    border-color: #72A565;
}
</style>

<!-- Header Section -->
<div class="form-header-modern">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h2 class="mb-2">
                <i class="fa-solid fa-cog"></i> City Settings - <?php echo htmlspecialchars($city['cityName']); ?>
            </h2>
            <p class="mb-0 opacity-75">Configure city-specific delivery fees, cutoff times, promotions, and loyalty rules</p>
        </div>
        <div>
            <a href="<?php echo base_url('dashboard/cities'); ?>" class="btn btn-light btn-modern">
                <i class="fa-solid fa-arrow-left"></i> Back to Markets
            </a>
        </div>
    </div>
</div>

<form method="post" id="citySettingsForm" action="<?php echo base_url('dashboard/update_city_settings'); ?>">
    <input type="hidden" name="cityId" value="<?php echo $cityId; ?>">
    
    <!-- Delivery Settings -->
    <div class="form-card-modern">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-truck text-primary"></i> Delivery Settings
            </h5>
        </div>
        <div class="card-body">
            <div class="info-box">
                <i class="fa-solid fa-info-circle"></i>
                <strong>Note:</strong> These settings apply only to this market. Zone-specific delivery fees can be configured in the Zones section.
            </div>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label-modern">Base Delivery Fee ($) <span class="text-danger">*</span></label>
                    <input type="number" step="0.01" min="0" name="deliveryFeeBase" 
                        class="form-control form-control-modern" 
                        value="<?php echo isset($settings['deliveryFeeBase']) ? $settings['deliveryFeeBase'] : '0.00'; ?>" 
                        required>
                    <small class="text-muted">Base delivery fee for this city (zone fees are added on top)</small>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label-modern">Minimum Order Amount ($) <span class="text-danger">*</span></label>
                    <input type="number" step="0.01" min="0" name="minOrderAmount" 
                        class="form-control form-control-modern" 
                        value="<?php echo isset($settings['minOrderAmount']) ? $settings['minOrderAmount'] : '0.00'; ?>" 
                        required>
                    <small class="text-muted">Minimum order amount required for delivery</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Cutoff Times -->
    <div class="form-card-modern">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-clock text-primary"></i> Order Cutoff Times
            </h5>
        </div>
        <div class="card-body">
            <div class="info-box">
                <i class="fa-solid fa-info-circle"></i>
                <strong>Cutoff Time:</strong> Orders placed after this time will be scheduled for the next day.
            </div>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label-modern">Daily Cutoff Time <span class="text-danger">*</span></label>
                    <input type="time" name="cutoffTime" 
                        class="form-control form-control-modern" 
                        value="<?php echo isset($settings['cutoffTime']) ? $settings['cutoffTime'] : '22:00'; ?>" 
                        required>
                    <small class="text-muted">Last time customers can place same-day orders (24-hour format)</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Loyalty Program Settings -->
    <div class="form-card-modern">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-star text-primary"></i> Loyalty Program Settings
            </h5>
        </div>
        <div class="card-body">
            <div class="mb-3">
                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" name="enableLoyalty" id="enableLoyalty" 
                        <?php echo (isset($settings['enableLoyalty']) && $settings['enableLoyalty']) ? 'checked' : ''; ?>>
                    <label class="form-check-label" for="enableLoyalty">
                        <strong>Enable Loyalty Program</strong>
                    </label>
                </div>
                <small class="text-muted">Enable or disable the loyalty program for this market</small>
            </div>
            
            <div id="loyaltySettings" style="<?php echo (isset($settings['enableLoyalty']) && $settings['enableLoyalty']) ? '' : 'display: none;'; ?>">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label-modern">Points Per Dollar Spent <span class="text-danger">*</span></label>
                        <input type="number" step="0.1" min="0" name="loyaltyPointsPerDollar" 
                            class="form-control form-control-modern" 
                            value="<?php echo isset($settings['loyaltyPointsPerDollar']) ? $settings['loyaltyPointsPerDollar'] : '1'; ?>" 
                            required>
                        <small class="text-muted">Number of loyalty points earned per dollar spent</small>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label-modern">Points Required for Reward <span class="text-danger">*</span></label>
                        <input type="number" step="1" min="1" name="loyaltyPointsRequired" 
                            class="form-control form-control-modern" 
                            value="<?php echo isset($settings['loyaltyPointsRequired']) ? $settings['loyaltyPointsRequired'] : '100'; ?>" 
                            required>
                        <small class="text-muted">Number of points needed to redeem a reward</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Promotions Settings -->
    <div class="form-card-modern">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-tags text-primary"></i> Promotions Settings
            </h5>
        </div>
        <div class="card-body">
            <div class="mb-3">
                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" name="enablePromotions" id="enablePromotions" 
                        <?php echo (isset($settings['enablePromotions']) && $settings['enablePromotions']) ? 'checked' : ''; ?>>
                    <label class="form-check-label" for="enablePromotions">
                        <strong>Enable Promotions</strong>
                    </label>
                </div>
                <small class="text-muted">Allow promotions and discount codes for this market</small>
            </div>
        </div>
    </div>

    <!-- Submit Button -->
    <div class="text-end mb-4">
        <button type="submit" class="btn btn-submit-modern">
            <i class="fa-solid fa-save"></i> Save Settings
        </button>
    </div>
</form>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    // Toggle loyalty settings visibility
    $('#enableLoyalty').on('change', function() {
        if ($(this).is(':checked')) {
            $('#loyaltySettings').slideDown();
        } else {
            $('#loyaltySettings').slideUp();
        }
    });
    
    // Form submission
    $('#citySettingsForm').on('submit', function(e) {
        e.preventDefault();
        
        var form = $(this);
        var formData = form.serialize();
        var url = form.attr('action');
        
        var submitBtn = form.find('button[type="submit"]');
        var originalText = submitBtn.html();
        submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
        
        $.ajax({
            url: url,
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                submitBtn.prop('disabled', false).html(originalText);
                
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: response.message,
                        confirmButtonText: 'OK',
                        timer: 2000,
                        timerProgressBar: true
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: response.message,
                        confirmButtonText: 'OK'
                    });
                }
            },
            error: function() {
                submitBtn.prop('disabled', false).html(originalText);
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: 'Something went wrong. Please try again.',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
});
</script>
