<style>
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

* {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
}

.customer-management-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.2);
}

.customer-stats-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    border-left: 4px solid;
    height: 100%;
    border: 1px solid rgba(102, 126, 234, 0.1);
}

.customer-stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.15);
}

.customer-stats-card.primary { 
    border-left-color: #667eea;
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.05) 0%, rgba(118, 75, 162, 0.05) 100%);
}
.customer-stats-card.success { border-left-color: #48bb78; }
.customer-stats-card.warning { border-left-color: #ed8936; }
.customer-stats-card.info { border-left-color: #4299e1; }

.filter-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    margin-bottom: 2rem;
    border: 1px solid rgba(102, 126, 234, 0.1);
}

.customer-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    overflow: hidden;
    border: 1px solid rgba(102, 126, 234, 0.1);
}

.customer-table-card .card-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.customer-table-card table thead {
    background: #f7fafc;
}

.customer-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.customer-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.customer-table-card table tbody tr:hover {
    background: #f7fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.customer-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.75rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-modern i {
    font-size: 0.7rem;
}

.badge-primary-modern {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.badge-success-modern {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.badge-warning-modern {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.badge-danger-modern {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.badge-info-modern {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.badge-secondary-modern {
    background: linear-gradient(135deg, #a0aec0 0%, #718096 100%);
    color: white;
}

.btn-modern {
    border-radius: 10px;
    padding: 0.6rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    border: none;
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.btn-modern-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
}

.btn-modern-primary:hover {
    background: linear-gradient(135deg, #5568d3 0%, #653f8f 100%);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
}

.btn-modern-success {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.btn-modern-warning {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.btn-modern-danger {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.btn-modern-info {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
}

.btn-modern-info:hover {
    background: linear-gradient(135deg, #5568d3 0%, #653f8f 100%);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
}

.action-dropdown .dropdown-menu {
    border-radius: 12px;
    box-shadow: 0 10px 40px rgba(102, 126, 234, 0.15);
    border: 1px solid rgba(102, 126, 234, 0.1);
    padding: 0.5rem;
    margin-top: 0.5rem;
}

.action-dropdown .dropdown-item {
    border-radius: 8px;
    padding: 0.75rem 1rem;
    transition: all 0.2s ease;
    margin-bottom: 0.25rem;
}

.action-dropdown .dropdown-item:hover {
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
    transform: translateX(5px);
    color: #667eea;
}

.action-dropdown .dropdown-item i {
    width: 20px;
    text-align: center;
}

.customer-name-link {
    color: #667eea;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
}

.customer-name-link:hover {
    color: #764ba2;
    text-decoration: none;
    transform: translateX(5px);
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.stats-number.success {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.stats-number.warning {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.stats-number.info {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.filter-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    margin-bottom: 1rem;
}

.id-image {
    width: 60px;
    height: 60px;
    object-fit: cover;
    border-radius: 8px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    cursor: pointer;
    transition: transform 0.3s ease;
}

.id-image:hover {
    transform: scale(1.1);
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}

.tab-button {
    border-radius: 10px;
    padding: 0.75rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.tab-button.active {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-color: transparent;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
}

.tab-button:not(.active) {
    background: white;
    color: #667eea;
    border-color: #667eea;
}

.tab-button:not(.active):hover {
    background: rgba(102, 126, 234, 0.1);
    border-color: #764ba2;
    color: #764ba2;
}

.tab-button:not(.active):hover {
    background: #f7fafc;
    transform: translateY(-2px);
}
</style>

<!-- Header Section -->
<div class="customer-management-header">
    <div class="row align-items-center">
        <div class="col-md-8">
            <h2 class="mb-2">
                <i class="fa-solid fa-users"></i> Customer Management
            </h2>
            <p class="mb-0 opacity-75">Manage users, view account balances, ratings, and account status</p>
        </div>
        <div class="col-md-4 text-end">
            <div class="btn-group" role="group">
                <a href="<?php echo base_url('Customer'); ?>" 
                   class="btn tab-button <?php echo (isset($filterType) && $filterType == 'pending') ? 'active' : ''; ?>">
                    <i class="fa-solid fa-clock"></i> Pending
                </a>
                <a href="<?php echo base_url('Customer/approvedcustomer'); ?>" 
                   class="btn tab-button <?php echo (isset($filterType) && $filterType == 'approved') ? 'active' : ''; ?>">
                    <i class="fa-solid fa-check-circle"></i> Approved
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3 mb-3">
        <div class="customer-stats-card primary">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">Total Customers</h6>
                    <h3 class="stats-number mb-0"><?php echo isset($stats['totalCustomers']) ? $stats['totalCustomers'] : 0; ?></h3>
                </div>
                <div>
                    <i class="fa-solid fa-users fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="customer-stats-card success">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">Online Users</h6>
                    <h3 class="stats-number success mb-0"><?php echo isset($stats['onlineUsers']) ? $stats['onlineUsers'] : 0; ?></h3>
                </div>
                <div>
                    <i class="fa-solid fa-circle-dot fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="customer-stats-card info">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">Total Balance</h6>
                    <h3 class="stats-number info mb-0">$<?php echo isset($stats['totalBalance']) ? number_format($stats['totalBalance'], 2) : '0.00'; ?></h3>
                    <small class="text-muted"><?php echo isset($stats['withBalance']) ? $stats['withBalance'] : 0; ?> users with balance</small>
                </div>
                <div>
                    <i class="fa-solid fa-wallet fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="customer-stats-card warning">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">Avg Rating</h6>
                    <h3 class="stats-number warning mb-0"><?php echo isset($stats['avgRating']) ? number_format($stats['avgRating'], 1) : '0.0'; ?></h3>
                    <small class="text-muted"><?php echo isset($stats['totalRatings']) ? $stats['totalRatings'] : 0; ?> total ratings</small>
                </div>
                <div>
                    <i class="fa-solid fa-star fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="filter-card">
    <div class="row align-items-center">
        <div class="col-md-6">
            <label class="form-label fw-bold text-muted mb-2">
                <i class="fa-solid fa-search"></i> Search Users
            </label>
            <input type="text" class="form-control" id="searchInput" placeholder="Search by name, email, or device type...">
        </div>
        <div class="col-md-6 text-end">
            <a href="<?php echo base_url('Customer/addcustomer'); ?>" class="btn btn-modern btn-modern-primary mt-4">
                <i class="fa-solid fa-plus"></i> Add User
            </a>
        </div>
    </div>
</div>

<!-- Customers Table -->
<div class="customer-table-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-table"></i> 
            <?php echo (isset($filterType) && $filterType == 'approved') ? 'Approved' : 'Pending'; ?> Customers List
        </h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0" id="customerTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>User</th>
                        <th>Email</th>
                        <th>Device</th>
                        <th>Balance</th>
                        <th>Rating</th>
                        <th>Status</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (!empty($customerlist)) {
                        $count = 1;
                        foreach ($customerlist as $id => $user):
                            $userName = isset($user['userName']) ? $user['userName'] : 'Unknown User';
                            $email = isset($user['email']) ? $user['email'] : '-';
                            $deviceType = isset($user['deviceType']) ? $user['deviceType'] : 'Unknown';
                            $balance = isset($user['balance']) ? floatval($user['balance']) : 0;
                            $avgRating = isset($user['avgRating']) ? floatval($user['avgRating']) : 0;
                            $totalRating = isset($user['totalRating']) ? intval($user['totalRating']) : 0;
                            $isActive = isset($user['isActive']) && $user['isActive'];
                            $isOnline = isset($user['isOnline']) && $user['isOnline'];
                            $userImage = isset($user['image']) ? $user['image'] : '';
                    ?>
                    <tr>
                        <td><?php echo $count; ?></td>
                        <td>
                            <div class="d-flex align-items-center">
                                <?php if (!empty($userImage)): ?>
                                    <img src="<?php echo htmlspecialchars($userImage); ?>" 
                                         alt="User" 
                                         class="rounded-circle me-2" 
                                         style="width: 40px; height: 40px; object-fit: cover;">
                                <?php else: ?>
                                    <div class="rounded-circle me-2 d-flex align-items-center justify-content-center bg-light" 
                                         style="width: 40px; height: 40px;">
                                        <i class="fa-solid fa-user text-muted"></i>
                                    </div>
                                <?php endif; ?>
                                <div>
                                    <strong class="customer-name-link">
                                        <?php echo htmlspecialchars($userName); ?>
                                        <?php if ($isOnline): ?>
                                            <i class="fa-solid fa-circle text-success" style="font-size: 0.6rem;" data-bs-toggle="tooltip" title="Online"></i>
                                        <?php endif; ?>
                                    </strong>
                                    <br><small class="text-muted">ID: <?php echo substr($id, 0, 8); ?>...</small>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div>
                                <i class="fa-solid fa-envelope text-muted me-1"></i>
                                <span><?php echo htmlspecialchars($email); ?></span>
                            </div>
                        </td>
                        <td>
                            <span class="badge-modern <?php echo strtoupper($deviceType) == 'IOS' ? 'badge-info-modern' : 'badge-secondary-modern'; ?>">
                                <i class="fa-solid fa-mobile-screen"></i>
                                <?php echo htmlspecialchars($deviceType); ?>
                            </span>
                        </td>
                        <td>
                            <?php if ($balance > 0): ?>
                                <span class="badge-modern badge-success-modern">
                                    <i class="fa-solid fa-dollar-sign"></i>
                                    <?php echo number_format($balance, 2); ?>
                                </span>
                            <?php else: ?>
                                <span class="text-muted">$0.00</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($totalRating > 0): ?>
                                <div>
                                    <span class="badge-modern badge-warning-modern">
                                        <i class="fa-solid fa-star"></i>
                                        <?php echo number_format($avgRating, 1); ?>
                                    </span>
                                    <br><small class="text-muted">(<?php echo $totalRating; ?> reviews)</small>
                                </div>
                            <?php else: ?>
                                <span class="text-muted">No ratings</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($isActive): ?>
                                <span class="badge-modern badge-success-modern">
                                    <i class="fa-solid fa-check-circle"></i> Active
                                </span>
                            <?php else: ?>
                                <span class="badge-modern badge-warning-modern">
                                    <i class="fa-solid fa-clock"></i> Inactive
                                </span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="dropdown action-dropdown">
                                <button class="btn btn-sm btn-modern btn-modern-info" type="button" 
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="fa-solid fa-ellipsis-v"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <?php if ($isActive): ?>
                                        <li>
                                            <a class="dropdown-item" 
                                               href="<?php echo base_url('Customer/suspendCustomer/' . $id); ?>"
                                               onclick="return confirm('Are you sure you want to deactivate this user?');">
                                                <i class="fa-solid fa-ban text-warning"></i> Deactivate
                                            </a>
                                        </li>
                                    <?php else: ?>
                                        <li>
                                            <a class="dropdown-item" 
                                               href="<?php echo base_url('Customer/unSuspendCustomer/' . $id); ?>"
                                               onclick="return confirm('Are you sure you want to activate this user?');">
                                                <i class="fa-solid fa-check text-success"></i> Activate
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <li>
                                        <a class="dropdown-item" 
                                           href="<?php echo base_url('Customer/editcustomers/' . $id); ?>">
                                            <i class="fa-solid fa-edit text-primary"></i> Edit
                                        </a>
                                    </li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li>
                                        <a class="dropdown-item text-danger" 
                                           href="<?php echo base_url('Customer/deleteCustomer/' . $id); ?>"
                                           onclick="return confirm('Are you sure you want to delete this user? This action cannot be undone.');">
                                            <i class="fa-solid fa-trash"></i> Delete
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    <?php 
                        $count++;
                        endforeach;
                    } else {
                    ?>
                    <tr>
                        <td colspan="8" class="text-center py-5">
                            <i class="fa-solid fa-users fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No Users Found</h5>
                            <p class="text-muted">
                                <?php echo (isset($filterType) && $filterType == 'approved') ? 
                                    'No active users yet.' : 
                                    'No inactive users at the moment.'; ?>
                            </p>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
var customerTable;

$(document).ready(function() {
    // Initialize DataTables
    customerTable = $('#customerTable').DataTable({
        "order": [[ 1, "asc" ]],
        "pageLength": 25,
        "language": {
            "search": "<i class='fa-solid fa-search'></i> Search:",
            "lengthMenu": "Show _MENU_ users per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ users",
            "infoEmpty": "No users found",
            "infoFiltered": "(filtered from _MAX_ total users)"
        }
    });
    
    // Initialize tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
    
    // Search filter
    $('#searchInput').on('keyup', function() {
        customerTable.search($(this).val()).draw();
    });
});
</script>
