<style>
.driver-detail-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.detail-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border: none;
    overflow: hidden;
}

.detail-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.12);
}

.detail-card .card-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    border-bottom: 2px solid #e2e8f0;
    padding: 1.25rem 1.5rem;
    font-weight: 600;
    color: #2d3748;
}

.detail-card .card-body {
    padding: 1.5rem;
}

.driver-profile-image {
    width: 150px;
    height: 150px;
    border-radius: 15px;
    object-fit: cover;
    border: 4px solid white;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

.driver-profile-placeholder {
    width: 150px;
    height: 150px;
    border-radius: 15px;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 3rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

.info-item {
    padding: 1rem;
    background: #f7fafc;
    border-radius: 10px;
    margin-bottom: 1rem;
    border-left: 4px solid #667eea;
    transition: all 0.3s ease;
}

.info-item:hover {
    background: #edf2f7;
    transform: translateX(5px);
}

.info-item-label {
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    color: #718096;
    font-weight: 600;
    margin-bottom: 0.5rem;
}

.info-item-value {
    font-size: 1rem;
    color: #2d3748;
    font-weight: 500;
}

.badge-lg-modern {
    padding: 0.75rem 1.5rem;
    border-radius: 25px;
    font-weight: 600;
    font-size: 0.875rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.action-btn-modern {
    border-radius: 10px;
    padding: 0.75rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    width: 100%;
    margin-bottom: 0.5rem;
}

.action-btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

#driverMap {
    width: 100%;
    height: 400px;
    border-radius: 10px;
    margin-top: 1rem;
}

.online-indicator-large {
    width: 16px;
    height: 16px;
    border-radius: 50%;
    display: inline-block;
    margin-right: 0.5rem;
    animation: pulse 2s infinite;
}

.online-indicator-large.online {
    background: #48bb78;
    box-shadow: 0 0 0 0 rgba(72, 187, 120, 0.7);
}

.online-indicator-large.offline {
    background: #a0aec0;
}

@keyframes pulse {
    0% {
        box-shadow: 0 0 0 0 rgba(72, 187, 120, 0.7);
    }
    70% {
        box-shadow: 0 0 0 10px rgba(72, 187, 120, 0);
    }
    100% {
        box-shadow: 0 0 0 0 rgba(72, 187, 120, 0);
    }
}
</style>

<!-- Header -->
<div class="driver-detail-header">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h2 class="mb-2">
                <i class="fa-solid fa-car"></i> Driver Details
            </h2>
            <p class="mb-0 opacity-75">Complete driver information, location, and status</p>
        </div>
        <div>
            <a href="<?php echo base_url('drivers/edit_driver_info/' . $driverId); ?>" class="btn btn-light btn-modern">
                <i class="fa-solid fa-edit"></i> Edit Driver
            </a>
            <a href="<?php echo base_url('drivers'); ?>" class="btn btn-light btn-modern">
                <i class="fa-solid fa-arrow-left"></i> Back to List
            </a>
        </div>
    </div>
</div>

<div class="row">
    <!-- Main Content -->
    <div class="col-md-8">
        <!-- Driver Information -->
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-user-circle text-primary"></i> Driver Information
                </h5>
            </div>
            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-4 text-center">
                        <?php if (isset($driver['image']) && !empty($driver['image'])): ?>
                            <img src="<?php echo $driver['image']; ?>" alt="Driver Image" class="driver-profile-image">
                        <?php else: ?>
                            <div class="driver-profile-placeholder">
                                <i class="fa-solid fa-user"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-8">
                        <h3 class="mb-3"><?php echo isset($driver['firstName']) ? $driver['firstName'] : ''; ?> <?php echo isset($driver['lastName']) ? $driver['lastName'] : ''; ?></h3>
                        <div class="info-item">
                            <div class="info-item-label">
                                <i class="fa-solid fa-envelope"></i> Email Address
                            </div>
                            <div class="info-item-value"><?php echo isset($driver['email']) ? $driver['email'] : '-'; ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-item-label">
                                <i class="fa-solid fa-phone"></i> Phone Number
                            </div>
                            <div class="info-item-value"><?php echo isset($driver['phoneNumber']) ? $driver['phoneNumber'] : '-'; ?></div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Status</div>
                            <div>
                                <?php 
                                $isApproved = isset($driver['isApproved']) ? $driver['isApproved'] : false;
                                $isActive = isset($driver['isActive']) ? $driver['isActive'] : true;
                                ?>
                                <?php if ($isApproved && $isActive): ?>
                                    <span class="badge-lg-modern badge-success-modern">
                                        <i class="fa-solid fa-check-circle"></i> Active
                                    </span>
                                <?php elseif ($isApproved && !$isActive): ?>
                                    <span class="badge-lg-modern badge-secondary-modern">
                                        <i class="fa-solid fa-pause-circle"></i> Inactive
                                    </span>
                                <?php else: ?>
                                    <span class="badge-lg-modern badge-danger-modern">
                                        <i class="fa-solid fa-clock"></i> Pending Approval
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Availability</div>
                            <div>
                                <?php 
                                $isOnline = isset($driver['isOnline']) ? $driver['isOnline'] : false;
                                ?>
                                <?php if ($isOnline): ?>
                                    <span class="badge-lg-modern badge-success-modern">
                                        <span class="online-indicator-large online"></span> Online
                                    </span>
                                <?php else: ?>
                                    <span class="badge-lg-modern badge-secondary-modern">
                                        <span class="online-indicator-large offline"></span> Offline
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- City Assignment -->
        <?php if (isset($city) && !empty($city)): ?>
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-city text-primary"></i> City Assignment
                </h5>
            </div>
            <div class="card-body">
                <div class="info-item">
                    <div class="info-item-label">Assigned City</div>
                    <div>
                        <span class="badge-lg-modern badge-info-modern">
                            <i class="fa-solid fa-city"></i> <?php echo isset($city['cityName']) ? $city['cityName'] : 'Unknown'; ?>
                        </span>
                    </div>
                </div>
                <?php if (isset($city['hqAddress'])): ?>
                <div class="info-item">
                    <div class="info-item-label">City HQ Address</div>
                    <div class="info-item-value"><?php echo $city['hqAddress']; ?></div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php else: ?>
        <div class="detail-card border-warning">
            <div class="card-body">
                <div class="alert alert-warning mb-0">
                    <i class="fa-solid fa-exclamation-triangle"></i> This driver is not assigned to any city.
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Vehicle Information -->
        <?php if (isset($vehicle) && !empty($vehicle)): ?>
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-car text-primary"></i> Vehicle Information
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Make & Model</div>
                            <div class="info-item-value">
                                <?php echo isset($vehicle['make']) ? $vehicle['make'] : ''; ?> 
                                <?php echo isset($vehicle['model']) ? $vehicle['model'] : ''; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">License Plate</div>
                            <div class="info-item-value"><?php echo isset($vehicle['tagNumber']) ? $vehicle['tagNumber'] : '-'; ?></div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Color</div>
                            <div class="info-item-value"><?php echo isset($vehicle['color']) ? $vehicle['color'] : '-'; ?></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Year</div>
                            <div class="info-item-value"><?php echo isset($vehicle['year']) ? $vehicle['year'] : '-'; ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Driver Location Map -->
        <?php if (isset($driver['latitude']) && isset($driver['longitude'])): ?>
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-map-marker-alt text-primary"></i> Current Location
                </h5>
            </div>
            <div class="card-body">
                <div id="driverMap"></div>
                <div class="mt-3">
                    <div class="info-item">
                        <div class="info-item-label">Coordinates</div>
                        <div class="info-item-value">
                            <i class="fa-solid fa-location-dot"></i> 
                            <?php echo $driver['latitude']; ?>, <?php echo $driver['longitude']; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php else: ?>
        <div class="detail-card">
            <div class="card-body">
                <div class="alert alert-info mb-0">
                    <i class="fa-solid fa-info-circle"></i> Driver location not available.
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Sidebar -->
    <div class="col-md-4">
        <!-- Quick Actions -->
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-bolt text-primary"></i> Quick Actions
                </h5>
            </div>
            <div class="card-body">
                <a href="<?php echo base_url('drivers/edit_driver_info/' . $driverId); ?>" class="btn btn-primary action-btn-modern">
                    <i class="fa-solid fa-edit"></i> Edit Driver
                </a>
                <?php if ($isApproved && $isActive): ?>
                    <a href="<?php echo base_url('drivers/deactivateDriver/' . $driverId); ?>" class="btn btn-warning action-btn-modern">
                        <i class="fa-solid fa-ban"></i> Deactivate
                    </a>
                <?php elseif ($isApproved && !$isActive): ?>
                    <a href="<?php echo base_url('drivers/activateDriver/' . $driverId); ?>" class="btn btn-success action-btn-modern">
                        <i class="fa-solid fa-check-circle"></i> Activate
                    </a>
                <?php else: ?>
                    <a href="<?php echo base_url('drivers/approveDriver/' . $driverId); ?>" class="btn btn-success action-btn-modern">
                        <i class="fa-solid fa-check"></i> Approve Driver
                    </a>
                <?php endif; ?>
                <?php if ($isOnline): ?>
                    <a href="<?php echo base_url('drivers/setDriverOffline/' . $driverId); ?>" class="btn btn-warning action-btn-modern">
                        <i class="fa-solid fa-toggle-on"></i> Set Offline
                    </a>
                <?php else: ?>
                    <a href="<?php echo base_url('drivers/setDriverOnline/' . $driverId); ?>" class="btn btn-success action-btn-modern">
                        <i class="fa-solid fa-toggle-off"></i> Set Online
                    </a>
                <?php endif; ?>
                <a href="<?php echo base_url('drivers/deleteDriver/' . $driverId); ?>" 
                   class="btn btn-danger action-btn-modern"
                   onclick="return confirm('Are you sure you want to delete this driver? This action cannot be undone.');">
                    <i class="fa-solid fa-trash"></i> Delete Driver
                </a>
            </div>
        </div>
    </div>
</div>

<?php if (isset($driver['latitude']) && isset($driver['longitude'])): ?>
<!-- Google Maps API -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB0jx5yCf4vk4I5ridEorfPMqohEhpH1H4"></script>
<script>
function initDriverMap() {
    var driverLat = <?php echo $driver['latitude']; ?>;
    var driverLng = <?php echo $driver['longitude']; ?>;
    
    var map = new google.maps.Map(document.getElementById('driverMap'), {
        zoom: 15,
        center: {lat: driverLat, lng: driverLng},
        mapTypeId: 'roadmap'
    });
    
    var marker = new google.maps.Marker({
        position: {lat: driverLat, lng: driverLng},
        map: map,
        title: '<?php echo isset($driver['firstName']) ? $driver['firstName'] : ''; ?> <?php echo isset($driver['lastName']) ? $driver['lastName'] : ''; ?>',
        icon: {
            url: 'http://maps.google.com/mapfiles/ms/icons/blue-dot.png'
        }
    });
    
    var infoWindow = new google.maps.InfoWindow({
        content: '<div style="padding: 10px;"><strong><?php echo isset($driver['firstName']) ? $driver['firstName'] : ''; ?> <?php echo isset($driver['lastName']) ? $driver['lastName'] : ''; ?></strong><br>Current Location</div>'
    });
    
    marker.addListener('click', function() {
        infoWindow.open(map, marker);
    });
    
    // Open info window by default
    infoWindow.open(map, marker);
}

// Initialize map when page loads
google.maps.event.addDomListener(window, 'load', initDriverMap);
</script>
<?php endif; ?>
