<?php

$sessiondata = $this->session->userdata['session_data'];
$userid = $sessiondata['userId'];
$admin = $this->common->readdatadocument("Users", $userid);

?>
<!doctype html>
<html lang="en" data-bs-theme="light">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>X-driven - Admin Dashboard</title>
    <!--favicon-->

    <!-- fontwsomw -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" />
    <!--plugins-->
    <link href="<?php echo base_url('assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('assets/plugins/metismenu/metisMenu.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('assets/plugins/metismenu/mm-vertical.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('assets/plugins/simplebar/css/simplebar.css'); ?>" rel="stylesheet">
    <!--bootstrap css-->
    <link href="<?php echo base_url('assets/css/bootstrap.min.css'); ?>" rel="stylesheet">

    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans:wght@300;400;500;600&amp;display=swap"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Material+Icons+Outlined" rel="stylesheet">
    <!--main css-->
    <link href="<?php echo base_url('assets/css/bootstrap-extended.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('assets/sass/main.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('assets/sass/dark-theme.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('assets/sass/semi-dark.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('assets/sass/bordered-theme.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('assets/sass/responsive.css'); ?>" rel="stylesheet">
    <!-- X-driven Theme -->
    <link href="<?php echo base_url('assets/css/cannabus-theme.css'); ?>" rel="stylesheet">
    <!-- X-driven Modern Template -->
    <link href="<?php echo base_url('assets/css/xdriven-modern.css'); ?>" rel="stylesheet">

    <!-- date range picker -->
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <!-- fontwsomw -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" />

    <!--bootstrap js-->
<script src="<?php echo base_url('assets/js/bootstrap.bundle.min.js'); ?>"></script>

<!--plugins-->
<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
</head>

<body>

    <!--start header-->
    <header class="top-header">
        <nav class="navbar navbar-expand align-items-center gap-4">
            <div class="btn-toggle">
                <a href="javascript:;"><i class="material-icons-outlined">menu</i></a>
            </div>
            <div class="search-bar flex-grow-1">
                <div class="position-relative">
                    <span
                        class="material-icons-outlined position-absolute me-3 translate-middle-y end-0 top-50 search-close">close</span>
                    <div class="search-popup p-3">
                        <div class="card rounded-4 overflow-hidden">
                            <div class="card-header d-lg-none">
                                <div class="position-relative">
                                    <span
                                        class="material-icons-outlined position-absolute ms-3 translate-middle-y start-0 top-50">search</span>
                                    <span
                                        class="material-icons-outlined position-absolute me-3 translate-middle-y end-0 top-50 mobile-search-close">close</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <ul class="navbar-nav gap-1 nav-right-links align-items-center">
                <li class="nav-item dropdown">
                    <a href="javascrpt:;" class="dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown">
                        <div class="d-flex align-items-center">
                            <div class="me-1">
                                <p class="mb-0 fs2"><?php echo isset($admin['name']) ? $admin['name'] : 'Admin'; ?></p>
                                <p class="text-muted mt-0 fmon text-end mb-0 "> Admin</p>
                            </div>
                            <?php if (!empty($admin['image'])): ?>
                            <img src="<?php echo $admin['image']; ?>" class="p-1 borderCustom" width="45" height="45"
                                style="border-radius: 50%;" alt="Admin Image" />
                            <?php else: ?>
                            <img src="<?php echo base_url('assets/images/dummy-man.png'); ?>" class="p-1 borderCustom"
                                width="45" height="45" style="border-radius: 50%;" alt="Dummy Image" />
                            <?php endif; ?>
                        </div>
                    </a>
                    <div class="dropdown-menu dropdown-user dropdown-menu-end shadow">
                        <a class="dropdown-item gap-2 py-2" href="javascript:;">
                            <div class="text-center">
                                <?php if (!empty($admin['image'])): ?>
                                <img src="<?php echo $admin['image']; ?>" class="p-1 shadow mb-3" width="90" height="90"
                                    alt="Admin Image" />
                                <?php else: ?>
                                <img src="<?php echo base_url('assets/images/dummy-man.png'); ?>"
                                    class="p-1 shadow mb-3" width="90" height="90" alt="Dummy Image" />
                                <?php endif; ?>
                                <h5 class="user-name mb-0 fw-bold"><?php echo isset($admin['name']) ? $admin['name'] : 'Admin'; ?></h5>
                                <small class="text-muted mt-0 fmon"> Admin</small>
                            </div>
                        </a>
                        <hr class="dropdown-divider" />
                        <a class="dropdown-item d-flex align-items-center gap-2 py-2"
                            href="<?php echo base_url('Customer/editprofile'); ?>">
                            <i class="material-icons-outlined">person</i>Profile
                        </a>
                        <a class="dropdown-item d-flex align-items-center gap-2 py-2"
                            href="<?php echo base_url('login/logout'); ?>"><i
                                class="material-icons-outlined">power_settings_new</i>Logout</a>
                    </div>
                </li>
            </ul>
        </nav>
    </header>
