<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>X-driven - Login</title>
    <!-- bootstrap cdn -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <!-- custom css -->
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/style.css" />
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet" />
    <!-- fontawesone link -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />
    <!--favicon-->
    <link rel="icon" href="<?= base_url(); ?>assets/images/favicon-32x32.png" type="image/png" />
    <style>
        * {
            font-family: 'Inter', sans-serif;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .login-container {
            background: #ffffff;
            border-radius: 24px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
            overflow: hidden;
            max-width: 1000px;
            width: 100%;
        }

        .login-left {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 60px 50px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            color: white;
            position: relative;
            overflow: hidden;
        }

        .login-left::before {
            content: '';
            position: absolute;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            top: -50%;
            left: -50%;
            animation: pulse 15s ease-in-out infinite;
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); opacity: 0.5; }
            50% { transform: scale(1.1); opacity: 0.8; }
        }

        .login-left-content {
            position: relative;
            z-index: 1;
            text-align: center;
        }

        .brand-logo {
            font-size: 48px;
            font-weight: 700;
            margin-bottom: 20px;
            letter-spacing: -1px;
        }

        .brand-tagline {
            font-size: 18px;
            opacity: 0.95;
            font-weight: 400;
            line-height: 1.6;
        }

        .login-right {
            padding: 60px 50px;
        }

        .login-header {
            margin-bottom: 40px;
        }

        .login-title {
            font-size: 32px;
            font-weight: 700;
            color: #1a202c;
            margin-bottom: 10px;
        }

        .login-subtitle {
            font-size: 15px;
            color: #718096;
            font-weight: 400;
        }

        .form-group-custom {
            margin-bottom: 24px;
        }

        .form-label-custom {
            font-size: 14px;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 8px;
            display: block;
        }

        .input-group-custom {
            position: relative;
        }

        .input-icon {
            position: absolute;
            left: 18px;
            top: 50%;
            transform: translateY(-50%);
            color: #a0aec0;
            z-index: 3;
            font-size: 16px;
        }

        .input-icon-right {
            position: absolute;
            right: 18px;
            top: 50%;
            transform: translateY(-50%);
            color: #a0aec0;
            z-index: 3;
            cursor: pointer;
            font-size: 16px;
            transition: color 0.2s;
        }

        .input-icon-right:hover {
            color: #667eea;
        }

        .form-control-custom {
            width: 100%;
            padding: 14px 18px 14px 48px;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            font-size: 15px;
            color: #2d3748;
            transition: all 0.3s ease;
            background: #ffffff;
        }

        .form-control-custom:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .form-control-custom::placeholder {
            color: #a0aec0;
        }

        .btn-login {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 12px;
            color: white;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 8px;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
        }

        .btn-login:active {
            transform: translateY(0);
        }

        .forgot-password-link {
            text-align: center;
            margin-top: 20px;
        }

        .forgot-password-link a {
            color: #667eea;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            transition: color 0.2s;
        }

        .forgot-password-link a:hover {
            color: #764ba2;
            text-decoration: underline;
        }

        .alert-custom {
            border-radius: 12px;
            border: none;
            padding: 14px 18px;
            margin-bottom: 24px;
        }

        .alert-success {
            background: #f0fdf4;
            color: #166534;
            border-left: 4px solid #22c55e;
        }

        .alert-warning {
            background: #fffbeb;
            color: #92400e;
            border-left: 4px solid #f59e0b;
        }

        .btn-close-custom {
            opacity: 0.7;
        }

        .btn-close-custom:hover {
            opacity: 1;
        }

        @media (max-width: 768px) {
            .login-left {
                padding: 40px 30px;
                min-height: 200px;
            }

            .login-right {
                padding: 40px 30px;
            }

            .brand-logo {
                font-size: 36px;
            }

            .login-title {
                font-size: 28px;
            }
        }

        .feature-icon {
            font-size: 40px;
            margin-bottom: 15px;
            opacity: 0.9;
        }
    </style>
</head>

<body>
    <div class="login-container">
        <div class="row g-0">
            <!-- Left Side - Branding -->
            <div class="col-lg-5 login-left d-none d-lg-flex">
                <div class="login-left-content">
                    <div class="feature-icon">
                        <i class="fas fa-calendar-check"></i>
                    </div>
                    <h1 class="brand-logo">X-driven</h1>
                    <p class="brand-tagline">
                        Your trusted booking platform. Manage your reservations with ease and efficiency.
                    </p>
                </div>
            </div>

            <!-- Right Side - Login Form -->
            <div class="col-lg-7 login-right">
                <div class="login-header">
                    <h2 class="login-title">Welcome Back</h2>
                    <p class="login-subtitle">Sign in to your account to continue</p>
                </div>

                <?php 
                $successMessage = $this->session->flashdata('successmessage');
                $warningmessage = $this->session->flashdata('warningmessage');
                if (isset($successMessage)) {
                    echo '<div id="alertmessage" class="alert-custom alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="btn-close btn-close-custom" data-bs-dismiss="alert" aria-label="Close"></button>
                        ' . output($successMessage) . '
                    </div>';
                }
                if (isset($warningmessage)) {
                    echo '<div id="alertmessage" class="alert-custom alert-warning alert-dismissible fade show" role="alert">
                        <button type="button" class="btn-close btn-close-custom" data-bs-dismiss="alert" aria-label="Close"></button>
                        ' . output($warningmessage) . '
                    </div>';
                }
                ?>

                <form action="<?= base_url() . 'login/login_action'; ?>" method="post">
                    <div class="form-group-custom">
                        <label for="email" class="form-label-custom">Email Address</label>
                        <div class="input-group-custom">
                            <i class="fas fa-envelope input-icon"></i>
                            <input 
                                class="form-control-custom" 
                                type="email" 
                                id="email"
                                name="email" 
                                placeholder="Enter your email address" 
                                required
                                autocomplete="email"
                            />
                        </div>
                    </div>

                    <div class="form-group-custom">
                        <label for="password" class="form-label-custom">Password</label>
                        <div class="input-group-custom">
                            <i class="fas fa-lock input-icon"></i>
                            <input 
                                class="form-control-custom" 
                                type="password" 
                                id="password"
                                name="password" 
                                placeholder="Enter your password" 
                                required
                                autocomplete="current-password"
                            />
                            <i class="fas fa-eye input-icon-right eye-toggle" id="eyeToggle"></i>
                        </div>
                    </div>

                    <button type="submit" class="btn-login">
                        <i class="fas fa-sign-in-alt me-2"></i>Sign In
                    </button>

                    <div class="forgot-password-link">
                        <a href="<?php echo base_url('forgot'); ?>">Forgot your password?</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous">
    </script>

    <script>
    document.addEventListener("DOMContentLoaded", function() {
        const eyeToggle = document.getElementById("eyeToggle");
        const passwordField = document.getElementById("password");

        if (eyeToggle && passwordField) {
            eyeToggle.addEventListener("click", function() {
                if (passwordField.type === "password") {
                    passwordField.type = "text";
                    this.classList.remove("fa-eye");
                    this.classList.add("fa-eye-slash");
                } else {
                    passwordField.type = "password";
                    this.classList.remove("fa-eye-slash");
                    this.classList.add("fa-eye");
                }
            });
        }
    });
    </script>
</body>

</html>