<style>
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

* {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
}

.order-detail-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.2);
}

.detail-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border: none;
    overflow: hidden;
}

.detail-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.12);
}

.detail-card .card-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    border-bottom: 2px solid #e2e8f0;
    padding: 1.25rem 1.5rem;
    font-weight: 600;
    color: #2d3748;
}

.detail-card .card-body {
    padding: 1.5rem;
}

.info-item {
    padding: 1rem;
    background: #f7fafc;
    border-radius: 10px;
    margin-bottom: 1rem;
    border-left: 4px solid #667eea;
    transition: all 0.3s ease;
}

.info-item:hover {
    background: #edf2f7;
    transform: translateX(5px);
}

.info-item-label {
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    color: #718096;
    font-weight: 600;
    margin-bottom: 0.5rem;
}

.info-item-value {
    font-size: 1rem;
    color: #2d3748;
    font-weight: 500;
}

.badge-lg-modern {
    padding: 0.75rem 1.5rem;
    border-radius: 25px;
    font-weight: 600;
    font-size: 0.875rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.item-card {
    background: white;
    border: 2px solid #e2e8f0;
    border-radius: 10px;
    padding: 1rem;
    margin-bottom: 0.75rem;
    transition: all 0.3s ease;
}

.item-card:hover {
    border-color: #667eea;
    box-shadow: 0 5px 15px rgba(102, 126, 234, 0.1);
    transform: translateX(5px);
}

.item-card.cannabus {
    border-left: 4px solid #4299e1;
}

.item-card.storefront {
    border-left: 4px solid #ed8936;
}

.action-btn-modern {
    border-radius: 10px;
    padding: 0.75rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    width: 100%;
    margin-bottom: 0.5rem;
}

.action-btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.alert-modern {
    border-radius: 10px;
    border: none;
    padding: 1.25rem;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.distance-badge {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 600;
    font-size: 1.1rem;
    display: inline-block;
    margin-top: 0.5rem;
}

.badge-primary-modern {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.badge-success-modern {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.badge-warning-modern {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.badge-danger-modern {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.badge-info-modern {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.badge-secondary-modern {
    background: linear-gradient(135deg, #a0aec0 0%, #718096 100%);
    color: white;
}

.logic-box {
    background: #f7fafc;
    border-left: 4px solid #667eea;
    padding: 1rem;
    border-radius: 8px;
    margin-top: 1rem;
}

.form-control-modern {
    border-radius: 10px;
    border: 2px solid #e2e8f0;
    padding: 0.75rem 1rem;
    transition: all 0.3s ease;
}

.form-control-modern:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    outline: none;
}
</style>

<!-- Header -->
<div class="order-detail-header">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-calendar-check"></i> Booking Details
            </h2>
            <p class="mb-0 opacity-75">Booking #BK-<?php echo substr($orderId, 0, 8); ?> - Complete booking information and details</p>
        </div>
        <div>
            <a href="<?php echo base_url('orders'); ?>" class="btn btn-light btn-modern">
                <i class="fas fa-arrow-left"></i> Back to Bookings
            </a>
        </div>
    </div>
</div>

<div class="row">
    <!-- Main Content -->
    <div class="col-md-8">
        <!-- Booking Information -->
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-info-circle text-primary"></i> Booking Information
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Booking Number</div>
                            <div class="info-item-value">BK-<?php echo substr($orderId, 0, 8); ?></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Status</div>
                            <div>
                                <?php 
                                $status = isset($order['status']) ? strtolower($order['status']) : 'pending';
                                $statusColors = array(
                                    'pending' => 'warning-modern',
                                    'accepted' => 'info-modern',
                                    'in_progress' => 'primary-modern',
                                    'on_way' => 'primary-modern',
                                    'ridecomplete' => 'success-modern',
                                    'completed' => 'success-modern',
                                    'delivered' => 'success-modern',
                                    'dispute' => 'danger-modern',
                                    'disputed' => 'danger-modern',
                                    'cancelled' => 'danger-modern'
                                );
                                $statusColor = isset($statusColors[$status]) ? $statusColors[$status] : 'secondary-modern';
                                $statusDisplay = ucwords(str_replace('_', ' ', $status));
                                ?>
                                <span class="badge-lg-modern badge-<?php echo $statusColor; ?>">
                                    <?php echo $statusDisplay; ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Booking Date</div>
                            <div class="info-item-value">
                                <?php 
                                $bookingDate = isset($order['bookingDate']) ? $order['bookingDate'] : (isset($order['pickupDate']) ? $order['pickupDate'] : 0);
                                echo $bookingDate > 0 ? date('Y-m-d H:i:s', $bookingDate / 1000) : 'N/A'; 
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Service Type</div>
                            <div>
                                <?php 
                                $serviceType = isset($order['service_type']) ? strtoupper($order['service_type']) : 'N/A';
                                ?>
                                <span class="badge-lg-modern badge-info-modern">
                                    <i class="fas fa-clock"></i> <?php echo $serviceType; ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="info-item">
                            <div class="info-item-label">Pickup Address</div>
                            <div class="info-item-value">
                                <?php echo isset($order['pickupAddress']) ? htmlspecialchars($order['pickupAddress']) : 'N/A'; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if (isset($order['pickupLat']) && isset($order['pickupLng'])): ?>
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Pickup Latitude</div>
                            <div class="info-item-value"><?php echo $order['pickupLat']; ?></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Pickup Longitude</div>
                            <div class="info-item-value"><?php echo $order['pickupLng']; ?></div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Route Information -->
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-route text-primary"></i> Route Information
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="info-item">
                            <div class="info-item-label">Distance</div>
                            <div class="distance-badge">
                                <i class="fas fa-route"></i> 
                                <?php echo isset($order['distance']) ? htmlspecialchars($order['distance']) : 'N/A'; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-item">
                            <div class="info-item-label">Duration</div>
                            <div class="info-item-value">
                                <strong><?php echo isset($order['duration']) ? $order['duration'] : 0; ?> min<?php echo (isset($order['duration']) && $order['duration'] != 1) ? 's' : ''; ?></strong>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-item">
                            <div class="info-item-label">Time</div>
                            <div class="info-item-value">
                                <strong><?php echo isset($order['time']) ? htmlspecialchars($order['time']) : 'N/A'; ?></strong>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if (!empty($order['destinationsList'])): ?>
                <div class="logic-box mt-3">
                    <h6 class="mb-3">
                        <i class="fas fa-map-marker-alt text-primary"></i> Destinations (<?php echo count($order['destinationsList']); ?>)
                    </h6>
                    <?php foreach ($order['destinationsList'] as $index => $destination): ?>
                    <div class="info-item mb-2">
                        <div class="info-item-label">Destination <?php echo $index + 1; ?></div>
                        <div class="info-item-value">
                            <?php echo htmlspecialchars($destination['address']); ?>
                            <?php if (isset($destination['lat']) && isset($destination['lng'])): ?>
                                <br><small class="text-muted">Lat: <?php echo $destination['lat']; ?>, Lng: <?php echo $destination['lng']; ?></small>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Vehicle Information -->
        <?php if (isset($order['vehicleName'])): ?>
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-car text-primary"></i> Vehicle Information
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <?php if (isset($order['vehicleImage']) && !empty($order['vehicleImage'])): ?>
                        <img src="<?php echo htmlspecialchars($order['vehicleImage']); ?>" alt="Vehicle" class="img-fluid rounded" style="max-height: 200px;">
                        <?php endif; ?>
                    </div>
                    <div class="col-md-8">
                        <div class="info-item">
                            <div class="info-item-label">Vehicle Name</div>
                            <div class="info-item-value">
                                <strong><?php echo htmlspecialchars($order['vehicleName']); ?></strong>
                            </div>
                        </div>
                        <?php if (isset($order['vehicleDescription']) && !empty($order['vehicleDescription'])): ?>
                        <div class="info-item">
                            <div class="info-item-label">Description</div>
                            <div class="info-item-value">
                                <small><?php echo htmlspecialchars($order['vehicleDescription']); ?></small>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php if (isset($order['vehiclePrice']) && !empty($order['vehiclePrice'])): ?>
                        <div class="info-item">
                            <div class="info-item-label">Price</div>
                            <div class="info-item-value">
                                <?php echo htmlspecialchars($order['vehiclePrice']); ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Passenger Information -->
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-users text-primary"></i> Passenger Information
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="info-item">
                            <div class="info-item-label">Adults</div>
                            <div class="info-item-value">
                                <strong><?php echo isset($order['adults']) ? $order['adults'] : 0; ?></strong>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-item">
                            <div class="info-item-label">Children</div>
                            <div class="info-item-value">
                                <strong><?php echo isset($order['children']) ? $order['children'] : 0; ?></strong>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-item">
                            <div class="info-item-label">Luggage</div>
                            <div class="info-item-value">
                                <strong><?php echo isset($order['luggage']) ? $order['luggage'] : 0; ?></strong>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if (isset($order['comment']) && !empty($order['comment'])): ?>
                <div class="info-item mt-3">
                    <div class="info-item-label">Special Comments</div>
                    <div class="info-item-value">
                        <?php echo htmlspecialchars($order['comment']); ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

    </div>

    <!-- Sidebar -->
    <div class="col-md-4">
        <!-- Pricing Summary -->
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-dollar-sign text-primary"></i> Pricing Summary
                </h5>
            </div>
            <div class="card-body">
                <div class="info-item">
                    <div class="info-item-label">Booking Price</div>
                    <div class="info-item-value"><?php echo isset($order['priceFormatted']) ? $order['priceFormatted'] : (isset($order['price']) ? '$' . number_format(floatval($order['price']), 2) : '$0.00'); ?></div>
                </div>
                <?php if (isset($order['currency']) && $order['currency'] != 'USD'): ?>
                <div class="info-item">
                    <div class="info-item-label">Currency</div>
                    <div class="info-item-value">
                        <span class="badge-lg-modern badge-info-modern">
                            <?php echo htmlspecialchars($order['currency']); ?>
                        </span>
                    </div>
                </div>
                <?php endif; ?>
                <?php if (isset($order['rating']) && $order['rating'] > 0): ?>
                <div class="info-item">
                    <div class="info-item-label">Rating</div>
                    <div class="info-item-value">
                        <?php for ($i = 1; $i <= 5; $i++): ?>
                            <i class="fas fa-star <?php echo $i <= $order['rating'] ? 'text-warning' : 'text-muted'; ?>"></i>
                        <?php endfor; ?>
                        <strong class="ms-2"><?php echo $order['rating']; ?>/5</strong>
                    </div>
                </div>
                <?php endif; ?>
                <hr>
                <div class="info-item" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none;">
                    <div class="info-item-label" style="color: rgba(255,255,255,0.8);">Total Price</div>
                    <div class="info-item-value" style="color: white; font-size: 1.5rem;">
                        <strong><?php echo isset($order['priceFormatted']) ? $order['priceFormatted'] : (isset($order['price']) ? '$' . number_format(floatval($order['price']), 2) : '$0.00'); ?></strong>
                    </div>
                </div>
            </div>
        </div>

        <!-- Update Status -->
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-sync text-primary"></i> Update Status
                </h5>
            </div>
            <div class="card-body">
                <form method="post" action="<?php echo base_url('orders/updatestatus'); ?>" id="statusForm">
                    <input type="hidden" name="orderId" value="<?php echo $orderId; ?>">
                    <div class="form-group-modern">
                        <label class="form-label-modern">Booking Status</label>
                        <select name="status" class="form-control form-control-modern" required>
                            <?php 
                            $currentStatus = isset($order['status']) ? strtolower($order['status']) : 'pending';
                            $statusOptions = array(
                                'pending' => 'Pending',
                                'accepted' => 'Accepted',
                                'in_progress' => 'In Progress',
                                'on_way' => 'On Way',
                                'ridecomplete' => 'Completed',
                                'dispute' => 'Dispute',
                                'cancelled' => 'Cancelled'
                            );
                            foreach ($statusOptions as $value => $label):
                            ?>
                            <option value="<?php echo $value; ?>" <?php echo ($currentStatus == $value) ? 'selected' : ''; ?>>
                                <?php echo $label; ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary action-btn-modern">
                        <i class="fas fa-save"></i> Update Status
                    </button>
                </form>
            </div>
        </div>

        <!-- Driver Information -->
        <?php if (isset($driver) && !empty($driver)): ?>
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-user-tie text-primary"></i> Driver Information
                </h5>
            </div>
            <div class="card-body">
                <div class="info-item">
                    <div class="info-item-label">Name</div>
                    <div class="info-item-value">
                        <?php echo isset($driver['userName']) ? htmlspecialchars($driver['userName']) : 'N/A'; ?>
                    </div>
                </div>
                <div class="info-item">
                    <div class="info-item-label">Email</div>
                    <div class="info-item-value"><?php echo isset($driver['email']) ? htmlspecialchars($driver['email']) : 'N/A'; ?></div>
                </div>
                <?php if (isset($order['driverLat']) && isset($order['driverLng'])): ?>
                <div class="info-item">
                    <div class="info-item-label">Current Location</div>
                    <div class="info-item-value">
                        Lat: <?php echo $order['driverLat']; ?>, Lng: <?php echo $order['driverLng']; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Customer Information -->
        <?php if (isset($customer) && !empty($customer)): ?>
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-user text-primary"></i> Customer Information
                </h5>
            </div>
            <div class="card-body">
                <div class="info-item">
                    <div class="info-item-label">Name</div>
                    <div class="info-item-value">
                        <?php echo isset($customer['userName']) ? htmlspecialchars($customer['userName']) : 'N/A'; ?>
                    </div>
                </div>
                <div class="info-item">
                    <div class="info-item-label">Email</div>
                    <div class="info-item-value"><?php echo isset($customer['email']) ? htmlspecialchars($customer['email']) : 'N/A'; ?></div>
                </div>
                <?php if (isset($customer['avgRating']) && $customer['avgRating'] > 0): ?>
                <div class="info-item">
                    <div class="info-item-label">Rating</div>
                    <div class="info-item-value">
                        <?php for ($i = 1; $i <= 5; $i++): ?>
                            <i class="fas fa-star <?php echo $i <= $customer['avgRating'] ? 'text-warning' : 'text-muted'; ?>"></i>
                        <?php endfor; ?>
                        <strong class="ms-2"><?php echo number_format($customer['avgRating'], 1); ?>/5</strong>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    $('#statusForm').on('submit', function(e) {
        e.preventDefault();
        
        var form = $(this);
        var formData = form.serialize();
        var url = form.attr('action');
        
        var submitBtn = form.find('button[type="submit"]');
        var originalText = submitBtn.html();
        submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Updating...');
        
        $.ajax({
            url: url,
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                submitBtn.prop('disabled', false).html(originalText);
                
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: response.message,
                        confirmButtonText: 'OK',
                        timer: 2000,
                        timerProgressBar: true
                    }).then(function() {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: response.message,
                        confirmButtonText: 'OK'
                    });
                }
            },
            error: function() {
                submitBtn.prop('disabled', false).html(originalText);
                // Fallback to regular form submission
                form.off('submit').submit();
            }
        });
    });
});
</script>
