<style>
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

* {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
}

.order-management-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.2);
}

.order-stats-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-left: 4px solid;
}

.order-stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.order-stats-card.primary { border-left-color: #667eea; }
.order-stats-card.success { border-left-color: #48bb78; }
.order-stats-card.warning { border-left-color: #ed8936; }
.order-stats-card.danger { border-left-color: #f56565; }
.order-stats-card.info { border-left-color: #4299e1; }

.filter-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 2rem;
}

.order-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    overflow: hidden;
}

.order-table-card .card-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.order-table-card table thead {
    background: #f7fafc;
}

.order-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.order-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.order-table-card table tbody tr:hover {
    background: #f7fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.order-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.75rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-modern i {
    font-size: 0.7rem;
}

.badge-primary-modern {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.badge-success-modern {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.badge-warning-modern {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.badge-danger-modern {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.badge-info-modern {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.badge-secondary-modern {
    background: linear-gradient(135deg, #a0aec0 0%, #718096 100%);
    color: white;
}

.btn-modern {
    border-radius: 10px;
    padding: 0.6rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.btn-modern-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    color: white;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
}

.btn-modern-primary:hover {
    background: linear-gradient(135deg, #5568d3 0%, #653f8f 100%);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.filter-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    margin-bottom: 1rem;
}

.order-link {
    color: #667eea;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
}

.order-link:hover {
    color: #764ba2;
    text-decoration: none;
}
</style>

<!-- Header Section -->
<div class="order-management-header">
    <div class="row align-items-center">
        <div class="col-md-6">
            <h2 class="mb-2">
                <i class="fas fa-calendar-check"></i> Bookings Management
            </h2>
            <p class="mb-0 opacity-75">Track, monitor, and manage all booking orders</p>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<?php
$totalOrders = count($orders);
$pendingOrders = 0;
$deliveredOrders = 0;
$totalRevenue = 0;

foreach ($orders as $booking) {
    $status = isset($booking['status']) ? strtolower($booking['status']) : 'pending';
    if (in_array($status, array('pending', 'dispute'))) $pendingOrders++;
    if (in_array($status, array('ridecomplete', 'completed', 'delivered', 'rated'))) $deliveredOrders++;
    
    // Calculate revenue from price field
    $price = isset($booking['price']) ? floatval($booking['price']) : 0;
    $totalRevenue += $price;
}
?>
<div class="row mb-4">
    <div class="col-md-3">
        <div class="order-stats-card primary">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon">
                        <i class="fa-solid fa-shopping-cart"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Total Bookings</p>
                    <h3 class="stats-number mb-0"><?php echo $totalOrders; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="order-stats-card warning">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);">
                        <i class="fa-solid fa-clock"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Pending Bookings</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $pendingOrders; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="order-stats-card success">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);">
                        <i class="fa-solid fa-check-circle"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Completed Bookings</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $deliveredOrders; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="order-stats-card <?php echo $blockedOrders > 0 ? 'danger' : 'info'; ?>">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Total Revenue</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">$<?php echo number_format($totalRevenue, 2); ?></h3>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="filter-card">
    <div class="d-flex align-items-center mb-3">
        <i class="fas fa-filter text-primary me-2"></i>
        <h5 class="mb-0">Filter Bookings</h5>
    </div>
    <form method="get" action="<?php echo base_url('orders'); ?>" class="row g-3">
        <div class="col-md-3">
            <label for="filter_status" class="form-label fw-bold">Status</label>
            <select class="form-control form-select" id="filter_status" name="filter_status">
                <option value="all" <?php echo (!isset($filterStatus) || $filterStatus == 'all') ? 'selected' : ''; ?>>All Status</option>
                <option value="pending" <?php echo (isset($filterStatus) && $filterStatus == 'pending') ? 'selected' : ''; ?>>Pending</option>
                <option value="accepted" <?php echo (isset($filterStatus) && $filterStatus == 'accepted') ? 'selected' : ''; ?>>Accepted</option>
                <option value="in_progress" <?php echo (isset($filterStatus) && $filterStatus == 'in_progress') ? 'selected' : ''; ?>>In Progress</option>
                <option value="ridecomplete" <?php echo (isset($filterStatus) && $filterStatus == 'ridecomplete') ? 'selected' : ''; ?>>Completed</option>
                <option value="dispute" <?php echo (isset($filterStatus) && $filterStatus == 'dispute') ? 'selected' : ''; ?>>Dispute</option>
                <option value="cancelled" <?php echo (isset($filterStatus) && $filterStatus == 'cancelled') ? 'selected' : ''; ?>>Cancelled</option>
            </select>
        </div>
        <div class="col-md-3">
            <label for="filter_service_type" class="form-label fw-bold">Service Type</label>
            <select class="form-control form-select" id="filter_service_type" name="filter_service_type">
                <option value="all" <?php echo (!isset($filterServiceType) || $filterServiceType == 'all') ? 'selected' : ''; ?>>All Types</option>
                <option value="HOURLY" <?php echo (isset($filterServiceType) && $filterServiceType == 'HOURLY') ? 'selected' : ''; ?>>Hourly</option>
                <option value="POINT_TO_POINT" <?php echo (isset($filterServiceType) && $filterServiceType == 'POINT_TO_POINT') ? 'selected' : ''; ?>>Point to Point</option>
                <option value="FIXED_ROUTE" <?php echo (isset($filterServiceType) && $filterServiceType == 'FIXED_ROUTE') ? 'selected' : ''; ?>>Fixed Route</option>
            </select>
        </div>
        <div class="col-md-2">
            <label for="filter_date_from" class="form-label fw-bold">Date From</label>
            <input type="date" class="form-control" id="filter_date_from" name="filter_date_from" value="<?php echo isset($filterDateFrom) ? $filterDateFrom : ''; ?>">
        </div>
        <div class="col-md-2">
            <label for="filter_date_to" class="form-label fw-bold">Date To</label>
            <input type="date" class="form-control" id="filter_date_to" name="filter_date_to" value="<?php echo isset($filterDateTo) ? $filterDateTo : ''; ?>">
        </div>
        <div class="col-md-2">
            <label class="form-label fw-bold">&nbsp;</label>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-modern btn-modern-primary w-100">
                    <i class="fas fa-filter"></i> Filter
                </button>
                <a href="<?php echo base_url('orders'); ?>" class="btn btn-secondary btn-modern">
                    <i class="fas fa-times"></i>
                </a>
            </div>
        </div>
    </form>
</div>

<!-- Orders Table -->
<div class="order-table-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-table"></i> Bookings List
        </h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0" id="ordersTable">
                <thead>
                    <tr>
                        <th>Booking #</th>
                        <th>User</th>
                        <th>Driver</th>
                        <th>Vehicle</th>
                        <th>Pickup</th>
                        <th>Destinations</th>
                        <th>Service Type</th>
                        <th>Price</th>
                        <th>Status</th>
                        <th>Booking Date</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (!empty($orders)) {
                        foreach ($orders as $bookingId => $booking) {
                           

                            $bookingId = $booking['id'];
                            $bookingNumber = 'BK-' . substr($bookingId, 0, 8);
                            
                            // Get user/customer name
                            $userName = isset($booking['userName']) ? $booking['userName'] : 'Unknown User';
                            $userEmail = isset($booking['userEmail']) ? $booking['userEmail'] : '';
                            
                            // Get driver name
                            $driverName = isset($booking['driverName']) ? $booking['driverName'] : 'Not Assigned';
                            
                            // Get vehicle name
                            $vehicleName = isset($booking['vehicleName']) ? $booking['vehicleName'] : 'N/A';
                            
                            // Get pickup address
                            $pickupAddress = isset($booking['pickupAddress']) ? $booking['pickupAddress'] : 'N/A';
                            if (strlen($pickupAddress) > 40) {
                                $pickupAddress = substr($pickupAddress, 0, 40) . '...';
                            }
                            
                            // Get destinations count
                            $destinationsCount = isset($booking['destinationsCount']) ? $booking['destinationsCount'] : 0;
                            
                            // Get booking date (use bookingDate, fallback to pickupDate)
                            $bookingDate = isset($booking['bookingDate']) ? $booking['bookingDate'] : (isset($booking['pickupDate']) ? $booking['pickupDate'] : 0);
                            $bookingDateFormatted = $bookingDate > 0 ? date('Y-m-d H:i', $bookingDate / 1000) : 'N/A';
                            
                            // Get status
                            $status = isset($booking['status']) ? strtolower($booking['status']) : 'pending';
                            
                            // Get service type
                            $serviceType = isset($booking['service_type']) ? strtoupper($booking['service_type']) : 'N/A';
                            
                            // Get price
                            $price = isset($booking['price']) ? floatval($booking['price']) : 0;
                            $priceFormatted = '$' . number_format($price, 2);
                            
                            // Status badge colors
                            $statusColors = array(
                                'pending' => 'warning-modern',
                                'accepted' => 'info-modern',
                                'in_progress' => 'primary-modern',
                                'on_way' => 'primary-modern',
                                'ridecomplete' => 'success-modern',
                                'completed' => 'success-modern',
                                'delivered' => 'success-modern',
                                'dispute' => 'danger-modern',
                                'disputed' => 'danger-modern',
                                'cancelled' => 'danger-modern',
                                'cancelled' => 'danger-modern'
                            );
                            $statusColor = isset($statusColors[$status]) ? $statusColors[$status] : 'secondary-modern';
                            $statusDisplay = ucwords(str_replace('_', ' ', $status));
                    ?>
                    <tr>
                        <td>
                            <a href="<?php echo base_url('orders/view/' . $bookingId); ?>" class="order-link">
                                <?php echo $bookingNumber; ?>
                            </a>
                        </td>
                        <td>
                            <div>
                                <strong><?php echo htmlspecialchars($userName); ?></strong>
                                <?php if ($userEmail): ?>
                                    <br><small class="text-muted"><?php echo htmlspecialchars($userEmail); ?></small>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td>
                            <?php if ($driverName != 'Not Assigned'): ?>
                                <span class="badge-modern badge-info-modern">
                                    <i class="fas fa-user"></i>
                                    <?php echo htmlspecialchars($driverName); ?>
                                </span>
                            <?php else: ?>
                                <span class="text-muted">Not Assigned</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($vehicleName != 'N/A'): ?>
                                <span class="badge-modern badge-primary-modern">
                                    <i class="fas fa-car"></i>
                                    <?php echo htmlspecialchars($vehicleName); ?>
                                </span>
                            <?php else: ?>
                                <span class="text-muted">N/A</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <small><?php echo htmlspecialchars($pickupAddress); ?></small>
                        </td>
                        <td>
                            <?php if ($destinationsCount > 0): ?>
                                <span class="badge-modern badge-success-modern">
                                    <i class="fas fa-map-marker-alt"></i>
                                    <?php echo $destinationsCount; ?> destination<?php echo $destinationsCount > 1 ? 's' : ''; ?>
                                </span>
                            <?php else: ?>
                                <span class="text-muted">No destinations</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge-modern badge-warning-modern">
                                <i class="fas fa-clock"></i>
                                <?php echo htmlspecialchars($serviceType); ?>
                            </span>
                        </td>
                        <td><strong><?php echo $priceFormatted; ?></strong></td>
                        <td>
                            <span class="badge-modern badge-<?php echo $statusColor; ?>">
                                <?php echo $statusDisplay; ?>
                            </span>
                        </td>
                        <td><?php echo $bookingDateFormatted; ?></td>
                        <td>
                            <a href="<?php echo base_url('orders/view/' . $bookingId); ?>" class="btn btn-sm btn-modern btn-modern-primary">
                                <i class="fas fa-eye"></i> View
                            </a>
                        </td>
                    </tr>
                    <?php
                        }
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    $('#ordersTable').DataTable({
        "order": [[ 10, "desc" ]],
        "pageLength": 25,
        "language": {
            "search": "<i class='fas fa-search'></i> Search:",
            "lengthMenu": "Show _MENU_ bookings per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ bookings",
            "infoEmpty": "No bookings found",
            "infoFiltered": "(filtered from _MAX_ total bookings)"
        }
    });
});
</script>
