<!-- Page Header -->
<div class="page-header-modern">
    <div class="row align-items-center">
        <div class="col-md-8">
            <h2 class="mb-2">
                <i class="fas fa-calendar-check"></i> Bookings Management
            </h2>
            <p class="mb-0 opacity-75">View and manage all booking orders</p>
        </div>
    </div>
</div>

<!-- Bookings Table -->
<div class="card-modern">
    <div class="card-header-modern">
        <h5 class="mb-0">
            <i class="fas fa-table"></i> All Bookings
        </h5>
    </div>
    <div class="card-body-modern p-0">
        <div class="table-responsive">
            <table class="table table-modern mb-0" id="vendortable">
                <thead>
                    <tr>
                        <th scope="col">Date</th>
                        <th scope="col">Vendor</th>
                        <th scope="col">Address</th>
                        <th scope="col" class="text-nowrap">Status</th>
                        <th scope="col">Total Products</th>
                        <th scope="col">Price</th>
                        <th scope="col" class="text-center">Actions</th>
                    </tr>
                </thead>
            <tbody>
                <?php foreach ($trips as $v => $d) {
                    $name="";
                    if($d['vendorId'] !=""){
                  //$vendorinfo=$this->common->readdatadocument("Bookings", $d['vendorId']);
                  
                    }


                ?>
                <tr>
                    <td class="text-nowrap"><?php echo date("Y-m-d",$d['date']/1000) ; ?></td>
                    <td><?php echo getusername($d['vendorId']); ?></td>
                    <td><?php echo $d['address']['address'] ?></td>
                    <td>
                        <?php


                              switch ($d['orderStatus']) {
                                case 'process':
                                  $status = '<span class="badge badge-info bg-info">Process</span>';
                                  break;
                                case 'processing':
                                  $status = '<span class="badge badge-warning bg-warning">Processing</span>';
                                  break;
                                case 'booked':
                                  $status = '<span class="badge badge-warning bg-warning">Booked - Yet to start</span>';
                                  break;
                                case 'dispute':
                                    $status = '<span class="badge badge-info bg-info">Dispute</span>';
                                    break;
                                case 'disputed':
                                    $status = '<span class="badge badge-info bg-info">Disputed</span>';
                                    break;
   
                                case 'cancel':
                                  $status = '<span class="badge badge-danger bg-danger">Cancelled</span>';
                                  break;
                                case 'cancelled':
                                  $status = '<span class="badge badge-danger bg-danger">Cancelled</span>';
                                  break;
                                case 'driverAccepted':
                                  $status = '<span class="badge badge-warning bg-warning">Driver is Arriving</span>';
                                  break;
                                case 'deliver':
                                  $status = '<span class="badge badge-primary bg-primary">Deliver</span>';
                                  break;
                                  case 'delivered':
                                    $status = '<span class="badge badge-success bg-success">delivered</span>';
                                    break;
                                case 'proccessed':
                                  $status = '<span class="badge badge-success bg-success">proccessed</span>';
                                  break;
                                  case 'rated':
                                    $status = '<span class="badge badge-success bg-success">rated</span>';
                                    break;

                              }
                              echo $status;
                              ?>
                    </td>
                    <td><?php echo $d['totalQuantity'] ?></td>
                    <td><?php echo $d['price'] ?></td>

                    <td>
                        <div class="dropdown action-dropdown">
                            <button class="btn btn-sm btn-modern btn-modern-info" type="button" 
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fas fa-ellipsis-v"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li>
                                    <a class="dropdown-item" href="<?php echo base_url('Orders/vieworder/').$v; ?>">
                                        <i class="fas fa-eye text-primary"></i> View Order
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
        </div>
    </div>
</div>



<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    $('#vendortable').DataTable();
});
</script>