<style>
.product-detail-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.detail-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    border: none;
    overflow: hidden;
}

.detail-card .card-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    border-bottom: 2px solid #e2e8f0;
    padding: 1.25rem 1.5rem;
    font-weight: 600;
    color: #2d3748;
}

.detail-card .card-body {
    padding: 1.5rem;
}

.info-item {
    padding: 1rem;
    background: #f7fafc;
    border-radius: 10px;
    margin-bottom: 1rem;
    border-left: 4px solid #667eea;
}

.info-item-label {
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    color: #718096;
    font-weight: 600;
    margin-bottom: 0.5rem;
}

.info-item-value {
    font-size: 1rem;
    color: #2d3748;
    font-weight: 500;
}

.badge-lg-modern {
    padding: 0.75rem 1.5rem;
    border-radius: 25px;
    font-weight: 600;
    font-size: 0.875rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.product-image-large {
    width: 100%;
    max-width: 500px;
    height: auto;
    border-radius: 15px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.progress-modern {
    height: 25px;
    border-radius: 15px;
    background: #e2e8f0;
    overflow: hidden;
}

.progress-bar-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 600;
    font-size: 0.875rem;
    transition: width 0.3s ease;
}

.btn-action-modern {
    border-radius: 10px;
    padding: 0.75rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    margin-right: 0.5rem;
    margin-bottom: 0.5rem;
}

.btn-action-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.star-rating {
    color: #fbbf24;
    font-size: 1.2rem;
}

.form-control-modern {
    border-radius: 10px;
    border: 2px solid #e2e8f0;
    padding: 0.75rem 1rem;
    transition: all 0.3s ease;
}

.form-control-modern:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    outline: none;
}
</style>

<!-- Header -->
<div class="product-detail-header">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h2 class="mb-2">
                <i class="fa-solid fa-box"></i> Product Details
            </h2>
            <p class="mb-0 opacity-75"><?php echo htmlspecialchars(isset($productdetail['productName']) ? $productdetail['productName'] : 'Product Information'); ?></p>
        </div>
        <div>
            <a href="<?php echo base_url('products'); ?>" class="btn btn-light btn-modern">
                <i class="fa-solid fa-arrow-left"></i> Back to Products
            </a>
        </div>
    </div>
</div>

<div class="row">
    <!-- Left Column - Product Image & Basic Info -->
    <div class="col-md-5">
        <div class="detail-card">
            <div class="card-body text-center">
                <?php if (isset($productdetail['productUrl']) && !empty($productdetail['productUrl'])): ?>
                    <img src="<?php echo htmlspecialchars($productdetail['productUrl']); ?>" alt="Product" class="product-image-large mb-4">
                <?php else: ?>
                    <div class="product-image-large bg-light d-flex align-items-center justify-content-center mb-4" style="height: 400px;">
                        <i class="fa-solid fa-image fa-5x text-muted"></i>
                    </div>
                <?php endif; ?>
                
                <h3 class="mb-3"><?php echo htmlspecialchars(isset($productdetail['productName']) ? $productdetail['productName'] : 'Unknown Product'); ?></h3>
                
                <!-- Rating -->
                <?php if (isset($totalrating) && $totalrating > 0): ?>
                    <div class="mb-3">
                        <div class="star-rating mb-2">
                            <?php 
                            $roundedRating = ceil($totalrating);
                            for ($i = 0; $i < $roundedRating; $i++) { 
                                echo '<i class="fa-solid fa-star"></i>';
                            }
                            for ($i = $roundedRating; $i < 5; $i++) { 
                                echo '<i class="fa-regular fa-star"></i>';
                            }
                            ?>
                        </div>
                        <p class="text-muted mb-0">
                            <strong><?php echo number_format($totalrating, 1); ?></strong> / 5.0 
                            (<?php echo isset($totalreview) ? $totalreview : 0; ?> reviews)
                        </p>
                    </div>
                <?php endif; ?>
                
                <!-- Status Badge -->
                <div class="mb-3">
                    <?php if (isset($productdetail['isVerified']) && $productdetail['isVerified']): ?>
                        <span class="badge-lg-modern" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%); color: white;">
                            <i class="fa-solid fa-check-circle"></i> Approved
                        </span>
                    <?php else: ?>
                        <span class="badge-lg-modern" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%); color: white;">
                            <i class="fa-solid fa-clock"></i> Pending Approval
                        </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Right Column - Product Information -->
    <div class="col-md-7">
        <!-- Pricing Information -->
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-dollar-sign text-primary"></i> Pricing Information
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Base Price</div>
                            <div class="info-item-value">
                                <strong>$<?php echo isset($productdetail['productPrice']) ? number_format($productdetail['productPrice'], 2) : '0.00'; ?></strong>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Display Price</div>
                            <div class="info-item-value">
                                <strong>$<?php echo isset($productdetail['displayPrice']) ? number_format($productdetail['displayPrice'], 2) : (isset($productdetail['productPrice']) ? number_format($productdetail['productPrice'], 2) : '0.00'); ?></strong>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Update Price Form -->
                <form method="post" action="<?php echo base_url('products/updateprice/' . $id); ?>" class="mt-3">
                    <div class="input-group">
                        <input type="number" step="0.01" class="form-control form-control-modern" name="displayPrice" 
                            value="<?php echo isset($productdetail['displayPrice']) ? $productdetail['displayPrice'] : (isset($productdetail['productPrice']) ? $productdetail['productPrice'] : '0.00'); ?>" 
                            placeholder="Update Display Price" required>
                        <button type="submit" class="btn btn-primary btn-action-modern">
                            <i class="fa-solid fa-save"></i> Update Price
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Product Details -->
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-info-circle text-primary"></i> Product Details
                </h5>
            </div>
            <div class="card-body">
                <div class="info-item">
                    <div class="info-item-label">Product Name</div>
                    <div class="info-item-value"><?php echo htmlspecialchars(isset($productdetail['productName']) ? $productdetail['productName'] : 'N/A'); ?></div>
                </div>
                
                <?php if (isset($productdetail['productUnit']) && !empty($productdetail['productUnit'])): ?>
                <div class="info-item">
                    <div class="info-item-label">Product Unit</div>
                    <div class="info-item-value"><?php echo htmlspecialchars($productdetail['productUnit']); ?></div>
                </div>
                <?php endif; ?>
                
                <?php if (isset($categories) && !empty($categories)): ?>
                <div class="info-item">
                    <div class="info-item-label">Category</div>
                    <div class="info-item-value">
                        <span class="badge-lg-modern" style="background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%); color: white;">
                            <i class="fa-solid fa-tag"></i>
                            <?php echo htmlspecialchars(isset($categories['categoryName']) ? $categories['categoryName'] : 'Unknown'); ?>
                        </span>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if (isset($subcategories) && !empty($subcategories) && isset($subcategories['subcategoryName'])): ?>
                <div class="info-item">
                    <div class="info-item-label">Subcategory</div>
                    <div class="info-item-value"><?php echo htmlspecialchars($subcategories['subcategoryName']); ?></div>
                </div>
                <?php endif; ?>
                
                <?php if (isset($productdetail['productDetail']) && !empty($productdetail['productDetail'])): ?>
                <div class="info-item">
                    <div class="info-item-label">Description</div>
                    <div class="info-item-value"><?php echo nl2br(htmlspecialchars($productdetail['productDetail'])); ?></div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Product Levels -->
        <?php if (isset($productdetail['potencyLevel']) || isset($productdetail['nicotineLevel'])): ?>
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-chart-line text-primary"></i> Product Levels
                </h5>
            </div>
            <div class="card-body">
                <?php if (isset($productdetail['potencyLevel'])): ?>
                <div class="mb-3">
                    <div class="d-flex justify-content-between mb-2">
                        <span class="info-item-label">THC Potency Level</span>
                        <span class="info-item-value"><strong><?php echo $productdetail['potencyLevel']; ?>%</strong></span>
                    </div>
                    <div class="progress-modern">
                        <div class="progress-bar-modern" style="width: <?php echo $productdetail['potencyLevel']; ?>%;">
                            <?php echo $productdetail['potencyLevel']; ?>%
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if (isset($productdetail['nicotineLevel'])): ?>
                <div class="mb-3">
                    <div class="d-flex justify-content-between mb-2">
                        <span class="info-item-label">Nicotine Level</span>
                        <span class="info-item-value"><strong><?php echo $productdetail['nicotineLevel']; ?>%</strong></span>
                    </div>
                    <div class="progress-modern">
                        <div class="progress-bar-modern" style="width: <?php echo $productdetail['nicotineLevel']; ?>%;">
                            <?php echo $productdetail['nicotineLevel']; ?>%
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Vendor Information -->
        <?php if (isset($userinfo) && !empty($userinfo)): ?>
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-store text-primary"></i> Vendor Information
                </h5>
            </div>
            <div class="card-body">
                <div class="info-item">
                    <div class="info-item-label">Vendor Name</div>
                    <div class="info-item-value">
                        <?php 
                        $vendorName = isset($userinfo['shopName']) ? $userinfo['shopName'] : 
                            (isset($userinfo['firstName']) ? $userinfo['firstName'] . ' ' . (isset($userinfo['lastName']) ? $userinfo['lastName'] : '') : 'Unknown');
                        echo htmlspecialchars($vendorName);
                        ?>
                    </div>
                </div>
                <?php if (isset($userinfo['email'])): ?>
                <div class="info-item">
                    <div class="info-item-label">Email</div>
                    <div class="info-item-value"><?php echo htmlspecialchars($userinfo['email']); ?></div>
                </div>
                <?php endif; ?>
                <?php if (isset($userinfo['phoneNumber'])): ?>
                <div class="info-item">
                    <div class="info-item-label">Phone</div>
                    <div class="info-item-value"><?php echo htmlspecialchars($userinfo['phoneNumber']); ?></div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Actions -->
<div class="detail-card">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center flex-wrap">
            <div>
                <a href="<?php echo base_url('products/editproduct/' . $id); ?>" class="btn btn-info btn-action-modern">
                    <i class="fa-solid fa-edit"></i> Edit Product
                </a>
                <a href="<?php echo base_url('products/deleteproduct/' . $id); ?>" 
                    class="btn btn-danger btn-action-modern"
                    onclick="return confirm('Are you sure you want to delete this product?');">
                    <i class="fa-solid fa-trash"></i> Delete Product
                </a>
            </div>
            <div>
                <?php if (isset($productdetail['isVerified']) && $productdetail['isVerified']): ?>
                    <a href="<?php echo base_url('products/updatestatus/' . $id . '/reject'); ?>" 
                        class="btn btn-warning btn-action-modern">
                        <i class="fa-solid fa-ban"></i> Remove From Listing
                    </a>
                <?php else: ?>
                    <a href="<?php echo base_url('products/updatestatus/' . $id . '/approved'); ?>" 
                        class="btn btn-success btn-action-modern">
                        <i class="fa-solid fa-check-circle"></i> Approve Product
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
