<style>
.product-management-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(114, 165, 101, 0.2);
}

.product-stats-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-left: 4px solid;
}

.product-stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.product-stats-card.primary { border-left-color: #72A565; }
.product-stats-card.success { border-left-color: #48bb78; }
.product-stats-card.warning { border-left-color: #ed8936; }
.product-stats-card.info { border-left-color: #4299e1; }

.filter-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 2rem;
}

.product-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    overflow: hidden;
}

.product-table-card .card-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.product-table-card table thead {
    background: #f7fafc;
}

.product-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.product-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.product-table-card table tbody tr:hover {
    background: #f7fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.product-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.75rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-modern i {
    font-size: 0.7rem;
}

.badge-primary-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
}

.badge-success-modern {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.badge-warning-modern {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.badge-danger-modern {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.badge-info-modern {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.btn-modern {
    border-radius: 10px;
    padding: 0.6rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.btn-modern-primary {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    border: none;
    color: white;
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.filter-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    margin-bottom: 1rem;
}

.product-image {
    width: 60px;
    height: 60px;
    object-fit: cover;
    border-radius: 10px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.product-link {
    color: #72A565;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
}

.product-link:hover {
    color: #91A134;
    text-decoration: none;
}
</style>

<!-- Header Section -->
<div class="product-management-header">
    <div class="row align-items-center">
        <div class="col-md-6">
            <h2 class="mb-2">
                <i class="fa-solid fa-box"></i> Product Management
            </h2>
            <p class="mb-0 opacity-75">Manage your product catalog with categories, vendors, and pricing</p>
        </div>
        <div class="col-md-6 text-end">
            <a href="<?php echo base_url('products/addproduct'); ?>" class="btn btn-light btn-modern">
                <i class="fa-solid fa-plus"></i> Add New Product
            </a>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<?php
$totalProducts = count($products);
$approvedProducts = 0;
$pendingProducts = 0;
$totalValue = 0;

foreach ($products as $product) {
    $isVerified = isset($product['isVerified']) ? $product['isVerified'] : false;
    if ($isVerified) {
        $approvedProducts++;
    } else {
        $pendingProducts++;
    }
    
    $price = isset($product['productPrice']) ? $product['productPrice'] : 0;
    $totalValue += $price;
}
?>
<div class="row mb-4">
    <div class="col-md-3">
        <div class="product-stats-card primary">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon">
                        <i class="fa-solid fa-box"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Total Products</p>
                    <h3 class="stats-number mb-0"><?php echo $totalProducts; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="product-stats-card success">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);">
                        <i class="fa-solid fa-check-circle"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Approved</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $approvedProducts; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="product-stats-card warning">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);">
                        <i class="fa-solid fa-clock"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Pending</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $pendingProducts; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="product-stats-card info">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);">
                        <i class="fa-solid fa-dollar-sign"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Total Value</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">$<?php echo number_format($totalValue, 2); ?></h3>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="filter-card">
    <div class="d-flex align-items-center mb-3">
        <i class="fa-solid fa-filter text-primary me-2"></i>
        <h5 class="mb-0">Filter Products</h5>
    </div>
    <form method="get" action="<?php echo base_url('products'); ?>" class="row g-3">
        <div class="col-md-3">
            <label for="search" class="form-label fw-bold">Search</label>
            <input type="text" class="form-control" id="search" name="search" 
                value="<?php echo isset($searchTerm) ? htmlspecialchars($searchTerm) : ''; ?>" 
                placeholder="Product name...">
        </div>
        <div class="col-md-2">
            <label for="filter_category" class="form-label fw-bold">Category</label>
            <select class="form-control form-select" id="filter_category" name="filter_category">
                <option value="">All Categories</option>
                <?php foreach ($categories as $categoryId => $category): ?>
                    <option value="<?php echo $categoryId; ?>" <?php echo (isset($filterCategory) && $filterCategory == $categoryId) ? 'selected' : ''; ?>>
                        <?php echo isset($category['name']) ? htmlspecialchars($category['name']) : 'Unknown'; ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-2">
            <label for="filter_vendor" class="form-label fw-bold">Vendor</label>
            <select class="form-control form-select" id="filter_vendor" name="filter_vendor">
                <option value="">All Vendors</option>
                <?php foreach ($vendors as $vendorId => $vendor): ?>
                    <option value="<?php echo $vendorId; ?>" <?php echo (isset($filterVendor) && $filterVendor == $vendorId) ? 'selected' : ''; ?>>
                        <?php 
                        $vendorName = isset($vendor['shopName']) ? $vendor['shopName'] : 
                            (isset($vendor['firstName']) ? $vendor['firstName'] . ' ' . (isset($vendor['lastName']) ? $vendor['lastName'] : '') : 'Unknown');
                        echo htmlspecialchars($vendorName);
                        ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-2">
            <label for="filter_status" class="form-label fw-bold">Status</label>
            <select class="form-control form-select" id="filter_status" name="filter_status">
                <option value="all" <?php echo (!isset($filterStatus) || $filterStatus == 'all') ? 'selected' : ''; ?>>All Status</option>
                <option value="approved" <?php echo (isset($filterStatus) && $filterStatus == 'approved') ? 'selected' : ''; ?>>Approved</option>
                <option value="pending" <?php echo (isset($filterStatus) && $filterStatus == 'pending') ? 'selected' : ''; ?>>Pending</option>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label fw-bold">&nbsp;</label>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-modern btn-modern-primary w-100">
                    <i class="fa-solid fa-filter"></i> Filter
                </button>
                <a href="<?php echo base_url('products'); ?>" class="btn btn-secondary btn-modern">
                    <i class="fa-solid fa-times"></i>
                </a>
            </div>
        </div>
    </form>
</div>

<!-- Products Table -->
<div class="product-table-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-table"></i> Products List
        </h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0" id="productsTable">
                <thead>
                    <tr>
                        <th>Image</th>
                        <th>Product Name</th>
                        <th>Category</th>
                        <th>Vendor</th>
                        <th>Base Price</th>
                        <th>Display Price</th>
                        <th>Status</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (!empty($products)) {
                        foreach ($products as $productId => $product) {
                            $isVerified = isset($product['isVerified']) ? $product['isVerified'] : false;
                            $productImage = isset($product['productUrl']) ? $product['productUrl'] : '';
                    ?>
                    <tr>
                        <td>
                            <?php if ($productImage): ?>
                                <img src="<?php echo htmlspecialchars($productImage); ?>" alt="Product" class="product-image">
                            <?php else: ?>
                                <div class="product-image bg-light d-flex align-items-center justify-content-center">
                                    <i class="fa-solid fa-image text-muted"></i>
                                </div>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?php echo base_url('products/detail/' . $productId); ?>" class="product-link">
                                <?php echo htmlspecialchars(isset($product['productName']) ? $product['productName'] : 'Unknown'); ?>
                            </a>
                        </td>
                        <td>
                            <span class="badge-modern badge-info-modern">
                                <i class="fa-solid fa-tag"></i>
                                <?php
                                foreach ($categories as $categoryId => $category) {
                                    if ($categoryId == $product['categoryId']) {
                                        echo htmlspecialchars($category['name']);
                                        break;
                                    }
                                }
                                ?>
                            </span>
                        </td>
                        <td>
                            <?php echo htmlspecialchars(isset($product['vendorName']) ? $product['vendorName'] : 'Unknown'); ?>
                        </td>
                        <td><strong>$<?php echo isset($product['productPrice']) ? number_format($product['productPrice'], 2) : '0.00'; ?></strong></td>
                        <td><strong>$<?php echo isset($product['displayPrice']) ? number_format($product['displayPrice'], 2) : (isset($product['productPrice']) ? number_format($product['productPrice'], 2) : '0.00'); ?></strong></td>
                        <td>
                            <?php if ($isVerified): ?>
                                <span class="badge-modern badge-success-modern">
                                    <i class="fa-solid fa-check"></i> Approved
                                </span>
                            <?php else: ?>
                                <span class="badge-modern badge-warning-modern">
                                    <i class="fa-solid fa-clock"></i> Pending
                                </span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="d-flex gap-2 justify-content-center">
                                <a href="<?php echo base_url('products/detail/' . $productId); ?>" class="btn btn-sm btn-primary btn-modern" title="View">
                                    <i class="fa-solid fa-eye"></i>
                                </a>
                                <a href="<?php echo base_url('products/editproduct/' . $productId); ?>" class="btn btn-sm btn-info btn-modern" title="Edit">
                                    <i class="fa-solid fa-edit"></i>
                                </a>
                                <a href="<?php echo base_url('products/deleteproduct/' . $productId); ?>" 
                                    class="btn btn-sm btn-danger btn-modern" 
                                    title="Delete"
                                    onclick="return confirm('Are you sure you want to delete this product?');">
                                    <i class="fa-solid fa-trash"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php
                        }
                    } else {
                    ?>
                    <tr>
                        <td colspan="8" class="text-center py-5">
                            <i class="fa-solid fa-box-open fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No products found</p>
                        </td>
                    </tr>
                    <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    $('#productsTable').DataTable({
        "order": [[ 1, "asc" ]],
        "pageLength": 25,
        "language": {
            "search": "<i class='fa-solid fa-search'></i> Search:",
            "lengthMenu": "Show _MENU_ products per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ products",
            "infoEmpty": "No products found",
            "infoFiltered": "(filtered from _MAX_ total products)"
        }
    });
});
</script>
