<style>
.promotion-management-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.promotion-stats-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-left: 4px solid;
}

.promotion-stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.promotion-stats-card.primary { border-left-color: #667eea; }
.promotion-stats-card.success { border-left-color: #48bb78; }
.promotion-stats-card.warning { border-left-color: #ed8936; }
.promotion-stats-card.danger { border-left-color: #f56565; }

.promotion-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    overflow: hidden;
}

.promotion-table-card .card-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.promotion-table-card table thead {
    background: #f7fafc;
}

.promotion-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.promotion-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.promotion-table-card table tbody tr:hover {
    background: #f7fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.promotion-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.75rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-primary-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
}

.badge-success-modern {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.badge-warning-modern {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.badge-danger-modern {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.btn-modern {
    border-radius: 10px;
    padding: 0.6rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.btn-modern-primary {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    border: none;
    color: white;
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.filter-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    margin-bottom: 1rem;
}

.status-active {
    color: #48bb78;
}

.status-expired {
    color: #f56565;
}

.status-upcoming {
    color: #ed8936;
}
</style>

<!-- Header Section -->
<div class="promotion-management-header">
    <div class="row align-items-center">
        <div class="col-md-6">
            <h2 class="mb-2">
                <i class="fa-solid fa-percent"></i> Promotion Management
            </h2>
            <p class="mb-0 opacity-75">Manage promotional campaigns, discounts, and special offers</p>
        </div>
        <div class="col-md-6 text-end">
            <a href="<?php echo base_url('Promotion/addPromopage'); ?>" class="btn btn-light btn-modern">
                <i class="fa-solid fa-plus"></i> Add New Promotion
            </a>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<?php
$totalPromotions = !empty($promotions) ? count($promotions) : 0;
$activePromotions = 0;
$expiredPromotions = 0;
$upcomingPromotions = 0;
$currentTime = time() * 1000; // Current time in milliseconds

if (!empty($promotions)) {
    foreach ($promotions as $promo) {
        $startTime = isset($promo['startTime']) ? $promo['startTime'] : 0;
        $endTime = isset($promo['endTime']) ? $promo['endTime'] : 0;
        
        if ($currentTime < $startTime) {
            $upcomingPromotions++;
        } elseif ($currentTime >= $startTime && $currentTime <= $endTime) {
            $activePromotions++;
        } elseif ($currentTime > $endTime) {
            $expiredPromotions++;
        }
    }
}
?>
<div class="row mb-4">
    <div class="col-md-3">
        <div class="promotion-stats-card primary">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon">
                        <i class="fa-solid fa-percent"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Total Promotions</p>
                    <h3 class="stats-number mb-0"><?php echo $totalPromotions; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="promotion-stats-card success">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);">
                        <i class="fa-solid fa-check-circle"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Active Now</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $activePromotions; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="promotion-stats-card warning">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);">
                        <i class="fa-solid fa-clock"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Upcoming</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $upcomingPromotions; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="promotion-stats-card danger">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);">
                        <i class="fa-solid fa-times-circle"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Expired</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $expiredPromotions; ?></h3>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Promotions Table -->
<div class="promotion-table-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-table"></i> Promotions List
        </h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0" id="promotionsTable">
                <thead>
                    <tr>
                        <th>Title</th>
                        <th>Code</th>
                        <th>Type</th>
                        <th>Discount</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Status</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (!empty($promotions)) {
                        foreach ($promotions as $id => $promotion) {
                            $title = isset($promotion['title']) ? $promotion['title'] : 'Unknown';
                            $code = isset($promotion['code']) ? $promotion['code'] : 'N/A';
                            $type = isset($promotion['type']) ? $promotion['type'] : 'Percentage';
                            $percentage = isset($promotion['Percentage']) ? $promotion['Percentage'] : 0;
                            
                            $startTime = isset($promotion['startTime']) ? $promotion['startTime'] : 0;
                            $endTime = isset($promotion['endTime']) ? $promotion['endTime'] : 0;
                            $startDate = $startTime > 0 ? date('Y-m-d H:i', $startTime / 1000) : 'N/A';
                            $endDate = $endTime > 0 ? date('Y-m-d H:i', $endTime / 1000) : 'N/A';
                            
                            // Determine status
                            $status = 'expired';
                            $statusClass = 'danger-modern';
                            $statusIcon = 'fa-times-circle';
                            $statusText = 'Expired';
                            
                            if ($currentTime < $startTime) {
                                $status = 'upcoming';
                                $statusClass = 'warning-modern';
                                $statusIcon = 'fa-clock';
                                $statusText = 'Upcoming';
                            } elseif ($currentTime >= $startTime && $currentTime <= $endTime) {
                                $status = 'active';
                                $statusClass = 'success-modern';
                                $statusIcon = 'fa-check-circle';
                                $statusText = 'Active';
                            }
                            
                            $discountDisplay = $type == 'Percentage' ? $percentage . '%' : '$' . number_format($percentage, 2);
                    ?>
                    <tr>
                        <td><strong><?php echo htmlspecialchars($title); ?></strong></td>
                        <td>
                            <span class="badge-modern badge-primary-modern">
                                <i class="fa-solid fa-tag"></i>
                                <?php echo htmlspecialchars($code); ?>
                            </span>
                        </td>
                        <td>
                            <span class="badge-modern badge-info-modern">
                                <?php echo htmlspecialchars($type); ?>
                            </span>
                        </td>
                        <td><strong><?php echo $discountDisplay; ?></strong></td>
                        <td><?php echo $startDate; ?></td>
                        <td><?php echo $endDate; ?></td>
                        <td>
                            <span class="badge-modern badge-<?php echo $statusClass; ?>">
                                <i class="fa-solid <?php echo $statusIcon; ?>"></i>
                                <?php echo $statusText; ?>
                            </span>
                        </td>
                        <td>
                            <div class="d-flex gap-2 justify-content-center">
                                <a href="<?php echo base_url('Promotion/editPromotion/' . $id); ?>" class="btn btn-sm btn-info btn-modern" title="Edit">
                                    <i class="fa-solid fa-edit"></i> Edit
                                </a>
                                <a href="<?php echo base_url('Promotion/deletePromotion/' . $id); ?>" 
                                    class="btn btn-sm btn-danger btn-modern" 
                                    title="Delete"
                                    onclick="return confirm('Are you sure you want to delete this promotion?');">
                                    <i class="fa-solid fa-trash"></i> Delete
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php
                        }
                    } else {
                    ?>
                    <tr>
                        <td colspan="8" class="text-center py-5">
                            <i class="fa-solid fa-percent fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No promotions found</p>
                            <a href="<?php echo base_url('Promotion/addPromopage'); ?>" class="btn btn-modern btn-modern-primary">
                                <i class="fa-solid fa-plus"></i> Add First Promotion
                            </a>
                        </td>
                    </tr>
                    <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    $('#promotionsTable').DataTable({
        "order": [[ 4, "desc" ]],
        "pageLength": 25,
        "language": {
            "search": "<i class='fa-solid fa-search'></i> Search:",
            "lengthMenu": "Show _MENU_ promotions per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ promotions",
            "infoEmpty": "No promotions found",
            "infoFiltered": "(filtered from _MAX_ total promotions)"
        }
    });
});
</script>
